/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.ComponentPanelLayout;
import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.panel.ComponentReorderListener;
import com.alee.global.StyleConstants;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class WebComponentPanel
extends WebPanel {
    public static final int GRIPPER_SIZE = 7;
    public static final int SINGLE_GRIPPER_STEP = 4;
    private final List<ComponentReorderListener> listeners = new ArrayList<ComponentReorderListener>(1);
    private WebPanel container;
    private final Map<Component, WebSelectablePanel> components = new LinkedHashMap<Component, WebSelectablePanel>();
    private Insets elementMargin = new Insets(2, 2, 2, 2);
    private boolean reorderingAllowed = false;
    private boolean showReorderGrippers = true;
    private boolean upDownHotkeysAllowed = true;
    private boolean leftRightHotkeysAllowed = false;

    public WebComponentPanel() {
        this.initialize();
    }

    public WebComponentPanel(boolean decorated) {
        super(decorated);
        this.initialize();
    }

    private void initialize() {
        this.setWebColoredBackground(false);
        this.container = new WebPanel();
        this.container.setLayout(new ComponentPanelLayout());
        this.add((Component)this.container, (Object)"Center");
        HotkeyRunnable prevAction = new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                if (WebComponentPanel.this.upDownHotkeysAllowed && Hotkey.UP.isTriggered(e) || WebComponentPanel.this.leftRightHotkeysAllowed && Hotkey.LEFT.isTriggered(e)) {
                    int index = WebComponentPanel.this.getFocusedElementIndex();
                    if (index == -1) {
                        WebComponentPanel.this.focusElement(WebComponentPanel.this.getElementCount() - 1);
                    } else {
                        WebComponentPanel.this.focusElement(index > 0 ? index - 1 : WebComponentPanel.this.getElementCount() - 1);
                    }
                }
            }
        };
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.UP, prevAction);
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.LEFT, prevAction);
        HotkeyRunnable nextAction = new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                if (WebComponentPanel.this.upDownHotkeysAllowed && Hotkey.DOWN.isTriggered(e) || WebComponentPanel.this.leftRightHotkeysAllowed && Hotkey.RIGHT.isTriggered(e)) {
                    int index = WebComponentPanel.this.getFocusedElementIndex();
                    if (index == -1) {
                        WebComponentPanel.this.focusElement(0);
                    } else {
                        WebComponentPanel.this.focusElement(index < WebComponentPanel.this.getElementCount() - 1 ? index + 1 : 0);
                    }
                }
            }
        };
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.DOWN, nextAction);
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.RIGHT, nextAction);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.updateAllBorders();
    }

    public ComponentPanelLayout getContainerLayout() {
        return (ComponentPanelLayout)this.container.getLayout();
    }

    public boolean isUpDownHotkeysAllowed() {
        return this.upDownHotkeysAllowed;
    }

    public void setUpDownHotkeysAllowed(boolean upDownHotkeysAllowed) {
        this.upDownHotkeysAllowed = upDownHotkeysAllowed;
    }

    public boolean isLeftRightHotkeysAllowed() {
        return this.leftRightHotkeysAllowed;
    }

    public void setLeftRightHotkeysAllowed(boolean leftRightHotkeysAllowed) {
        this.leftRightHotkeysAllowed = leftRightHotkeysAllowed;
    }

    public WebSelectablePanel addElement(Component component) {
        if (this.components.containsKey(component)) {
            return this.components.get(component);
        }
        WebSelectablePanel element = new WebSelectablePanel();
        element.add(component, (Object)"Center");
        this.container.add((Component)element, (Object)"");
        this.components.put(component, element);
        this.updateAllBorders();
        return element;
    }

    public void removeElement(int index) {
        this.removeElement(this.getElement(index));
    }

    public void removeElement(WebSelectablePanel element) {
        for (Component component : this.components.keySet()) {
            if (this.components.get(component) != element) continue;
            this.removeElement(component);
            break;
        }
    }

    public void removeElement(Component component) {
        WebSelectablePanel element = this.components.get(component);
        this.container.remove(element);
        this.components.remove(component);
        this.updateAllBorders();
    }

    public int getElementCount() {
        return this.components.size();
    }

    public WebSelectablePanel getElement(int index) {
        return (WebSelectablePanel)this.getContainerLayout().getComponent(index);
    }

    public WebSelectablePanel getFocusedElement() {
        for (Component component : this.getContainerLayout().getComponents()) {
            WebSelectablePanel selectablePanel = (WebSelectablePanel)component;
            if (!selectablePanel.isFocused()) continue;
            return selectablePanel;
        }
        return null;
    }

    public int getFocusedElementIndex() {
        return this.getContainerLayout().indexOf(this.getFocusedElement());
    }

    public void focusElement(int index) {
        this.getElement(index).transferFocus();
    }

    public Insets getElementMargin() {
        return this.elementMargin;
    }

    public void setElementMargin(int margin) {
        this.setElementMargin(margin, margin, margin, margin);
    }

    public void setElementMargin(int top, int left, int bottom, int right) {
        this.setElementMargin(new Insets(top, left, bottom, right));
    }

    public void setElementMargin(Insets margin) {
        this.elementMargin = margin;
        this.updateAllBorders();
    }

    public boolean isReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setReorderingAllowed(boolean reorderingAllowed) {
        this.reorderingAllowed = reorderingAllowed;
        this.updateAllBorders();
    }

    public boolean isShowReorderGrippers() {
        return this.showReorderGrippers;
    }

    public void setShowReorderGrippers(boolean showReorderGrippers) {
        this.showReorderGrippers = showReorderGrippers;
        this.updateAllBorders();
    }

    private void updateAllBorders() {
        for (WebSelectablePanel panel : this.components.values()) {
            panel.updateBorder();
        }
    }

    public void addComponentReorderListener(ComponentReorderListener listener) {
        this.listeners.add(listener);
    }

    public void removeComponentReorderListener(ComponentReorderListener listener) {
        this.listeners.remove(listener);
    }

    private void fireComponentOrderChanged(Component component, int oldIndex, int newIndex) {
        for (ComponentReorderListener listener : CollectionUtils.copy(this.listeners)) {
            listener.componentOrderChanged(component, oldIndex, newIndex);
        }
    }

    public class WebSelectablePanelPainter
    extends AbstractPainter<WebSelectablePanel> {
        protected float[] fractions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
        protected Color[] lightColors = new Color[]{StyleConstants.transparent, Color.WHITE, Color.WHITE, StyleConstants.transparent};
        protected Color[] darkColors = new Color[]{StyleConstants.transparent, Color.GRAY, Color.GRAY, StyleConstants.transparent};

        @Override
        public Boolean isOpaque(WebSelectablePanel c) {
            return true;
        }

        @Override
        public void paint(Graphics2D g2d, Rectangle bounds, WebSelectablePanel panel) {
            boolean notLast;
            boolean notFirst = panel.getIndex() > 0;
            boolean bl = notLast = panel.getIndex() < WebComponentPanel.this.components.size() - 1;
            if (panel.isFocused()) {
                g2d.setPaint(new GradientPaint(bounds.x, bounds.y, StyleConstants.topBgColor, bounds.x, bounds.y + bounds.height, StyleConstants.bottomBgColor));
                g2d.fill(bounds);
                Integer shift = WebComponentPanel.this.getContainerLayout().getComponentShift(panel);
                boolean moved = panel.isDragged() && shift != null && shift != 0;
                g2d.setPaint(StyleConstants.darkBorderColor);
                if (notFirst || moved) {
                    g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
                }
                if (notLast || moved) {
                    g2d.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
                }
            }
            if (WebComponentPanel.this.reorderingAllowed && WebComponentPanel.this.showReorderGrippers) {
                boolean ltr = panel.getComponentOrientation().isLeftToRight();
                int minY = bounds.y + 2 + (notFirst ? 1 : 0);
                int maxY = bounds.x + bounds.height - 2 - (notLast ? 1 : 0);
                int x = ltr ? bounds.x + 3 : bounds.x + bounds.width - 7 + 2;
                int y = minY + (maxY - minY) % 4 / 2;
                LinearGradientPaint light = new LinearGradientPaint(x, minY, x, maxY, this.fractions, this.lightColors);
                LinearGradientPaint dark = new LinearGradientPaint(x, minY, x, maxY, this.fractions, this.darkColors);
                while (y + 3 < maxY) {
                    g2d.setPaint(light);
                    g2d.fillRect(x + 1, y + 1, 2, 2);
                    g2d.setPaint(dark);
                    g2d.fillRect(x, y, 2, 2);
                    y += 4;
                }
            }
        }
    }

    public class WebSelectablePanel
    extends WebPanel {
        private final DefaultFocusTracker focusTracker;
        private boolean dragged = false;
        private boolean focused = false;

        public WebSelectablePanel() {
            this.updateBorder();
            this.setPainter(new WebSelectablePanelPainter());
            MouseAdapter mouseAdapter = new MouseAdapter(){
                private int startY;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!SwingUtils.hasFocusOwner(WebSelectablePanel.this)) {
                        WebSelectablePanel.this.transferFocus();
                    }
                    if (WebComponentPanel.this.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                        WebSelectablePanel.this.dragged = true;
                        this.startY = this.getY();
                        WebComponentPanel.this.container.setComponentZOrder(WebSelectablePanel.this, 0);
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (WebSelectablePanel.this.dragged) {
                        WebComponentPanel.this.getContainerLayout().setComponentShift(WebSelectablePanel.this, this.getY() - this.startY);
                        WebSelectablePanel.this.revalidate();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    WebSelectablePanel wsp = WebSelectablePanel.this;
                    ComponentPanelLayout cpl = WebComponentPanel.this.getContainerLayout();
                    if (SwingUtilities.isLeftMouseButton(e) && WebSelectablePanel.this.dragged) {
                        WebSelectablePanel.this.dragged = false;
                        if (this.getY() - this.startY == 0 || cpl.getComponents().size() <= 1) {
                            cpl.setComponentShift(wsp, null);
                        } else {
                            int oldIndex = cpl.indexOf(wsp);
                            int middle = this.getMiddleY(wsp);
                            int insertIndex = 0;
                            for (Component component : cpl.getComponents()) {
                                if (component == wsp || middle <= this.getMiddleY(component)) continue;
                                insertIndex = cpl.indexOf(component) + 1;
                            }
                            if (insertIndex > oldIndex) {
                                --insertIndex;
                            }
                            cpl.setComponentShift(wsp, null);
                            if (oldIndex != insertIndex) {
                                cpl.removeLayoutComponent(wsp);
                                cpl.insertLayoutComponent(insertIndex, wsp);
                                WebComponentPanel.this.updateAllBorders();
                                WebComponentPanel.this.fireComponentOrderChanged(wsp.getComponent(), oldIndex, insertIndex);
                            }
                        }
                        wsp.revalidate();
                    }
                }

                private int getMiddleY(Component component) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.y + rectangle.height / 2;
                }

                private int getY() {
                    return MouseInfo.getPointerInfo().getLocation().y;
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            this.focusTracker = new DefaultFocusTracker(true){

                @Override
                public void focusChanged(boolean focused) {
                    WebSelectablePanel wsp = WebSelectablePanel.this;
                    wsp.focused = focused;
                    if (!focused && WebSelectablePanel.this.dragged) {
                        WebSelectablePanel.this.dragged = false;
                        WebComponentPanel.this.getContainerLayout().setComponentShift(wsp, null);
                        wsp.revalidate();
                    }
                    WebSelectablePanel.this.repaint();
                }
            };
            FocusManager.addFocusTracker(this, this.focusTracker);
        }

        public void updateBorder() {
            int index = this.getIndex();
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            int top = index == 0 ? ((WebComponentPanel)WebComponentPanel.this).elementMargin.top : ((WebComponentPanel)WebComponentPanel.this).elementMargin.top + 1;
            int left = ((WebComponentPanel)WebComponentPanel.this).elementMargin.left + (WebComponentPanel.this.reorderingAllowed && WebComponentPanel.this.showReorderGrippers && ltr ? 7 : 0);
            int bottom = index == WebComponentPanel.this.components.size() - 1 ? ((WebComponentPanel)WebComponentPanel.this).elementMargin.bottom : ((WebComponentPanel)WebComponentPanel.this).elementMargin.bottom + 1;
            int right = ((WebComponentPanel)WebComponentPanel.this).elementMargin.right + (WebComponentPanel.this.reorderingAllowed && WebComponentPanel.this.showReorderGrippers && !ltr ? 7 : 0);
            this.setMargin(top, left, bottom, right);
        }

        public boolean isFocused() {
            return this.focused;
        }

        public boolean isDragged() {
            return this.dragged;
        }

        public Component getComponent() {
            return this.getComponent(0);
        }

        public int getIndex() {
            return WebComponentPanel.this.getContainerLayout().indexOf(this);
        }
    }
}

