/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.menu;

import com.alee.extended.image.WebImage;
import com.alee.extended.menu.DynamicMenuLayout;
import com.alee.extended.menu.DynamicMenuType;
import com.alee.extended.menu.WebDynamicMenuItem;
import com.alee.global.StyleConstants;
import com.alee.laf.rootpane.WebWindow;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.utils.GeometryUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.swing.WebHeavyWeightPopup;
import com.alee.utils.swing.WebTimer;
import com.alee.utils.swing.WindowFollowAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class WebDynamicMenu
extends WebHeavyWeightPopup {
    protected int radius;
    protected double startingAngle;
    protected double angleRange;
    protected float stepProgress;
    protected DynamicMenuType type;
    protected DynamicMenuType hideType;
    protected boolean clockwise;
    protected List<WebDynamicMenuItem> items = new ArrayList<WebDynamicMenuItem>();
    protected float currentProgress = 0.0f;
    protected final Object sync = new Object();
    protected WebTimer animator = null;
    protected WindowFollowAdapter followAdapter;
    protected boolean displaying = false;
    protected boolean hiding = false;
    protected int hidingCause = -1;
    protected AWTEventListener mouseListener;
    protected GlobalFocusListener focusListener;
    protected final Object lsync = new Object();
    protected final List<Runnable> onFullDisplay = new ArrayList<Runnable>();
    protected final List<Runnable> onFullHide = new ArrayList<Runnable>();

    public WebDynamicMenu() {
        super("transparent", (LayoutManager)new DynamicMenuLayout());
        this.setRadius(60);
        this.setStartingAngle(0.0);
        this.setAngleRange(360.0);
        this.setStepProgress(0.04f);
        this.setType(DynamicMenuType.shutter);
        this.setHideType(null);
        this.setClockwise(true);
        this.setWindowOpaque(false);
        this.setFollowInvoker(true);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getStartingAngle() {
        return this.startingAngle;
    }

    public void setStartingAngle(double startingAngle) {
        this.startingAngle = startingAngle;
    }

    public double getAngleRange() {
        return this.angleRange;
    }

    public void setAngleRange(double angleRange) {
        this.angleRange = angleRange;
    }

    public float getStepProgress() {
        return this.stepProgress;
    }

    public void setStepProgress(float stepProgress) {
        this.stepProgress = stepProgress;
    }

    public DynamicMenuType getType() {
        return this.type;
    }

    public void setType(DynamicMenuType type) {
        this.type = type;
    }

    public DynamicMenuType getHideType() {
        return this.hideType != null ? this.hideType : this.type;
    }

    public void setHideType(DynamicMenuType hideType) {
        this.hideType = hideType;
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        this.clockwise = clockwise;
    }

    public List<WebDynamicMenuItem> getItems() {
        return this.items;
    }

    public WebImage addItem(ImageIcon icon) {
        return this.addItem(icon, null);
    }

    public WebImage addItem(ImageIcon icon, ActionListener action) {
        return this.addItem(new WebDynamicMenuItem(icon, action));
    }

    public WebImage addItem(final WebDynamicMenuItem item) {
        this.items.add(item);
        final WebImage menuItem = new WebImage(item.getIcon()){

            @Override
            protected void paintComponent(Graphics g) {
                if (item.isDrawBorder()) {
                    Graphics2D g2d = (Graphics2D)g;
                    Object aa = GraphicsUtils.setupAntialias(g2d);
                    Area outer = new Area(new Ellipse2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
                    Ellipse2D.Double inner = new Ellipse2D.Double(2.0, 2.0, this.getWidth() - 4, this.getHeight() - 4);
                    outer.exclusiveOr(new Area(inner));
                    g2d.setPaint(this.isEnabled() ? item.getBorderColor() : item.getDisabledBorderColor());
                    g2d.fill(outer);
                    g2d.setColor(Color.WHITE);
                    g2d.fill(inner);
                    GraphicsUtils.restoreAntialias(g2d, aa);
                }
                super.paintComponent(g);
            }
        };
        menuItem.setEnabled(item.getAction() != null);
        menuItem.setMargin(item.getMargin());
        menuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ActionListener action = item.getAction();
                if (action != null) {
                    action.actionPerformed(new ActionEvent(e.getSource(), 0, "Action performed"));
                }
                WebDynamicMenu.this.hideMenu(WebDynamicMenu.this.getComponentZOrder(menuItem));
            }
        });
        this.add((Component)menuItem);
        return menuItem;
    }

    public float getCurrentProgress() {
        return this.currentProgress;
    }

    public WebTimer getAnimator() {
        return this.animator;
    }

    public boolean isDisplaying() {
        return this.displaying;
    }

    public boolean isHiding() {
        return this.hiding;
    }

    public int getHidingCause() {
        return this.hidingCause;
    }

    public void showMenu(Component invoker, Point location) {
        this.showMenu(invoker, location.x, location.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMenu(Component invoker, int x, int y) {
        Object object = this.sync;
        synchronized (object) {
            if (this.displaying || this.window != null || this.getComponentCount() == 0) {
                return;
            }
            this.displaying = true;
            if (this.hiding) {
                if (this.animator != null) {
                    this.animator.stop();
                }
                this.hiding = false;
                this.hidingCause = -1;
            }
            this.displayMenuWindow(invoker, x, y);
            this.animator = WebTimer.repeat(StyleConstants.fastAnimationDelay, 0L, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = WebDynamicMenu.this.sync;
                    synchronized (object) {
                        if (WebDynamicMenu.this.currentProgress < 1.0f) {
                            WebDynamicMenu.this.currentProgress = Math.min(WebDynamicMenu.this.currentProgress + WebDynamicMenu.this.stepProgress, 1.0f);
                            WebDynamicMenu.this.revalidate();
                            WebDynamicMenu.this.setWindowOpacity(WebDynamicMenu.this.currentProgress);
                        } else {
                            WebDynamicMenu.this.animator.stop();
                            WebDynamicMenu.this.animator = null;
                            WebDynamicMenu.this.displaying = false;
                            WebDynamicMenu.this.fullyDisplayed();
                        }
                    }
                }
            });
        }
    }

    protected void displayMenuWindow(Component invoker, int x, int y) {
        this.setWindowOpacity(this.currentProgress);
        Dimension size = this.getPreferredSize();
        this.showPopup(invoker, x - size.width / 2, y - size.height / 2);
    }

    @Override
    public WebHeavyWeightPopup hidePopup() {
        this.hideMenu();
        return this;
    }

    public void hideMenu() {
        this.hideMenu(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideMenu(int index) {
        Object object = this.sync;
        synchronized (object) {
            if (this.hiding) {
                return;
            }
            this.hiding = true;
            this.hidingCause = index;
            if (this.displaying) {
                if (this.animator != null) {
                    this.animator.stop();
                }
                this.displaying = false;
            }
            this.animator = WebTimer.repeat(StyleConstants.fastAnimationDelay, 0L, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = WebDynamicMenu.this.sync;
                    synchronized (object) {
                        if (WebDynamicMenu.this.currentProgress > 0.0f) {
                            WebDynamicMenu.this.currentProgress = Math.max(WebDynamicMenu.this.currentProgress - WebDynamicMenu.this.stepProgress, 0.0f);
                            WebDynamicMenu.this.revalidate();
                            WebDynamicMenu.this.setWindowOpacity(WebDynamicMenu.this.currentProgress);
                        } else {
                            WebDynamicMenu.this.destroyMenuWindow();
                            WebDynamicMenu.this.animator.stop();
                            WebDynamicMenu.this.animator = null;
                            WebDynamicMenu.this.hiding = false;
                            WebDynamicMenu.this.hidingCause = -1;
                            WebDynamicMenu.this.fullyHidden();
                        }
                    }
                }
            });
        }
    }

    protected void destroyMenuWindow() {
        super.hidePopup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFullDisplay(Runnable action) {
        Object object = this.lsync;
        synchronized (object) {
            if (!this.isShowing() || this.isDisplaying()) {
                this.onFullDisplay.add(action);
            } else if (this.isShowing() && !this.isHiding()) {
                action.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyDisplayed() {
        Object object = this.lsync;
        synchronized (object) {
            for (Runnable runnable : this.onFullDisplay) {
                runnable.run();
            }
            this.onFullDisplay.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFullHide(Runnable action) {
        Object object = this.lsync;
        synchronized (object) {
            if (this.isShowing()) {
                this.onFullHide.add(action);
            } else {
                action.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyHidden() {
        Object object = this.lsync;
        synchronized (object) {
            for (Runnable runnable : this.onFullHide) {
                runnable.run();
            }
            this.onFullHide.clear();
        }
    }

    public double getItemAngle(Component item) {
        return this.getItemAngle(this.getComponentZOrder(item));
    }

    public double getItemAngle(int index) {
        return GeometryUtils.toDegrees(this.getActualLayout().getItemAngle(this, index));
    }

    public DynamicMenuLayout getActualLayout() {
        return (DynamicMenuLayout)this.getLayout();
    }

    public static boolean isAnyDynamicMenuDisplayed() {
        for (Window window : Window.getWindows()) {
            if (!window.isShowing() || !(window instanceof WebWindow) || !(((WebWindow)window).getContentPane() instanceof WebDynamicMenu)) continue;
            return true;
        }
        return false;
    }

    public static void hideAllDynamicMenus() {
        for (Window window : Window.getWindows()) {
            if (!window.isShowing() || !(window instanceof WebWindow) || !(((WebWindow)window).getContentPane() instanceof WebDynamicMenu)) continue;
            WebDynamicMenu menu = (WebDynamicMenu)((WebWindow)window).getContentPane();
            menu.hideMenu();
        }
    }
}

