/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.global.GlobalConstants;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.menu.WebMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.text.WebTextField;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileSystemView;

public class WebPathField
extends WebPanel {
    protected static final ImageIcon down = new ImageIcon(WebPathField.class.getResource("icons/down.png"));
    protected static final ImageIcon left = new ImageIcon(WebPathField.class.getResource("icons/left.png"));
    protected static final ImageIcon right = new ImageIcon(WebPathField.class.getResource("icons/right.png"));
    protected static final String FILE_ICON = "fileIcon";
    protected List<PathFieldListener> listeners = new ArrayList<PathFieldListener>(1);
    protected boolean focusOwner = false;
    protected static FileSystemView fsv = FileSystemView.getFileSystemView();
    protected AbstractFileFilter fileFilter = GlobalConstants.DIRECTORIES_FILTER;
    protected int preferredWidth = -1;
    protected boolean filesDropEnabled = true;
    protected File selectedPath;
    protected boolean autocompleteEnabled = true;
    protected JWindow autocompleteDialog = null;
    protected WebPanel contentPanel;
    protected WebTextField pathField;
    protected FocusAdapter pathFocusListener;
    protected WebButton myComputer = null;
    protected int rootsMenuItemsCount = 0;
    protected WebPopupMenu rootsMenu = null;
    protected WebToggleButton rootsArrowButton = null;
    protected final DefaultFocusTracker focusTracker;

    public WebPathField() {
        this(FileUtils.getDiskRoots()[0]);
    }

    public WebPathField(String path) {
        this(new File(path));
    }

    public WebPathField(File path) {
        super(true);
        this.setMargin(-1);
        this.setOpaque(false);
        this.setPaintFocus(true);
        this.setWebColoredBackground(false);
        this.setBackground(Color.WHITE);
        this.setTransferHandler(new FileDragAndDropHandler(){

            @Override
            public boolean isDropEnabled() {
                return WebPathField.this.filesDropEnabled;
            }

            @Override
            public boolean filesDropped(List<File> files) {
                AbstractFileFilter filter = WebPathField.this.getFileFilter();
                for (File file : files) {
                    File actualFile;
                    File file2 = actualFile = file.isDirectory() ? file : file.getParentFile();
                    if (filter != null && !filter.accept(actualFile)) continue;
                    WebPathField.this.folderSelected(actualFile);
                    return true;
                }
                return false;
            }
        });
        this.contentPanel = new WebPanel();
        this.contentPanel.setOpaque(false);
        this.contentPanel.setLayout(new HorizontalFlowLayout(0, true));
        this.add((Component)this.contentPanel, (Object)"Center");
        this.pathField = WebTextField.createWebTextField(false);
        this.pathField.setMargin(2);
        this.pathField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebPathField.this.autocompleteDialog == null || !WebPathField.this.autocompleteDialog.isVisible()) {
                    if (WebPathField.this.pathField.getText().trim().equals("")) {
                        WebPathField.this.folderSelected(null);
                    } else {
                        File choosenPath = new File(WebPathField.this.pathField.getText());
                        if (choosenPath.exists() && choosenPath.isDirectory()) {
                            WebPathField.this.folderSelected(choosenPath);
                        } else {
                            WebPathField.this.updatePath();
                        }
                    }
                    WebPathField.this.transferFocus();
                }
            }
        });
        this.pathField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((WebPathField.this.autocompleteDialog == null || !WebPathField.this.autocompleteDialog.isVisible()) && Hotkey.ESCAPE.isTriggered(e)) {
                    if (WebPathField.this.selectedPath == null && WebPathField.this.pathField.getText().trim().equals("") || WebPathField.this.selectedPath != null && WebPathField.this.getProperSelectedPath().equals(WebPathField.this.pathField.getText())) {
                        WebPathField.this.updatePath();
                        WebPathField.this.transferFocus();
                    } else {
                        WebPathField.this.pathField.setText(WebPathField.this.getProperSelectedPath());
                    }
                }
            }
        });
        this.pathFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (WebPathField.this.selectedPath == null && WebPathField.this.pathField.getText().trim().equals("") || WebPathField.this.selectedPath != null && WebPathField.this.getProperSelectedPath().equals(WebPathField.this.pathField.getText())) {
                    WebPathField.this.updatePath();
                }
            }
        };
        this.pathField.addCaretListener(new CaretListener(){
            private WebList list = null;
            private WebScrollPane listScroll;

            @Override
            public void caretUpdate(CaretEvent e) {
                int beginIndex;
                String t;
                String parentPath;
                File parent;
                List<File> similar;
                if (!(WebPathField.this.autocompleteEnabled && WebPathField.this.pathField.isVisible() && WebPathField.this.pathField.isShowing())) {
                    if (WebPathField.this.autocompleteDialog != null && WebPathField.this.autocompleteDialog.isVisible()) {
                        this.hideDialog();
                    }
                    return;
                }
                if (WebPathField.this.autocompleteDialog == null) {
                    WebPathField.this.autocompleteDialog = new JWindow(SwingUtils.getWindowAncestor(WebPathField.this));
                    WebPathField.this.autocompleteDialog.getContentPane().setLayout(new BorderLayout());
                    WebPathField.this.autocompleteDialog.setFocusable(false);
                    SwingUtils.getWindowAncestor(WebPathField.this).addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            this.hideDialog();
                        }

                        @Override
                        public void componentResized(ComponentEvent e) {
                            this.hideDialog();
                        }
                    });
                    this.list = new WebList();
                    this.list.setFocusable(false);
                    this.list.setSelectionMode(0);
                    this.list.setRolloverSelectionEnabled(true);
                    this.list.setCellRenderer(new WebListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                            renderer.setIcon(FileUtils.getFileIcon((File)value));
                            renderer.setText(FileUtils.getDisplayFileName((File)value));
                            return renderer;
                        }
                    });
                    this.list.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            int index = list.getUI().locationToIndex(list, e.getPoint());
                            if (SwingUtilities.isLeftMouseButton(e) && index != -1) {
                                this.setSelectedPath((File)list.getModel().getElementAt(index));
                            }
                        }
                    });
                    this.list.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (Hotkey.ENTER.isTriggered(e)) {
                                this.setSelectedPath((File)list.getSelectedValue());
                            }
                        }
                    });
                    this.listScroll = new WebScrollPane(this.list);
                    this.listScroll.setShadeWidth(0);
                    WebPathField.this.autocompleteDialog.getContentPane().add((Component)this.listScroll, "Center");
                    WebPathField.this.pathField.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (WebPathField.this.autocompleteDialog.isShowing() && list.getModel().getSize() > 0) {
                                if (list.getSelectedIndex() != -1) {
                                    if (Hotkey.ESCAPE.isTriggered(e) || Hotkey.F2.isTriggered(e) || Hotkey.CTRL_ENTER.isTriggered(e)) {
                                        this.hideDialog();
                                    } else if (Hotkey.ENTER.isTriggered(e)) {
                                        this.setSelectedPath((File)list.getSelectedValue());
                                    } else if (Hotkey.UP.isTriggered(e)) {
                                        if (list.getSelectedIndex() == 0) {
                                            list.setSelectedIndex(list.getModel().getSize() - 1);
                                            this.scrollToSelected();
                                        } else {
                                            list.setSelectedIndex(list.getSelectedIndex() - 1);
                                            this.scrollToSelected();
                                        }
                                    } else if (Hotkey.DOWN.isTriggered(e)) {
                                        if (list.getSelectedIndex() == list.getModel().getSize() - 1) {
                                            list.setSelectedIndex(0);
                                            this.scrollToSelected();
                                        } else {
                                            list.setSelectedIndex(list.getSelectedIndex() + 1);
                                            this.scrollToSelected();
                                        }
                                    }
                                } else {
                                    list.setSelectedIndex(0);
                                    this.scrollToSelected();
                                }
                            }
                        }

                        private void scrollToSelected() {
                            list.scrollRectToVisible(list.getUI().getCellBounds(list, list.getSelectedIndex(), list.getSelectedIndex()));
                        }
                    });
                    WebPathField.this.pathField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusLost(FocusEvent e) {
                            this.hideDialog();
                        }
                    });
                }
                if ((similar = WebPathField.this.getSimilarFileChilds(parent = (parentPath = t.substring(0, beginIndex = (beginIndex = (t = WebPathField.this.pathField.getText().substring(0, WebPathField.this.pathField.getCaretPosition())).lastIndexOf(File.separator)) != -1 ? beginIndex + 1 : 0)).trim().equals("") ? null : new File(parentPath), t.substring(beginIndex))) != null && similar.size() > 0) {
                    this.updateList(similar);
                } else {
                    this.hideDialog();
                }
            }

            private void updateList(final List<File> similar) {
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        list.setModel(new AbstractListModel(){

                            @Override
                            public int getSize() {
                                return similar.size();
                            }

                            @Override
                            public Object getElementAt(int i) {
                                return similar.get(i);
                            }
                        });
                        list.setVisibleRowCount(Math.min(similar.size(), 6));
                        list.updateUI();
                        if (similar.size() > 0) {
                            list.setSelectedIndex(0);
                        }
                        Point los = WebPathField.this.pathField.getLocationOnScreen();
                        WebPathField.this.autocompleteDialog.setSize(WebPathField.this.pathField.getWidth(), (this).listScroll.getPreferredSize().height);
                        WebPathField.this.autocompleteDialog.setLocation(WebPathField.this.pathField.getComponentOrientation().isLeftToRight() ? los.x : los.x + WebPathField.this.pathField.getWidth() - WebPathField.this.autocompleteDialog.getWidth(), los.y + WebPathField.this.pathField.getHeight());
                        if (!WebPathField.this.autocompleteDialog.isShowing()) {
                            WebPathField.this.autocompleteDialog.setVisible(true);
                            WebPathField.this.transferFocus();
                        }
                    }
                });
            }

            private void hideDialog() {
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebPathField.this.autocompleteDialog.setVisible(false);
                    }
                });
            }

            private void setSelectedPath(File path) {
                String text = path.getAbsolutePath();
                text = text.endsWith(File.separator) ? text : text + File.separator;
                WebPathField.this.pathField.setText(text);
                WebPathField.this.pathField.setCaretPosition(text.length());
            }
        });
        this.contentPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    WebPathField.this.startEditing();
                }
            }
        });
        HotkeyManager.registerHotkey((Component)this, (Component)this, Hotkey.F2, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                WebPathField.this.startEditing();
            }
        }, true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (!WebPathField.this.pathField.isShowing()) {
                    WebPathField.this.updatePath();
                }
            }
        });
        this.focusTracker = new DefaultFocusTracker(){

            @Override
            public void focusChanged(boolean focused) {
                WebPathField.this.focusOwner = focused;
                WebPathField.this.repaint();
            }
        };
        FocusManager.addFocusTracker(this, this.focusTracker);
        this.updatePath(path);
    }

    protected void startEditing() {
        if (!this.pathField.isFocusOwner()) {
            this.pathField.setPreferredSize(new Dimension(1, this.contentPanel.getHeight()));
            this.contentPanel.removeAll();
            if (this.selectedPath != null) {
                this.pathField.setText(this.getProperSelectedPath());
            } else {
                this.pathField.setText("");
            }
            this.pathField.selectAll();
            this.contentPanel.add((Component)this.pathField);
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
            this.transferFocus();
            this.pathField.addFocusListener(this.pathFocusListener);
        }
    }

    protected String getProperSelectedPath() {
        String path = this.selectedPath.getAbsolutePath();
        path = path.endsWith(File.separator) ? path : path + File.separator;
        return path;
    }

    public boolean isEditing() {
        return this.pathField.isFocusOwner();
    }

    public boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    public void setAutocompleteEnabled(boolean autocompleteEnabled) {
        this.autocompleteEnabled = autocompleteEnabled;
    }

    public AbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(AbstractFileFilter fileFilter) {
        this.setFileFilter(fileFilter, true);
    }

    public void setFileFilter(AbstractFileFilter fileFilter, boolean updatePath) {
        this.fileFilter = fileFilter;
        if (updatePath) {
            this.updatePath();
        }
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean filesDropEnabled) {
        this.filesDropEnabled = filesDropEnabled;
    }

    public File getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(File selectedPath) {
        this.updatePath(selectedPath);
    }

    public WebTextField getPathField() {
        return this.pathField;
    }

    public void updatePath() {
        this.updatePath(this.selectedPath);
    }

    protected synchronized void updatePath(File path) {
        this.selectedPath = path;
        this.pathField.removeFocusListener(this.pathFocusListener);
        this.contentPanel.removeAll();
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (SystemUtils.isWindows()) {
            WebButton computerButton = this.getMyComputer();
            this.contentPanel.add((Component)computerButton);
            this.contentPanel.add((Component)this.getRootsArrowButton(ltr));
        }
        if (this.selectedPath != null) {
            File folder = new File(this.selectedPath.getAbsolutePath());
            ArrayList<File> parents = new ArrayList<File>();
            parents.add(0, folder);
            while (folder.getParent() != null) {
                folder = folder.getParentFile();
                parents.add(0, folder);
            }
            boolean first = true;
            for (final File file : parents) {
                WebButton wb = new WebButton();
                wb.setRound(!SystemUtils.isWindows() && first ? StyleConstants.smallRound : 0);
                wb.setShadeWidth(0);
                wb.setLeftRightSpacing(0);
                wb.setRolloverDecoratedOnly(true);
                wb.setRolloverDarkBorderOnly(false);
                wb.setFocusable(false);
                if (!SystemUtils.isWindows() && first) {
                    wb.setIcon(FileUtils.getMyComputerIcon());
                    wb.putClientProperty(FILE_ICON, FileUtils.getMyComputerIcon());
                } else {
                    wb.setText(fsv.getSystemDisplayName(file));
                    wb.putClientProperty(FILE_ICON, FileUtils.getFileIcon(file, false));
                }
                wb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebPathField.this.folderSelected(file);
                    }
                });
                this.contentPanel.add((Component)wb);
                int childsCount = 0;
                final WebPopupMenu menu = new WebPopupMenu();
                File[] files = FileUtils.sortFiles(this.getFileChilds(file));
                if (files != null) {
                    for (final File root : files) {
                        if (!root.isDirectory()) continue;
                        WebMenuItem menuItem = new WebMenuItem(FileUtils.getDisplayFileName(root));
                        menuItem.setIcon(FileUtils.getFileIcon(root, false));
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                WebPathField.this.folderSelected(root);
                            }
                        });
                        menu.add(menuItem);
                        ++childsCount;
                    }
                }
                if (!SystemUtils.isWindows() && first) {
                    this.setRootsMenu(menu, childsCount);
                }
                final WebToggleButton childs = new WebToggleButton();
                childs.setIcon(ltr ? right : left);
                childs.setSelectedIcon(down);
                childs.setShadeToggleIcon(false);
                childs.setRound(0);
                childs.setShadeWidth(0);
                childs.setRolloverDecoratedOnly(true);
                childs.setRolloverDarkBorderOnly(false);
                childs.setFocusable(false);
                childs.setComponentPopupMenu(menu);
                childs.setMargin(0);
                childs.setLeftRightSpacing(0);
                childs.setEnabled(childsCount > 0);
                childs.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebPathField.this.transferFocus();
                        SwingUtils.applyOrientation(menu);
                        menu.showBelowMiddle(childs);
                    }
                });
                this.contentPanel.add((Component)childs);
                menu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        childs.setSelected(false);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                        childs.setSelected(false);
                    }
                });
                first = false;
            }
        }
        this.contentPanel.add((Component)new JLabel());
        if (!SystemUtils.isWindows()) {
            while (this.getRootsMenu().getComponentCount() > this.getRootsMenuItemsCount()) {
                this.getRootsMenu().remove(0);
            }
        }
        if (this.canShortenPath()) {
            this.getRootsMenu().addSeparator(0);
        }
        while (this.canShortenPath()) {
            WebButton wb = (WebButton)this.contentPanel.getComponent(2);
            WebMenuItem menuItem = new WebMenuItem();
            menuItem.setIcon((Icon)wb.getClientProperty(FILE_ICON));
            menuItem.setText(wb.getText());
            menuItem.addActionListener(wb.getActionListeners()[0]);
            this.getRootsMenu().add((Component)menuItem, 0);
            this.contentPanel.remove(2);
            this.contentPanel.remove(2);
        }
        this.revalidate();
        this.repaint();
    }

    protected List<File> getSimilarFileChilds(File file, String namePart) {
        String searchText = namePart.toLowerCase();
        File[] childs = this.getFileChilds(file);
        ArrayList<File> similar = new ArrayList<File>();
        if (childs != null) {
            for (File child : childs) {
                if (!child.getName().toLowerCase().contains(searchText)) continue;
                similar.add(child);
            }
        }
        return similar;
    }

    protected File[] getFileChilds(File file) {
        return file != null ? file.listFiles(this.fileFilter) : FileUtils.getDiskRoots();
    }

    protected boolean canShortenPath() {
        return this.contentPanel.getPreferredSize().width > this.contentPanel.getWidth() && this.contentPanel.getComponentCount() > 5;
    }

    protected WebButton getMyComputer() {
        if (this.myComputer == null) {
            this.myComputer = WebButton.createIconWebButton(FileUtils.getMyComputerIcon());
            this.myComputer.setRound(this.getRound());
            this.myComputer.setShadeWidth(0);
            this.myComputer.setLeftRightSpacing(0);
            this.myComputer.setRolloverDecoratedOnly(true);
            this.myComputer.setRolloverDarkBorderOnly(false);
            this.myComputer.setDrawFocus(false);
            this.myComputer.setDrawRight(false);
            this.myComputer.setDrawRightLine(true);
            this.myComputer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebPathField.this.folderSelected(null);
                }
            });
        }
        return this.myComputer;
    }

    public WebPopupMenu getRootsMenu() {
        return this.rootsMenu;
    }

    public int getRootsMenuItemsCount() {
        return this.rootsMenuItemsCount;
    }

    public void setRootsMenu(WebPopupMenu rootsMenu, int childsCount) {
        this.rootsMenu = rootsMenu;
        this.rootsMenuItemsCount = childsCount;
    }

    protected WebToggleButton getRootsArrowButton(boolean ltr) {
        if (this.rootsArrowButton == null) {
            this.rootsMenu = new WebPopupMenu();
            File[] rootFiles = FileUtils.getDiskRoots();
            for (final File root : FileUtils.sortFiles(rootFiles)) {
                WebMenuItem menuItem = new WebMenuItem(FileUtils.getDisplayFileName(root));
                menuItem.setIcon(FileUtils.getFileIcon(root, false));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebPathField.this.folderSelected(root);
                    }
                });
                this.rootsMenu.add(menuItem);
                ++this.rootsMenuItemsCount;
            }
            this.rootsArrowButton = new WebToggleButton();
            this.rootsArrowButton.setIcon(ltr ? right : left);
            this.rootsArrowButton.setSelectedIcon(down);
            this.rootsArrowButton.setShadeToggleIcon(false);
            this.rootsArrowButton.setRound(0);
            this.rootsArrowButton.setShadeWidth(0);
            this.rootsArrowButton.setRolloverDecoratedOnly(true);
            this.rootsArrowButton.setRolloverDarkBorderOnly(false);
            this.rootsArrowButton.setFocusable(false);
            this.rootsArrowButton.setMargin(0);
            this.rootsArrowButton.setLeftRightSpacing(0);
            this.rootsArrowButton.setComponentPopupMenu(this.rootsMenu);
            this.rootsArrowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebPathField.this.transferFocus();
                    SwingUtils.applyOrientation(WebPathField.this.rootsMenu);
                    WebPathField.this.rootsMenu.showBelowMiddle(WebPathField.this.rootsArrowButton);
                }
            });
            this.rootsMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    WebPathField.this.rootsArrowButton.setSelected(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    WebPathField.this.rootsArrowButton.setSelected(false);
                }
            });
        } else {
            this.rootsArrowButton.setIcon(ltr ? right : left);
        }
        while (this.rootsMenu.getComponentCount() > this.rootsMenuItemsCount) {
            this.rootsMenu.remove(0);
        }
        return this.rootsArrowButton;
    }

    protected void folderSelected(File folder) {
        folder = FileUtils.normalize(folder);
        this.updatePath(folder);
        this.fireDirectoryChanged(folder);
        this.transferFocus();
    }

    public void addPathFieldListener(PathFieldListener listener) {
        this.listeners.add(listener);
    }

    public void removePathFieldListener(PathFieldListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDirectoryChanged(File newDirectory) {
        for (PathFieldListener listener : CollectionUtils.copy(this.listeners)) {
            listener.directoryChanged(newDirectory);
        }
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.updatePath();
    }
}

