/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.filechooser.FilesSelectionListener;
import com.alee.extended.filechooser.WebFilePlate;
import com.alee.extended.layout.WrapFlowLayout;
import com.alee.global.StyleConstants;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.swing.WebTimer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class WebFileDrop
extends WebPanel
implements LanguageMethods {
    public static final ImageIcon CROSS_ICON = new ImageIcon(WebFileDrop.class.getResource("icons/cross.png"));
    protected static final BasicStroke dashStroke = new BasicStroke(3.0f, 1, 1, 1.0f, new float[]{8.0f, 8.0f}, 0.0f);
    protected int dashRound = StyleConstants.smallRound;
    protected int dashSideSpacing = 10;
    protected Color dropBackground = new Color(242, 242, 242);
    protected Color dropBorder = new Color(192, 192, 192);
    protected final List<FilesSelectionListener> listeners = new ArrayList<FilesSelectionListener>(1);
    protected boolean showRemoveButton = true;
    protected boolean showFileExtensions = false;
    protected boolean filesDragEnabled = false;
    protected int dragAction = 2;
    protected boolean filesDropEnabled = true;
    protected boolean allowSameFiles = false;
    protected AbstractFileFilter fileFilter = null;
    protected boolean showDropText = true;
    protected float dropTextOpacity = 1.0f;
    protected String dropText = null;
    protected List<File> selectedFiles = new ArrayList<File>();

    public WebFileDrop() {
        super("file-drop", (LayoutManager)new WrapFlowLayout(true));
        this.setFont(SwingUtils.getDefaultLabelFont().deriveFont(1).deriveFont(20.0f));
        this.setShowDefaultDropText(true);
        this.setTransferHandler(new FileDragAndDropHandler(){

            @Override
            public boolean isDropEnabled() {
                return WebFileDrop.this.filesDropEnabled;
            }

            @Override
            public boolean filesDropped(List<File> files) {
                WebFileDrop.this.addSelectedFiles(files);
                return true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebFileDrop.this.requestFocusInWindow();
            }
        });
        this.addFileSelectionListener(new FilesSelectionListener(){
            private int filesCount = 0;
            private WebTimer animator = null;

            @Override
            public void selectionChanged(List<File> selectedFiles) {
                if (this.filesCount == 0 && selectedFiles.size() > 0) {
                    this.stopAnimator();
                    this.filesCount = selectedFiles.size();
                    this.animator = new WebTimer("WebFileDrop.textFadeOutTimer", StyleConstants.animationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (WebFileDrop.this.dropTextOpacity > 0.0f) {
                                WebFileDrop.this.dropTextOpacity -= 0.1f;
                            }
                            WebFileDrop.this.dropTextOpacity = Math.max(WebFileDrop.this.dropTextOpacity, 0.0f);
                            WebFileDrop.this.repaint();
                            if (WebFileDrop.this.dropTextOpacity <= 0.0f) {
                                animator.stop();
                            }
                        }
                    });
                    this.animator.start();
                } else if (this.filesCount > 0 && selectedFiles.size() == 0) {
                    this.stopAnimator();
                    this.filesCount = selectedFiles.size();
                    this.animator = new WebTimer("WebFileDrop.textFadeInTimer", StyleConstants.animationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (WebFileDrop.this.dropTextOpacity < 1.0f) {
                                WebFileDrop.this.dropTextOpacity += 0.1f;
                            }
                            WebFileDrop.this.dropTextOpacity = Math.min(WebFileDrop.this.dropTextOpacity, 1.0f);
                            WebFileDrop.this.repaint();
                            if (WebFileDrop.this.dropTextOpacity >= 1.0f) {
                                animator.stop();
                            }
                        }
                    });
                    this.animator.start();
                }
            }

            private void stopAnimator() {
                if (this.animator != null && this.animator.isRunning()) {
                    this.animator.stop();
                }
            }
        });
    }

    public boolean isShowDropText() {
        return this.showDropText;
    }

    public void setShowDropText(boolean showDropText) {
        this.showDropText = showDropText;
        this.repaint();
    }

    public boolean isFilesDragEnabled() {
        return this.filesDragEnabled;
    }

    public void setFilesDragEnabled(boolean filesDragEnabled) {
        this.filesDragEnabled = filesDragEnabled;
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public void setDragAction(int dragAction) {
        this.dragAction = dragAction;
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean filesDropEnabled) {
        this.filesDropEnabled = filesDropEnabled;
    }

    public List<File> getSelectedFiles() {
        return CollectionUtils.copy(this.selectedFiles);
    }

    public void setSelectedFiles(List<File> files) {
        this.removeAllSelectedFiles();
        this.addSelectedFiles(files);
    }

    public void addSelectedFiles(List<File> files) {
        boolean changed = false;
        for (File file : files) {
            changed = this.addSelectedFileImpl(file) || changed;
        }
        if (changed) {
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    public void addSelectedFiles(File ... files) {
        boolean changed = false;
        for (File file : files) {
            changed = this.addSelectedFileImpl(file) || changed;
        }
        if (changed) {
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    public void addSelectedFile(File file) {
        if (this.addSelectedFileImpl(file)) {
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    protected boolean addSelectedFileImpl(File file) {
        if (!(this.fileFilter != null && !this.fileFilter.accept(file) || !this.allowSameFiles && FileUtils.containtsFile(this.selectedFiles, file))) {
            this.add((Component)this.createFilePlate(file));
            this.selectedFiles.add(file);
            return true;
        }
        return false;
    }

    public void removeAllSelectedFiles() {
        boolean changed = false;
        for (File file : CollectionUtils.copy(this.selectedFiles)) {
            changed = this.removeSelectedFileImpl(file, false) || changed;
        }
        if (changed) {
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    public void removeSelectedFiles(List<File> files) {
        boolean changed = false;
        for (File file : files) {
            changed = this.removeSelectedFileImpl(file, true) || changed;
        }
        if (changed) {
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    public void removeSelectedFiles(File ... files) {
        boolean changed = false;
        for (File file : files) {
            changed = this.removeSelectedFileImpl(file, true) || changed;
        }
        if (changed) {
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    public void removeSelectedFile(File file) {
        if (this.removeSelectedFileImpl(file, true)) {
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    protected boolean removeSelectedFileImpl(File file, boolean animate) {
        if (FileUtils.containtsFile(this.selectedFiles, file)) {
            for (WebFilePlate filePlate : this.getFilePlates(file)) {
                if (animate) {
                    filePlate.remove();
                    continue;
                }
                this.remove(filePlate);
                this.selectedFiles.remove(file);
            }
            return !animate;
        }
        return false;
    }

    public List<WebFilePlate> getFilePlates(File file) {
        ArrayList<WebFilePlate> plates = new ArrayList<WebFilePlate>(1);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof WebFilePlate)) continue;
            WebFilePlate filePlate = (WebFilePlate)component;
            if (!file.getAbsolutePath().equals(filePlate.getFile().getAbsolutePath())) continue;
            plates.add(filePlate);
        }
        return plates;
    }

    public boolean isAllowSameFiles() {
        return this.allowSameFiles;
    }

    public void setAllowSameFiles(boolean allowSameFiles) {
        this.allowSameFiles = allowSameFiles;
        this.setSelectedFiles(this.selectedFiles);
    }

    public AbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(AbstractFileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.setSelectedFiles(this.selectedFiles);
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean showRemoveButton) {
        this.showRemoveButton = showRemoveButton;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((WebFilePlate)this.getComponent(i)).setShowRemoveButton(showRemoveButton);
        }
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean showFileExtensions) {
        this.showFileExtensions = showFileExtensions;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((WebFilePlate)this.getComponent(i)).setShowFileExtensions(showFileExtensions);
        }
    }

    public Color getDropBackground() {
        return this.dropBackground;
    }

    public void setDropBackground(Color dropBackground) {
        this.dropBackground = dropBackground;
        this.repaint();
    }

    public Color getDropBorder() {
        return this.dropBorder;
    }

    public void setDropBorder(Color dropBorder) {
        this.dropBorder = dropBorder;
        this.repaint();
    }

    public int getDashRound() {
        return this.dashRound;
    }

    public void setDashRound(int dashRound) {
        this.dashRound = dashRound;
        this.repaint();
    }

    public int getDashSideSpacing() {
        return this.dashSideSpacing;
    }

    public void setDashSideSpacing(int dashSideSpacing) {
        this.dashSideSpacing = dashSideSpacing;
        this.repaint();
    }

    public String getDropText() {
        return this.dropText;
    }

    public void setDropText(String dropText) {
        this.dropText = dropText;
        this.repaint();
    }

    public void setShowDefaultDropText(boolean defaultDropText) {
        if (defaultDropText) {
            this.setLanguage("weblaf.ex.filedrop.drop", new Object[0]);
        } else {
            this.removeLanguage();
        }
        this.repaint();
    }

    public boolean isDropTextVisible() {
        return this.dropText != null && this.showDropText && this.dropTextOpacity > 0.0f;
    }

    protected WebFilePlate createFilePlate(final File file) {
        WebFilePlate filePlate = new WebFilePlate(file);
        filePlate.setShowFileExtensions(this.showFileExtensions);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebFileDrop.this.requestFocusInWindow();
            }
        });
        filePlate.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileDrop.this.selectedFiles.remove(file);
                WebFileDrop.this.fireSelectionChanged();
            }
        });
        return filePlate;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isDropTextVisible()) {
            Graphics2D g2d = (Graphics2D)g;
            Composite old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(this.dropTextOpacity));
            Object aa = GraphicsUtils.setupAntialias(g2d);
            Insets bi = this.getInsets();
            int hd = Math.round(dashStroke.getLineWidth() / 2.0f);
            int hd2 = Math.round(dashStroke.getLineWidth());
            int dashX = this.dashSideSpacing + bi.left;
            int dashY = this.dashSideSpacing + bi.top;
            int dashWidth = this.getWidth() - this.dashSideSpacing * 2 - bi.left - bi.right;
            int dashHeight = this.getHeight() - this.dashSideSpacing * 2 - bi.top - bi.bottom;
            g2d.setPaint(this.dropBackground);
            g2d.fillRoundRect(dashX + hd, dashY + hd, dashWidth - hd2, dashHeight - hd2, this.dashRound * 2, this.dashRound * 2);
            Stroke os = GraphicsUtils.setupStroke(g2d, dashStroke);
            g2d.setPaint(this.dropBorder);
            g2d.drawRoundRect(dashX, dashY, dashWidth, dashHeight, this.dashRound * 2, this.dashRound * 2);
            GraphicsUtils.restoreStroke(g2d, os);
            GraphicsUtils.restoreAntialias(g2d, aa);
            FontMetrics fm = g2d.getFontMetrics();
            if (dashWidth >= fm.stringWidth(this.dropText) && dashHeight > fm.getHeight()) {
                Map hints = SwingUtils.setupTextAntialias(g2d);
                Point ts = LafUtils.getTextCenterShear(fm, this.dropText);
                g2d.drawString(this.dropText, dashX + dashWidth / 2 + ts.x, dashY + dashHeight / 2 + ts.y);
                SwingUtils.restoreTextAntialias(g2d, hints);
            }
            GraphicsUtils.restoreComposite(g2d, old);
        }
    }

    public void addFileSelectionListener(FilesSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileSelectionListener(FilesSelectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSelectionChanged() {
        for (FilesSelectionListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged(CollectionUtils.copy(this.selectedFiles));
        }
    }

    @Override
    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, data);
    }

    @Override
    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, key, data);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }
}

