/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.FrameType;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.painter.Painter;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.TextUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WebDockableFrame
extends WebPanel
implements LanguageMethods {
    public static final ImageIcon dockTop = new ImageIcon(WebDockablePane.class.getResource("icons/dock_top.png"));
    public static final ImageIcon dockLeft = new ImageIcon(WebDockablePane.class.getResource("icons/dock_left.png"));
    public static final ImageIcon dockRight = new ImageIcon(WebDockablePane.class.getResource("icons/dock_right.png"));
    public static final ImageIcon dockBottom = new ImageIcon(WebDockablePane.class.getResource("icons/dock_bottom.png"));
    public static final String ID_PREFIX = "WDF";
    protected String frameId;
    protected FrameType frameType;
    protected final WebPanel titlePanel;
    protected final WebLabel titleLabel;
    protected final WebPanel buttonsPanel;
    protected final WebButton dockButton;

    public WebDockableFrame() {
        this("");
    }

    public WebDockableFrame(String frameTitle) {
        this(TextUtils.generateId(ID_PREFIX), frameTitle);
    }

    public WebDockableFrame(String frameId, String frameTitle) {
        this(frameId, null, frameTitle);
    }

    public WebDockableFrame(Icon frameIcon) {
        this(frameIcon, "");
    }

    public WebDockableFrame(Icon frameIcon, String frameTitle) {
        this(TextUtils.generateId(ID_PREFIX), frameIcon, frameTitle);
    }

    public WebDockableFrame(String frameId, Icon frameIcon) {
        this(frameId, frameIcon, "");
    }

    public WebDockableFrame(String frameId, Icon frameIcon, String frameTitle) {
        super(true);
        this.frameId = frameId;
        this.setShadeWidth(0);
        this.setWebColoredBackground(false);
        this.setPaintSides(false, false, false, false);
        this.titlePanel = new WebPanel("dockable-frame-title");
        this.add((Component)this.titlePanel, (Object)"North");
        this.titleLabel = new WebLabel(frameTitle, frameIcon);
        this.titleLabel.setStyleId("dockable-frame-title");
        this.titlePanel.add((Component)this.titleLabel, (Object)"Center");
        this.buttonsPanel = new WebPanel("dockable-frame-buttons", (LayoutManager)new HorizontalFlowLayout(0, false));
        this.titlePanel.add((Component)this.buttonsPanel, (Object)"East");
        this.dockButton = new WebButton();
        this.dockButton.setLeftRightSpacing(0);
        this.dockButton.setShadeWidth(0);
        this.dockButton.setFocusable(false);
        this.dockButton.setDrawSides(false, true, false, false);
        this.buttonsPanel.add((Component)this.dockButton);
    }

    public String getFrameId() {
        return this.frameId;
    }

    public void setFrameId(String frameId) {
        this.frameId = frameId;
    }

    public void setIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.titleLabel.getIcon();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType frameType) {
        this.frameType = frameType;
        this.setPaintSides(frameType.equals((Object)FrameType.bottom), frameType.equals((Object)FrameType.right), frameType.equals((Object)FrameType.top), frameType.equals((Object)FrameType.left));
        this.dockButton.setIcon(this.getDockIcon(frameType));
    }

    public void setTitlePainter(Painter painter) {
        this.titlePanel.setPainter(painter);
    }

    public Painter getTitlePainter() {
        return this.titlePanel.getPainter();
    }

    public WebPanel getTitlePanel() {
        return this.titlePanel;
    }

    public WebLabel getTitleLabel() {
        return this.titleLabel;
    }

    public WebPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public void addButton(WebButton button) {
        button.setShadeWidth(0);
        button.setDrawSides(false, true, false, false);
        if (button.getText() == null || button.getText().trim().length() == 0) {
            button.setLeftRightSpacing(0);
        }
        this.buttonsPanel.add((Component)button, 0);
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
    }

    public WebButton getDockButton() {
        return this.dockButton;
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    protected Icon getDockIcon(FrameType frameType) {
        if (frameType.equals((Object)FrameType.top)) {
            return dockTop;
        }
        if (frameType.equals((Object)FrameType.left)) {
            return dockLeft;
        }
        if (frameType.equals((Object)FrameType.right)) {
            return dockRight;
        }
        if (frameType.equals((Object)FrameType.bottom)) {
            return dockBottom;
        }
        return null;
    }

    @Override
    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, data);
    }

    @Override
    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, key, data);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }
}

