/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.extended.date.DateSelectionListener;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateFieldStyle;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.text.WebFormattedTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.settings.SettingsMethods;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.SizeMethods;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebDateField
extends WebFormattedTextField
implements ShapeProvider,
SettingsMethods,
SizeMethods<WebFormattedTextField> {
    public static final ImageIcon selectDateIcon = new ImageIcon(WebDateField.class.getResource("icons/date.png"));
    protected List<DateSelectionListener> dateSelectionListeners = new ArrayList<DateSelectionListener>(1);
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    protected Date date = null;
    protected WebButton popupButton;
    protected WebWindow popup;
    protected WebCalendar calendar;
    protected DateSelectionListener dateSelectionListener;

    public WebDateField() {
        this((Date)null);
    }

    public WebDateField(boolean drawBorder) {
        this((Date)null, drawBorder);
    }

    public WebDateField(Date date) {
        this(date, WebDateFieldStyle.drawBorder);
    }

    public WebDateField(Date date, boolean drawBorder) {
        this.date = date;
        this.setOpaque(false);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawBackground(WebDateFieldStyle.drawBackground);
        this.setBackground(WebDateFieldStyle.backgroundColor);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawFocus(WebDateFieldStyle.drawFocus);
        this.popupButton = WebButton.createIconWebButton(selectDateIcon, WebDateFieldStyle.round);
        this.popupButton.setFocusable(false);
        this.popupButton.setShadeWidth(0);
        this.popupButton.setMoveIconOnPress(false);
        this.popupButton.setRolloverDecoratedOnly(true);
        this.popupButton.setCursor(Cursor.getDefaultCursor());
        this.popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDateField.this.showCalendarPopup();
            }
        });
        this.setTrailingComponent(this.popupButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDateField.this.setDateFromField();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebDateField.this.isEnabled() && SwingUtilities.isRightMouseButton(e)) {
                    WebDateField.this.showCalendarPopup();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!SwingUtils.isEqualOrChild(WebDateField.this.popup, e.getOppositeComponent())) {
                    WebDateField.this.setDateFromField();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (WebDateField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(e)) {
                        WebDateField.this.updateFieldFromDate();
                    } else if (Hotkey.DOWN.isTriggered(e)) {
                        WebDateField.this.showCalendarPopup();
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                WebDateField.this.hideCalendarPopup();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WebDateField.this.hideCalendarPopup();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                WebDateField.this.hideCalendarPopup();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                WebDateField.this.hideCalendarPopup();
            }
        });
        this.updateFieldFromDate();
        this.setDrawBorder(drawBorder);
        this.setRound(WebDateFieldStyle.round);
        this.setShadeWidth(WebDateFieldStyle.shadeWidth);
    }

    @Override
    public void setRound(int round) {
        super.setRound(round);
        this.popupButton.setRound(round);
    }

    @Override
    public void setDrawBorder(boolean drawBorder) {
        super.setDrawBorder(drawBorder);
        this.updateMargin();
    }

    protected void updateMargin() {
        this.setMargin(this.isDrawBorder() ? WebDateFieldStyle.margin : WebDateFieldStyle.undecoratedMargin);
    }

    protected void showCalendarPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.setDateFromField();
        if (this.popup == null || this.calendar == null) {
            Window ancestor = SwingUtils.getWindowAncestor(this);
            this.calendar = new WebCalendar(this.date);
            this.calendar.setPaintFocus(false);
            this.calendar.setRound(StyleConstants.smallRound);
            this.calendar.setShadeWidth(0);
            this.popup = new WebWindow(ancestor);
            this.popup.setLayout(new BorderLayout());
            this.popup.setCloseOnFocusLoss(true);
            this.popup.setWindowOpaque(false);
            this.popup.add(this.calendar);
            this.customizePopup(this.popup);
            this.popup.pack();
            this.updatePopupLocation();
            ancestor.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (WebDateField.this.popup.isShowing()) {
                        WebDateField.this.updatePopupLocation();
                    }
                }
            });
            this.dateSelectionListener = new DateSelectionListener(){

                @Override
                public void dateSelected(Date date) {
                    WebDateField.this.hideCalendarPopup();
                    WebDateField.this.setDateFromCalendar();
                    WebDateField.this.requestFocusInWindow();
                }
            };
            this.calendar.addDateSelectionListener(this.dateSelectionListener);
        } else {
            this.updatePopupLocation();
        }
        SwingUtils.copyOrientation(this, this.popup);
        this.popup.setVisible(true);
        this.calendar.transferFocus();
    }

    protected void customizePopup(WebWindow popup) {
    }

    protected void hideCalendarPopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    protected void updatePopupLocation() {
        Point los = this.getLocationOnScreen();
        Rectangle gb = this.popup.getGraphicsConfiguration().getBounds();
        int shadeWidth = this.isDrawBorder() ? this.getShadeWidth() : 0;
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = ltr ? (los.x + shadeWidth + this.popup.getWidth() <= gb.x + gb.width ? los.x + shadeWidth : los.x + w - shadeWidth - this.popup.getWidth()) : (los.x + w - shadeWidth - this.popup.getWidth() >= gb.x ? los.x + w - shadeWidth - this.popup.getWidth() : los.x + shadeWidth);
        int y = los.y + h + this.popup.getHeight() <= gb.y + gb.height ? los.y + h + (this.isDrawBorder() ? 0 : 1) : los.y - this.popup.getHeight() - (this.isDrawBorder() ? 0 : 1);
        this.popup.setLocation(x, y);
    }

    protected Date getDateFromField() {
        try {
            String text = this.getText();
            if (text != null && !text.trim().equals("")) {
                return this.dateFormat.parse(text);
            }
            return null;
        }
        catch (Throwable ex) {
            return this.date;
        }
    }

    protected String getTextDate() {
        return this.date != null ? this.dateFormat.format(this.date) : "";
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.setDateImpl(date, UpdateSource.other);
    }

    protected void setDateFromField() {
        this.setDateImpl(this.getDateFromField(), UpdateSource.field);
    }

    protected void setDateFromCalendar() {
        this.setDateImpl(this.calendar.getDate(), UpdateSource.calendar);
    }

    protected void setDateImpl(Date date, UpdateSource source) {
        boolean changed = !CompareUtils.equals(this.date, date);
        this.date = date;
        this.updateFieldFromDate();
        if (changed) {
            if (source != UpdateSource.calendar && this.calendar != null) {
                this.updateCalendarFromDate(date);
            }
            this.fireDateSelected(date);
        }
    }

    protected void updateFieldFromDate() {
        this.setText(this.getTextDate());
    }

    protected void updateCalendarFromDate(Date date) {
        this.calendar.removeDateSelectionListener(this.dateSelectionListener);
        this.calendar.setDate(date, false);
        this.calendar.addDateSelectionListener(this.dateSelectionListener);
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.updateFieldFromDate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.popupButton.setEnabled(enabled);
    }

    public void addDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.add(listener);
    }

    public void removeDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.remove(listener);
    }

    public void fireDateSelected(Date date) {
        for (DateSelectionListener listener : CollectionUtils.copy(this.dateSelectionListeners)) {
            listener.dateSelected(date);
        }
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebDateField setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebDateField setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebDateField setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebDateField setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    protected static enum UpdateSource {
        field,
        calendar,
        other;

    }
}

