/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.WebSplitButtonStyle;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButtonUI;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebSplitButtonUI
extends WebButtonUI {
    protected ImageIcon splitIcon = WebSplitButtonStyle.splitIcon;
    protected int splitIconGap = WebSplitButtonStyle.splitIconGap;
    protected int contentGap = WebSplitButtonStyle.contentGap;

    public static ComponentUI createUI(JComponent c) {
        return new WebSplitButtonUI();
    }

    public ImageIcon getSplitIcon() {
        return this.splitIcon;
    }

    public void setSplitIcon(ImageIcon splitIcon) {
        this.splitIcon = splitIcon;
    }

    public int getSplitIconGap() {
        return this.splitIconGap;
    }

    public void setSplitIconGap(int splitIconGap) {
        this.splitIconGap = splitIconGap;
    }

    public int getContentGap() {
        return this.contentGap;
    }

    public void setContentGap(int contentGap) {
        this.contentGap = contentGap;
    }

    @Override
    protected Insets getBorderInsets() {
        Insets i = super.getBorderInsets();
        boolean ltr = this.button.getComponentOrientation().isLeftToRight();
        int splitPartWidth = this.splitIcon.getIconWidth() + 1 + this.splitIconGap * 2 + this.contentGap;
        if (ltr) {
            i.right += splitPartWidth;
        } else {
            i.left += splitPartWidth;
        }
        return i;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        Rectangle rect = this.getSplitButtonBounds(c);
        int ix = rect.x + rect.width / 2 - this.splitIcon.getIconWidth() / 2;
        int iy = rect.y + rect.height / 2 - this.splitIcon.getIconHeight() / 2;
        g.drawImage(this.splitIcon.getImage(), ix, iy, null);
        int lineX = ltr ? rect.x : rect.x + rect.width - 1;
        g.setColor(c.isEnabled() ? StyleConstants.borderColor : StyleConstants.disabledBorderColor);
        g.drawLine(lineX, rect.y + 1, lineX, rect.y + rect.height - 2);
    }

    public Rectangle getSplitButtonBounds(JComponent c) {
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        Insets i = c.getInsets();
        int styleSide = this.drawRight ? this.shadeWidth + 1 : (this.drawRightLine ? 1 : 0);
        int height = c.getHeight() - i.top - i.bottom;
        if (ltr) {
            int width = i.right - this.contentGap - styleSide;
            return new Rectangle(c.getWidth() - i.right + this.contentGap, i.top, width, height);
        }
        int width = i.left - this.contentGap - styleSide;
        return new Rectangle(styleSide, i.top, width, height);
    }

    public Rectangle getSplitButtonHitbox(JComponent c) {
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        Insets i = c.getInsets();
        return ltr ? new Rectangle(c.getWidth() - i.right + this.contentGap, 0, i.right - this.contentGap, c.getHeight()) : new Rectangle(0, 0, i.left - this.contentGap, c.getHeight());
    }
}

