/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix.sort;

import edu.upf.bg.mtabix.sort.FileMerger;
import edu.upf.bg.mtabix.sort.FileSorter;
import edu.upf.bg.mtabix.sort.comparator.Lexical;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;

public class SortController {
    private static final int MERGE_FACTOR = 12;

    public static void sortAndCompressFile(String tmpFolderPath, InputStream inputStream, File outputFile, Comparator<String> comparator, String header) throws FileNotFoundException {
        SortController.sortAndCompressFile(tmpFolderPath, inputStream, outputFile, comparator, header, 12);
    }

    public static void sortAndCompressFile(String tmpFolderPath, InputStream inputStream, File outputFile, Comparator<String> comparator, String header, int mergeFactor) throws FileNotFoundException {
        if (comparator == null) {
            comparator = Lexical.ascending();
        }
        String tmpName = outputFile.getName() + "-sort-" + Long.toHexString(System.nanoTime());
        File tmpFolder = tmpFolderPath == null || tmpFolderPath.isEmpty() ? new File(System.getProperty("java.io.tmpdir"), tmpName) : new File(tmpFolderPath, tmpName);
        tmpFolder.mkdir();
        List<File> sortedFiles = FileSorter.splitAndSort(tmpFolder, inputStream, comparator, header != null);
        FileMerger.merge(tmpFolder, sortedFiles, outputFile, comparator, mergeFactor, header);
        for (File file : tmpFolder.listFiles()) {
            file.delete();
        }
        tmpFolder.delete();
    }
}

