/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix.sort;

import edu.upf.bg.mtabix.sort.DataUtilException;
import edu.upf.bg.mtabix.sort.FileMerger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.time.DurationFormatUtils;

public class FileSorter {
    private static final int MIN_AVAILABLE_MEMORY = 0xA00000;
    private static final int BUFFER_SIZE = 0x100000;
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> splitAndSort(final File splitDir, InputStream inputStream, final Comparator<String> comparator, boolean skipHeader) {
        if (splitDir == null) {
            throw new DataUtilException("The split directory parameter can not be a null value");
        }
        if (!splitDir.exists()) {
            throw new DataUtilException("The split directory is not a valid path");
        }
        ArrayList<File> splitFiles = new ArrayList<File>();
        long mem = FileSorter.getAvailableMemory();
        int maxLines = (int)((mem - 0xA00000L) / 250L);
        System.out.println("SORT...  (batch size: " + maxLines + " lines - available memory: " + mem / 0x100000L + "MB)");
        String[] rows = new String[maxLines];
        int sortedLines = 0;
        int blocks = 0;
        long start = System.currentTimeMillis();
        File batch01 = null;
        File batch02 = null;
        try {
            File splitFile;
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int rowNumber = 0;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (skipHeader && ++rowNumber == 1) continue;
                if (i == maxLines) {
                    Arrays.sort(rows, comparator);
                    splitFile = FileSorter.writePartToFile(splitDir, rows, i);
                    if (batch01 == null) {
                        batch01 = splitFile;
                    } else if (batch02 == null) {
                        batch02 = splitFile;
                    } else {
                        final File mergePair = File.createTempFile("tri-merge-", ".part", splitDir);
                        final ArrayList<File> batch = new ArrayList<File>(3);
                        batch.add(batch01);
                        batch.add(batch02);
                        batch.add(splitFile);
                        EXECUTOR.submit(new Runnable(){

                            @Override
                            public void run() {
                                FileMerger.merge(splitDir, batch, mergePair, comparator, 12, null);
                            }
                        });
                        splitFiles.add(mergePair);
                        batch01 = null;
                        batch02 = null;
                    }
                    rows = new String[maxLines];
                    i = 0;
                    System.out.println("Sort " + ++blocks + " (" + (sortedLines += maxLines) + " lines done - " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - start), (String)"HH:mm:ss,SSS") + ") ");
                }
                rows[i] = line;
                ++i;
            }
            if (batch01 != null) {
                splitFiles.add(batch01);
            }
            if (batch02 != null) {
                splitFiles.add(batch02);
            }
            if (i > 0) {
                Arrays.sort(rows, 0, i, comparator);
                splitFile = FileSorter.writePartToFile(splitDir, rows, i);
                splitFiles.add(splitFile);
                System.out.println("Sort " + ++blocks + " (" + (sortedLines += i) + " lines done - " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - start), (String)"HH:mm:ss,SSS") + ") ");
            }
            inputStream.close();
            inputStream = null;
            EXECUTOR.shutdown();
            EXECUTOR.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (FileNotFoundException e) {
            throw new DataUtilException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataUtilException(e);
        }
        catch (IOException e) {
            throw new DataUtilException(e);
        }
        catch (InterruptedException e) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return splitFiles;
    }

    private static File writePartToFile(File splitDir, String[] rows, int size) {
        File splitFile;
        PrintWriter writer = null;
        try {
            splitFile = File.createTempFile("split-", ".part", splitDir);
            writer = new PrintWriter(new GZIPOutputStream((OutputStream)new FileOutputStream(splitFile), 0x100000));
            for (int i = 0; i < size; ++i) {
                writer.println(rows[i]);
            }
            writer.flush();
            writer.close();
            writer = null;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataUtilException(e);
        }
        catch (FileNotFoundException e) {
            throw new DataUtilException(e);
        }
        catch (IOException e) {
            throw new DataUtilException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return splitFile;
    }

    private static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long usedMemory = totalMemory - freeMemory;
        long availableMemory = maxMemory - usedMemory;
        return availableMemory;
    }
}

