/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix.sort;

import edu.upf.bg.mtabix.compress.BlockCompressedOutputStream;
import edu.upf.bg.mtabix.sort.DataUtilDefaults;
import edu.upf.bg.mtabix.sort.DataUtilException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.time.DurationFormatUtils;

public class FileMerger {
    private static final int MERGE_FACTOR = 8;
    public static final int BUFFER_SIZE = 0x100000;

    public static void merge(File mergeDir, List<File> sortedFiles, File mergedFile, Comparator<String> comparator) {
        FileMerger.merge(mergeDir, sortedFiles, mergedFile, comparator, 8, null);
    }

    public static void merge(File mergeDir, List<File> sortedFiles, File mergedFile, Comparator<String> comparator, int mergeFactor, String header) {
        LinkedList<File> mergeFiles = new LinkedList<File>(sortedFiles);
        LinkedList<BatchFile> batch = new LinkedList<BatchFile>();
        int mergeSteps = 0;
        int totalSteps = (int)Math.ceil((double)sortedFiles.size() / (double)mergeFactor);
        System.out.println("MERGE... ");
        long start = System.currentTimeMillis();
        try {
            while (mergeFiles.size() > 0) {
                File aggFile;
                batch.clear();
                for (int i = 0; i < mergeFactor && mergeFiles.size() > 0; ++i) {
                    batch.add(new BatchFile(mergeFiles.remove()));
                }
                if (mergeFiles.size() > 0) {
                    aggFile = File.createTempFile("merge-", ".part", mergeDir);
                    mergeFiles.addLast(aggFile);
                } else {
                    aggFile = mergedFile;
                }
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new BlockCompressedOutputStream(aggFile.getAbsoluteFile()), 0x100000)));
                if (header != null && mergeFiles.size() == 0) {
                    writer.println(header);
                }
                Object[] buffer = new String[batch.size()];
                Arrays.fill(buffer, null);
                boolean[] inUse = new boolean[batch.size()];
                Arrays.fill(inUse, true);
                boolean inUseFlag = true;
                while (inUseFlag) {
                    int index = -1;
                    Object selected = null;
                    for (int i = 0; i < batch.size(); ++i) {
                        if (!inUse[i]) continue;
                        if (buffer[i] == null) {
                            buffer[i] = ((BatchFile)batch.get(i)).getRow();
                            if (buffer[i] == null) {
                                inUse[i] = false;
                            }
                        }
                        if (buffer[i] == null) continue;
                        if (index == -1) {
                            index = i;
                            selected = buffer[i];
                            continue;
                        }
                        if (comparator.compare((String)buffer[i], (String)selected) >= 0) continue;
                        index = i;
                        selected = buffer[i];
                    }
                    if (index >= 0) {
                        writer.println((String)buffer[index]);
                        buffer[index] = null;
                        inUseFlag = true;
                        continue;
                    }
                    inUseFlag = false;
                }
                writer.flush();
                writer.close();
                System.out.println("Merge (" + ++mergeSteps + " / " + totalSteps + " - " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - start), (String)"HH:mm:ss,SSS") + ")");
            }
        }
        catch (IOException e) {
            throw new DataUtilException(e);
        }
    }

    private static class BatchFile {
        private File file;
        private InputStream inputStream;
        private BufferedReader reader;
        private String line;
        private boolean hasMoreData;

        private BatchFile(File file) {
            this.file = file;
            try {
                this.inputStream = new GZIPInputStream(new FileInputStream(file));
                this.reader = new BufferedReader(new InputStreamReader(this.inputStream, DataUtilDefaults.charSet));
                this.hasMoreData = true;
            }
            catch (FileNotFoundException e) {
                throw new DataUtilException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new DataUtilException(e);
            }
            catch (IOException e) {
                throw new DataUtilException(e);
            }
        }

        private String getRow() {
            if (!this.hasMoreData) {
                return null;
            }
            try {
                this.line = this.reader.readLine();
                if (this.line == null) {
                    this.hasMoreData = false;
                    this.close();
                }
                return this.line;
            }
            catch (IOException e) {
                this.hasMoreData = false;
                throw new DataUtilException(e);
            }
        }

        public File getFile() {
            return this.file;
        }

        private void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new DataUtilException(e);
            }
        }
    }
}

