/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix.compress;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class MappedReadFile
implements Closeable {
    private List<ByteBuffer> chunks = new ArrayList<ByteBuffer>();
    private static final long TWOGIG = Integer.MAX_VALUE;
    private long length;
    private RandomAccessFile coreFileAccessor;

    public MappedReadFile(File coreFile) throws IOException {
        long len;
        this.coreFileAccessor = new RandomAccessFile(coreFile, "r");
        this.length = this.coreFileAccessor.length();
        FileChannel channelMapper = this.coreFileAccessor.getChannel();
        long nChunks = this.length / Integer.MAX_VALUE;
        if (nChunks > Integer.MAX_VALUE) {
            throw new ArithmeticException("Requested File Size Too Large");
        }
        long from = 0L;
        for (long countDown = this.length; countDown > 0L; countDown -= len) {
            len = Math.min(Integer.MAX_VALUE, countDown);
            MappedByteBuffer chunk = channelMapper.map(FileChannel.MapMode.READ_ONLY, from, len);
            this.chunks.add(chunk);
            from += len;
        }
    }

    public byte[] get(long offSet, int size) throws IOException {
        byte[] dst;
        block5: {
            double a = offSet;
            double b = 2.147483647E9;
            dst = new byte[size];
            long whichChunk = (long)Math.floor(a / b);
            long withinChunk = offSet - whichChunk * Integer.MAX_VALUE;
            try {
                if (Integer.MAX_VALUE - withinChunk > (long)dst.length) {
                    ByteBuffer chunk = this.chunks.get((int)whichChunk);
                    ByteBuffer readBuffer = chunk.asReadOnlyBuffer();
                    readBuffer.position((int)withinChunk);
                    readBuffer.get(dst, 0, dst.length);
                    break block5;
                }
                int l1 = (int)(Integer.MAX_VALUE - withinChunk);
                int l2 = dst.length - l1;
                ByteBuffer chunk = this.chunks.get((int)whichChunk);
                ByteBuffer readBuffer = chunk.asReadOnlyBuffer();
                readBuffer.position((int)withinChunk);
                readBuffer.get(dst, 0, l1);
                chunk = this.chunks.get((int)whichChunk + 1);
                readBuffer = chunk.asReadOnlyBuffer();
                readBuffer.position(0);
                readBuffer.get(dst, l1, l2);
            }
            catch (IndexOutOfBoundsException i) {
                throw new IOException("Out of bounds");
            }
        }
        return dst;
    }

    @Override
    public void close() {
        if (this.coreFileAccessor != null) {
            try {
                this.coreFileAccessor.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public long getSize() {
        return this.length;
    }
}

