/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix.compress;

import edu.upf.bg.mtabix.compress.BlockCompressedFilePointerUtil;
import edu.upf.bg.mtabix.compress.BlockGunzipper;
import edu.upf.bg.mtabix.compress.MappedReadFile;
import java.io.File;
import java.io.IOException;

public class BlockCompressedReader {
    private MappedReadFile mFile = null;
    private byte[] mCurrentBlock = null;
    private int mCurrentOffset = 0;
    private int mBlockLength = 0;
    private long mBlockAddress = 0L;
    private final BlockGunzipper blockGunzipper = new BlockGunzipper();
    private static final byte eol = 10;
    private static final byte eolCr = 13;

    public BlockCompressedReader(File file) throws IOException {
        this.mFile = new MappedReadFile(file);
    }

    public int readLine(byte[] buf) throws IOException {
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        int lineLength = 0;
        boolean done = false;
        boolean foundCr = false;
        while (!done) {
            int linetmpPos = this.mCurrentOffset;
            int bCnt = 0;
            while (available-- > 0) {
                byte c;
                if ((c = this.mCurrentBlock[linetmpPos++]) == 10) {
                    done = true;
                    break;
                }
                if (foundCr) {
                    --linetmpPos;
                    done = true;
                    break;
                }
                if (c == 13) {
                    foundCr = true;
                    continue;
                }
                ++bCnt;
            }
            if (this.mCurrentOffset < linetmpPos) {
                for (int i = 0; i < bCnt; ++i) {
                    buf[lineLength] = this.mCurrentBlock[this.mCurrentOffset + i];
                    ++lineLength;
                }
                this.mCurrentOffset = linetmpPos;
            }
            if ((available = this.available()) != 0) continue;
            done = true;
        }
        return lineLength;
    }

    public void seek(long pos) throws IOException {
        int available;
        long compressedOffset = BlockCompressedFilePointerUtil.getBlockAddress(pos);
        int uncompressedOffset = BlockCompressedFilePointerUtil.getBlockOffset(pos);
        if (this.mBlockAddress == compressedOffset && this.mCurrentBlock != null) {
            available = this.mCurrentBlock.length;
        } else {
            this.mBlockAddress = compressedOffset;
            this.readBlock();
            available = this.available();
        }
        if (uncompressedOffset > available) {
            throw new IOException("Invalid file pointer: " + pos);
        }
        this.mCurrentOffset = uncompressedOffset;
    }

    public long getFilePointer() {
        if (this.mCurrentOffset == this.mCurrentBlock.length) {
            return BlockCompressedFilePointerUtil.makeFilePointer(this.mBlockAddress + (long)this.mBlockLength, 0);
        }
        return BlockCompressedFilePointerUtil.makeFilePointer(this.mBlockAddress, this.mCurrentOffset);
    }

    private int available() throws IOException {
        if (this.mCurrentBlock == null || this.mCurrentOffset == this.mCurrentBlock.length) {
            this.mBlockAddress += (long)this.mBlockLength;
            if (this.mFile.getSize() < this.mBlockAddress) {
                return 0;
            }
            this.readBlock();
        }
        if (this.mCurrentBlock == null) {
            return 0;
        }
        return this.mCurrentBlock.length - this.mCurrentOffset;
    }

    private void readBlock() throws IOException {
        this.mBlockLength = this.unpackInt16(this.mFile, this.mBlockAddress + 16L) + 1;
        int uncompressedLength = this.unpackInt32(this.mFile, this.mBlockAddress + (long)this.mBlockLength - 4L);
        byte[] uncompressBuffer = this.mCurrentBlock;
        this.mCurrentBlock = null;
        if (uncompressBuffer == null || uncompressBuffer.length != uncompressedLength) {
            try {
                uncompressBuffer = new byte[uncompressedLength];
            }
            catch (NegativeArraySizeException e) {
                throw new RuntimeException("BGZF file has invalid uncompressedLength: " + uncompressedLength, e);
            }
        }
        this.blockGunzipper.unzipBlock(uncompressBuffer, this.mFile.get(this.mBlockAddress, this.mBlockLength), this.mBlockLength);
        this.mCurrentBlock = uncompressBuffer;
        this.mCurrentOffset = 0;
    }

    private int unpackInt16(MappedReadFile file, long offset) throws IOException {
        byte[] buffer = file.get(offset, 2);
        return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
    }

    private int unpackInt32(MappedReadFile file, long offset) throws IOException {
        byte[] buffer = file.get(offset, 4);
        return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16 | (buffer[3] & 0xFF) << 24;
    }
}

