/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix.compress;

public class BlockCompressedFilePointerUtil {
    private static final int SHIFT_AMOUNT = 16;
    private static final int OFFSET_MASK = 65535;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFL;
    public static final long MAX_BLOCK_ADDRESS = 0xFFFFFFFFFFFFL;
    public static final int MAX_OFFSET = 65535;

    public static int compare(long vfp1, long vfp2) {
        if (vfp1 == vfp2) {
            return 0;
        }
        if (vfp1 < 0L && vfp2 >= 0L) {
            return 1;
        }
        if (vfp1 >= 0L && vfp2 < 0L) {
            return -1;
        }
        if (vfp1 < vfp2) {
            return -1;
        }
        return 1;
    }

    public static boolean areInSameOrAdjacentBlocks(long vfp1, long vfp2) {
        long block2;
        long block1 = BlockCompressedFilePointerUtil.getBlockAddress(vfp1);
        return block1 == (block2 = BlockCompressedFilePointerUtil.getBlockAddress(vfp2)) || block1 + 1L == block2;
    }

    public static long makeFilePointer(long blockAddress, int blockOffset) {
        if (blockOffset < 0) {
            throw new IllegalArgumentException("Negative blockOffset " + blockOffset + " not allowed.");
        }
        if (blockAddress < 0L) {
            throw new IllegalArgumentException("Negative blockAddress " + blockAddress + " not allowed.");
        }
        if (blockOffset > 65535) {
            throw new IllegalArgumentException("blockOffset " + blockOffset + " too large.");
        }
        if (blockAddress > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("blockAddress " + blockAddress + " too large.");
        }
        return blockAddress << 16 | (long)blockOffset;
    }

    public static long getBlockAddress(long virtualFilePointer) {
        return virtualFilePointer >> 16 & 0xFFFFFFFFFFFFL;
    }

    public static int getBlockOffset(long virtualFilePointer) {
        return (int)(virtualFilePointer & 0xFFFFL);
    }

    public static String asString(long vfp) {
        return String.format("%d(0x%x): (block address: %d, offset: %d)", vfp, vfp, BlockCompressedFilePointerUtil.getBlockAddress(vfp), BlockCompressedFilePointerUtil.getBlockOffset(vfp));
    }
}

