/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix;

import edu.upf.bg.mtabix.MTabixConfig;
import edu.upf.bg.mtabix.MTabixIndex;
import edu.upf.bg.mtabix.compress.BlockCompressedOutputStream;
import edu.upf.bg.mtabix.parse.DefaultKeyParser;
import edu.upf.bg.mtabix.sort.SortController;
import edu.upf.bg.mtabix.sort.comparator.Lexical;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static final String ARGUMENT_INPUT_FILE = "i";
    private static final String ARGUMENT_TMP_FOLDER = "t";
    private static final String ARGUMENT_SORT = "s";
    private static final String EXTENSION_GZ = ".gz";
    private static final String EXTENSION_TDM = ".tdm";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        File tdmGz;
        block17: {
            block16: {
                CommandLine line;
                Options options = new Options();
                OptionBuilder.withArgName((String)"file");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"Input data file TDM formatted");
                options.addOption(OptionBuilder.create((String)ARGUMENT_INPUT_FILE));
                OptionBuilder.withArgName((String)"folder");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"Folder to store intermediate temporal files");
                options.addOption(OptionBuilder.create((String)ARGUMENT_TMP_FOLDER));
                options.addOption(ARGUMENT_SORT, false, "Sort the tdm file before compression");
                PosixParser parser = new PosixParser();
                try {
                    line = parser.parse(options, args);
                }
                catch (ParseException e) {
                    System.err.println("Parsing failed.  Reason: " + e.getMessage());
                    System.exit(1);
                    return;
                }
                if (!line.hasOption(ARGUMENT_INPUT_FILE)) {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp("mtabix", options);
                    System.exit(1);
                    return;
                }
                File tdm = new File(line.getOptionValue(ARGUMENT_INPUT_FILE));
                if (!tdm.isAbsolute()) {
                    tdm = new File(System.getProperty("user.dir"), line.getOptionValue(ARGUMENT_INPUT_FILE));
                }
                boolean gzipInput = tdm.getName().endsWith(".tdm.gz");
                InputStream inputStream = null;
                String header = null;
                try {
                    inputStream = Main.openInputStream(tdm, gzipInput, inputStream);
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    header = br.readLine();
                    inputStream.close();
                    inputStream = Main.openInputStream(tdm, gzipInput, inputStream);
                }
                catch (IOException e) {
                    System.err.println("Open input failed. Reason: " + e.getMessage());
                    System.exit(1);
                    return;
                }
                if (gzipInput) {
                    String path = tdm.getAbsolutePath();
                    tdmGz = new File(path.substring(0, path.length() - (EXTENSION_GZ.length() + EXTENSION_TDM.length())) + "-sorted" + EXTENSION_TDM + EXTENSION_GZ);
                } else {
                    tdmGz = new File(tdm.getAbsoluteFile() + EXTENSION_GZ);
                }
                if (tdmGz.exists()) break block16;
                if (line.hasOption(ARGUMENT_SORT)) {
                    LOGGER.info("Sorting...");
                    long start = System.currentTimeMillis();
                    try {
                        SortController.sortAndCompressFile(line.getOptionValue(ARGUMENT_TMP_FOLDER), inputStream, tdmGz, Lexical.ascending(), header);
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Sort failed. Reason: " + e.getMessage());
                        System.exit(1);
                        return;
                    }
                    LOGGER.info("Sort finished " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - start), (String)"HH:mm:ss,SSS"));
                    break block17;
                } else {
                    tdmGz = new File(tdm.getAbsoluteFile() + EXTENSION_GZ);
                    try {
                        Main.compressFile(tdm, tdmGz);
                    }
                    catch (IOException e) {
                        System.err.println("Compress failed. Reason: " + e.getMessage());
                        System.exit(1);
                        return;
                    }
                }
            }
            LOGGER.warn("File '" + tdmGz.getName() + "' already exist skipping compression.");
        }
        File tdmGzIndex = new File(tdmGz.getAbsoluteFile() + ".mtabix");
        MTabixConfig config = new MTabixConfig(tdmGz, tdmGzIndex, new DefaultKeyParser(1, 0));
        MTabixIndex mTabix = new MTabixIndex(config);
        try {
            mTabix.buildIndex();
            return;
        }
        catch (Exception e) {
            System.err.println("Indexing failed. Reason: " + e.getMessage());
        }
    }

    private static InputStream openInputStream(File tdm, boolean gzipInput, InputStream inputStream) throws IOException {
        inputStream = new FileInputStream(tdm);
        if (gzipInput) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static void compressFile(File inFile, File outFile) throws IOException {
        FileInputStream in = new FileInputStream(inFile);
        BlockCompressedOutputStream out = new BlockCompressedOutputStream(outFile);
        LOGGER.info("Compressing...");
        long start = System.currentTimeMillis();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).close();
        in.close();
        LOGGER.info("Compress finished " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - start), (String)"HH:mm:ss,SSS"));
    }
}

