/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix;

import edu.upf.bg.mtabix.MTabixBlock;
import edu.upf.bg.mtabix.MTabixConfig;
import edu.upf.bg.mtabix.compress.BlockCompressedFilePointerUtil;
import edu.upf.bg.mtabix.compress.BlockCompressedInputStream;
import edu.upf.bg.mtabix.parse.IKeyParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class MTabixReader
implements Closeable {
    private IKeyParser parser;
    private Set<String> validKeys;
    private BlockCompressedInputStream inputStream;
    private Iterator<MTabixBlock> blocks;
    private boolean done = false;
    private MTabixBlock currentBlock = null;

    public MTabixReader(Iterator<MTabixBlock> blocks, MTabixConfig config, Set<String> validKeys) throws IOException {
        this.blocks = blocks;
        this.inputStream = new BlockCompressedInputStream(config.getDataFile());
        this.validKeys = validKeys;
        this.parser = config.getKeyParser();
        this.nextBlock();
    }

    private void nextBlock() throws IOException {
        if (this.blocks.hasNext()) {
            this.currentBlock = this.blocks.next();
            this.inputStream.seek(this.currentBlock.getFilePointer());
        } else {
            this.close();
        }
    }

    public String readLine() throws IOException {
        String line;
        if (this.done) {
            return null;
        }
        if (this.inputStream.available() == 0 || BlockCompressedFilePointerUtil.getBlockAddress(this.currentBlock.getFilePointer()) != BlockCompressedFilePointerUtil.getBlockAddress(this.inputStream.getFilePointer())) {
            this.nextBlock();
            if (this.done) {
                return null;
            }
        }
        while ((line = this.inputStream.readLine()) != null) {
            if (this.validKeys.contains(this.extractKey(line))) {
                return line;
            }
            if (BlockCompressedFilePointerUtil.getBlockAddress(this.currentBlock.getFilePointer()) == BlockCompressedFilePointerUtil.getBlockAddress(this.inputStream.getFilePointer())) continue;
            this.nextBlock();
            if (!this.done) continue;
            return null;
        }
        return null;
    }

    private String extractKey(String line) {
        StringBuilder str = new StringBuilder(30 * this.parser.getKeys().length);
        str.append(this.parser.parse(line, this.parser.getKeys()[0]));
        for (int k = 1; k < this.parser.getKeys().length; ++k) {
            str.append(this.parser.getSeparator());
            str.append(this.parser.parse(line, this.parser.getKeys()[k]));
        }
        return str.toString();
    }

    @Override
    public void close() throws IOException {
        this.done = true;
        this.inputStream.close();
    }
}

