/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.mtabix;

import edu.upf.bg.mtabix.MTabixBlock;
import edu.upf.bg.mtabix.MTabixConfig;
import edu.upf.bg.mtabix.MTabixReader;
import edu.upf.bg.mtabix.compress.BlockCompressedFilePointerUtil;
import edu.upf.bg.mtabix.compress.BlockCompressedInputStream;
import edu.upf.bg.mtabix.parse.IKeyParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTabixIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(MTabixIndex.class);
    private static final int BUFFER_SIZE = 0x100000;
    public static final String VERSION = "# MTABIX v1.0";
    public static final String BLOCKS = "# Blocks";
    public static final String HASH = "# MD5 hash";
    public static final String KEYS = "# Keys";
    private MTabixConfig config;
    private Map<Integer, List<String>> indexIdentifiers;
    private Map<Integer, Map<String, Integer>> indexPositions;
    private TreeSet<MTabixBlock> indexBlocks;
    private String indexChecksum;

    public MTabixIndex(MTabixConfig config) {
        this.config = config;
    }

    public void buildIndex() throws IOException, NoSuchAlgorithmException {
        String line;
        PrintWriter index = new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)new FileOutputStream(this.config.getIndexFile()), 0x100000), "UTF-8"));
        IKeyParser parser = this.config.getKeyParser();
        index.println(VERSION);
        index.println();
        long start = System.currentTimeMillis();
        MessageDigest md = DigestUtils.getMd5Digest();
        BlockCompressedInputStream data = new BlockCompressedInputStream(new DigestInputStream(new FileInputStream(this.config.getDataFile()), md));
        String headers = data.readLine();
        Map<Integer, List<String>> identifiers = this.config.getIdentifiers();
        if (identifiers == null) {
            LOGGER.info("Calculating MD5 and key identifiers...");
            identifiers = this.readIdentifiers(data);
            data.close();
            data = new BlockCompressedInputStream(new FileInputStream(this.config.getDataFile()));
            headers = data.readLine();
            LOGGER.info("First pass " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - start), (String)"HH:mm:ss,SSS"));
            start = System.currentTimeMillis();
            LOGGER.info("Writing hash index...");
        } else {
            LOGGER.info("Writing hash index and MD5...");
        }
        HashMap positions = new HashMap(identifiers.size());
        for (int key : parser.getKeys()) {
            index.println(KEYS);
            List<String> ids = identifiers.get(key);
            HashMap<String, Integer> positionMap = new HashMap<String, Integer>(ids.size());
            for (int i = 0; i < ids.size(); ++i) {
                String id = ids.get(i);
                index.println(id);
                positionMap.put(id, i);
            }
            positions.put(key, positionMap);
            index.println();
        }
        long filePointer = data.getFilePointer();
        long lastBlock = -1L;
        index.println(BLOCKS);
        while ((line = data.readLine()) != null) {
            long block = BlockCompressedFilePointerUtil.getBlockAddress(filePointer);
            if (block != lastBlock) {
                index.print(Long.toHexString(filePointer));
                for (int key : parser.getKeys()) {
                    Integer position = (Integer)((Map)positions.get(key)).get(parser.parse(line, key));
                    index.print(parser.getSeparator());
                    index.print(position);
                }
                index.println();
                lastBlock = block;
            }
            filePointer = data.getFilePointer();
        }
        index.println();
        index.println(HASH);
        index.println(Hex.encodeHexString((byte[])md.digest()));
        LOGGER.info("Index created " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - start), (String)"HH:mm:ss,SSS"));
        data.close();
        index.close();
    }

    private Map<Integer, List<String>> readIdentifiers(BlockCompressedInputStream data) throws IOException {
        String line;
        IKeyParser parser = this.config.getKeyParser();
        int[] keys = parser.getKeys();
        Set[] ids = new Set[keys.length];
        for (int k = 0; k < keys.length; ++k) {
            ids[k] = new HashSet();
        }
        while ((line = data.readLine()) != null) {
            for (int k = 0; k < keys.length; ++k) {
                String id = parser.parse(line, keys[k]);
                if (id == null || ids[k].contains(id)) continue;
                ids[k].add(id);
            }
        }
        HashMap<Integer, List<String>> identifiers = new HashMap<Integer, List<String>>(keys.length);
        for (int k = 0; k < keys.length; ++k) {
            ArrayList idList = new ArrayList(ids[k]);
            Collections.sort(idList);
            identifiers.put(keys[k], idList);
        }
        return identifiers;
    }

    public void loadIndex() throws IOException {
        IKeyParser parser = this.config.getKeyParser();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.config.getIndexFile())), "UTF-8"));
        String line = in.readLine();
        if (!VERSION.equals(line)) {
            throw new UnsupportedOperationException("Invalid mtabix index file");
        }
        while ((line = in.readLine()) != null && !KEYS.equals(line)) {
        }
        int[] keys = parser.getKeys();
        this.indexIdentifiers = new HashMap<Integer, List<String>>(keys.length);
        this.indexPositions = new HashMap<Integer, Map<String, Integer>>(keys.length);
        for (int key : keys) {
            int i = 0;
            ArrayList<String> idList = new ArrayList<String>();
            HashMap<String, Integer> idMap = new HashMap<String, Integer>();
            while ((line = in.readLine()) != null && !KEYS.equals(line) && !BLOCKS.equals(line)) {
                if (line.isEmpty()) continue;
                idList.add(line);
                idMap.put(line, i);
                ++i;
            }
            this.indexIdentifiers.put(key, idList);
            this.indexPositions.put(key, idMap);
        }
        while (!BLOCKS.equals(line) && (line = in.readLine()) != null) {
        }
        this.indexBlocks = new TreeSet();
        int blocks = 0;
        while ((line = in.readLine()) != null && !HASH.equals(line)) {
            if (line.isEmpty()) continue;
            Long pointer = Long.parseLong(parser.parse(line, 0), 16);
            Integer[] values = new Integer[keys.length];
            for (int k = 0; k < keys.length; ++k) {
                values[k] = Integer.parseInt(parser.parse(line, keys[k] + 1));
            }
            this.indexBlocks.add(new MTabixBlock(values, pointer));
            ++blocks;
        }
        if (!HASH.equals(line)) {
            throw new UnsupportedOperationException("Invalid mtabix index file");
        }
        this.indexChecksum = in.readLine();
        in.close();
        LOGGER.info(blocks + " blocks loaded");
    }

    public boolean checkMD5() throws IOException {
        return this.checkMD5(new FileInputStream(this.config.getDataFile()));
    }

    public boolean checkMD5(InputStream in) throws IOException {
        if (this.indexChecksum == null) {
            throw new UnsupportedOperationException("Before checking the MD5 hash you need to call 'loadIndex'");
        }
        return this.indexChecksum.equals(DigestUtils.md5Hex((InputStream)in));
    }

    public MTabixBlock getBlock(String ... identifiers) {
        int[] keys = this.config.getKeyParser().getKeys();
        Integer[] pos = new Integer[keys.length];
        if (keys.length != identifiers.length) {
            throw new UnsupportedOperationException("This mtabix index needs " + keys.length + " identifiers");
        }
        for (int k = 0; k < keys.length; ++k) {
            Integer index = this.indexPositions.get(k).get(identifiers[keys[k]]);
            if (index == null) {
                throw new NoSuchElementException("Identifier '" + identifiers[k] + "' not found.");
            }
            pos[k] = index;
        }
        return this.indexBlocks.floor(new MTabixBlock(pos, 0L));
    }

    public MTabixReader read(BufferedReader reader) throws IOException {
        String line;
        TreeSet<MTabixBlock> queryBlocks = new TreeSet<MTabixBlock>();
        IKeyParser parser = this.config.getKeyParser();
        int[] keys = parser.getKeys();
        MTabixBlock queryBlock = new MTabixBlock(new Integer[keys.length], 0L);
        HashSet<String> validKeys = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            for (int k = 0; k < keys.length; ++k) {
                queryBlock.getKeys()[k] = this.indexPositions.get(keys[k]).get(parser.parse(line, k));
            }
            validKeys.add(line);
            queryBlocks.add(this.indexBlocks.floor(queryBlock));
        }
        return new MTabixReader(queryBlocks.iterator(), this.config, validKeys);
    }

    public MTabixConfig getConfig() {
        return this.config;
    }

    public Map<Integer, List<String>> getIndexIdentifiers() {
        return this.indexIdentifiers;
    }
}

