# Place all the behaviors and hooks related to the matching controller here.
# All this logic will automatically be available in application.js.
# You can use CoffeeScript in this file: http://jashkenas.github.com/coffee-script/
# unhide edit user name form
$ ->
  $('#edit-name-link').click((event) ->
    $('#edit-name-row').addClass('hidden')
    $('#edit-name-form').removeClass('hidden')
    event.preventDefault()
  )

# hide edit user name form
$ ->
  $('#cancel-edit-name').click((event) ->
    $('#edit-name-form').addClass('hidden')
    $('#edit-name-row').removeClass('hidden')
    event.preventDefault()
  )

$ ->
  $("#uploaded-avatar").change((event, ui) ->
    $("#user-avatar-kind").val("uploaded")
    $("#upload-form").submit()
  )

# adds bootstrap popovers to user names
Application.setupPopovers = () ->
  isVisible = false
  clickedAway = false
  $('.user-name-with-popover').popover(
    html: true,
    placement: 'top',
    trigger: 'manual'
  )
  $('.user-name-with-popover').click((e)->
    if isVisible
      $(this).addClass("selected")
      $('.user-name-with-popover').each ->
        if $(this).hasClass("selected")
          if $(this).hasClass("popover-visible")
            toggle_popover(false, $(this))
            isVisible = false
          else
            toggle_popover(true, $(this))
            isVisible = true
        else
          toggle_popover(false, $(this))
      $(this).removeClass("selected")
      clickedAway = false
    else
      toggle_popover(true, $(this))
      clickedAway = false
      isVisible = true
    e.preventDefault()
  )

  $(document).click((e)->
    if(isVisible & clickedAway)
      target = e.target
      if !$(target).closest(".popover").length
        toggle_popover(false, $('.user-name-with-popover'))
        isVisible = false
        clickedAway = false
    else
      clickedAway = true
  )

  toggle_popover = (show, elem) ->
    if show
      elem.popover('show')
      elem.addClass('popover-visible')
    else
      elem.popover('hide')
      elem.removeClass('popover-visible')

$ ->
  Application.setupPopovers()
