# Lectern snapshot

## Data pack

`@data_pack pack.mcmeta`

```json
{
  "pack": {
    "pack_format": 18,
    "description": ""
  }
}
```

`@data_pack pack.png`

![data_pack.png](data:image/png;base64,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)

## Resource pack

`@resource_pack pack.mcmeta`

```json
{
  "pack": {
    "pack_format": 18,
    "description": ""
  }
}
```

`@resource_pack pack.png`

![resource_pack.png](data:image/png;base64,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)
