# Lectern snapshot

## Data pack

`@data_pack pack.mcmeta`

```json
{
  "pack": {
    "pack_format": 18,
    "description": ""
  },
  "overlays": {
    "entries": [
      {
        "formats": {
          "min_inclusive": 16,
          "max_inclusive": 17
        },
        "directory": "dummy_overlay"
      }
    ]
  }
}
```

`@data_pack pack.png`

![data_pack.png](data:image/png;base64,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)

### tutorial

`@function tutorial:greeting`

```mcfunction
say This is added before.
say Hello, world!
say This is added afterwards.
```

`@function tutorial:obtained_dead_bush`

```mcfunction
say You obtained a dead bush!
```

`@function tutorial:hidden`

```mcfunction
say This will not appear in the rendered markdown.
```

`@function tutorial:also_hidden`

```mcfunction
say This is also hidden.
```

`@function(strip_final_newline) tutorial:stripped`

```mcfunction
say This function doesn't have a final newline.
```

`@advancement tutorial:obtained_dead_bush`

```json
{
  "criteria": {
    "dead_bush": {
      "trigger": "minecraft:inventory_changed",
      "conditions": {
        "items": [
          {
            "item": "minecraft:dead_bush"
          }
        ]
      }
    }
  },
  "requirements": [
    [
      "dead_bush"
    ]
  ],
  "rewards": {
    "function": "tutorial:obtained_dead_bush"
  }
}
```

`@function_tag(strip_final_newline) tutorial:something_else`

```json
{
  "values": ["tutorial:stripped"]
}
```

`@function_tag tutorial:from_github`

```json
say foo
```

### minecraft

`@function_tag minecraft:load`

```json
{
  "values": [
    "tutorial:greeting",
    "#tutorial:something_else"
  ]
}
```

`@loot_table minecraft:blocks/diamond_ore`

```json
{
  "pools": [
    {
      "rolls": 1,
      "entries": [
        {
          "type": "minecraft:item",
          "name": "minecraft:dead_bush"
        }
      ]
    }
  ]
}
```

`@loot_table minecraft:blocks/yellow_shulker_box`

```json
{
  "type": "minecraft:block",
  "pools": [
    {
      "rolls": 1,
      "entries": [
        {
          "type": "minecraft:alternatives",
          "children": [
            {
              "type": "minecraft:dynamic",
              "name": "minecraft:contents",
              "conditions": [
                {
                  "condition": "minecraft:match_tool",
                  "predicate": {
                    "item": "minecraft:air",
                    "nbt": "{drop_contents:1b}"
                  }
                }
              ]
            },
            {
              "type": "minecraft:item",
              "name": "minecraft:yellow_shulker_box",
              "functions": [
                {
                  "function": "minecraft:copy_name",
                  "source": "block_entity"
                },
                {
                  "function": "minecraft:copy_nbt",
                  "source": "block_entity",
                  "ops": [
                    {
                      "source": "Lock",
                      "target": "BlockEntityTag.Lock",
                      "op": "replace"
                    },
                    {
                      "source": "LootTable",
                      "target": "BlockEntityTag.LootTable",
                      "op": "replace"
                    },
                    {
                      "source": "LootTableSeed",
                      "target": "BlockEntityTag.LootTableSeed",
                      "op": "replace"
                    }
                  ]
                },
                {
                  "function": "minecraft:set_contents",
                  "entries": [
                    {
                      "type": "minecraft:dynamic",
                      "name": "minecraft:contents"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}
```

### text_in_block

`@function text_in_block:foo`

```mcfunction
say foo
```

## Overlay `dummy_overlay`

`@overlay dummy_overlay`

### tutorial

`@function tutorial:greeting`

```mcfunction
say Hello from overlay!
```

`@endoverlay`
