#!/bin/bash

# sp.sh - Archivo de idioma español para el servidor Plutonium Call of Duty: Black Ops
# Versión: 1.0.0
# Autor: Sterbweise
# Última actualización: 12/12/2024

# Descripción:
# Este script contiene todas las cadenas de texto en español utilizadas en los scripts de
# instalación, gestión y desinstalación del servidor Plutonium Call of Duty: Black Ops.
# Proporciona soporte de localización para usuarios hispanohablantes.

# Uso:
# Este archivo es utilizado por otros scripts para proporcionar texto localizado.
# No debe ejecutarse directamente.

# Nota: Asegúrese de que este archivo esté en el directorio .config/lang/ relativo a los scripts principales.

# Mensajes de instalación
# Estos mensajes se muestran durante el proceso de instalación del servidor

# Mensajes de utilidad
selectLanguage_sp="Seleccione su idioma:"
update_sp="Actualizando el sistema"
bit_sp="Habilitando paquetes de 32 bits"
finish_sp="Instalación finalizada."
quit_sp="Presione CTRL+C para salir."
dependencies_install_sp="Instalando dependencias."

# Mensajes del firewall
firewall_sp="¿Desea instalar el firewall UFW (Y/n)?"
ssh_port_sp="Ingrese el puerto SSH a abrir (predeterminado: 22):"
ssh_port_enter_sp="Si no puede usar ENTER, presione la barra espaciadora varias veces."
firewall_install_sp="Instalación del firewall y apertura de puertos."

# Mensajes de Dotnet
dotnet_sp="¿Desea instalar Dotnet [Requerido para IW4Madmin] (Y/n)?"
dotnet_failed_install_sp="La instalación de Dotnet falló."
dotnet_install_sp="Instalando Dotnet."

# Mensajes de Wine
wine_sp="Instalando Wine."

# Mensajes de archivos binarios del juego
binary_sp="Instalación de archivos binarios del juego."

# Mensajes de desinstalación
uninstall_options_sp="Seleccione los componentes a desinstalar:"
uninstallDotnet_sp="Desinstalar Dotnet"
uninstallWine_sp="Desinstalar Wine"
disable_32bit_sp="Deshabilitar soporte de 32 bits"
uninstallFirewall_sp="Desinstalar Firewall"
uninstallGameBinaries_sp="Desinstalar archivos binarios del juego"
uninstall_selected_sp="Desinstalar componentes seleccionados"
cancel_sp="Cancelar"
select_option_sp="Ingrese su opción:"
confirmUninstall_selected_sp="¿Está seguro de que desea desinstalar los componentes seleccionados?"
confirmUninstall_sp="¿Está seguro de que desea desinstalar? Esto eliminará todos los componentes instalados por el script de configuración."
confirm_prompt_sp="Escriba 's' para confirmar: "
uninstall_cancelled_sp="Desinstalación cancelada."
uninstall_binary_sp="Desinstalando archivos binarios del juego."
remove_firewall_sp="Eliminando firewall."
cleanup_sp="Limpiando."
uninstall_finish_sp="Desinstalación completada."