Setup | crAPI
=============

> **Note**: Custom jwks key can be passed by adding a *jwks.json* file in *keys* folder in each deployment folder such as `/deploy/docker/keys`

## Docker and docker compose

You'll need to have Docker and docker-compose installed and running on your host system. Also, the version of docker-compose should be `1.27.0` or above. Check your docker-compose version using:
```
docker compose version
```
**Upgrade your docker compose version if you get errors like**

```ERROR: Invalid interpolation format for ...```

### Using prebuilt images
You can use prebuilt images generated by our CI workflow by downloading the docker-compose and .env files.

#### Start crAPI

 - To use the latest stable version.

      - Linux Machine

      ```
      curl -o /tmp/crapi.zip https://github.com/OWASP/crAPI/archive/refs/heads/main.zip
      
      unzip /tmp/crapi.zip
      
      cd crAPI-main/deploy/docker

      docker compose pull

      docker compose -f docker-compose.yml --compatibility up -d
      ```
      
      To override server configurations, change the values of the variables present in the **.env** file or add the respective variables to the start of the docker compose command.

      For example to expose the system to all network interfaces.

      ```
      LISTEN_IP="0.0.0.0" docker compose -f docker-compose.yml --compatibility up -d
      ```

      - Windows Machine

      ```
      curl.exe -o crapi.zip https://github.com/OWASP/crAPI/archive/refs/heads/main.zip

      tar -xf .\crapi.zip
     
      cd crAPI-main/deploy/docker

      docker compose pull

      docker compose -f docker-compose.yml --compatibility up -d
      ```
     
      To override server configurations, change the values of the variables present in the **.env** file or add the respective variables to the start of the docker compose command.

      For example to expose the system to all network interfaces.

      ```
      LISTEN_IP="0.0.0.0" docker compose -f docker-compose.yml --compatibility up -d
      ```

  - To use the latest development version

      - Linux Machine

      ```
      curl -o /tmp/crapi.zip https://github.com/OWASP/crAPI/archive/refs/heads/develop.zip
      
      unzip /tmp/crapi.zip
      
      cd crAPI-develop/deploy/docker

      docker compose pull

      docker compose -f docker-compose.yml --compatibility up -d
      ```
      
      To override server configurations, change the values of the variables present in the **.env** file or add the respective variables to the start of the docker compose command.

      For example to expose the system to all network interfaces.

      ```
      LISTEN_IP="0.0.0.0" docker compose -f docker-compose.yml --compatibility up -d
      ```

      - Windows Machine

      ```
      curl.exe -o crapi.zip https://github.com/OWASP/crAPI/archive/refs/heads/develop.zip

      tar -xf .\crapi.zip
     
      cd crAPI-develop/deploy/docker

      docker compose pull

      docker compose -f docker-compose.yml --compatibility up -d
      ```
     
      To override server configurations, change the values of the variables present in the **.env** file or add the respective variables to the start of the docker compose command.

      For example to expose the system to all network interfaces.

      ```
      LISTEN_IP="0.0.0.0" docker compose -f docker-compose.yml --compatibility up -d
      ```


#### Visit [http://localhost:8888](http://localhost:8888).

**Note**: All emails are sent to mailhog service by default and can be checked on
[http://localhost:8025](http://localhost:8025)
You can change the smtp configuration if required however all emails with domain **example.com** will still go to mailhog.

### Build it yourself

1. Clone crAPI repository

   - Linux Machine

   ```
       $ git clone [REPOSITORY-URL]
   ```

   - Windows Machine

   ```
       $ git clone [REPOSITORY-URL] --config core.autocrlf=input
   ```

2. Build all docker images

   - Linux Machine

   ```
   $ cd deploy/docker; build-all.sh
   ```

   - Windows Machine

   ```
   $ call "%cd%\deploy\docker\build-all.bat"
   ```

3. Start crAPI
   ```
   $ cd deploy/docker
   
   $ docker compose -f docker-compose.yml --compatibility up -d
   
   ```
4. Visit `http://localhost:8888`

**Note**: All emails are sent to mailhog service by default and can be checked on
`http://localhost:8025`
You can change the smtp configuration if required however all emails with domain **example.com** will still go to mailhog.

## Kubernetes

### Using Helm Charts

1. Clone the repo
    ```
    git clone [REPOSITORY-URL]
    ```
2. Install the helm chart
    
    Inorder to manually mount the data to a specific location, hostPath should be updated in values-pv.yaml, and used to install the helm charts. 
    
    ```
    cd deploy/helm

    helm install --namespace crapi crapi . --values values-pv.yaml
    ```
    Otherwise install the helm chart normally. 
    ```
    cd deploy/helm

    helm install --namespace crapi crapi . --values values.yaml
    ```

3. If using minikube, create a tunnel to initialize the LoadBalancers
    ```
    minikube tunnel --alsologtostderr
    ```

4. Access crAPI

    crAPI should be available on the `<LOADBALANCER_IP>:8888`
    Mailhog on `<LOADBALANCER_IP>:8025`

    Or for minikube run the following command to get the URL

    ```
    crAPI URL:
    $ echo "http://$(minikube ip):30080"
    ```
    ```
    Mailhog URL:
    echo "http://$(minikube ip):30025"
    ```

## Vagrant

This option allows you to run crAPI within a virtual machine, thus isolated from
your system. You'll need to have [Vagrant] and, for example [VirtualBox]
installed.

1. Clone crAPI repository
    ```
    $ git clone [REPOSITORY-URL]
    ```
2. Start crAPI Virtual Machine
    ```
    $ cd deploy/vagrant && vagrant up
    ```
3. Visit `http://192.168.33.20`


**Note**: All emails are sent to mailhog service by default and can be checked on
`http://192.168.33.20:8025`
You can change the smtp configuration if required however all emails with domain **example.com** will still go to mailhog.

Once you're done playing with crAPI, you can remove it completely from your
system running the following command from the repository root directory

```
$ cd deploy/vagrant && vagrant destroy
```

[Vagrant]: https://www.vagrantup.com/downloads
[VirtualBox]: https://www.virtualbox.org/wiki/Downloads

## Troubleshooting guide for general issues while installing and running crAPI
If you need any help with installing and running crAPI you can check out this guide: [Troubleshooting guide crAPI](https://github.com/OWASP/crAPI/blob/main/docs/troubleshooting.md). If this doesn't solve your problem, please create an issue in Github Issues.
