/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tables;

import java.util.HashMap;
import java.util.Map;
import uk.ac.ox.well.t2d.tables.NoSuchColumnException;
import uk.ac.ox.well.t2d.tables.RandomAccessRow;

public class ColumnIndexer {
    protected String cellSeparator;
    protected Map<String, Integer> columnIndex;

    public ColumnIndexer() {
        this("\t");
    }

    public ColumnIndexer(String separator) {
        this.cellSeparator = separator;
    }

    public void load(String headerLine) {
        this.columnIndex = this.buildColumnIndex(headerLine);
    }

    public RandomAccessRow toRow(long position, String line) {
        String[] array = this.getCellArray(line);
        return new ArrayRow(position, array);
    }

    public int getIndex(String columnLabel) throws NoSuchColumnException {
        Integer i = this.columnIndex.get(columnLabel);
        if (null == i) {
            throw new NoSuchColumnException(columnLabel);
        }
        return i;
    }

    Map<String, Integer> buildColumnIndex(String headerLine) {
        HashMap<String, Integer> idxMap = new HashMap<String, Integer>();
        String[] cells = this.getCellArray(headerLine);
        for (int i = 0; i < cells.length; ++i) {
            idxMap.put(cells[i].trim(), new Integer(i));
        }
        return idxMap;
    }

    String[] getCellArray(String line) {
        return this.getCellArray(this.cellSeparator, line);
    }

    String[] getCellArray(String separator, String line) {
        return line.split(separator);
    }

    class ArrayRow
    implements RandomAccessRow {
        long position;
        String[] array;

        ArrayRow(long pos, String[] data) {
            this.position = pos;
            this.array = data;
        }

        @Override
        public String getCell(int columnIndex) throws NoSuchColumnException {
            try {
                return this.array[columnIndex];
            }
            catch (IndexOutOfBoundsException ioob) {
                throw new NoSuchColumnException(ioob);
            }
        }

        @Override
        public String getCell(String columnLabel) throws NoSuchColumnException {
            int index = ColumnIndexer.this.getIndex(columnLabel);
            return this.getCell(index);
        }

        @Override
        public long getPosition() {
            return this.position;
        }
    }
}

