/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tables;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.tables.Index;

public abstract class BasicFileIndex
extends Properties
implements Index {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private File file;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void load() throws IOException {
        if (this.getFile().exists()) {
            this.load(new FileInputStream(this.getFile()));
        } else {
            this.logger.warn("Index file '" + this.getFile().getCanonicalPath() + "' not found.");
        }
    }

    @Override
    public void store() throws IOException {
        if (!this.file.exists()) {
            this.logger.warn("Creating new Index file '" + this.getFile().getCanonicalPath() + "'");
        }
        this.store(new FileOutputStream(this.getFile()), "Index file");
    }

    public void delete() throws IOException {
        this.clear();
        if (this.getFile().exists()) {
            this.getFile().delete();
            this.logger.info("Deleted Index file '" + this.getFile().getCanonicalPath() + "'");
        }
    }

    @Override
    public boolean isBuilt() {
        return 0 != this.size();
    }
}

