/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.reports.imputation;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.reports.imputation.CrossCohortFormatter;
import uk.ac.ox.well.t2d.reports.imputation.DirectoryManager;
import uk.ac.ox.well.t2d.reports.imputation.ImputationReportBean;
import uk.ac.ox.well.t2d.reports.imputation.ObjectLoader;
import uk.ac.ox.well.t2d.reports.imputation.PerCohortFormatter;

public class ProjectManager
implements Runnable {
    protected static Logger logger = LoggerFactory.getLogger(ProjectManager.class);
    String projectLabel = "";
    Path inputDirectory = null;
    Path outputDirectory = null;
    Map<String, Path> groups = new TreeMap<String, Path>();
    Map<String, Object> topLevelObjects;
    List<ImputationReportBean> beans = new ArrayList<ImputationReportBean>();
    protected ObjectLoader ldr;

    public ProjectManager() {
        this.topLevelObjects = new TreeMap<String, Object>();
        this.ldr = new ObjectLoader();
    }

    public String getProjectLabel() {
        return this.projectLabel;
    }

    public void setProjectLabel(String l) {
        this.projectLabel = l;
    }

    public void setOutputDirectory(String p) {
        this.setOutputDirectory(Paths.get(p, new String[0]));
    }

    public void setOutputDirectory(Path p) {
        this.outputDirectory = p;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setInputDirectory(String p) {
        this.setInputDirectory(Paths.get(p, new String[0]));
    }

    public void setInputDirectory(Path p) {
        this.inputDirectory = p;
    }

    public Path getInputDirectory() {
        return this.inputDirectory;
    }

    @Override
    public void run() {
        if (null == this.getInputDirectory()) {
            throw new RuntimeException("No input directory set");
        }
        if (null == this.getOutputDirectory()) {
            throw new RuntimeException("No output directory set");
        }
        try {
            Files.createDirectories(this.getOutputDirectory(), new FileAttribute[0]);
            this.loadTopLevelObjects();
            this.discoverChildDirectories();
            logger.info(String.format("Found %,d subgroups in directory %s", this.groups.size(), this.groups.keySet()));
            this.groups.entrySet().forEach(e -> this.collectReportBeans((String)e.getKey(), (Path)e.getValue()));
            this.formatPerCohortReports();
            this.formatCrossCohortReport();
        }
        catch (Exception re) {
            throw new RuntimeException(re);
        }
    }

    protected void collectReportBeans(String key, Path path) {
        DirectoryManager dm = new DirectoryManager();
        dm.setProject(this.getProjectLabel());
        dm.setLabel(key);
        dm.setInputDirectory(path);
        dm.run();
        this.beans.addAll(dm.getReportBeans());
    }

    protected void formatPerCohortReports() {
        PerCohortFormatter formatter = new PerCohortFormatter();
        this.beans.forEach(b -> formatter.outputReport(this.outputDirectory, (ImputationReportBean)b));
    }

    protected void formatCrossCohortReport() {
        CrossCohortFormatter formatter = new CrossCohortFormatter();
        formatter.setTopLevelObjects(this.topLevelObjects);
        formatter.setReportBeans(this.beans);
        String data = formatter.format();
        Path p = this.outputDirectory.resolve("CrossCohortReport.html");
        formatter.outputReport(p, data);
    }

    protected void discoverChildDirectories() throws IOException {
        DirectoryStream.Filter<Path> filter = file -> Files.isDirectory(file, new LinkOption[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getInputDirectory(), filter);){
            stream.forEach(path -> {
                String name = path.getFileName().toString();
                String[] psplit = name.split("\\.");
                if (psplit.length < 2) {
                    logger.warn("Subgroup directory path %s did not split properly using period separator. Expecting at least 2 components.", path);
                }
                this.groups.put(psplit[0], (Path)path);
            });
        }
    }

    protected void loadTopLevelObjects() {
        String nom = "All-Cohort-Info-Summary.png";
        Path p = this.getInputDirectory().resolve(nom);
        Object o = this.ldr.loadObject(p);
        this.topLevelObjects.put(nom, o);
    }
}

