/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.reports.imputation;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectLoader {
    protected static Logger logger = LoggerFactory.getLogger(ObjectLoader.class);

    public Object loadObject(Path p) {
        String[] psplit = p.getFileName().toString().split("\\.");
        if (psplit.length < 2) {
            logger.warn("Path %s did not split properly using period separator. Expecting at least 2 components.", p);
        }
        String ext = psplit[psplit.length - 1];
        Object o = this.loadObjectByType(p, ext);
        return o;
    }

    public Object loadObjectByType(Path p, String ext) {
        if ("PNG".equalsIgnoreCase(ext)) {
            return this.loadPngData(p);
        }
        if ("TXT".equalsIgnoreCase(ext)) {
            return this.loadTableData(p);
        }
        if ("MAP".equalsIgnoreCase(ext)) {
            return this.loadMapData(p);
        }
        logger.warn("Unknown file type in object data: %s", p.getFileName());
        return null;
    }

    public String loadPngData(Path p) {
        try {
            byte[] ba = Files.readAllBytes(p);
            String b64 = Base64.getEncoder().encodeToString(ba);
            return b64;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public List<String[]> loadTableData(Path p) {
        try {
            ArrayList<String[]> table = new ArrayList<String[]>();
            Files.readAllLines(p).forEach(l -> table.add(l.split("\\t")));
            return table;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Map<String, String> loadMapData(Path p) {
        List<String[]> table = this.loadTableData(p);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        table.forEach(l -> {
            String key = l[0];
            String value = null;
            if (((String[])l).length > 1) {
                value = l[1];
            }
            map.put(key, value);
        });
        return map;
    }
}

