/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.metabochip_fasttrack;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import uk.ac.ox.well.t2d.lang.StringUtilities;
import uk.ac.ox.well.t2d.parser.CellByCellParser;
import uk.ac.ox.well.t2d.parser.CellHandler;
import uk.ac.ox.well.t2d.parser.LabelledCellHandler;
import uk.ac.ox.well.t2d.parser.LineByLineParser;
import uk.ac.ox.well.t2d.parser.MapHandler;
import uk.ac.ox.well.t2d.parser.RecordHandler;

public class ProvenanceProcessor
implements Runnable {
    File inFile;
    File outFile;
    PrintWriter pw;

    public void setInFile(File f) {
        this.inFile = f;
    }

    public void setOutFile(File f) {
        this.outFile = f;
    }

    @Override
    public void run() {
        try {
            this.pw = new PrintWriter(new FileWriter(this.outFile));
            LineByLineParser llp = new LineByLineParser((RecordHandler)new CellByCellParser((CellHandler)new LabelledCellHandler((MapHandler)new Parser())));
            llp.parse(this.inFile);
            this.pw.flush();
            this.pw.close();
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void println(String string) {
        try {
            this.pw.println(string);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class Parser
    implements MapHandler {
        public boolean handleRecord(int recordNumber, Map<String, String> recordData) {
            if (recordNumber == 2) {
                ProvenanceProcessor.this.println("SNP\tIS_DIAGRAM\tIS_CONTROL\tKNOWNT2D\tKNOWNT1D\tt2drep-excluded-hitr2\tt2drep-excluded-hit1Mb\tProxies\tIS_DIABETES_HIT");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(recordData.get("SNPs"));
            sb.append("\t");
            sb.append(recordData.get("DIAGRAM").toUpperCase());
            sb.append("\t");
            sb.append(recordData.get("CONTROL_SET").toUpperCase());
            sb.append("\t");
            sb.append(recordData.get("KNOWNT2D"));
            sb.append("\t");
            sb.append(recordData.get("KNOWNT1D"));
            sb.append("\t");
            sb.append(recordData.get("t2drep-excluded-hitr2"));
            sb.append("\t");
            sb.append(recordData.get("t2drep-excluded-hit1Mb"));
            sb.append("\t");
            sb.append(recordData.get("Proxies"));
            sb.append("\t");
            if (this.isDiabetesHit(recordData)) {
                sb.append("Y");
            } else {
                sb.append("N");
            }
            ProvenanceProcessor.this.println(sb.toString());
            return true;
        }

        public boolean isDiabetesHit(Map<String, String> recordData) {
            if (this.isYes(recordData.get("KNOWNT2D"))) {
                return true;
            }
            if (this.isYes(recordData.get("KNOWNT1D"))) {
                return true;
            }
            if (this.isYes(recordData.get("t2drep-excluded-hitr2"))) {
                return true;
            }
            if (this.isYes(recordData.get("t2drep-excluded-hit1Mb"))) {
                return true;
            }
            return this.isExcluded(recordData.get("Proxies"));
        }

        public boolean isYes(String str) {
            if (StringUtilities.isNullOrEmpty((String)str)) {
                return false;
            }
            return "Y".equalsIgnoreCase(str);
        }

        public boolean isExcluded(String str) {
            if (StringUtilities.isNullOrEmpty((String)str)) {
                return false;
            }
            return "exclude".equalsIgnoreCase(str);
        }
    }
}

