/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class GenFileParser {
    public static void main(String[] args) throws Exception {
        File[] fs;
        if (args.length != 2) {
            throw new Exception("Expecting args: subset file name, sample file name");
        }
        File subsetFile = new File(args[0]);
        File sampleFile = new File(args[1]);
        System.out.println("HOME DIRECTORY IS " + new File(".").getAbsolutePath());
        System.out.println("SUBSET FILE IS " + subsetFile.getAbsolutePath());
        System.out.println("SAMPLE FILE IS " + sampleFile.getAbsolutePath());
        LinkedHashSet<String> subset = GenFileParser.captureSampleSubset(subsetFile);
        Map<String, Integer> indices = GenFileParser.captureSampleIndices(subset, sampleFile);
        for (File f : fs = GenFileParser.getDataFiles()) {
            System.out.println("PROCESSING DATA FILE: " + f.getAbsolutePath());
            GenFileParser.processDataFile(subset, indices, f);
        }
        System.out.println("Finished files");
    }

    public static File[] getDataFiles() {
        File here = new File(".");
        return here.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".gz");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processDataFile(LinkedHashSet<String> set, Map<String, Integer> map, File datafile) throws IOException {
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(datafile))));
        File output = GenFileParser.getOutputFile(datafile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(output)));
        try {
            GenFileParser.processData(set, map, lnr, bw);
        }
        finally {
            bw.close();
            lnr.close();
        }
    }

    public static void processData(LinkedHashSet<String> set, Map<String, Integer> map, LineNumberReader reader, BufferedWriter writer) throws IOException {
        String line;
        while (null != (line = reader.readLine())) {
            String[] cells = line.split("\\s");
            writer.write(GenFileParser.processLine(set, map, cells));
            writer.newLine();
        }
    }

    public static String processLine(LinkedHashSet<String> set, Map<String, Integer> map, String[] line) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenFileParser.captureSNPInfo(line));
        sb.append(" ");
        for (String id : set) {
            Integer i = map.get(id);
            sb.append(GenFileParser.captureStatInfo(i, line));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String captureStatInfo(int index, String[] line) {
        int i = index + 5;
        return line[i] + " " + line[i + 1] + " " + line[i + 2];
    }

    public static String captureSNPInfo(String[] str) {
        return str[0] + " " + str[1] + " " + str[2] + " " + str[3] + " " + str[4];
    }

    public static File getOutputFile(File input) {
        String inputName = input.getName();
        inputName = inputName.substring(0, inputName.length() - 3);
        return new File("processed." + inputName);
    }

    public static Map<String, Integer> captureSampleIndices(Set<String> ids, File f) throws IOException {
        String line;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(f)));
        int i = 0;
        while (null != (line = lnr.readLine())) {
            String id;
            if (0 != i && 1 != i && ids.contains(id = GenFileParser.getID(line))) {
                map.put(id, i - 2);
            }
            ++i;
        }
        lnr.close();
        return map;
    }

    public static LinkedHashSet<String> captureSampleSubset(File f) throws IOException {
        String line;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(f)));
        while (null != (line = lnr.readLine())) {
            set.add(GenFileParser.getID(line));
        }
        lnr.close();
        return set;
    }

    public static String getID(String line) {
        String[] cells = line.split("\\s");
        String id = cells[0] + " " + cells[1];
        return id;
    }
}

