"""Conftest for speedtestdotnet."""
from unittest.mock import patch

import pytest

from tests.components.speedtestdotnet import MOCK_RESULTS, MOCK_SERVERS


@pytest.fixture(autouse=True)
def mock_api():
    """Mock entry setup."""
    with patch("speedtest.Speedtest") as mock_api:
        mock_api.return_value.get_servers.return_value = MOCK_SERVERS
        mock_api.return_value.get_best_server.return_value = MOCK_SERVERS[1][0]
        mock_api.return_value.results.dict.return_value = MOCK_RESULTS
        yield mock_api
