"""The binary_sensor tests for the nexia platform."""

from homeassistant.const import STATE_OFF, STATE_ON

from .util import async_init_integration


async def test_create_binary_sensors(hass):
    """Test creation of binary sensors."""

    await async_init_integration(hass)

    state = hass.states.get("binary_sensor.master_suite_blower_active")
    assert state.state == STATE_ON
    expected_attributes = {
        "attribution": "Data provided by Trane Technologies",
        "friendly_name": "Master Suite Blower Active",
    }
    # Only test for a subset of attributes in case
    # HA changes the implementation and a new one appears
    assert all(
        state.attributes[key] == expected_attributes[key] for key in expected_attributes
    )

    state = hass.states.get("binary_sensor.downstairs_east_wing_blower_active")
    assert state.state == STATE_OFF
    expected_attributes = {
        "attribution": "Data provided by Trane Technologies",
        "friendly_name": "Downstairs East Wing Blower Active",
    }
    # Only test for a subset of attributes in case
    # HA changes the implementation and a new one appears
    assert all(
        state.attributes[key] == expected_attributes[key] for key in expected_attributes
    )
