--
-- Copyright (C) 2012-2014 the original author or authors.
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--

-- the first script for migration
create table Article (
    id bigint generated by default as identity,
    content varchar(5000),
    postedAt timestamp,
    title varchar(255),
    primary key (id)
);

create table Article_authorIds (
    Article_id bigint not null,
    authorIds bigint
);
   
create table User (
    id bigint generated by default as identity,
    fullname varchar(255),
    isAdmin boolean not null,
    password varchar(255),
    username varchar(255),
    primary key (id)
);
    
alter table Article_authorIds 
add constraint FK_f9ivk719aqb0rqd8my08loev7 
foreign key (Article_id) 
references Article;