﻿# Contributing to Git Extensions

:exclamation: As of 23 January 2019 all submissions to this project must be done under [The Developer Certificate of Origin](contributors.txt). You must sign it with your pull request, if you've not done so before.

Git Extensions is a project with a long history, made possible by [hundreds of contributors](https://github.com/gitextensions/gitextensions/graphs/contributors).

We welcome contributions including:

- Ideas for improvements
- Bug reports
- Bug fixes
- New features

To help the project maintainers be as effective as possible, please follow the simple guidelines below.

## Reporting Issues

[Search the issue tracker](https://github.com/gitextensions/gitextensions/issues?&q=) for an
existing or closely related issue before creating a new one. Be sure to include closed issues
in your search.

If an open issue already exists, read through the discussion. If you can add something helpful, do so.
Add a 👍 if you'd like to see it prioritised. Subscribe to the issue for updates.

If a closed issue already exists and the issue was addressed, you may like to try one of the
[CI builds](https://github.com/gitextensions/gitextensions/wiki/CI-Builds).

If no issue exists, create one. Complete the template, and add any further information that
could be relevant such as steps to reproduce, stack traces, screenshots, git/OS version, etc.

## Pull Requests

Want to contribute some code? Great! In addition to the regular GitHub Pull Request workflow,
you'll want to browse our [wiki](https://github.com/gitextensions/gitextensions/wiki).

Good places to start contributing include:

- Open [bugs](https://github.com/gitextensions/gitextensions/labels/bug)
- Open issues marked [good first issue](https://github.com/gitextensions/gitextensions/labels/good%20first%20issue)
- Open issues marked [help wanted](https://github.com/gitextensions/gitextensions/labels/help%20wanted)

It's a good idea to mention that you're picking something up by commenting on its issue.

If no issue exists, create one before making a PR. This creates the opportunity to discuss
the issue before you spend time on its implementation. You will likely be more effective
this way, and have a greater chance of satisfaction in the end.

Pull requests will be reviewed by one or more team members. To improve the chance of your
pull request being merged, your contribution should be as easy to review as possible.
Specifically:

- Be focussed in scope
- Be comprised of clear commits (use interactive rebase to tidy things up if needed)
- Include a clear description of the changes and why they should be made
- Be accompanied by unit tests
- Be consistent with the current code style

When filing a pull request, you should be prepared to answer questions about your changes
and to perform additional work on the changes in response to review feedback.

.xlf files do not need to be modified.  The English xlf is generated by the TranslationApp and then uploaded to Transifex when a release is generated.  The other languages are generated from Transifex site.  

## Conduct

Please review our [code of conduct](CODE_OF_CONDUCT.md).

