## API Report File for "@jsplumb/core"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { AbstractSegment } from '@jsplumb/common';
import { AnchorPlacement } from '@jsplumb/common';
import { AnchorSpec } from '@jsplumb/common';
import { ArrowOverlayOptions } from '@jsplumb/common';
import { BlankEndpointParams } from '@jsplumb/common';
import { Connector } from '@jsplumb/common';
import { ConnectorOptions } from '@jsplumb/common';
import { ConnectorSpec } from '@jsplumb/common';
import { Constructable } from '@jsplumb/util';
import { DotEndpointParams } from '@jsplumb/common';
import { EndpointRepresentationParams } from '@jsplumb/common';
import { EndpointSpec } from '@jsplumb/common';
import { EndpointStyle } from '@jsplumb/common';
import { EventGenerator } from '@jsplumb/util';
import { Extents } from '@jsplumb/util';
import { FullOverlaySpec } from '@jsplumb/common';
import { Geometry } from '@jsplumb/common';
import { LabelOverlayOptions } from '@jsplumb/common';
import { Merge } from '@jsplumb/util';
import { OverlayOptions } from '@jsplumb/common';
import { OverlaySpec } from '@jsplumb/common';
import { PaintAxis } from '@jsplumb/common';
import { PaintStyle } from '@jsplumb/common';
import { PerimeterAnchorShapes } from '@jsplumb/common';
import { PointNearPath } from '@jsplumb/common';
import { PointXY } from '@jsplumb/util';
import { RectangleEndpointParams } from '@jsplumb/common';
import { RotatedPointXY } from '@jsplumb/util';
import { Rotations } from '@jsplumb/util';
import { Segment } from '@jsplumb/common';
import { SegmentParams } from '@jsplumb/common';
import { Size } from '@jsplumb/util';

// @public (undocumented)
export const ABSOLUTE = "absolute";

// Warning: (ae-internal-missing-underscore) The name "AbstractConnector" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export abstract class AbstractConnector implements Connector {
    constructor(connection: Connection, params: ConnectorOptions);
    // (undocumented)
    _addSegment(clazz: Constructable<Segment>, params: any): void;
    // (undocumented)
    boundingBoxIntersection(box: any): Array<PointXY>;
    // (undocumented)
    bounds: Extents;
    // (undocumented)
    boxIntersection(x: number, y: number, w: number, h: number): Array<PointXY>;
    // (undocumented)
    _clearSegments(): void;
    // (undocumented)
    compute(params: ConnectorComputeParams): void;
    // (undocumented)
    abstract _compute(geometry: PaintGeometry, params: ConnectorComputeParams): void;
    // (undocumented)
    connection: Connection;
    // (undocumented)
    cssClass: string;
    // (undocumented)
    edited: boolean;
    exportGeometry(): Geometry;
    _findSegmentForLocation(location: number, absolute?: boolean): {
        segment: Segment;
        proportion: number;
        index: number;
    };
    // Warning: (ae-forgotten-export) The symbol "SegmentForPoint" needs to be exported by the entry point index.d.ts
    findSegmentForPoint(x: number, y: number): SegmentForPoint;
    // (undocumented)
    gap: number;
    // (undocumented)
    geometry: Geometry;
    // (undocumented)
    abstract getDefaultStubs(): [number, number];
    // (undocumented)
    getIdPrefix(): string;
    // (undocumented)
    getLength(): number;
    // (undocumented)
    getTypeDescriptor(): string;
    // (undocumented)
    gradientAtPoint(location: number, absolute?: boolean): number;
    // (undocumented)
    h: number;
    // (undocumented)
    hoverClass: string;
    importGeometry(g: Geometry): boolean;
    // (undocumented)
    lineIntersection(x1: number, y1: number, x2: number, y2: number): Array<PointXY>;
    // (undocumented)
    maxStub: number;
    // (undocumented)
    protected paintInfo: PaintGeometry;
    // (undocumented)
    pointAlongPathFrom(location: number, distance: number, absolute?: boolean): PointXY;
    // (undocumented)
    pointOnPath(location: number, absolute?: boolean): PointXY;
    // (undocumented)
    resetBounds(): void;
    // (undocumented)
    resetGeometry(): void;
    // (undocumented)
    segment: number;
    // (undocumented)
    segmentProportionalLengths: Array<number>;
    // (undocumented)
    segmentProportions: Array<[number, number]>;
    // (undocumented)
    segments: Array<Segment>;
    // (undocumented)
    setAnchorOrientation(idx: number, orientation: number[]): void;
    // (undocumented)
    protected setGeometry(g: Geometry, internal: boolean): void;
    // (undocumented)
    sourceGap: number;
    // (undocumented)
    sourceStub: number;
    // (undocumented)
    strokeWidth: number;
    // (undocumented)
    stub: number | number[];
    // (undocumented)
    targetGap: number;
    // (undocumented)
    targetStub: number;
    // (undocumented)
    totalLength: number;
    protected transformAnchorPlacement(a: AnchorPlacement, dx: number, dy: number): AnchorPlacement;
    // (undocumented)
    abstract transformGeometry(g: Geometry, dx: number, dy: number): Geometry;
    // (undocumented)
    abstract type: string;
    // (undocumented)
    typeId: string;
    // (undocumented)
    updateBounds(segment: Segment): void;
    // (undocumented)
    _updateSegmentProportions(): void;
    // (undocumented)
    w: number;
    // (undocumented)
    x: number;
    // (undocumented)
    y: number;
}

// @public (undocumented)
export interface AbstractSelectOptions<E> {
    // (undocumented)
    scope?: SelectionList;
    // (undocumented)
    source?: ElementSelectionSpecifier<E>;
    // (undocumented)
    target?: ElementSelectionSpecifier<E>;
}

// @public (undocumented)
export const ADD_CLASS_ACTION = "add";

// @public (undocumented)
export interface AddGroupOptions<E> extends GroupOptions {
    // (undocumented)
    collapsed?: boolean;
    // (undocumented)
    el: E;
}

// Warning: (ae-internal-missing-underscore) The name "AnchorComputeParams" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type AnchorComputeParams = {
    xy?: PointXY;
    wh?: Size;
    txy?: PointXY;
    twh?: Size;
    element?: Endpoint;
    timestamp?: string;
    index?: number;
    tElement?: Endpoint;
    connection?: Connection;
    elementId?: string;
    rotation?: Rotations;
    tRotation?: Rotations;
};

// @public (undocumented)
export type AnchorOrientationHint = -1 | 0 | 1;

// Warning: (ae-internal-missing-underscore) The name "AnchorRecord" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface AnchorRecord {
    // (undocumented)
    cls: string;
    // (undocumented)
    iox: AnchorOrientationHint;
    // (undocumented)
    ioy: AnchorOrientationHint;
    // (undocumented)
    offx: number;
    // (undocumented)
    offy: number;
    // (undocumented)
    ox: AnchorOrientationHint;
    // (undocumented)
    oy: AnchorOrientationHint;
    // (undocumented)
    x: number;
    // (undocumented)
    y: number;
}

// Warning: (ae-internal-missing-underscore) The name "ArcSegment" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export class ArcSegment extends AbstractSegment {
    constructor(params: ArcSegmentParams);
    // (undocumented)
    anticlockwise: boolean;
    // (undocumented)
    circumference: number;
    // (undocumented)
    cx: number;
    // (undocumented)
    cy: number;
    // (undocumented)
    endAngle: number;
    // (undocumented)
    frac: number;
    // (undocumented)
    getLength(): number;
    // (undocumented)
    getPath(isFirstSegment: boolean): string;
    gradientAtPoint(location: number, absolute?: boolean): number;
    // (undocumented)
    length: number;
    // (undocumented)
    pointAlongPathFrom(location: number, distance: number, absolute?: boolean): PointXY;
    pointOnPath(location: number, absolute?: boolean): PointXY;
    // (undocumented)
    radius: number;
    // (undocumented)
    static segmentType: string;
    // (undocumented)
    startAngle: number;
    // (undocumented)
    sweep: number;
    // (undocumented)
    type: string;
}

// Warning: (ae-internal-missing-underscore) The name "ArcSegmentParams" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface ArcSegmentParams extends SegmentParams {
    // (undocumented)
    ac: boolean;
    // (undocumented)
    cx: number;
    // (undocumented)
    cy: number;
    // (undocumented)
    endAngle?: number;
    // (undocumented)
    r: number;
    // (undocumented)
    startAngle?: number;
}

// @public (undocumented)
export class ArrowOverlay extends Overlay {
    constructor(instance: JsPlumbInstance, component: Component, p: ArrowOverlayOptions);
    // (undocumented)
    cachedDimensions: Size;
    // (undocumented)
    component: Component;
    // (undocumented)
    direction: number;
    // (undocumented)
    draw(component: Component, currentConnectionPaintStyle: PaintStyle, absolutePosition?: PointXY): any;
    // (undocumented)
    foldback: number;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    length: number;
    // (undocumented)
    location: number;
    // (undocumented)
    paintStyle: PaintStyle;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
    // (undocumented)
    updateFrom(d: any): void;
    // (undocumented)
    width: number;
}

// @public (undocumented)
export function att(...attName: Array<string>): string;

// @public (undocumented)
export const ATTRIBUTE_GROUP = "data-jtk-group";

// @public (undocumented)
export const ATTRIBUTE_MANAGED = "data-jtk-managed";

// @public (undocumented)
export const ATTRIBUTE_NOT_DRAGGABLE = "data-jtk-not-draggable";

// @public (undocumented)
export const ATTRIBUTE_SCOPE = "data-jtk-scope";

// @public (undocumented)
export const ATTRIBUTE_SCOPE_PREFIX: string;

// @public (undocumented)
export const ATTRIBUTE_TABINDEX = "tabindex";

// @public (undocumented)
export type Axis = [Face, Face];

// @public
export type BeforeDetachInterceptor = (c: Connection) => boolean;

// @public
export type BeforeDragInterceptor<E = any> = (params: BeforeDragParams<E>) => boolean | Record<string, any>;

// @public
export interface BeforeDragParams<E> {
    // (undocumented)
    connection: Connection;
    // (undocumented)
    endpoint: Endpoint;
    // (undocumented)
    source: E;
    // (undocumented)
    sourceId: string;
}

// @public
export type BeforeDropInterceptor = (params: BeforeDropParams) => boolean;

// @public
export interface BeforeDropParams {
    // (undocumented)
    connection: Connection;
    // (undocumented)
    dropEndpoint: Endpoint;
    // (undocumented)
    scope: string;
    // (undocumented)
    sourceId: string;
    // (undocumented)
    targetId: string;
}

// @public
export type BeforeStartDetachInterceptor<E = any> = (params: BeforeStartDetachParams<E>) => boolean;

// @public
export interface BeforeStartDetachParams<E> extends BeforeDragParams<E> {
}

// @public
export interface BehaviouralTypeDescriptor<T = any> extends EndpointTypeDescriptor {
    allowLoopback?: boolean;
    anchorPositionFinder?: (el: Element, elxy: PointXY, def: BehaviouralTypeDescriptor, e: Event) => AnchorSpec | null;
    canAcceptNewConnection?: (el: Element, e: Event) => boolean;
    edgeType?: string;
    extract?: Record<string, string>;
    onMaxConnections?: (value: any, event?: any) => any;
    parameterExtractor?: (el: T, eventTarget: T, event: Event) => Record<string, any>;
    parentSelector?: string;
    portId?: string;
    rank?: number;
    redrop?: RedropPolicy;
    source?: boolean;
    target?: boolean;
    uniqueEndpoint?: boolean;
}

// @public (undocumented)
export class BlankEndpoint extends EndpointRepresentation<ComputedBlankEndpoint> {
    constructor(endpoint: Endpoint, params?: BlankEndpointParams);
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export const BlankEndpointHandler: EndpointHandler<BlankEndpoint, ComputedBlankEndpoint>;

// @public (undocumented)
export const BLOCK = "block";

// @public (undocumented)
export const BOTTOM = FaceValues.bottom;

// @public (undocumented)
export const CHECK_CONDITION = "checkCondition";

// @public (undocumented)
export const CHECK_DROP_ALLOWED = "checkDropAllowed";

// @public (undocumented)
export const CLASS_CONNECTED = "jtk-connected";

// @public (undocumented)
export const CLASS_CONNECTOR = "jtk-connector";

// @public (undocumented)
export const CLASS_CONNECTOR_OUTLINE = "jtk-connector-outline";

// @public (undocumented)
export const CLASS_ENDPOINT = "jtk-endpoint";

// @public (undocumented)
export const CLASS_ENDPOINT_ANCHOR_PREFIX = "jtk-endpoint-anchor";

// @public (undocumented)
export const CLASS_ENDPOINT_CONNECTED = "jtk-endpoint-connected";

// @public (undocumented)
export const CLASS_ENDPOINT_DROP_ALLOWED = "jtk-endpoint-drop-allowed";

// @public (undocumented)
export const CLASS_ENDPOINT_DROP_FORBIDDEN = "jtk-endpoint-drop-forbidden";

// @public (undocumented)
export const CLASS_ENDPOINT_FLOATING = "jtk-floating-endpoint";

// @public (undocumented)
export const CLASS_ENDPOINT_FULL = "jtk-endpoint-full";

// @public (undocumented)
export const CLASS_GROUP_COLLAPSED = "jtk-group-collapsed";

// @public (undocumented)
export const CLASS_GROUP_EXPANDED = "jtk-group-expanded";

// @public (undocumented)
export const CLASS_OVERLAY = "jtk-overlay";

// Warning: (ae-internal-missing-underscore) The name "ClassAction" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type ClassAction = typeof ADD_CLASS_ACTION | typeof REMOVE_CLASS_ACTION;

// @public (undocumented)
export function classList(...className: Array<string>): string;

// @public (undocumented)
export function cls(...className: Array<string>): string;

// @public
export abstract class Component extends EventGenerator {
    // Warning: (ae-incompatible-release-tags) The symbol "__constructor" is marked as @public, but its signature references "ComponentOptions" which is marked as @internal
    protected constructor(instance: JsPlumbInstance, params?: ComponentOptions);
    addClass(clazz: string, cascade?: boolean): void;
    // @internal
    addOverlay(overlay: OverlaySpec): Overlay;
    // @internal (undocumented)
    addType(typeId: string, params?: any): void;
    // @internal (undocumented)
    appendToDefaultType(obj: Record<string, any>): void;
    // @internal (undocumented)
    applyType(t: any, params?: any): void;
    // (undocumented)
    beforeDetach: BeforeDetachInterceptor;
    // (undocumented)
    beforeDrop: BeforeDropInterceptor;
    // @internal (undocumented)
    cacheTypeItem(key: string, item: any, typeId: string): void;
    // @internal (undocumented)
    clearTypes(params?: any): void;
    // (undocumented)
    clone: () => Component;
    // (undocumented)
    cssClass: string;
    // (undocumented)
    data: Record<string, any>;
    // (undocumented)
    defaultLabelLocation: number | [number, number];
    // Warning: (ae-incompatible-release-tags) The symbol "_defaultType" is marked as @public, but its signature references "ComponentTypeDescriptor" which is marked as @internal
    //
    // (undocumented)
    _defaultType: ComponentTypeDescriptor;
    // (undocumented)
    deleted: boolean;
    // @internal (undocumented)
    destroy(): void;
    // (undocumented)
    events: any;
    // @internal (undocumented)
    getAbsoluteOverlayPosition(overlay: Overlay): PointXY;
    // @internal (undocumented)
    getCachedTypeItem(key: string, typeId: string): any;
    getClass(): string;
    getData(): Record<string, any>;
    // (undocumented)
    abstract getDefaultOverlayKey(): string;
    // @internal (undocumented)
    getDefaultType(): ComponentTypeDescriptor;
    // @internal (undocumented)
    getHoverPaintStyle(): PaintStyle;
    // @internal (undocumented)
    getId(): string;
    // (undocumented)
    abstract getIdPrefix(): string;
    getLabel(): string;
    // @internal (undocumented)
    getLabelOverlay(): LabelOverlay;
    getOverlay<T extends Overlay>(id: string): T;
    getOverlays(): Record<string, Overlay>;
    // @internal (undocumented)
    getPaintStyle(): PaintStyle;
    // @internal (undocumented)
    getType(): string[];
    // (undocumented)
    abstract getTypeDescriptor(): string;
    // (undocumented)
    abstract getXY(): PointXY;
    // (undocumented)
    h: number;
    // @internal (undocumented)
    hasType(typeId: string): boolean;
    hideOverlay(id: string): void;
    hideOverlays(...ids: Array<string>): void;
    // (undocumented)
    _hover: boolean;
    // (undocumented)
    hoverClass: string;
    // (undocumented)
    hoverPaintStyle: PaintStyle;
    // (undocumented)
    id: string;
    // (undocumented)
    instance: JsPlumbInstance;
    // @internal
    isDetachAllowed(connection: Connection): boolean;
    // @internal (undocumented)
    isDropAllowed(sourceId: string, targetId: string, scope: string, connection: Connection, dropEndpoint: Endpoint): boolean;
    // @internal (undocumented)
    isHover(): boolean;
    // @internal (undocumented)
    isVisible(): boolean;
    // (undocumented)
    lastPaintedAt: string;
    mergeData(d: any): void;
    // @internal (undocumented)
    mergeParameters(p: ComponentParameters): void;
    // (undocumented)
    overlayPlacements: Record<string, Extents>;
    // (undocumented)
    overlayPositions: Record<string, PointXY>;
    // (undocumented)
    overlays: Record<string, Overlay>;
    // (undocumented)
    paintStyle: PaintStyle;
    // (undocumented)
    paintStyleInUse: PaintStyle;
    // (undocumented)
    parameters: ComponentParameters;
    // (undocumented)
    params: Record<string, any>;
    // @internal (undocumented)
    reapplyTypes(params?: any): void;
    removeAllOverlays(): void;
    removeClass(clazz: string, cascade?: boolean): void;
    // @internal
    removeOverlay(overlayId: string, dontCleanup?: boolean): void;
    removeOverlays(...overlays: string[]): void;
    // @internal (undocumented)
    removeType(typeId: string, params?: any): void;
    // (undocumented)
    segment: number;
    // @internal (undocumented)
    setAbsoluteOverlayPosition(overlay: Overlay, xy: PointXY): void;
    setData(d: any): void;
    // @internal (undocumented)
    setHoverPaintStyle(style: PaintStyle): void;
    setLabel(l: string | Function | LabelOverlay): void;
    // @internal (undocumented)
    setPaintStyle(style: PaintStyle): void;
    // @internal (undocumented)
    setType(typeId: string, params?: any): void;
    // @internal (undocumented)
    setVisible(v: boolean): void;
    // @internal (undocumented)
    shouldFireEvent(event: string, value: any, originalEvent?: Event): boolean;
    showOverlay(id: string): void;
    showOverlays(...ids: Array<string>): void;
    // @internal (undocumented)
    toggleType(typeId: string, params?: any): void;
    // (undocumented)
    _typeCache: {};
    // (undocumented)
    typeId: string;
    // (undocumented)
    _types: Set<string>;
    // (undocumented)
    visible: boolean;
    // (undocumented)
    w: number;
    // (undocumented)
    x: number;
    // (undocumented)
    y: number;
}

// Warning: (ae-internal-missing-underscore) The name "ComponentOptions" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface ComponentOptions {
    // (undocumented)
    beforeDetach?: BeforeDetachInterceptor;
    // (undocumented)
    beforeDrop?: BeforeDropInterceptor;
    // (undocumented)
    cssClass?: string;
    // (undocumented)
    data?: any;
    // (undocumented)
    events?: Record<string, (value: any, event: any) => any>;
    // (undocumented)
    hoverClass?: string;
    // (undocumented)
    id?: string;
    // (undocumented)
    label?: string;
    // (undocumented)
    labelLocation?: number;
    // (undocumented)
    overlays?: Array<OverlaySpec>;
    // (undocumented)
    parameters?: Record<string, any>;
    // (undocumented)
    scope?: string;
}

// @public (undocumented)
export type ComponentParameters = Record<string, any>;

// Warning: (ae-forgotten-export) The symbol "TypeDescriptorBase" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-missing-underscore) The name "ComponentTypeDescriptor" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export interface ComponentTypeDescriptor extends TypeDescriptorBase {
    // (undocumented)
    overlays: Record<string, OverlaySpec>;
}

// @public (undocumented)
export type ComputedBlankEndpoint = [number, number, number, number];

// @public (undocumented)
export type ComputedDotEndpoint = [number, number, number, number, number];

// Warning: (ae-internal-missing-underscore) The name "ComputedPosition" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface ComputedPosition {
    // (undocumented)
    curX: number;
    // (undocumented)
    curY: number;
    // (undocumented)
    ox: AnchorOrientationHint;
    // (undocumented)
    oy: AnchorOrientationHint;
    // (undocumented)
    x: number;
    // (undocumented)
    y: number;
}

// @public (undocumented)
export type ComputedRectangleEndpoint = [number, number, number, number];

// @public (undocumented)
export class Connection<E = any> extends Component {
    // @internal
    constructor(instance: JsPlumbInstance, params: ConnectionOptions<E>);
    addClass(c: string, cascade?: boolean): void;
    // (undocumented)
    applyType(t: ConnectionTypeDescriptor, typeMap: any): void;
    // Warning: (ae-incompatible-release-tags) The symbol "connector" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
    //
    // (undocumented)
    connector: AbstractConnector;
    cost: number;
    // (undocumented)
    defaultLabelLocation: number;
    // @internal (undocumented)
    destroy(): void;
    detachable: boolean;
    directed: boolean;
    // (undocumented)
    endpointHoverStyle: PaintStyle;
    // (undocumented)
    readonly endpointHoverStyles: [PaintStyle, PaintStyle];
    endpoints: [Endpoint<E>, Endpoint<E>];
    // (undocumented)
    readonly endpointSpec: EndpointSpec;
    // (undocumented)
    readonly endpointsSpec: [EndpointSpec, EndpointSpec];
    // (undocumented)
    endpointStyle: PaintStyle;
    // (undocumented)
    endpointStyles: [PaintStyle, PaintStyle];
    // @internal (undocumented)
    _forceDetach: boolean;
    // @internal (undocumented)
    _forceReattach: boolean;
    // (undocumented)
    getDefaultOverlayKey(): string;
    // (undocumented)
    getIdPrefix(): string;
    // (undocumented)
    getTypeDescriptor(): string;
    // (undocumented)
    getUuids(): [string, string];
    // (undocumented)
    getXY(): {
        x: number;
        y: number;
    };
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    isDetachable(ep?: Endpoint): boolean;
    // (undocumented)
    isReattach(): boolean;
    // (undocumented)
    makeEndpoint(isSource: boolean, el: any, elId: string, anchor?: AnchorSpec, ep?: Endpoint): Endpoint;
    // @internal (undocumented)
    pending: boolean;
    // @internal (undocumented)
    prepareConnector(connectorSpec: ConnectorSpec, typeId?: string): AbstractConnector;
    // (undocumented)
    previousConnection: Connection;
    // @internal
    proxies: Array<{
        ep: Endpoint<E>;
        originalEp: Endpoint<E>;
    }>;
    reattach: boolean;
    removeClass(c: string, cascade?: boolean): void;
    replaceEndpoint(idx: number, endpointDef: EndpointSpec): void;
    // (undocumented)
    scope: string;
    // @internal (undocumented)
    _setConnector(connectorSpec: ConnectorSpec, doNotRepaint?: boolean, doNotChangeListenerComponent?: boolean, typeId?: string): void;
    // (undocumented)
    setDetachable(detachable: boolean): void;
    // @internal (undocumented)
    setPreparedConnector(connector: AbstractConnector, doNotRepaint?: boolean, doNotChangeListenerComponent?: boolean, typeId?: string): void;
    // (undocumented)
    setReattach(reattach: boolean): void;
    setVisible(v: boolean): void;
    source: E;
    sourceId: string;
    // @internal (undocumented)
    suspendedElement: E;
    // @internal (undocumented)
    suspendedElementId: string;
    // @internal (undocumented)
    suspendedElementType: string;
    // @internal (undocumented)
    suspendedEndpoint: Endpoint<E>;
    // @internal (undocumented)
    suspendedIndex: number;
    target: E;
    targetId: string;
    // (undocumented)
    static type: string;
    // (undocumented)
    typeId: string;
    readonly uuids: [string, string];
}

// @public
export interface ConnectionDetachedParams<E = any> extends ConnectionEstablishedParams<E> {
}

// @public (undocumented)
export class ConnectionDragSelector {
    constructor(selector: string, def: SourceOrTargetDefinition, exclude?: boolean);
    // (undocumented)
    def: SourceOrTargetDefinition;
    // (undocumented)
    exclude: boolean;
    // (undocumented)
    readonly id: string;
    // (undocumented)
    isEnabled(): boolean;
    // (undocumented)
    redrop: RedropPolicy;
    // (undocumented)
    selector: string;
    // (undocumented)
    setEnabled(enabled: boolean): void;
}

// @public
export interface ConnectionEstablishedParams<E = any> {
    // (undocumented)
    connection: Connection<E>;
    // (undocumented)
    source: E;
    // (undocumented)
    sourceEndpoint: Endpoint<E>;
    // (undocumented)
    sourceId: string;
    // (undocumented)
    target: E;
    // (undocumented)
    targetEndpoint: Endpoint<E>;
    // (undocumented)
    targetId: string;
}

// @public
export interface ConnectionMovedParams<E = any> {
    // (undocumented)
    connection: Connection<E>;
    // (undocumented)
    index: number;
    // (undocumented)
    newEndpoint: Endpoint<E>;
    // (undocumented)
    newSourceId: string;
    // (undocumented)
    newTargetId: string;
    // (undocumented)
    originalEndpoint: Endpoint<E>;
    // (undocumented)
    originalSourceId: string;
    // (undocumented)
    originalTargetId: string;
}

// Warning: (ae-internal-missing-underscore) The name "ConnectionOptions" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type ConnectionOptions<E = any> = Merge<ConnectParams<E>, {
    source?: E;
    target?: E;
    sourceEndpoint?: Endpoint;
    targetEndpoint?: Endpoint;
    previousConnection?: Connection<E>;
    geometry?: any;
}>;

// Warning: (ae-forgotten-export) The symbol "SelectionBase" needs to be exported by the entry point index.d.ts
//
// @public (undocumented)
export class ConnectionSelection extends SelectionBase<Connection> {
    // (undocumented)
    deleteAll(): void;
    // (undocumented)
    repaint(): ConnectionSelection;
    // (undocumented)
    setConnector(spec: ConnectorSpec): ConnectionSelection;
    // (undocumented)
    setDetachable(d: boolean): ConnectionSelection;
    // (undocumented)
    setReattach(d: boolean): ConnectionSelection;
}

// @public
export interface ConnectionTypeDescriptor extends TypeDescriptor {
    detachable?: boolean;
    endpoints?: [EndpointSpec, EndpointSpec];
    reattach?: boolean;
}

// @public (undocumented)
export type ConnectorComputeParams = {
    sourcePos: AnchorPlacement;
    targetPos: AnchorPlacement;
    sourceEndpoint: Endpoint;
    targetEndpoint: Endpoint;
    strokeWidth: number;
    sourceInfo: ViewportElement<any>;
    targetInfo: ViewportElement<any>;
};

// @public (undocumented)
export const Connectors: {
    get: (connection: Connection, name: string, params: any) => AbstractConnector;
    register: (name: string, conn: Constructable<AbstractConnector>) => void;
};

// @public
export interface ConnectParams<E> {
    anchor?: AnchorSpec;
    anchors?: [AnchorSpec, AnchorSpec];
    // (undocumented)
    color?: string;
    connector?: ConnectorSpec;
    cost?: number;
    // (undocumented)
    cssClass?: string;
    // (undocumented)
    data?: any;
    deleteEndpointsOnDetach?: boolean;
    deleteEndpointsOnEmpty?: boolean;
    detachable?: boolean;
    directed?: boolean;
    endpoint?: EndpointSpec;
    endpointHoverStyle?: EndpointStyle;
    endpointHoverStyles?: [EndpointStyle, EndpointStyle];
    endpoints?: [EndpointSpec, EndpointSpec];
    endpointStyle?: EndpointStyle;
    endpointStyles?: [EndpointStyle, EndpointStyle];
    // (undocumented)
    hoverClass?: string;
    hoverPaintStyle?: PaintStyle;
    // (undocumented)
    id?: string;
    label?: string;
    // (undocumented)
    lineWidth?: number;
    // (undocumented)
    outlineColor?: string;
    // (undocumented)
    outlineWidth?: number;
    overlays?: Array<OverlaySpec>;
    paintStyle?: PaintStyle;
    parameters?: Record<string, any>;
    ports?: [string, string];
    reattach?: boolean;
    // (undocumented)
    scope?: string;
    source?: Element | Endpoint;
    target?: Element | Endpoint;
    type?: string;
    uuids?: [UUID, UUID];
}

// @public
export function convertToFullOverlaySpec(spec: string | OverlaySpec): FullOverlaySpec;

// @public (undocumented)
export function createFloatingAnchor(instance: JsPlumbInstance, element: Element, elementId: string): LightweightFloatingAnchor;

// @public (undocumented)
export function _createPerimeterAnchor(params: Record<string, any>): LightweightPerimeterAnchor;

// @public (undocumented)
export class CustomOverlay extends Overlay {
    constructor(instance: JsPlumbInstance, component: Component, p: CustomOverlayOptions);
    // (undocumented)
    component: Component;
    // (undocumented)
    create: (c: Component) => any;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
    // (undocumented)
    updateFrom(d: any): void;
}

// @public (undocumented)
export interface CustomOverlayOptions extends OverlayOptions {
    // (undocumented)
    create: (c: Component) => any;
}

// @public (undocumented)
export const DEFAULT_KEY_ALLOW_NESTED_GROUPS = "allowNestedGroups";

// @public (undocumented)
export const DEFAULT_KEY_ANCHOR = "anchor";

// @public (undocumented)
export const DEFAULT_KEY_ANCHORS = "anchors";

// @public (undocumented)
export const DEFAULT_KEY_CONNECTION_OVERLAYS = "connectionOverlays";

// @public (undocumented)
export const DEFAULT_KEY_CONNECTIONS_DETACHABLE = "connectionsDetachable";

// @public (undocumented)
export const DEFAULT_KEY_CONNECTOR = "connector";

// @public (undocumented)
export const DEFAULT_KEY_CONTAINER = "container";

// @public (undocumented)
export const DEFAULT_KEY_ENDPOINT = "endpoint";

// @public (undocumented)
export const DEFAULT_KEY_ENDPOINT_HOVER_STYLE = "endpointHoverStyle";

// @public (undocumented)
export const DEFAULT_KEY_ENDPOINT_HOVER_STYLES = "endpointHoverStyles";

// @public (undocumented)
export const DEFAULT_KEY_ENDPOINT_OVERLAYS = "endpointOverlays";

// @public (undocumented)
export const DEFAULT_KEY_ENDPOINT_STYLE = "endpointStyle";

// @public (undocumented)
export const DEFAULT_KEY_ENDPOINT_STYLES = "endpointStyles";

// @public (undocumented)
export const DEFAULT_KEY_ENDPOINTS = "endpoints";

// @public (undocumented)
export const DEFAULT_KEY_HOVER_CLASS = "hoverClass";

// @public (undocumented)
export const DEFAULT_KEY_HOVER_PAINT_STYLE = "hoverPaintStyle";

// @public (undocumented)
export const DEFAULT_KEY_LIST_STYLE = "listStyle";

// @public (undocumented)
export const DEFAULT_KEY_MAX_CONNECTIONS = "maxConnections";

// @public (undocumented)
export const DEFAULT_KEY_PAINT_STYLE = "paintStyle";

// @public (undocumented)
export const DEFAULT_KEY_REATTACH_CONNECTIONS = "reattachConnections";

// @public (undocumented)
export const DEFAULT_KEY_SCOPE = "scope";

// @public
export type DeleteConnectionOptions = {
    force?: boolean;
    fireEvent?: boolean;
    originalEvent?: Event;
    endpointToIgnore?: Endpoint;
};

// @public (undocumented)
export class DiamondOverlay extends ArrowOverlay {
    constructor(instance: JsPlumbInstance, component: Component, p: ArrowOverlayOptions);
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export class DotEndpoint extends EndpointRepresentation<ComputedDotEndpoint> {
    constructor(endpoint: Endpoint, params?: DotEndpointParams);
    // (undocumented)
    defaultInnerRadius: number;
    // (undocumented)
    defaultOffset: number;
    // (undocumented)
    radius: number;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export const DotEndpointHandler: EndpointHandler<DotEndpoint, ComputedDotEndpoint>;

// @public (undocumented)
export type ElementSelectionSpecifier<E> = E | Array<E> | '*';

// @public (undocumented)
export class Endpoint<E = any> extends Component {
    constructor(instance: JsPlumbInstance, params: InternalEndpointOptions<E>);
    // (undocumented)
    addClass(clazz: string, cascade?: boolean): void;
    // (undocumented)
    addConnection(conn: Connection): void;
    // (undocumented)
    _anchor: LightweightAnchor;
    _anchorLocationChanged(currentAnchor: LightweightAnchor): void;
    // (undocumented)
    applyType(t: any, typeMap: any): void;
    // (undocumented)
    connectionCost: number;
    // (undocumented)
    connections: Array<Connection<E>>;
    // (undocumented)
    connectionsDetachable: boolean;
    // (undocumented)
    connectionsDirected: boolean;
    // (undocumented)
    connector: ConnectorSpec;
    // (undocumented)
    connectorClass: string;
    // (undocumented)
    connectorHoverClass: string;
    // (undocumented)
    connectorHoverStyle: PaintStyle;
    // (undocumented)
    connectorOverlays: Array<OverlaySpec>;
    // (undocumented)
    connectorSelector(): Connection;
    // (undocumented)
    connectorStyle: PaintStyle;
    // (undocumented)
    currentAnchorClass: string;
    // (undocumented)
    defaultLabelLocation: [number, number];
    deleteEveryConnection(params?: DeleteConnectionOptions): void;
    // (undocumented)
    deleteOnEmpty: boolean;
    // (undocumented)
    destroy(): void;
    detachFrom(otherEndpoint: Endpoint): Endpoint;
    detachFromConnection(connection: Connection, idx?: number, transientDetach?: boolean): void;
    // (undocumented)
    dragAllowedWhenFull: boolean;
    // (undocumented)
    edgeType: string;
    // (undocumented)
    element: E;
    // (undocumented)
    elementId: string;
    // (undocumented)
    enabled: boolean;
    // (undocumented)
    endpoint: EndpointRepresentation<any>;
    // (undocumented)
    finalEndpoint: Endpoint<E>;
    // (undocumented)
    getDefaultOverlayKey(): string;
    // (undocumented)
    getIdPrefix(): string;
    // (undocumented)
    getTypeDescriptor(): string;
    // (undocumented)
    getUuid(): string;
    // (undocumented)
    getXY(): {
        x: number;
        y: number;
    };
    // (undocumented)
    instance: JsPlumbInstance;
    isConnectedTo(otherEndpoint: Endpoint): boolean;
    // (undocumented)
    isFloating(): boolean;
    // (undocumented)
    isFull(): boolean;
    // (undocumented)
    isSource: boolean;
    // (undocumented)
    isTarget: boolean;
    // (undocumented)
    isTemporarySource: boolean;
    // (undocumented)
    maxConnections: number;
    // (undocumented)
    portId: string;
    // (undocumented)
    proxiedBy: Endpoint<E>;
    // (undocumented)
    reattachConnections: boolean;
    // (undocumented)
    referenceEndpoint: Endpoint<E>;
    // (undocumented)
    removeClass(clazz: string, cascade?: boolean): void;
    // (undocumented)
    scope: string;
    // (undocumented)
    setAnchor(anchorParams: AnchorSpec | Array<AnchorSpec>): Endpoint;
    // (undocumented)
    setDragAllowedWhenFull(allowed: boolean): void;
    // (undocumented)
    setEndpoint<C>(ep: EndpointSpec | EndpointRepresentation<C>): void;
    // (undocumented)
    setVisible(v: boolean, doNotChangeConnections?: boolean, doNotNotifyOtherEndpoint?: boolean): void;
    // (undocumented)
    timestamp: string;
    // (undocumented)
    uuid: string;
}

// @public (undocumented)
export type EndpointComputeFunction<T> = (endpoint: EndpointRepresentation<T>, anchorPoint: AnchorPlacement, orientation: Orientation, endpointStyle: any) => T;

// @public (undocumented)
export const EndpointFactory: {
    get: (ep: Endpoint, name: string, params: any) => EndpointRepresentation<any>;
    clone: <C>(epr: EndpointRepresentation<C>) => EndpointRepresentation<C>;
    compute: <T>(endpoint: EndpointRepresentation<T>, anchorPoint: AnchorPlacement, orientation: Orientation, endpointStyle: any) => T;
    registerHandler: <E, T_1>(eph: EndpointHandler<E, T_1>) => void;
};

// @public (undocumented)
export interface EndpointHandler<E, T> {
    // (undocumented)
    cls: Constructable<EndpointRepresentation<T>>;
    // (undocumented)
    compute: EndpointComputeFunction<T>;
    // (undocumented)
    getParams(endpoint: E): Record<string, any>;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface EndpointOptions<E = any> {
    anchor?: AnchorSpec;
    anchors?: [AnchorSpec, AnchorSpec];
    connectionCost?: number;
    connectionsDetachable?: boolean;
    connectionsDirected?: boolean;
    connector?: ConnectorSpec;
    connectorClass?: string;
    connectorHoverClass?: string;
    connectorHoverStyle?: PaintStyle;
    connectorOverlays?: Array<OverlaySpec>;
    connectorStyle?: PaintStyle;
    // (undocumented)
    cssClass?: string;
    // (undocumented)
    data?: any;
    deleteOnEmpty?: boolean;
    dragAllowedWhenFull?: boolean;
    edgeType?: string;
    enabled?: boolean;
    endpoint?: EndpointSpec;
    // (undocumented)
    hoverClass?: string;
    hoverPaintStyle?: PaintStyle;
    maxConnections?: number;
    onMaxConnections?: (value: any, event?: any) => any;
    paintStyle?: PaintStyle;
    // (undocumented)
    parameters?: Record<string, any>;
    portId?: string;
    reattachConnections?: boolean;
    // (undocumented)
    scope?: string;
    source?: boolean;
    target?: boolean;
    uuid?: string;
}

// @public
export abstract class EndpointRepresentation<C> {
    protected constructor(endpoint: Endpoint, params?: EndpointRepresentationParams);
    // (undocumented)
    addClass(c: string): void;
    // (undocumented)
    bounds: Extents;
    // (undocumented)
    classes: Array<string>;
    // (undocumented)
    compute(anchorPoint: AnchorPlacement, orientation: Orientation, endpointStyle: any): void;
    // (undocumented)
    computedValue: C;
    // (undocumented)
    endpoint: Endpoint;
    // (undocumented)
    h: number;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    removeClass(c: string): void;
    // (undocumented)
    setVisible(v: boolean): void;
    // (undocumented)
    abstract type: string;
    // (undocumented)
    typeId: string;
    // (undocumented)
    w: number;
    // (undocumented)
    x: number;
    // (undocumented)
    y: number;
}

// @public (undocumented)
export class EndpointSelection extends SelectionBase<Endpoint> {
    // (undocumented)
    deleteAll(): EndpointSelection;
    // (undocumented)
    deleteEveryConnection(): EndpointSelection;
    // (undocumented)
    setAnchor(a: AnchorSpec): EndpointSelection;
    // (undocumented)
    setEnabled(e: boolean): EndpointSelection;
}

// @public
export interface EndpointTypeDescriptor extends TypeDescriptor {
    connectionsDetachable?: boolean;
    maxConnections?: number;
    reattachConnections?: boolean;
}

// @public (undocumented)
export const ERROR_SOURCE_DOES_NOT_EXIST = "Cannot establish connection: source does not exist";

// @public (undocumented)
export const ERROR_SOURCE_ENDPOINT_FULL = "Cannot establish connection: source endpoint is full";

// @public (undocumented)
export const ERROR_TARGET_DOES_NOT_EXIST = "Cannot establish connection: target does not exist";

// @public (undocumented)
export const ERROR_TARGET_ENDPOINT_FULL = "Cannot establish connection: target endpoint is full";

// @public (undocumented)
export const EVENT_ANCHOR_CHANGED = "anchor:changed";

// @public (undocumented)
export const EVENT_CONNECTION = "connection";

// @public (undocumented)
export const EVENT_CONNECTION_DETACHED = "connection:detach";

// @public (undocumented)
export const EVENT_CONNECTION_MOVED = "connection:move";

// @public (undocumented)
export const EVENT_CONTAINER_CHANGE = "container:change";

// @public (undocumented)
export const EVENT_ENDPOINT_REPLACED = "endpoint:replaced";

// @public (undocumented)
export const EVENT_GROUP_ADDED = "group:added";

// @public (undocumented)
export const EVENT_GROUP_COLLAPSE = "group:collapse";

// @public (undocumented)
export const EVENT_GROUP_EXPAND = "group:expand";

// @public (undocumented)
export const EVENT_GROUP_MEMBER_ADDED = "group:member:added";

// @public (undocumented)
export const EVENT_GROUP_MEMBER_REMOVED = "group:member:removed";

// @public (undocumented)
export const EVENT_GROUP_REMOVED = "group:removed";

// @public (undocumented)
export const EVENT_INTERNAL_CONNECTION = "internal.connection";

// @public (undocumented)
export const EVENT_INTERNAL_CONNECTION_DETACHED = "internal.connection:detached";

// @public (undocumented)
export const EVENT_INTERNAL_ENDPOINT_UNREGISTERED = "internal.endpoint:unregistered";

// @public (undocumented)
export const EVENT_MANAGE_ELEMENT = "element:manage";

// @public (undocumented)
export const EVENT_MAX_CONNECTIONS = "maxConnections";

// @public (undocumented)
export const EVENT_NESTED_GROUP_ADDED = "group:nested:added";

// @public (undocumented)
export const EVENT_NESTED_GROUP_REMOVED = "group:nested:removed";

// @public (undocumented)
export const EVENT_UNMANAGE_ELEMENT = "element:unmanage";

// @public (undocumented)
export const EVENT_ZOOM = "zoom";

// Warning: (ae-forgotten-export) The symbol "FaceValues" needs to be exported by the entry point index.d.ts
//
// @public (undocumented)
export type Face = keyof typeof FaceValues;

// @public (undocumented)
export const FIXED = "fixed";

// Warning: (ae-internal-missing-underscore) The name "getDefaultFace" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export function getDefaultFace(a: LightweightContinuousAnchor): Face;

// @public (undocumented)
export interface GroupCollapsedParams<E> {
    // (undocumented)
    group: UIGroup<E>;
}

// @public (undocumented)
export interface GroupExpandedParams<E> {
    // (undocumented)
    group: UIGroup<E>;
}

// @public (undocumented)
export class GroupManager<E> {
    constructor(instance: JsPlumbInstance);
    // (undocumented)
    addGroup(params: AddGroupOptions<E>): UIGroup<E>;
    // (undocumented)
    addToGroup(group: string | UIGroup<E>, doNotFireEvent: boolean, ...el: Array<E>): void;
    cascadeCollapse(collapsedGroup: UIGroup<E>, targetGroup: UIGroup<E>, collapsedIds: Set<string>): void;
    // (undocumented)
    collapseGroup(group: string | UIGroup<E>): void;
    // (undocumented)
    _connectionSourceMap: Record<string, UIGroup<E>>;
    // (undocumented)
    _connectionTargetMap: Record<string, UIGroup<E>>;
    // (undocumented)
    expandGroup(group: string | UIGroup<E>, doNotFireEvent?: boolean): void;
    // (undocumented)
    forEach(f: (g: UIGroup<E>) => any): void;
    // (undocumented)
    getAncestors(group: UIGroup<E>): Array<UIGroup<E>>;
    // (undocumented)
    getDescendants(group: UIGroup<E>): Array<UIGroup<E>>;
    // (undocumented)
    getGroup(groupId: string | UIGroup<E>): UIGroup<E>;
    // (undocumented)
    getGroupFor(el: E): UIGroup<E>;
    // (undocumented)
    getGroups(): Array<UIGroup<E>>;
    // (undocumented)
    groupMap: Record<string, UIGroup<E>>;
    // (undocumented)
    instance: JsPlumbInstance;
    isAncestor(group: UIGroup<E>, possibleAncestor: UIGroup<E>): boolean;
    // (undocumented)
    isDescendant(possibleDescendant: UIGroup<E>, ancestor: UIGroup<E>): boolean;
    // (undocumented)
    orphan(el: E, doNotTransferToAncestor: boolean): {
        id: string;
        pos: PointXY;
    };
    // (undocumented)
    removeAllGroups(deleteMembers?: boolean, manipulateView?: boolean, doNotFireEvent?: boolean): void;
    // (undocumented)
    removeFromGroup(group: string | UIGroup<E>, doNotFireEvent: boolean, ...el: Array<E>): void;
    // (undocumented)
    removeGroup(group: string | UIGroup<E>, deleteMembers?: boolean, manipulateView?: boolean, doNotFireEvent?: boolean): Record<string, PointXY>;
    // (undocumented)
    repaintGroup(group: string | UIGroup<E>): void;
    // (undocumented)
    reset(): void;
    // (undocumented)
    toggleGroup(group: string | UIGroup<E>): void;
    // (undocumented)
    _updateConnectionsForGroup(group: UIGroup<E>): void;
}

// @public (undocumented)
export interface GroupOptions {
    // (undocumented)
    anchor?: AnchorSpec;
    // (undocumented)
    constrain?: boolean;
    // (undocumented)
    dropOverride?: boolean;
    // (undocumented)
    droppable?: boolean;
    // (undocumented)
    enabled?: boolean;
    // (undocumented)
    endpoint?: EndpointSpec;
    // (undocumented)
    ghost?: boolean;
    // (undocumented)
    id?: string;
    // (undocumented)
    orphan?: boolean;
    // (undocumented)
    proxied?: boolean;
    // (undocumented)
    prune?: boolean;
    // (undocumented)
    revert?: boolean;
}

// @public (undocumented)
export const INTERCEPT_BEFORE_DETACH = "beforeDetach";

// @public (undocumented)
export const INTERCEPT_BEFORE_DRAG = "beforeDrag";

// @public (undocumented)
export const INTERCEPT_BEFORE_DROP = "beforeDrop";

// @public (undocumented)
export const INTERCEPT_BEFORE_START_DETACH = "beforeStartDetach";

// @public
export interface InternalConnectParams<E> extends ConnectParams<E> {
    // (undocumented)
    id?: string;
    // (undocumented)
    newConnection?: (p: any) => Connection;
    // (undocumented)
    scope?: string;
    // (undocumented)
    sourceEndpoint?: Endpoint<E>;
    // (undocumented)
    targetEndpoint?: Endpoint<E>;
    // (undocumented)
    type?: string;
}

// @public (undocumented)
export interface InternalEndpointOptions<E> extends EndpointOptions<E> {
    // (undocumented)
    connections?: Array<Connection>;
    // (undocumented)
    element?: E;
    // (undocumented)
    elementId?: string;
    // (undocumented)
    existingEndpoint?: EndpointRepresentation<E>;
    // (undocumented)
    id?: string;
    // (undocumented)
    isTemporarySource?: boolean;
    // (undocumented)
    preparedAnchor?: LightweightAnchor;
    // (undocumented)
    _transient?: boolean;
    // (undocumented)
    type?: string;
}

// @public (undocumented)
export const IS_DETACH_ALLOWED = "isDetachAllowed";

// @public (undocumented)
export function isArrowOverlay(o: Overlay): o is ArrowOverlay;

// @public (undocumented)
export function isContinuous(a: LightweightAnchor): a is LightweightContinuousAnchor;

// @public (undocumented)
export function isCustomOverlay(o: Overlay): o is CustomOverlay;

// @public (undocumented)
export function isDiamondOverlay(o: Overlay): o is DiamondOverlay;

// @public (undocumented)
export function isDynamic(a: LightweightAnchor): boolean;

// Warning: (ae-internal-missing-underscore) The name "isEdgeSupported" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export function isEdgeSupported(a: LightweightContinuousAnchor, edge: Face): boolean;

// @public (undocumented)
export function isFloating(a: LightweightAnchor): a is LightweightFloatingAnchor;

// @public
export function isFullOverlaySpec(o: OverlaySpec): o is FullOverlaySpec;

// @public (undocumented)
export function isLabelOverlay(o: Overlay): o is LabelOverlay;

// @public (undocumented)
export function isPlainArrowOverlay(o: Overlay): o is PlainArrowOverlay;

// @public (undocumented)
export interface JsPlumbDefaults<E> {
    // (undocumented)
    [DEFAULT_KEY_ALLOW_NESTED_GROUPS]?: boolean;
    // (undocumented)
    [DEFAULT_KEY_ANCHOR]?: AnchorSpec;
    // (undocumented)
    [DEFAULT_KEY_ANCHORS]?: [AnchorSpec, AnchorSpec];
    // (undocumented)
    [DEFAULT_KEY_CONNECTION_OVERLAYS]?: Array<OverlaySpec>;
    // (undocumented)
    [DEFAULT_KEY_CONNECTIONS_DETACHABLE]?: boolean;
    // (undocumented)
    [DEFAULT_KEY_CONNECTOR]?: ConnectorSpec;
    // (undocumented)
    [DEFAULT_KEY_CONTAINER]?: E;
    // (undocumented)
    [DEFAULT_KEY_ENDPOINT]?: EndpointSpec;
    // (undocumented)
    [DEFAULT_KEY_ENDPOINT_HOVER_STYLE]?: EndpointStyle;
    // (undocumented)
    [DEFAULT_KEY_ENDPOINT_HOVER_STYLES]?: [EndpointStyle, EndpointStyle];
    // (undocumented)
    [DEFAULT_KEY_ENDPOINT_OVERLAYS]?: Array<OverlaySpec>;
    // (undocumented)
    [DEFAULT_KEY_ENDPOINTS]?: [EndpointSpec, EndpointSpec];
    // (undocumented)
    [DEFAULT_KEY_ENDPOINT_STYLE]?: EndpointStyle;
    // (undocumented)
    [DEFAULT_KEY_ENDPOINT_STYLES]?: [EndpointStyle, EndpointStyle];
    // (undocumented)
    [DEFAULT_KEY_HOVER_CLASS]?: string;
    // (undocumented)
    [DEFAULT_KEY_HOVER_PAINT_STYLE]?: PaintStyle;
    // (undocumented)
    [DEFAULT_KEY_LIST_STYLE]?: ListSpec;
    // (undocumented)
    [DEFAULT_KEY_MAX_CONNECTIONS]?: number;
    // (undocumented)
    [DEFAULT_KEY_PAINT_STYLE]?: PaintStyle;
    // (undocumented)
    [DEFAULT_KEY_REATTACH_CONNECTIONS]?: boolean;
    // (undocumented)
    [DEFAULT_KEY_SCOPE]?: string;
}

// @public (undocumented)
export interface jsPlumbElement<E> {
    // (undocumented)
    _isJsPlumbGroup: boolean;
    // (undocumented)
    _jsPlumbGroup: UIGroup<E>;
    // (undocumented)
    _jsPlumbParentGroup: UIGroup<E>;
    // (undocumented)
    _jsPlumbProxies: Array<[Connection, number]>;
    // (undocumented)
    parentNode: jsPlumbElement<E>;
}

// @public (undocumented)
export abstract class JsPlumbInstance<T extends {
    E: unknown;
} = any> extends EventGenerator {
    constructor(_instanceIndex: number, defaults?: JsPlumbDefaults<T["E"]>);
    // (undocumented)
    abstract addClass(el: T["E"] | ArrayLike<T["E"]>, clazz: string): void;
    // @internal (undocumented)
    abstract addConnectorClass(connector: AbstractConnector, clazz: string): void;
    addEndpoint(el: T["E"], params?: EndpointOptions<T["E"]>, referenceParams?: EndpointOptions<T["E"]>): Endpoint;
    // (undocumented)
    abstract addEndpointClass(ep: Endpoint<T>, c: string): void;
    addEndpoints(el: T["E"], endpoints: Array<EndpointOptions<T["E"]>>, referenceParams?: EndpointOptions<T["E"]>): Array<Endpoint>;
    addGroup(params: AddGroupOptions<T["E"]>): UIGroup<T["E"]>;
    addOverlay(component: Component, overlay: OverlaySpec, doNotRevalidate?: boolean): void;
    // (undocumented)
    abstract addOverlayClass(o: Overlay, clazz: string): void;
    addSourceSelector(selector: string, params?: BehaviouralTypeDescriptor, exclude?: boolean): ConnectionDragSelector;
    addTargetSelector(selector: string, params?: BehaviouralTypeDescriptor, exclude?: boolean): ConnectionDragSelector;
    addToGroup(group: string | UIGroup<T["E"]>, ...el: Array<T["E"]>): void;
    // (undocumented)
    allowNestedGroups: boolean;
    // (undocumented)
    abstract _appendElement(el: T["E"], parent: T["E"]): void;
    // (undocumented)
    abstract _appendElementToContainer(e: T["E"]): void;
    // (undocumented)
    abstract _appendElementToGroup(group: UIGroup, e: T["E"]): void;
    // Warning: (ae-incompatible-release-tags) The symbol "applyConnectorType" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
    //
    // (undocumented)
    abstract applyConnectorType(connector: AbstractConnector, t: TypeDescriptor): void;
    // (undocumented)
    abstract applyEndpointType(ep: Endpoint<T>, t: TypeDescriptor): void;
    // @internal
    _applyRotations(point: [number, number, number, number], rotations: Rotations): RotatedPointXY;
    // @internal
    _applyRotationsXY(point: PointXY, rotations: Rotations): PointXY;
    // @internal (undocumented)
    areDefaultAnchorsSet(): boolean;
    batch(fn: Function, doNotRepaintAfterwards?: boolean): void;
    // (undocumented)
    checkCondition<RetVal>(conditionName: string, args?: any): RetVal;
    collapseGroup(group: string | UIGroup<T["E"]>): void;
    connect(params: ConnectParams<T["E"]>, referenceParams?: ConnectParams<T["E"]>): Connection;
    // (undocumented)
    connectedClass: string;
    // (undocumented)
    readonly connections: Array<Connection>;
    // (undocumented)
    connectorClass: string;
    // (undocumented)
    connectorOutlineClass: string;
    // (undocumented)
    protected _createSourceDefinition(params?: BehaviouralTypeDescriptor, referenceParams?: BehaviouralTypeDescriptor): SourceDefinition;
    // (undocumented)
    currentlyDragging: boolean;
    // (undocumented)
    get currentZoom(): number;
    // (undocumented)
    defaults: JsPlumbDefaults<T["E"]>;
    // (undocumented)
    get defaultScope(): string;
    deleteConnection(connection: Connection, params?: DeleteConnectionOptions): boolean;
    deleteConnectionsForElement(el: T["E"], params?: DeleteConnectionOptions): JsPlumbInstance;
    deleteEndpoint(object: string | Endpoint): JsPlumbInstance;
    // (undocumented)
    deleteEveryConnection(params?: DeleteConnectionOptions): number;
    // @internal
    _deriveEndpointAndAnchorSpec(type: string, dontPrependDefault?: boolean): {
        endpoints: [EndpointSpec, EndpointSpec];
        anchors: [AnchorSpec, AnchorSpec];
    };
    destroy(): void;
    // @internal (undocumented)
    abstract destroyConnector(connection: Connection, force?: boolean): void;
    // (undocumented)
    abstract destroyEndpoint(ep: Endpoint<T>): void;
    // (undocumented)
    abstract destroyOverlay(o: Overlay): void;
    // (undocumented)
    abstract drawOverlay(overlay: Overlay, component: any, paintStyle: PaintStyle, absolutePosition?: PointXY): any;
    each(spec: T["E"] | Array<T["E"]>, fn: (e: T["E"]) => any): JsPlumbInstance;
    // (undocumented)
    endpointAnchorClassPrefix: string;
    // (undocumented)
    endpointClass: string;
    // (undocumented)
    endpointConnectedClass: string;
    // (undocumented)
    endpointDropAllowedClass: string;
    // (undocumented)
    endpointDropForbiddenClass: string;
    // (undocumented)
    endpointFloatingClass: string;
    // (undocumented)
    endpointFullClass: string;
    // (undocumented)
    endpointsByElement: Record<string, Array<Endpoint>>;
    expandGroup(group: string | UIGroup<T["E"]>): void;
    // @internal
    _finaliseConnection(jpc: Connection, params?: any, originalEvent?: Event): void;
    // (undocumented)
    fireMoveEvent(params?: ConnectionMovedParams, evt?: Event): void;
    // @internal
    abstract _getAssociatedElements(el: T["E"]): Array<T["E"]>;
    // (undocumented)
    abstract getAttribute(el: T["E"], name: string): string;
    // (undocumented)
    abstract getClass(el: T["E"]): string;
    // (undocumented)
    getConnections(options?: SelectOptions<T["E"]>, flat?: boolean): Record<string, Connection> | Array<Connection>;
    getConnectionType(id: string): ConnectionTypeDescriptor;
    // Warning: (ae-incompatible-release-tags) The symbol "getConnectorClass" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
    //
    // (undocumented)
    abstract getConnectorClass(connector: AbstractConnector): string;
    // (undocumented)
    getContainer(): any;
    getEndpoint(uuid: string): Endpoint;
    // (undocumented)
    abstract getEndpointClass(ep: Endpoint<T>): string;
    getEndpoints(el: T["E"]): Array<Endpoint>;
    getEndpointType(id: string): EndpointTypeDescriptor;
    getGroup(groupId: string): UIGroup<T["E"]>;
    // (undocumented)
    abstract getGroupContentArea(group: UIGroup): T["E"];
    getGroupFor(el: T["E"]): UIGroup<T["E"]>;
    // (undocumented)
    getId(element: T["E"], uuid?: string): string;
    // @internal
    getManagedData(elementId: string, dataIdentifier: string, key: string): any;
    getManagedElement(id: string): T["E"];
    getManagedElements(): Record<string, ManagedElement<T["E"]>>;
    // (undocumented)
    abstract getOffset(el: T["E"]): PointXY;
    // (undocumented)
    abstract getOffsetRelativeToRoot(el: T["E"] | string): PointXY;
    // @internal (undocumented)
    getPathData(connector: AbstractConnector): any;
    // @internal
    _getRotation(elementId: string): number;
    // @internal
    _getRotations(elementId: string): Rotations;
    // (undocumented)
    abstract getSelector(ctx: string | T["E"], spec?: string): ArrayLike<T["E"]>;
    // (undocumented)
    abstract getSize(el: T["E"]): Size;
    // (undocumented)
    abstract getStyle(el: T["E"], prop: string): any;
    // (undocumented)
    getSuspendedAt(): string;
    getType(id: string, typeDescriptor: string): TypeDescriptor;
    // (undocumented)
    readonly groupManager: GroupManager<T["E"]>;
    // (undocumented)
    abstract hasClass(el: T["E"], clazz: string): boolean;
    // (undocumented)
    hide(el: T["E"], changeEndpoints?: boolean): JsPlumbInstance;
    // (undocumented)
    hoverSuspended: boolean;
    // (undocumented)
    _idstamp(): string;
    importDefaults(d: JsPlumbDefaults<T["E"]>): JsPlumbInstance;
    // (undocumented)
    readonly _instanceIndex: number;
    // @internal
    _internal_newEndpoint(params: InternalEndpointOptions<T["E"]>): Endpoint;
    // (undocumented)
    isConnectionBeingDragged: boolean;
    isHoverSuspended(): boolean;
    // @internal
    _makeConnector(connection: Connection<T["E"]>, name: string, args: any): AbstractConnector;
    manage(element: T["E"], internalId?: string, _recalc?: boolean): ManagedElement<T["E"]>;
    manageAll(elements: ArrayLike<T["E"]> | string, recalc?: boolean): void;
    // (undocumented)
    protected _managedElements: Record<string, ManagedElement<T["E"]>>;
    // @internal
    _maybePruneEndpoint(endpoint: Endpoint): boolean;
    // @internal
    _newConnection(params: ConnectionOptions<T["E"]>): Connection;
    // (undocumented)
    abstract off(el: Document | T["E"] | ArrayLike<T["E"]>, event: string, callback: Function): void;
    // (undocumented)
    abstract on(el: Document | T["E"] | ArrayLike<T["E"]>, event: string, callbackOrSelector: Function | string, callback?: Function): void;
    // (undocumented)
    overlayClass: string;
    // @internal (undocumented)
    _paintConnection(connection: Connection, params?: {
        timestamp?: string;
    }): void;
    // @internal (undocumented)
    abstract paintConnector(connector: AbstractConnector, paintStyle: PaintStyle, extents?: Extents): void;
    // @internal (undocumented)
    _paintEndpoint(endpoint: Endpoint, params: {
        timestamp?: string;
        offset?: ViewportElement<T["E"]>;
        recalc?: boolean;
        elementWithPrecedence?: string;
        connectorPaintStyle?: PaintStyle;
        anchorLoc?: AnchorPlacement;
    }): void;
    // @internal (undocumented)
    abstract _paintOverlay(o: Overlay, params: any, extents: any): void;
    // @internal (undocumented)
    proxyConnection(connection: Connection, index: number, proxyEl: T["E"], endpointGenerator: (c: Connection, idx: number) => EndpointSpec, anchorGenerator: (c: Connection, idx: number) => AnchorSpec): void;
    // (undocumented)
    abstract reattachOverlay(o: Overlay, c: Component): void;
    // @internal (undocumented)
    _refreshEndpoint(endpoint: Endpoint): void;
    registerConnectionType(id: string, type: ConnectionTypeDescriptor): void;
    registerConnectionTypes(types: Record<string, ConnectionTypeDescriptor>): void;
    registerEndpointType(id: string, type: EndpointTypeDescriptor): void;
    registerEndpointTypes(types: Record<string, EndpointTypeDescriptor>): void;
    removeAllEndpoints(el: T["E"], recurse?: boolean): JsPlumbInstance;
    removeAllGroups(deleteMembers?: boolean, _manipulateView?: boolean): void;
    // (undocumented)
    abstract removeAttribute(el: T["E"], attName: string): void;
    // (undocumented)
    abstract removeClass(el: T["E"] | ArrayLike<T["E"]>, clazz: string): void;
    // Warning: (ae-incompatible-release-tags) The symbol "removeConnectorClass" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
    //
    // (undocumented)
    abstract removeConnectorClass(connector: AbstractConnector, clazz: string): void;
    // (undocumented)
    abstract _removeElement(el: T["E"]): void;
    // (undocumented)
    abstract removeEndpointClass(ep: Endpoint<T>, c: string): void;
    removeFromGroup(group: string | UIGroup<T["E"]>, el: T["E"], _doNotFireEvent?: boolean): void;
    removeGroup(group: string | UIGroup<T["E"]>, deleteMembers?: boolean, _manipulateView?: boolean, _doNotFireEvent?: boolean): Record<string, PointXY>;
    removeOverlay(component: Component, overlayId: string): void;
    // (undocumented)
    abstract removeOverlayClass(o: Overlay, clazz: string): void;
    removeSourceSelector(selector: ConnectionDragSelector): void;
    removeTargetSelector(selector: ConnectionDragSelector): void;
    // (undocumented)
    abstract renderEndpoint(ep: Endpoint<T>, paintStyle: PaintStyle): void;
    repaint(el: T["E"], timestamp?: string, offsetsWereJustCalculated?: boolean): RedrawResult;
    repaintEverything(): JsPlumbInstance;
    reset(): void;
    restoreDefaults(): JsPlumbInstance;
    revalidate(el: T["E"], timestamp?: string): RedrawResult;
    rotate(element: T["E"], rotation: number, _doNotRepaint?: boolean): RedrawResult;
    // (undocumented)
    readonly router: Router<T, any>;
    // (undocumented)
    select(params?: SelectOptions<T["E"]>): ConnectionSelection;
    // (undocumented)
    selectEndpoints(params?: SelectEndpointOptions<T["E"]>): EndpointSelection;
    // (undocumented)
    abstract setAttribute(el: T["E"], name: string, value: string): void;
    // (undocumented)
    abstract setAttributes(el: T["E"], atts: Record<string, string>): void;
    setColor(conn: Connection, color: string): void;
    setConnectionType(connection: Connection, type: string, params?: any): void;
    // @internal (undocumented)
    abstract setConnectorHover(connector: AbstractConnector, h: boolean, sourceEndpoint?: Endpoint): void;
    // Warning: (ae-incompatible-release-tags) The symbol "setConnectorVisible" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
    //
    // (undocumented)
    abstract setConnectorVisible(connector: AbstractConnector, v: boolean): void;
    // (undocumented)
    setContainer(c: T["E"]): void;
    setElementPosition(el: T["E"], x: number, y: number): RedrawResult;
    // (undocumented)
    abstract setEndpointHover(endpoint: Endpoint<T>, h: boolean, endpointIndex: number, doNotCascade?: boolean): void;
    setEndpointUuid(endpoint: Endpoint, uuid: string): void;
    // (undocumented)
    abstract setEndpointVisible(ep: Endpoint<T>, v: boolean): void;
    // (undocumented)
    abstract setGroupVisible(group: UIGroup, state: boolean): void;
    // (undocumented)
    abstract setHover(component: Component, hover: boolean): void;
    setLineStyle(conn: Connection, style: {
        lineWidth?: number;
        outlineWidth?: number;
        color?: string;
        outlineColor?: string;
    }): void;
    setLineWidth(conn: Connection, width: number): void;
    // @internal
    setManagedData(elementId: string, dataIdentifier: string, key: string, data: any): void;
    setOutlineColor(conn: Connection, color: string): void;
    setOutlineWidth(conn: Connection, width: number): void;
    // (undocumented)
    abstract setOverlayHover(o: Overlay, hover: boolean): void;
    // (undocumented)
    abstract setOverlayVisible(o: Overlay, visible: boolean): void;
    // (undocumented)
    abstract setPosition(el: T["E"], p: PointXY): void;
    setSource(connection: Connection, el: T["E"] | Endpoint): void;
    setSuspendDrawing(val?: boolean, repaintAfterwards?: boolean): boolean;
    setTarget(connection: Connection, el: T["E"] | Endpoint): void;
    // (undocumented)
    setZoom(z: number, repaintEverything?: boolean): boolean;
    // (undocumented)
    show(el: T["E"], changeEndpoints?: boolean): JsPlumbInstance;
    // @internal (undocumented)
    sourceOrTargetChanged(originalId: string, newId: string, connection: Connection, newElement: T["E"], index: number): void;
    // (undocumented)
    sourceSelectors: Array<ConnectionDragSelector>;
    // (undocumented)
    _suspendDrawing: boolean;
    // (undocumented)
    _suspendedAt: string;
    // (undocumented)
    targetSelectors: Array<ConnectionDragSelector>;
    // (undocumented)
    abstract toggleClass(el: T["E"] | ArrayLike<T["E"]>, clazz: string): void;
    toggleGroup(group: string | UIGroup<T["E"]>): void;
    toggleVisible(el: T["E"], changeEndpoints?: boolean): void;
    // (undocumented)
    abstract trigger(el: Document | T["E"], event: string, originalEvent?: Event, payload?: any, detail?: number): void;
    unmanage(el: T["E"], removeElement?: boolean): void;
    // @internal (undocumented)
    unproxyConnection(connection: Connection, index: number): void;
    // (undocumented)
    abstract updateLabel(o: LabelOverlay): void;
    // Warning: (ae-incompatible-release-tags) The symbol "updateOffset" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    updateOffset(params?: UpdateOffsetOptions): ViewportElement<T["E"]>;
    // @internal (undocumented)
    validAnchorsSpec(anchors: [AnchorSpec, AnchorSpec]): boolean;
    // (undocumented)
    readonly viewport: Viewport<T>;
}

// @public (undocumented)
export const KEY_CONNECTION_OVERLAYS = "connectionOverlays";

// @public (undocumented)
export class LabelOverlay extends Overlay {
    constructor(instance: JsPlumbInstance, component: Component, p: LabelOverlayOptions);
    // (undocumented)
    cachedDimensions: Size;
    // (undocumented)
    component: Component;
    // (undocumented)
    getDimensions(): Size;
    // (undocumented)
    getLabel(): string;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    label: string | Function;
    // (undocumented)
    labelText: string;
    // (undocumented)
    setLabel(l: string | Function): void;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
    // (undocumented)
    updateFrom(d: any): void;
}

// @public (undocumented)
export const LEFT = FaceValues.left;

// @public (undocumented)
export interface LightweightAnchor {
    // Warning: (ae-incompatible-release-tags) The symbol "computedPosition" is marked as @public, but its signature references "ComputedPosition" which is marked as @internal
    //
    // (undocumented)
    computedPosition?: ComputedPosition;
    // (undocumented)
    cssClass: string;
    // (undocumented)
    currentLocation: number;
    // (undocumented)
    id: string;
    // (undocumented)
    isContinuous: boolean;
    // (undocumented)
    isDynamic: boolean;
    // (undocumented)
    isFloating: boolean;
    // Warning: (ae-incompatible-release-tags) The symbol "locations" is marked as @public, but its signature references "AnchorRecord" which is marked as @internal
    //
    // (undocumented)
    locations: Array<AnchorRecord>;
    // (undocumented)
    locked: boolean;
    // (undocumented)
    timestamp: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface LightweightContinuousAnchor extends LightweightAnchor {
    // (undocumented)
    clockwise: boolean;
    // (undocumented)
    currentFace: Face;
    // (undocumented)
    faces: Array<Face>;
    // (undocumented)
    isContinuous: true;
    // (undocumented)
    isDynamic: false;
    // (undocumented)
    lockedAxis: Axis;
    // (undocumented)
    lockedFace: Face;
}

// @public (undocumented)
export class LightweightFloatingAnchor implements LightweightAnchor {
    constructor(instance: JsPlumbInstance, element: Element, elementId: string);
    // (undocumented)
    cssClass: string;
    // (undocumented)
    currentLocation: number;
    // (undocumented)
    element: Element;
    // (undocumented)
    id: string;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    isContinuous: false;
    // (undocumented)
    isDynamic: false;
    // (undocumented)
    isFloating: boolean;
    // Warning: (ae-incompatible-release-tags) The symbol "locations" is marked as @public, but its signature references "AnchorRecord" which is marked as @internal
    //
    // (undocumented)
    locations: Array<AnchorRecord>;
    // (undocumented)
    locked: boolean;
    // (undocumented)
    orientation: Orientation;
    out(): void;
    over(endpoint: Endpoint): void;
    // (undocumented)
    size: Size;
    // (undocumented)
    timestamp: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface LightweightPerimeterAnchor extends LightweightAnchor {
    // (undocumented)
    shape: PerimeterAnchorShapes;
}

// @public (undocumented)
export class LightweightRouter<T extends {
    E: unknown;
}> implements Router<T, LightweightAnchor> {
    constructor(instance: JsPlumbInstance);
    // Warning: (ae-forgotten-export) The symbol "AnchorLists" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    anchorLists: Map<string, AnchorLists>;
    // (undocumented)
    anchorLocations: Map<string, AnchorPlacement>;
    // @internal
    anchorsEqual(a1: LightweightAnchor, a2: LightweightAnchor): boolean;
    // Warning: (ae-incompatible-release-tags) The symbol "computeAnchorLocation" is marked as @public, but its signature references "AnchorComputeParams" which is marked as @internal
    //
    // (undocumented)
    computeAnchorLocation(anchor: LightweightAnchor, params: AnchorComputeParams): AnchorPlacement;
    // (undocumented)
    computePath(connection: Connection<any>, timestamp: string): void;
    // (undocumented)
    getAnchorOrientation(anchor: LightweightAnchor): Orientation;
    // Warning: (ae-incompatible-release-tags) The symbol "getEndpointLocation" is marked as @public, but its signature references "AnchorComputeParams" which is marked as @internal
    //
    // (undocumented)
    getEndpointLocation(endpoint: Endpoint<any>, params: AnchorComputeParams): AnchorPlacement;
    // (undocumented)
    getEndpointOrientation(ep: Endpoint<any>): Orientation;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    isDynamicAnchor(ep: Endpoint<any>): boolean;
    // (undocumented)
    isFloating(ep: Endpoint<any>): boolean;
    // @internal (undocumented)
    lock(a: LightweightAnchor): void;
    // @internal (undocumented)
    lockCurrentAxis(a: LightweightContinuousAnchor): void;
    // (undocumented)
    prepareAnchor(params: AnchorSpec | Array<AnchorSpec>): LightweightAnchor;
    // (undocumented)
    redraw(elementId: string, timestamp?: string, offsetToUI?: PointXY): RedrawResult;
    // (undocumented)
    reset(): void;
    // @internal
    selectAnchorLocation(a: LightweightAnchor, coords: {
        x: number;
        y: number;
    }): boolean;
    // (undocumented)
    setAnchor(endpoint: Endpoint<any>, anchor: LightweightAnchor): void;
    // (undocumented)
    setAnchorOrientation(anchor: LightweightAnchor, orientation: Orientation): void;
    // (undocumented)
    setConnectionAnchors(conn: Connection<any>, anchors: [LightweightAnchor, LightweightAnchor]): void;
    // @internal (undocumented)
    setCurrentFace(a: LightweightContinuousAnchor, face: Face, overrideLock?: boolean): void;
    // @internal (undocumented)
    unlock(a: LightweightAnchor): void;
    // @internal (undocumented)
    unlockCurrentAxis(a: LightweightContinuousAnchor): void;
}

// @public (undocumented)
export interface ListSpec {
    // (undocumented)
    endpoint?: EndpointSpec;
}

// @public (undocumented)
export function makeLightweightAnchorFromSpec(spec: AnchorSpec | Array<AnchorSpec>): LightweightAnchor;

// @public (undocumented)
export type ManagedElement<E> = {
    el: jsPlumbElement<E>;
    viewportElement?: ViewportElement<E>;
    endpoints?: Array<Endpoint>;
    connections?: Array<Connection>;
    rotation?: number;
    group?: string;
    data: Record<string, Record<string, any>>;
};

// @public
export interface ManageElementParams<E = any> {
    // (undocumented)
    el: E;
}

// @public (undocumented)
export const NONE = "none";

// @public (undocumented)
export type Orientation = [AnchorOrientationHint, AnchorOrientationHint];

// @public (undocumented)
export abstract class Overlay extends EventGenerator {
    constructor(instance: JsPlumbInstance, component: Component, p: OverlayOptions);
    // (undocumented)
    attributes: Record<string, string>;
    // (undocumented)
    component: Component;
    // (undocumented)
    cssClass: string;
    // (undocumented)
    events: Record<string, (value: any, event?: any) => any>;
    // (undocumented)
    id: string;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    isVisible(): boolean;
    // (undocumented)
    location: number | Array<number>;
    // (undocumented)
    setLocation(l: number | string): void;
    // (undocumented)
    setVisible(v: boolean): void;
    // (undocumented)
    shouldFireEvent(event: string, value: any, originalEvent?: Event): boolean;
    // (undocumented)
    abstract type: string;
    // (undocumented)
    abstract updateFrom(d: any): void;
    // (undocumented)
    visible: boolean;
}

// @public (undocumented)
export const OverlayFactory: {
    get: (instance: JsPlumbInstance, name: string, component: Component, params: any) => Overlay;
    register: (name: string, overlay: Constructable<Overlay>) => void;
};

// @public (undocumented)
export interface OverlayMouseEventParams {
    // (undocumented)
    e: Event;
    // (undocumented)
    overlay: Overlay;
}

// Warning: (ae-internal-missing-underscore) The name "PaintGeometry" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface PaintGeometry {
    // (undocumented)
    anchorOrientation?: string;
    // (undocumented)
    endStubX: number;
    // (undocumented)
    endStubY: number;
    // (undocumented)
    h: number;
    // (undocumented)
    isXGreaterThanStubTimes2: boolean;
    // (undocumented)
    isYGreaterThanStubTimes2: boolean;
    // (undocumented)
    mx: number;
    // (undocumented)
    my: number;
    // (undocumented)
    opposite: boolean;
    // (undocumented)
    orthogonal: boolean;
    // (undocumented)
    perpendicular: boolean;
    // (undocumented)
    points: [number, number, number, number, number, number, number, number];
    // (undocumented)
    segment: number;
    // (undocumented)
    so: Orientation;
    // (undocumented)
    sourceAxis: PaintAxis;
    // (undocumented)
    startStubX: number;
    // (undocumented)
    startStubY: number;
    // (undocumented)
    stubs: [number, number];
    // (undocumented)
    sx: number;
    // (undocumented)
    sy: number;
    // (undocumented)
    to: Orientation;
    // (undocumented)
    tx: number;
    // (undocumented)
    ty: number;
    // (undocumented)
    w: number;
    // (undocumented)
    x: number;
    // (undocumented)
    xSpan: number;
    // (undocumented)
    y: number;
    // (undocumented)
    ySpan: number;
}

// @public (undocumented)
export class PlainArrowOverlay extends ArrowOverlay {
    constructor(instance: JsPlumbInstance, component: Component, p: ArrowOverlayOptions);
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export class RectangleEndpoint extends EndpointRepresentation<ComputedRectangleEndpoint> {
    constructor(endpoint: Endpoint, params?: RectangleEndpointParams);
    // (undocumented)
    static _getParams(ep: RectangleEndpoint): Record<string, any>;
    // (undocumented)
    height: number;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
    // (undocumented)
    width: number;
}

// @public (undocumented)
export const RectangleEndpointHandler: EndpointHandler<RectangleEndpoint, ComputedRectangleEndpoint>;

// @public (undocumented)
export interface RedrawResult {
    // (undocumented)
    c: Set<Connection>;
    // (undocumented)
    e: Set<Endpoint>;
}

// @public
export const REDROP_POLICY_ANY = "any";

// @public
export const REDROP_POLICY_ANY_SOURCE = "anySource";

// @public
export const REDROP_POLICY_ANY_SOURCE_OR_TARGET = "anySourceOrTarget";

// @public
export const REDROP_POLICY_ANY_TARGET = "anyTarget";

// @public
export const REDROP_POLICY_STRICT = "strict";

// @public
export type RedropPolicy = typeof REDROP_POLICY_STRICT | typeof REDROP_POLICY_ANY | typeof REDROP_POLICY_ANY_SOURCE | typeof REDROP_POLICY_ANY_TARGET | typeof REDROP_POLICY_ANY_SOURCE_OR_TARGET;

// @public (undocumented)
export const REMOVE_CLASS_ACTION = "remove";

// @public (undocumented)
export function _removeTypeCssHelper<E>(component: Component, typeId: string): void;

// @public (undocumented)
export const RIGHT = FaceValues.right;

// @public (undocumented)
export interface Router<T extends {
    E: unknown;
}, A> {
    // (undocumented)
    anchorsEqual(a: A, b: A): boolean;
    // Warning: (ae-incompatible-release-tags) The symbol "computeAnchorLocation" is marked as @public, but its signature references "AnchorComputeParams" which is marked as @internal
    //
    // (undocumented)
    computeAnchorLocation(anchor: A, params: AnchorComputeParams): AnchorPlacement;
    // (undocumented)
    computePath(connection: Connection, timestamp: string): void;
    // (undocumented)
    getAnchorOrientation(anchor: A, endpoint?: Endpoint): Orientation;
    // Warning: (ae-incompatible-release-tags) The symbol "getEndpointLocation" is marked as @public, but its signature references "AnchorComputeParams" which is marked as @internal
    //
    // (undocumented)
    getEndpointLocation(endpoint: Endpoint<any>, params: AnchorComputeParams): AnchorPlacement;
    // (undocumented)
    getEndpointOrientation(endpoint: Endpoint): Orientation;
    // (undocumented)
    isDynamicAnchor(ep: Endpoint): boolean;
    // (undocumented)
    isFloating(ep: Endpoint): boolean;
    // (undocumented)
    lock(a: A): void;
    // (undocumented)
    prepareAnchor(params: AnchorSpec | Array<AnchorSpec>): A;
    // (undocumented)
    redraw(elementId: string, timestamp?: string, offsetToUI?: PointXY): RedrawResult;
    // (undocumented)
    reset(): void;
    // (undocumented)
    selectAnchorLocation(a: A, coords: {
        x: number;
        y: number;
    }): boolean;
    // (undocumented)
    setAnchor(endpoint: Endpoint, anchor: A): void;
    // (undocumented)
    setAnchorOrientation(anchor: A, orientation: Orientation): void;
    // (undocumented)
    setConnectionAnchors(conn: Connection, anchors: [A, A]): void;
    // (undocumented)
    setCurrentFace(a: LightweightContinuousAnchor, face: Face, overrideLock?: boolean): void;
    // (undocumented)
    unlock(a: A): void;
}

// @public (undocumented)
export interface SelectEndpointOptions<E> extends AbstractSelectOptions<E> {
    // (undocumented)
    element?: ElementSelectionSpecifier<E>;
}

// @public (undocumented)
export type SelectionList = '*' | Array<string>;

// @public (undocumented)
export interface SelectOptions<E> extends AbstractSelectOptions<E> {
    // (undocumented)
    connections?: Array<Connection>;
}

// @public (undocumented)
export const SELECTOR_MANAGED_ELEMENT: string;

// @public (undocumented)
export const SOURCE = "source";

// @public (undocumented)
export const SOURCE_INDEX = 0;

// @public
export interface SourceDefinition extends SourceOrTargetDefinition {
}

// @public
export interface SourceOrTargetDefinition {
    // (undocumented)
    def: BehaviouralTypeDescriptor;
    // (undocumented)
    enabled?: boolean;
    // (undocumented)
    endpoint?: Endpoint;
    // (undocumented)
    maxConnections?: number;
    // (undocumented)
    uniqueEndpoint?: boolean;
}

// @public (undocumented)
export const STATIC = "static";

// Warning: (ae-incompatible-release-tags) The symbol "StraightConnector" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
//
// @public (undocumented)
export class StraightConnector extends AbstractConnector {
    // Warning: (ae-incompatible-release-tags) The symbol "_compute" is marked as @public, but its signature references "PaintGeometry" which is marked as @internal
    //
    // (undocumented)
    _compute(paintInfo: PaintGeometry, p: ConnectorComputeParams): void;
    // (undocumented)
    getDefaultStubs(): [number, number];
    // (undocumented)
    transformGeometry(g: StraightConnectorGeometry, dx: number, dy: number): StraightConnectorGeometry;
    // (undocumented)
    static type: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface StraightConnectorGeometry {
    // (undocumented)
    source: AnchorPlacement;
    // (undocumented)
    target: AnchorPlacement;
}

// Warning: (ae-internal-missing-underscore) The name "StraightSegment" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export class StraightSegment extends AbstractSegment {
    constructor(params: StraightSegmentParams);
    boxIntersection(x: number, y: number, w: number, h: number): Array<PointXY>;
    findClosestPointOnPath(x: number, y: number): PointNearPath;
    // (undocumented)
    getGradient(): number;
    // (undocumented)
    getLength(): number;
    // (undocumented)
    getPath(isFirstSegment: boolean): string;
    gradientAtPoint(location: number, absolute?: boolean): number;
    // (undocumented)
    length: number;
    lineIntersection(_x1: number, _y1: number, _x2: number, _y2: number): Array<PointXY>;
    // (undocumented)
    m: number;
    // (undocumented)
    m2: number;
    pointAlongPathFrom(location: number, distance: number, absolute?: boolean): PointXY;
    pointOnPath(location: number, absolute?: boolean): PointXY;
    // (undocumented)
    static segmentType: string;
    // (undocumented)
    type: string;
}

// Warning: (ae-internal-missing-underscore) The name "StraightSegmentCoordinates" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type StraightSegmentCoordinates = {
    x1: number;
    y1: number;
    x2: number;
    y2: number;
};

// Warning: (ae-internal-missing-underscore) The name "StraightSegmentParams" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface StraightSegmentParams extends SegmentParams {
}

// @public (undocumented)
export const TARGET = "target";

// @public (undocumented)
export const TARGET_INDEX = 1;

// @public
export interface TargetDefinition extends SourceOrTargetDefinition {
}

// @public (undocumented)
export const TOP = FaceValues.top;

// Warning: (ae-incompatible-release-tags) The symbol "TranslatedViewportElement" is marked as @public, but its signature references "TranslatedViewportElementBase" which is marked as @internal
//
// @public (undocumented)
export type TranslatedViewportElement<E> = Omit<TranslatedViewportElementBase<E>, "dirty">;

// Warning: (ae-internal-missing-underscore) The name "TranslatedViewportElementBase" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface TranslatedViewportElementBase<E> extends ViewportElementBase<E> {
    // (undocumented)
    cr: number;
    // (undocumented)
    sr: number;
}

// @public
export interface TypeDescriptor extends TypeDescriptorBase {
    overlays?: Array<OverlaySpec>;
}

// @public (undocumented)
export class UIGroup<E = any> extends UINode<E> {
    constructor(instance: JsPlumbInstance, el: E, options: GroupOptions);
    // (undocumented)
    add(_el: E, doNotFireEvent?: boolean): void;
    // (undocumented)
    addGroup(group: UIGroup<E>): boolean;
    // (undocumented)
    anchor: AnchorSpec;
    // (undocumented)
    children: Array<UINode<E>>;
    // (undocumented)
    collapsed: boolean;
    // (undocumented)
    get collapseParent(): UIGroup<E>;
    // (undocumented)
    readonly connections: {
        source: Array<Connection>;
        target: Array<Connection>;
        internal: Array<Connection>;
    };
    // (undocumented)
    constrain: boolean;
    // (undocumented)
    get contentArea(): any;
    // (undocumented)
    dropOverride: boolean;
    // (undocumented)
    droppable: boolean;
    // (undocumented)
    readonly elId: string;
    // (undocumented)
    enabled: boolean;
    // (undocumented)
    endpoint: EndpointSpec;
    // (undocumented)
    getAnchor(conn: Connection, endpointIndex: number): AnchorSpec;
    // (undocumented)
    getEndpoint(conn: Connection, endpointIndex: number): EndpointSpec;
    // (undocumented)
    getGroups(): Array<UIGroup<E>>;
    // (undocumented)
    getNodes(): Array<UINode<E>>;
    // (undocumented)
    ghost: boolean;
    // (undocumented)
    id: string;
    // (undocumented)
    instance: JsPlumbInstance;
    // (undocumented)
    manager: GroupManager<E>;
    // (undocumented)
    orphan: boolean;
    // (undocumented)
    orphanAll(): Record<string, PointXY>;
    // (undocumented)
    overrideDrop(el: any, targetGroup: UIGroup<E>): boolean;
    // (undocumented)
    proxied: boolean;
    // (undocumented)
    prune: boolean;
    // (undocumented)
    remove(el: E, manipulateDOM?: boolean, doNotFireEvent?: boolean, doNotUpdateConnections?: boolean, targetGroup?: UIGroup<E>): void;
    // (undocumented)
    removeAll(manipulateDOM?: boolean, doNotFireEvent?: boolean): void;
    // (undocumented)
    removeGroup(group: UIGroup<E>): void;
    // (undocumented)
    revert: boolean;
}

// @public (undocumented)
export class UINode<E> {
    constructor(instance: JsPlumbInstance, el: E);
    // (undocumented)
    el: E;
    // (undocumented)
    group: UIGroup<E>;
    // (undocumented)
    instance: JsPlumbInstance;
}

// @public
export interface UnmanageElementParams<E = any> {
    // (undocumented)
    el: E;
}

// @public (undocumented)
export function _updateHoverStyle<E>(component: Component): void;

// @public
export interface UpdateOffsetOptions {
    // (undocumented)
    elId?: string;
    // (undocumented)
    recalc?: boolean;
    // (undocumented)
    timestamp?: string;
}

// @public (undocumented)
export type UUID = string;

// @public
export class Viewport<T extends {
    E: unknown;
}> extends EventGenerator {
    constructor(instance: JsPlumbInstance<T>);
    // Warning: (ae-incompatible-release-tags) The symbol "addElement" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    addElement(id: string, x: number, y: number, width: number, height: number, rotation: number): ViewportElement<T["E"]>;
    // (undocumented)
    _bounds: Record<string, number>;
    // Warning: (ae-incompatible-release-tags) The symbol "_elementMap" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    //
    // (undocumented)
    _elementMap: Map<string, ViewportElement<T["E"]>>;
    // (undocumented)
    endTransaction(): void;
    getBoundsHeight(): number;
    getBoundsWidth(): number;
    // Warning: (ae-incompatible-release-tags) The symbol "getElements" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    getElements(): Map<string, ViewportElement<T["E"]>>;
    // (undocumented)
    protected getOffset(el: T["E"]): PointXY;
    // Warning: (ae-incompatible-release-tags) The symbol "getPosition" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    getPosition(id: string): ViewportElement<T["E"]>;
    // (undocumented)
    protected getSize(el: T["E"]): Size;
    getX(): number;
    getY(): number;
    // (undocumented)
    instance: JsPlumbInstance<T>;
    isEmpty(): boolean;
    // (undocumented)
    recomputeBounds(): void;
    // Warning: (ae-incompatible-release-tags) The symbol "refreshElement" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    refreshElement(elId: string, doNotRecalculateBounds?: boolean): ViewportElement<T["E"]>;
    // Warning: (ae-incompatible-release-tags) The symbol "registerElement" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    registerElement(id: string, doNotRecalculateBounds?: boolean): ViewportElement<T["E"]>;
    remove(id: string): void;
    reset(): void;
    // Warning: (ae-incompatible-release-tags) The symbol "rotateElement" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    rotateElement(id: string, rotation: number): ViewportElement<T["E"]>;
    // Warning: (ae-incompatible-release-tags) The symbol "setPosition" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    setPosition(id: string, x: number, y: number): ViewportElement<T["E"]>;
    // Warning: (ae-incompatible-release-tags) The symbol "setSize" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    setSize(id: string, w: number, h: number): ViewportElement<T["E"]>;
    // (undocumented)
    shouldFireEvent(event: string, value: unknown, originalEvent?: Event): boolean;
    // (undocumented)
    _sortedElements: Record<string, Array<[string, number]>>;
    // (undocumented)
    startTransaction(): void;
    // (undocumented)
    _transformedElementMap: Map<string, TranslatedViewportElement<T["E"]>>;
    // Warning: (ae-incompatible-release-tags) The symbol "updateElement" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
    updateElement(id: string, x: number, y: number, width: number, height: number, rotation: number, doNotRecalculateBounds?: boolean): ViewportElement<T["E"]>;
    // (undocumented)
    updateElements(entries: Array<{
        id: string;
        x: number;
        y: number;
        width: number;
        height: number;
        rotation: number;
    }>): void;
}

// Warning: (ae-internal-missing-underscore) The name "ViewportElement" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface ViewportElement<E> extends ViewportElementBase<E> {
    // (undocumented)
    t: TranslatedViewportElement<E>;
}

// Warning: (ae-internal-missing-underscore) The name "ViewportElementBase" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface ViewportElementBase<E> extends ViewportPosition {
    // (undocumented)
    dirty: boolean;
    // (undocumented)
    x2: number;
    // (undocumented)
    y2: number;
}

// @public
export interface ViewportPosition extends PointXY {
    // (undocumented)
    c: PointXY;
    // (undocumented)
    h: number;
    // (undocumented)
    r: number;
    // (undocumented)
    w: number;
}

// @public (undocumented)
export const X_AXIS_FACES: Axis;

// @public (undocumented)
export const Y_AXIS_FACES: Axis;

// Warnings were encountered during analysis:
//
// /Users/simon/programming/jsplumb/jsplumb/dist/core/types/connector/abstract-connector.d.ts:29:5 - (ae-incompatible-release-tags) The symbol "sourceInfo" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
// /Users/simon/programming/jsplumb/jsplumb/dist/core/types/connector/abstract-connector.d.ts:30:5 - (ae-incompatible-release-tags) The symbol "targetInfo" is marked as @public, but its signature references "ViewportElement" which is marked as @internal
// /Users/simon/programming/jsplumb/jsplumb/dist/core/types/connector/connectors.d.ts:5:5 - (ae-incompatible-release-tags) The symbol "get" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
// /Users/simon/programming/jsplumb/jsplumb/dist/core/types/connector/connectors.d.ts:6:5 - (ae-incompatible-release-tags) The symbol "register" is marked as @public, but its signature references "AbstractConnector" which is marked as @internal
// /Users/simon/programming/jsplumb/jsplumb/dist/core/types/core.d.ts:68:5 - (ae-incompatible-release-tags) The symbol "viewportElement" is marked as @public, but its signature references "ViewportElement" which is marked as @internal

```
