/******************************************************************************
 *                       ____    _    _____                                   *
 *                      / ___|  / \  |  ___|    C++                           *
 *                     | |     / _ \ | |_       Actor                         *
 *                     | |___ / ___ \|  _|      Framework                     *
 *                      \____/_/   \_|_|                                      *
 *                                                                            *
 * Copyright (C) 2011 - 2016                                                  *
 * Dominik Charousset <dominik.charousset (at) haw-hamburg.de>                *
 *                                                                            *
 * Distributed under the terms and conditions of the BSD 3-Clause License or  *
 * (at your option) under the terms and conditions of the Boost Software      *
 * License 1.0. See accompanying files LICENSE and LICENSE_ALTERNATIVE.       *
 *                                                                            *
 * If you did not receive a copy of the license files, see                    *
 * http://opensource.org/licenses/BSD-3-Clause and                            *
 * http://www.boost.org/LICENSE_1_0.txt.                                      *
 ******************************************************************************/

#ifndef CAF_MAKE_TYPE_ERASED_VIEW_HPP
#define CAF_MAKE_TYPE_ERASED_VIEW_HPP

#include <functional>

#include "caf/type_erased_value.hpp"

#include "caf/detail/type_erased_value_impl.hpp"

namespace caf {

/// @relates type_erased_value
/// Creates a type-erased view for `x`.
template <class T>
detail::type_erased_value_impl<std::reference_wrapper<T>>
make_type_erased_view(T& x) {
  return {std::ref(x)};
}

} // namespace caf

#endif // CAF_MAKE_TYPE_ERASED_VIEW_HPP
