/******************************************************************************
 *                       ____    _    _____                                   *
 *                      / ___|  / \  |  ___|    C++                           *
 *                     | |     / _ \ | |_       Actor                         *
 *                     | |___ / ___ \|  _|      Framework                     *
 *                      \____/_/   \_|_|                                      *
 *                                                                            *
 * Copyright (C) 2011 - 2017                                                  *
 * Dominik Charousset <dominik.charousset (at) haw-hamburg.de>                *
 *                                                                            *
 * Distributed under the terms and conditions of the BSD 3-Clause License or  *
 * (at your option) under the terms and conditions of the Boost Software      *
 * License 1.0. See accompanying files LICENSE and LICENSE_ALTERNATIVE.       *
 *                                                                            *
 * If you did not receive a copy of the license files, see                    *
 * http://opensource.org/licenses/BSD-3-Clause and                            *
 * http://www.boost.org/LICENSE_1_0.txt.                                      *
 ******************************************************************************/

#ifndef CAF_MESSAGE_VIEW_HPP
#define CAF_MESSAGE_VIEW_HPP

#include "caf/fwd.hpp"

namespace caf {

/// Represents an object pointing to a `type_erased_tuple` that
/// is convertible to a `message`
class message_view {
public:
  virtual ~message_view();

  virtual type_erased_tuple& content() = 0;

  virtual message move_content_to_message() = 0;

  virtual message copy_content_to_message() const = 0;
};

} // namespace caf

#endif // CAF_MESSAGE_VIEW_HPP
