/**
 * vis.js
 * https://github.com/almende/vis
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 4.17.0
 * @date    2016-11-05
 *
 * @license
 * Copyright (C) 2011-2016 Almende B.V, http://almende.com
 *
 * Vis.js is dual licensed under both
 *
 * * The Apache 2.0 License
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * and
 *
 * * The MIT License
 *   http://opensource.org/licenses/MIT
 *
 * Vis.js may be distributed under either license.
 */
"use strict";!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.vis=e():t.vis=e()}(this,function(){return function(t){function e(n){if(i[n])return i[n].exports;var r=i[n]={exports:{},id:n,loaded:!1};return t[n].call(r.exports,r,r.exports,e),r.loaded=!0,r.exports}var i={};return e.m=t,e.c=i,e.p="",e(0)}([function(t,e,i){e.util=i(1),e.DOMutil=i(7),e.DataSet=i(8),e.DataView=i(10),e.Queue=i(9),e.Graph3d=i(11),e.graph3d={Camera:i(15),Filter:i(16),Point2d:i(14),Point3d:i(13),Slider:i(17),StepNumber:i(18)},e.moment=i(2),e.Hammer=i(21),e.keycharm=i(24)},function(t,e,i){var n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},r=i(2),o=i(6);e.isNumber=function(t){return t instanceof Number||"number"==typeof t},e.recursiveDOMDelete=function(t){if(t)for(;t.hasChildNodes()===!0;)e.recursiveDOMDelete(t.firstChild),t.removeChild(t.firstChild)},e.giveRange=function(t,e,i,n){if(e==t)return.5;var r=1/(e-t);return Math.max(0,(n-t)*r)},e.isString=function(t){return t instanceof String||"string"==typeof t},e.isDate=function(t){if(t instanceof Date)return!0;if(e.isString(t)){var i=s.exec(t);if(i)return!0;if(!isNaN(Date.parse(t)))return!0}return!1},e.randomUUID=function(){return o.v4()},e.assignAllKeys=function(t,e){for(var i in t)t.hasOwnProperty(i)&&"object"!==n(t[i])&&(t[i]=e)},e.fillIfDefined=function(t,i){var r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];for(var o in t)void 0!==i[o]&&("object"!==n(i[o])?void 0!==i[o]&&null!==i[o]||void 0===t[o]||r!==!0?t[o]=i[o]:delete t[o]:"object"===n(t[o])&&e.fillIfDefined(t[o],i[o],r))},e.protoExtend=function(t,e){for(var i=1;i<arguments.length;i++){var n=arguments[i];for(var r in n)t[r]=n[r]}return t},e.extend=function(t,e){for(var i=1;i<arguments.length;i++){var n=arguments[i];for(var r in n)n.hasOwnProperty(r)&&(t[r]=n[r])}return t},e.selectiveExtend=function(t,e,i){if(!Array.isArray(t))throw new Error("Array with property names expected as first argument");for(var n=2;n<arguments.length;n++)for(var r=arguments[n],o=0;o<t.length;o++){var s=t[o];r.hasOwnProperty(s)&&(e[s]=r[s])}return e},e.selectiveDeepExtend=function(t,i,n){var r=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(n))throw new TypeError("Arrays are not supported by deepExtend");for(var o=2;o<arguments.length;o++)for(var s=arguments[o],a=0;a<t.length;a++){var h=t[a];if(s.hasOwnProperty(h))if(n[h]&&n[h].constructor===Object)void 0===i[h]&&(i[h]={}),i[h].constructor===Object?e.deepExtend(i[h],n[h],!1,r):null===n[h]&&void 0!==i[h]&&r===!0?delete i[h]:i[h]=n[h];else{if(Array.isArray(n[h]))throw new TypeError("Arrays are not supported by deepExtend");null===n[h]&&void 0!==i[h]&&r===!0?delete i[h]:i[h]=n[h]}}return i},e.selectiveNotDeepExtend=function(t,i,n){var r=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(n))throw new TypeError("Arrays are not supported by deepExtend");for(var o in n)if(n.hasOwnProperty(o)&&t.indexOf(o)==-1)if(n[o]&&n[o].constructor===Object)void 0===i[o]&&(i[o]={}),i[o].constructor===Object?e.deepExtend(i[o],n[o]):null===n[o]&&void 0!==i[o]&&r===!0?delete i[o]:i[o]=n[o];else if(Array.isArray(n[o])){i[o]=[];for(var s=0;s<n[o].length;s++)i[o].push(n[o][s])}else null===n[o]&&void 0!==i[o]&&r===!0?delete i[o]:i[o]=n[o];return i},e.deepExtend=function(t,i,n,r){for(var o in i)if(i.hasOwnProperty(o)||n===!0)if(i[o]&&i[o].constructor===Object)void 0===t[o]&&(t[o]={}),t[o].constructor===Object?e.deepExtend(t[o],i[o],n):null===i[o]&&void 0!==t[o]&&r===!0?delete t[o]:t[o]=i[o];else if(Array.isArray(i[o])){t[o]=[];for(var s=0;s<i[o].length;s++)t[o].push(i[o][s])}else null===i[o]&&void 0!==t[o]&&r===!0?delete t[o]:t[o]=i[o];return t},e.equalArray=function(t,e){if(t.length!=e.length)return!1;for(var i=0,n=t.length;i<n;i++)if(t[i]!=e[i])return!1;return!0},e.convert=function(t,i){var n;if(void 0!==t){if(null===t)return null;if(!i)return t;if("string"!=typeof i&&!(i instanceof String))throw new Error("Type must be a string");switch(i){case"boolean":case"Boolean":return Boolean(t);case"number":case"Number":return isNaN(Date.parse(t))?Number(t.valueOf()):r(t).valueOf();case"string":case"String":return String(t);case"Date":if(e.isNumber(t))return new Date(t);if(t instanceof Date)return new Date(t.valueOf());if(r.isMoment(t))return new Date(t.valueOf());if(e.isString(t))return n=s.exec(t),n?new Date(Number(n[1])):r(new Date(t)).toDate();throw new Error("Cannot convert object of type "+e.getType(t)+" to type Date");case"Moment":if(e.isNumber(t))return r(t);if(t instanceof Date)return r(t.valueOf());if(r.isMoment(t))return r(t);if(e.isString(t))return n=s.exec(t),r(n?Number(n[1]):t);throw new Error("Cannot convert object of type "+e.getType(t)+" to type Date");case"ISODate":if(e.isNumber(t))return new Date(t);if(t instanceof Date)return t.toISOString();if(r.isMoment(t))return t.toDate().toISOString();if(e.isString(t))return n=s.exec(t),n?new Date(Number(n[1])).toISOString():r(t).format();throw new Error("Cannot convert object of type "+e.getType(t)+" to type ISODate");case"ASPDate":if(e.isNumber(t))return"/Date("+t+")/";if(t instanceof Date)return"/Date("+t.valueOf()+")/";if(e.isString(t)){n=s.exec(t);var o;return o=n?new Date(Number(n[1])).valueOf():new Date(t).valueOf(),"/Date("+o+")/"}throw new Error("Cannot convert object of type "+e.getType(t)+" to type ASPDate");default:throw new Error('Unknown type "'+i+'"')}}};var s=/^\/?Date\((\-?\d+)/i;e.getType=function(t){var e="undefined"==typeof t?"undefined":n(t);return"object"==e?null===t?"null":t instanceof Boolean?"Boolean":t instanceof Number?"Number":t instanceof String?"String":Array.isArray(t)?"Array":t instanceof Date?"Date":"Object":"number"==e?"Number":"boolean"==e?"Boolean":"string"==e?"String":void 0===e?"undefined":e},e.copyAndExtendArray=function(t,e){for(var i=[],n=0;n<t.length;n++)i.push(t[n]);return i.push(e),i},e.copyArray=function(t){for(var e=[],i=0;i<t.length;i++)e.push(t[i]);return e},e.getAbsoluteLeft=function(t){return t.getBoundingClientRect().left},e.getAbsoluteRight=function(t){return t.getBoundingClientRect().right},e.getAbsoluteTop=function(t){return t.getBoundingClientRect().top},e.addClassName=function(t,e){var i=t.className.split(" ");i.indexOf(e)==-1&&(i.push(e),t.className=i.join(" "))},e.removeClassName=function(t,e){var i=t.className.split(" "),n=i.indexOf(e);n!=-1&&(i.splice(n,1),t.className=i.join(" "))},e.forEach=function(t,e){var i,n;if(Array.isArray(t))for(i=0,n=t.length;i<n;i++)e(t[i],i,t);else for(i in t)t.hasOwnProperty(i)&&e(t[i],i,t)},e.toArray=function(t){var e=[];for(var i in t)t.hasOwnProperty(i)&&e.push(t[i]);return e},e.updateProperty=function(t,e,i){return t[e]!==i&&(t[e]=i,!0)},e.throttle=function(t){var e=!1;return function(){e||(e=!0,requestAnimationFrame(function(){e=!1,t()}))}},e.addEventListener=function(t,e,i,n){t.addEventListener?(void 0===n&&(n=!1),"mousewheel"===e&&navigator.userAgent.indexOf("Firefox")>=0&&(e="DOMMouseScroll"),t.addEventListener(e,i,n)):t.attachEvent("on"+e,i)},e.removeEventListener=function(t,e,i,n){t.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===e&&navigator.userAgent.indexOf("Firefox")>=0&&(e="DOMMouseScroll"),t.removeEventListener(e,i,n)):t.detachEvent("on"+e,i)},e.preventDefault=function(t){t||(t=window.event),t.preventDefault?t.preventDefault():t.returnValue=!1},e.getTarget=function(t){t||(t=window.event);var e;return t.target?e=t.target:t.srcElement&&(e=t.srcElement),void 0!=e.nodeType&&3==e.nodeType&&(e=e.parentNode),e},e.hasParent=function(t,e){for(var i=t;i;){if(i===e)return!0;i=i.parentNode}return!1},e.option={},e.option.asBoolean=function(t,e){return"function"==typeof t&&(t=t()),null!=t?0!=t:e||null},e.option.asNumber=function(t,e){return"function"==typeof t&&(t=t()),null!=t?Number(t)||e||null:e||null},e.option.asString=function(t,e){return"function"==typeof t&&(t=t()),null!=t?String(t):e||null},e.option.asSize=function(t,i){return"function"==typeof t&&(t=t()),e.isString(t)?t:e.isNumber(t)?t+"px":i||null},e.option.asElement=function(t,e){return"function"==typeof t&&(t=t()),t||e||null},e.hexToRGB=function(t){var e=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;t=t.replace(e,function(t,e,i,n){return e+e+i+i+n+n});var i=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return i?{r:parseInt(i[1],16),g:parseInt(i[2],16),b:parseInt(i[3],16)}:null},e.overrideOpacity=function(t,i){if(t.indexOf("rgba")!=-1)return t;if(t.indexOf("rgb")!=-1){var n=t.substr(t.indexOf("(")+1).replace(")","").split(",");return"rgba("+n[0]+","+n[1]+","+n[2]+","+i+")"}var n=e.hexToRGB(t);return null==n?t:"rgba("+n.r+","+n.g+","+n.b+","+i+")"},e.RGBToHex=function(t,e,i){return"#"+((1<<24)+(t<<16)+(e<<8)+i).toString(16).slice(1)},e.parseColor=function(t){var i;if(e.isString(t)===!0){if(e.isValidRGB(t)===!0){var n=t.substr(4).substr(0,t.length-5).split(",").map(function(t){return parseInt(t)});t=e.RGBToHex(n[0],n[1],n[2])}if(e.isValidHex(t)===!0){var r=e.hexToHSV(t),o={h:r.h,s:.8*r.s,v:Math.min(1,1.02*r.v)},s={h:r.h,s:Math.min(1,1.25*r.s),v:.8*r.v},a=e.HSVToHex(s.h,s.s,s.v),h=e.HSVToHex(o.h,o.s,o.v);i={background:t,border:a,highlight:{background:h,border:a},hover:{background:h,border:a}}}else i={background:t,border:t,highlight:{background:t,border:t},hover:{background:t,border:t}}}else i={},i.background=t.background||void 0,i.border=t.border||void 0,e.isString(t.highlight)?i.highlight={border:t.highlight,background:t.highlight}:(i.highlight={},i.highlight.background=t.highlight&&t.highlight.background||void 0,i.highlight.border=t.highlight&&t.highlight.border||void 0),e.isString(t.hover)?i.hover={border:t.hover,background:t.hover}:(i.hover={},i.hover.background=t.hover&&t.hover.background||void 0,i.hover.border=t.hover&&t.hover.border||void 0);return i},e.RGBToHSV=function(t,e,i){t/=255,e/=255,i/=255;var n=Math.min(t,Math.min(e,i)),r=Math.max(t,Math.max(e,i));if(n==r)return{h:0,s:0,v:n};var o=t==n?e-i:i==n?t-e:i-t,s=t==n?3:i==n?1:5,a=60*(s-o/(r-n))/360,h=(r-n)/r,l=r;return{h:a,s:h,v:l}};var a={split:function(t){var e={};return t.split(";").forEach(function(t){if(""!=t.trim()){var i=t.split(":"),n=i[0].trim(),r=i[1].trim();e[n]=r}}),e},join:function(t){return Object.keys(t).map(function(e){return e+": "+t[e]}).join("; ")}};e.addCssText=function(t,i){var n=a.split(t.style.cssText),r=a.split(i),o=e.extend(n,r);t.style.cssText=a.join(o)},e.removeCssText=function(t,e){var i=a.split(t.style.cssText),n=a.split(e);for(var r in n)n.hasOwnProperty(r)&&delete i[r];t.style.cssText=a.join(i)},e.HSVToRGB=function(t,e,i){var n,r,o,s=Math.floor(6*t),a=6*t-s,h=i*(1-e),l=i*(1-a*e),u=i*(1-(1-a)*e);switch(s%6){case 0:n=i,r=u,o=h;break;case 1:n=l,r=i,o=h;break;case 2:n=h,r=i,o=u;break;case 3:n=h,r=l,o=i;break;case 4:n=u,r=h,o=i;break;case 5:n=i,r=h,o=l}return{r:Math.floor(255*n),g:Math.floor(255*r),b:Math.floor(255*o)}},e.HSVToHex=function(t,i,n){var r=e.HSVToRGB(t,i,n);return e.RGBToHex(r.r,r.g,r.b)},e.hexToHSV=function(t){var i=e.hexToRGB(t);return e.RGBToHSV(i.r,i.g,i.b)},e.isValidHex=function(t){var e=/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t);return e},e.isValidRGB=function(t){t=t.replace(" ","");var e=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/i.test(t);return e},e.isValidRGBA=function(t){t=t.replace(" ","");var e=/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),(.{1,3})\)/i.test(t);return e},e.selectiveBridgeObject=function(t,i){if("object"==("undefined"==typeof i?"undefined":n(i))){for(var r=Object.create(i),o=0;o<t.length;o++)i.hasOwnProperty(t[o])&&"object"==n(i[t[o]])&&(r[t[o]]=e.bridgeObject(i[t[o]]));return r}return null},e.bridgeObject=function(t){if("object"==("undefined"==typeof t?"undefined":n(t))){var i=Object.create(t);for(var r in t)t.hasOwnProperty(r)&&"object"==n(t[r])&&(i[r]=e.bridgeObject(t[r]));return i}return null},e.insertSort=function(t,e){for(var i=0;i<t.length;i++){for(var n=t[i],r=i;r>0&&e(n,t[r-1])<0;r--)t[r]=t[r-1];t[r]=n}return t},e.mergeOptions=function(t,e,i){var n=(arguments.length>3&&void 0!==arguments[3]&&arguments[3],arguments.length>4&&void 0!==arguments[4]?arguments[4]:{});if(null===e[i])t[i]=Object.create(n[i]);else if(void 0!==e[i])if("boolean"==typeof e[i])t[i].enabled=e[i];else{void 0===e[i].enabled&&(t[i].enabled=!0);for(var r in e[i])e[i].hasOwnProperty(r)&&(t[i][r]=e[i][r])}},e.binarySearchCustom=function(t,e,i,n){for(var r=1e4,o=0,s=0,a=t.length-1;s<=a&&o<r;){var h=Math.floor((s+a)/2),l=t[h],u=void 0===n?l[i]:l[i][n],d=e(u);if(0==d)return h;d==-1?s=h+1:a=h-1,o++}return-1},e.binarySearchValue=function(t,e,i,n,r){for(var o,s,a,h,l=1e4,u=0,d=0,c=t.length-1,r=void 0!=r?r:function(t,e){return t==e?0:t<e?-1:1};d<=c&&u<l;){if(h=Math.floor(.5*(c+d)),o=t[Math.max(0,h-1)][i],s=t[h][i],a=t[Math.min(t.length-1,h+1)][i],0==r(s,e))return h;if(r(o,e)<0&&r(s,e)>0)return"before"==n?Math.max(0,h-1):h;if(r(s,e)<0&&r(a,e)>0)return"before"==n?h:Math.min(t.length-1,h+1);r(s,e)<0?d=h+1:c=h-1,u++}return-1},e.easingFunctions={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return t*(2-t)},easeInOutQuad:function(t){return t<.5?2*t*t:-1+(4-2*t)*t},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return 1- --t*t*t*t},easeInOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return 1+--t*t*t*t*t},easeInOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t}},e.getScrollBarWidth=function(){var t=document.createElement("p");t.style.width="100%",t.style.height="200px";var e=document.createElement("div");e.style.position="absolute",e.style.top="0px",e.style.left="0px",e.style.visibility="hidden",e.style.width="200px",e.style.height="150px",e.style.overflow="hidden",e.appendChild(t),document.body.appendChild(e);var i=t.offsetWidth;e.style.overflow="scroll";var n=t.offsetWidth;return i==n&&(n=e.clientWidth),document.body.removeChild(e),i-n}},function(t,e,i){t.exports="undefined"!=typeof window&&window.moment||i(3)},function(t,e,i){(function(t){!function(e,i){t.exports=i()}(this,function(){function e(){return pn.apply(null,arguments)}function i(t){pn=t}function n(t){return t instanceof Array||"[object Array]"===Object.prototype.toString.call(t)}function r(t){return null!=t&&"[object Object]"===Object.prototype.toString.call(t)}function o(t){var e;for(e in t)return!1;return!0}function s(t){return t instanceof Date||"[object Date]"===Object.prototype.toString.call(t)}function a(t,e){var i,n=[];for(i=0;i<t.length;++i)n.push(e(t[i],i));return n}function h(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function l(t,e){for(var i in e)h(e,i)&&(t[i]=e[i]);return h(e,"toString")&&(t.toString=e.toString),h(e,"valueOf")&&(t.valueOf=e.valueOf),t}function u(t,e,i,n){return ye(t,e,i,n,!0).utc()}function d(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null}}function c(t){return null==t._pf&&(t._pf=d()),t._pf}function f(t){if(null==t._isValid){var e=c(t),i=mn.call(e.parsedDateParts,function(t){return null!=t}),n=!isNaN(t._d.getTime())&&e.overflow<0&&!e.empty&&!e.invalidMonth&&!e.invalidWeekday&&!e.nullInput&&!e.invalidFormat&&!e.userInvalidated&&(!e.meridiem||e.meridiem&&i);if(t._strict&&(n=n&&0===e.charsLeftOver&&0===e.unusedTokens.length&&void 0===e.bigHour),null!=Object.isFrozen&&Object.isFrozen(t))return n;t._isValid=n}return t._isValid}function p(t){var e=u(NaN);return null!=t?l(c(e),t):c(e).userInvalidated=!0,e}function m(t){return void 0===t}function v(t,e){var i,n,r;if(m(e._isAMomentObject)||(t._isAMomentObject=e._isAMomentObject),m(e._i)||(t._i=e._i),m(e._f)||(t._f=e._f),m(e._l)||(t._l=e._l),m(e._strict)||(t._strict=e._strict),m(e._tzm)||(t._tzm=e._tzm),m(e._isUTC)||(t._isUTC=e._isUTC),m(e._offset)||(t._offset=e._offset),m(e._pf)||(t._pf=c(e)),m(e._locale)||(t._locale=e._locale),vn.length>0)for(i in vn)n=vn[i],r=e[n],m(r)||(t[n]=r);return t}function y(t){v(this,t),this._d=new Date(null!=t._d?t._d.getTime():NaN),yn===!1&&(yn=!0,e.updateOffset(this),yn=!1)}function g(t){return t instanceof y||null!=t&&null!=t._isAMomentObject}function _(t){return t<0?Math.ceil(t)||0:Math.floor(t)}function w(t){var e=+t,i=0;return 0!==e&&isFinite(e)&&(i=_(e)),i}function x(t,e,i){var n,r=Math.min(t.length,e.length),o=Math.abs(t.length-e.length),s=0;for(n=0;n<r;n++)(i&&t[n]!==e[n]||!i&&w(t[n])!==w(e[n]))&&s++;return s+o}function b(t){e.suppressDeprecationWarnings===!1&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+t)}function S(t,i){var n=!0;return l(function(){if(null!=e.deprecationHandler&&e.deprecationHandler(null,t),n){for(var r,o=[],s=0;s<arguments.length;s++){if(r="","object"==typeof arguments[s]){r+="\n["+s+"] ";for(var a in arguments[0])r+=a+": "+arguments[0][a]+", ";r=r.slice(0,-2)}else r=arguments[s];o.push(r)}b(t+"\nArguments: "+Array.prototype.slice.call(o).join("")+"\n"+(new Error).stack),n=!1}return i.apply(this,arguments)},i)}function T(t,i){null!=e.deprecationHandler&&e.deprecationHandler(t,i),gn[t]||(b(i),gn[t]=!0)}function D(t){return t instanceof Function||"[object Function]"===Object.prototype.toString.call(t)}function k(t){var e,i;for(i in t)e=t[i],D(e)?this[i]=e:this["_"+i]=e;this._config=t,this._ordinalParseLenient=new RegExp(this._ordinalParse.source+"|"+/\d{1,2}/.source)}function M(t,e){var i,n=l({},t);for(i in e)h(e,i)&&(r(t[i])&&r(e[i])?(n[i]={},l(n[i],t[i]),l(n[i],e[i])):null!=e[i]?n[i]=e[i]:delete n[i]);for(i in t)h(t,i)&&!h(e,i)&&r(t[i])&&(n[i]=l({},n[i]));return n}function C(t){null!=t&&this.set(t)}function E(t,e,i){var n=this._calendar[t]||this._calendar.sameElse;return D(n)?n.call(e,i):n}function O(t){var e=this._longDateFormat[t],i=this._longDateFormat[t.toUpperCase()];return e||!i?e:(this._longDateFormat[t]=i.replace(/MMMM|MM|DD|dddd/g,function(t){return t.slice(1)}),this._longDateFormat[t])}function P(){return this._invalidDate}function L(t){return this._ordinal.replace("%d",t)}function R(t,e,i,n){var r=this._relativeTime[i];return D(r)?r(t,e,i,n):r.replace(/%d/i,t)}function Y(t,e){var i=this._relativeTime[t>0?"future":"past"];return D(i)?i(e):i.replace(/%s/i,e)}function A(t,e){var i=t.toLowerCase();Mn[i]=Mn[i+"s"]=Mn[e]=t}function I(t){return"string"==typeof t?Mn[t]||Mn[t.toLowerCase()]:void 0}function W(t){var e,i,n={};for(i in t)h(t,i)&&(e=I(i),e&&(n[e]=t[i]));return n}function z(t,e){Cn[t]=e}function N(t){var e=[];for(var i in t)e.push({unit:i,priority:Cn[i]});return e.sort(function(t,e){return t.priority-e.priority}),e}function F(t,i){return function(n){return null!=n?(j(this,t,n),e.updateOffset(this,i),this):G(this,t)}}function G(t,e){return t.isValid()?t._d["get"+(t._isUTC?"UTC":"")+e]():NaN}function j(t,e,i){t.isValid()&&t._d["set"+(t._isUTC?"UTC":"")+e](i)}function V(t){return t=I(t),D(this[t])?this[t]():this}function B(t,e){if("object"==typeof t){t=W(t);for(var i=N(t),n=0;n<i.length;n++)this[i[n].unit](t[i[n].unit])}else if(t=I(t),D(this[t]))return this[t](e);return this}function U(t,e,i){var n=""+Math.abs(t),r=e-n.length,o=t>=0;return(o?i?"+":"":"-")+Math.pow(10,Math.max(0,r)).toString().substr(1)+n}function H(t,e,i,n){var r=n;"string"==typeof n&&(r=function(){return this[n]()}),t&&(Ln[t]=r),e&&(Ln[e[0]]=function(){return U(r.apply(this,arguments),e[1],e[2])}),i&&(Ln[i]=function(){return this.localeData().ordinal(r.apply(this,arguments),t)})}function X(t){return t.match(/\[[\s\S]/)?t.replace(/^\[|\]$/g,""):t.replace(/\\/g,"")}function Z(t){var e,i,n=t.match(En);for(e=0,i=n.length;e<i;e++)Ln[n[e]]?n[e]=Ln[n[e]]:n[e]=X(n[e]);return function(e){var r,o="";for(r=0;r<i;r++)o+=n[r]instanceof Function?n[r].call(e,t):n[r];return o}}function q(t,e){return t.isValid()?(e=Q(e,t.localeData()),Pn[e]=Pn[e]||Z(e),Pn[e](t)):t.localeData().invalidDate()}function Q(t,e){function i(t){return e.longDateFormat(t)||t}var n=5;for(On.lastIndex=0;n>=0&&On.test(t);)t=t.replace(On,i),On.lastIndex=0,n-=1;return t}function $(t,e,i){Qn[t]=D(e)?e:function(t,n){return t&&i?i:e}}function J(t,e){return h(Qn,t)?Qn[t](e._strict,e._locale):new RegExp(K(t))}function K(t){return tt(t.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(t,e,i,n,r){return e||i||n||r}))}function tt(t){return t.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function et(t,e){var i,n=e;for("string"==typeof t&&(t=[t]),"number"==typeof e&&(n=function(t,i){i[e]=w(t)}),i=0;i<t.length;i++)$n[t[i]]=n}function it(t,e){et(t,function(t,i,n,r){n._w=n._w||{},e(t,n._w,n,r)})}function nt(t,e,i){null!=e&&h($n,t)&&$n[t](e,i._a,i,t)}function rt(t,e){return new Date(Date.UTC(t,e+1,0)).getUTCDate()}function ot(t,e){return t?n(this._months)?this._months[t.month()]:this._months[(this._months.isFormat||ar).test(e)?"format":"standalone"][t.month()]:this._months}function st(t,e){return t?n(this._monthsShort)?this._monthsShort[t.month()]:this._monthsShort[ar.test(e)?"format":"standalone"][t.month()]:this._monthsShort}function at(t,e,i){var n,r,o,s=t.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],n=0;n<12;++n)o=u([2e3,n]),this._shortMonthsParse[n]=this.monthsShort(o,"").toLocaleLowerCase(),this._longMonthsParse[n]=this.months(o,"").toLocaleLowerCase();return i?"MMM"===e?(r=wn.call(this._shortMonthsParse,s),r!==-1?r:null):(r=wn.call(this._longMonthsParse,s),r!==-1?r:null):"MMM"===e?(r=wn.call(this._shortMonthsParse,s),r!==-1?r:(r=wn.call(this._longMonthsParse,s),r!==-1?r:null)):(r=wn.call(this._longMonthsParse,s),r!==-1?r:(r=wn.call(this._shortMonthsParse,s),r!==-1?r:null))}function ht(t,e,i){var n,r,o;if(this._monthsParseExact)return at.call(this,t,e,i);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),n=0;n<12;n++){if(r=u([2e3,n]),i&&!this._longMonthsParse[n]&&(this._longMonthsParse[n]=new RegExp("^"+this.months(r,"").replace(".","")+"$","i"),this._shortMonthsParse[n]=new RegExp("^"+this.monthsShort(r,"").replace(".","")+"$","i")),i||this._monthsParse[n]||(o="^"+this.months(r,"")+"|^"+this.monthsShort(r,""),this._monthsParse[n]=new RegExp(o.replace(".",""),"i")),i&&"MMMM"===e&&this._longMonthsParse[n].test(t))return n;if(i&&"MMM"===e&&this._shortMonthsParse[n].test(t))return n;if(!i&&this._monthsParse[n].test(t))return n}}function lt(t,e){var i;if(!t.isValid())return t;if("string"==typeof e)if(/^\d+$/.test(e))e=w(e);else if(e=t.localeData().monthsParse(e),"number"!=typeof e)return t;return i=Math.min(t.date(),rt(t.year(),e)),t._d["set"+(t._isUTC?"UTC":"")+"Month"](e,i),t}function ut(t){return null!=t?(lt(this,t),e.updateOffset(this,!0),this):G(this,"Month")}function dt(){return rt(this.year(),this.month())}function ct(t){return this._monthsParseExact?(h(this,"_monthsRegex")||pt.call(this),t?this._monthsShortStrictRegex:this._monthsShortRegex):(h(this,"_monthsShortRegex")||(this._monthsShortRegex=ur),this._monthsShortStrictRegex&&t?this._monthsShortStrictRegex:this._monthsShortRegex)}function ft(t){return this._monthsParseExact?(h(this,"_monthsRegex")||pt.call(this),t?this._monthsStrictRegex:this._monthsRegex):(h(this,"_monthsRegex")||(this._monthsRegex=dr),this._monthsStrictRegex&&t?this._monthsStrictRegex:this._monthsRegex)}function pt(){function t(t,e){return e.length-t.length}var e,i,n=[],r=[],o=[];for(e=0;e<12;e++)i=u([2e3,e]),n.push(this.monthsShort(i,"")),r.push(this.months(i,"")),o.push(this.months(i,"")),o.push(this.monthsShort(i,""));for(n.sort(t),r.sort(t),o.sort(t),e=0;e<12;e++)n[e]=tt(n[e]),r[e]=tt(r[e]);for(e=0;e<24;e++)o[e]=tt(o[e]);this._monthsRegex=new RegExp("^("+o.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+r.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+n.join("|")+")","i")}function mt(t){return vt(t)?366:365}function vt(t){return t%4===0&&t%100!==0||t%400===0}function yt(){return vt(this.year())}function gt(t,e,i,n,r,o,s){var a=new Date(t,e,i,n,r,o,s);return t<100&&t>=0&&isFinite(a.getFullYear())&&a.setFullYear(t),a}function _t(t){var e=new Date(Date.UTC.apply(null,arguments));return t<100&&t>=0&&isFinite(e.getUTCFullYear())&&e.setUTCFullYear(t),e}function wt(t,e,i){var n=7+e-i,r=(7+_t(t,0,n).getUTCDay()-e)%7;return-r+n-1}function xt(t,e,i,n,r){var o,s,a=(7+i-n)%7,h=wt(t,n,r),l=1+7*(e-1)+a+h;return l<=0?(o=t-1,s=mt(o)+l):l>mt(t)?(o=t+1,s=l-mt(t)):(o=t,s=l),{year:o,dayOfYear:s}}function bt(t,e,i){var n,r,o=wt(t.year(),e,i),s=Math.floor((t.dayOfYear()-o-1)/7)+1;return s<1?(r=t.year()-1,n=s+St(r,e,i)):s>St(t.year(),e,i)?(n=s-St(t.year(),e,i),r=t.year()+1):(r=t.year(),n=s),{week:n,year:r}}function St(t,e,i){var n=wt(t,e,i),r=wt(t+1,e,i);return(mt(t)-n+r)/7}function Tt(t){return bt(t,this._week.dow,this._week.doy).week}function Dt(){return this._week.dow}function kt(){return this._week.doy}function Mt(t){var e=this.localeData().week(this);return null==t?e:this.add(7*(t-e),"d")}function Ct(t){var e=bt(this,1,4).week;return null==t?e:this.add(7*(t-e),"d")}function Et(t,e){return"string"!=typeof t?t:isNaN(t)?(t=e.weekdaysParse(t),"number"==typeof t?t:null):parseInt(t,10)}function Ot(t,e){return"string"==typeof t?e.weekdaysParse(t)%7||7:isNaN(t)?null:t}function Pt(t,e){return t?n(this._weekdays)?this._weekdays[t.day()]:this._weekdays[this._weekdays.isFormat.test(e)?"format":"standalone"][t.day()]:this._weekdays}function Lt(t){return t?this._weekdaysShort[t.day()]:this._weekdaysShort}function Rt(t){return t?this._weekdaysMin[t.day()]:this._weekdaysMin}function Yt(t,e,i){var n,r,o,s=t.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],n=0;n<7;++n)o=u([2e3,1]).day(n),this._minWeekdaysParse[n]=this.weekdaysMin(o,"").toLocaleLowerCase(),this._shortWeekdaysParse[n]=this.weekdaysShort(o,"").toLocaleLowerCase(),this._weekdaysParse[n]=this.weekdays(o,"").toLocaleLowerCase();return i?"dddd"===e?(r=wn.call(this._weekdaysParse,s),r!==-1?r:null):"ddd"===e?(r=wn.call(this._shortWeekdaysParse,s),r!==-1?r:null):(r=wn.call(this._minWeekdaysParse,s),r!==-1?r:null):"dddd"===e?(r=wn.call(this._weekdaysParse,s),r!==-1?r:(r=wn.call(this._shortWeekdaysParse,s),r!==-1?r:(r=wn.call(this._minWeekdaysParse,s),r!==-1?r:null))):"ddd"===e?(r=wn.call(this._shortWeekdaysParse,s),r!==-1?r:(r=wn.call(this._weekdaysParse,s),r!==-1?r:(r=wn.call(this._minWeekdaysParse,s),r!==-1?r:null))):(r=wn.call(this._minWeekdaysParse,s),r!==-1?r:(r=wn.call(this._weekdaysParse,s),r!==-1?r:(r=wn.call(this._shortWeekdaysParse,s),r!==-1?r:null)))}function At(t,e,i){var n,r,o;if(this._weekdaysParseExact)return Yt.call(this,t,e,i);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),n=0;n<7;n++){if(r=u([2e3,1]).day(n),i&&!this._fullWeekdaysParse[n]&&(this._fullWeekdaysParse[n]=new RegExp("^"+this.weekdays(r,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[n]=new RegExp("^"+this.weekdaysShort(r,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[n]=new RegExp("^"+this.weekdaysMin(r,"").replace(".",".?")+"$","i")),this._weekdaysParse[n]||(o="^"+this.weekdays(r,"")+"|^"+this.weekdaysShort(r,"")+"|^"+this.weekdaysMin(r,""),this._weekdaysParse[n]=new RegExp(o.replace(".",""),"i")),i&&"dddd"===e&&this._fullWeekdaysParse[n].test(t))return n;if(i&&"ddd"===e&&this._shortWeekdaysParse[n].test(t))return n;if(i&&"dd"===e&&this._minWeekdaysParse[n].test(t))return n;if(!i&&this._weekdaysParse[n].test(t))return n}}function It(t){if(!this.isValid())return null!=t?this:NaN;var e=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=t?(t=Et(t,this.localeData()),this.add(t-e,"d")):e}function Wt(t){if(!this.isValid())return null!=t?this:NaN;var e=(this.day()+7-this.localeData()._week.dow)%7;return null==t?e:this.add(t-e,"d")}function zt(t){if(!this.isValid())return null!=t?this:NaN;if(null!=t){var e=Ot(t,this.localeData());return this.day(this.day()%7?e:e-7)}return this.day()||7}function Nt(t){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||jt.call(this),t?this._weekdaysStrictRegex:this._weekdaysRegex):(h(this,"_weekdaysRegex")||(this._weekdaysRegex=yr),this._weekdaysStrictRegex&&t?this._weekdaysStrictRegex:this._weekdaysRegex)}function Ft(t){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||jt.call(this),t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(h(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=gr),this._weekdaysShortStrictRegex&&t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Gt(t){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||jt.call(this),t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(h(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=_r),this._weekdaysMinStrictRegex&&t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function jt(){function t(t,e){return e.length-t.length}var e,i,n,r,o,s=[],a=[],h=[],l=[];for(e=0;e<7;e++)i=u([2e3,1]).day(e),n=this.weekdaysMin(i,""),r=this.weekdaysShort(i,""),o=this.weekdays(i,""),s.push(n),a.push(r),h.push(o),l.push(n),l.push(r),l.push(o);for(s.sort(t),a.sort(t),h.sort(t),l.sort(t),e=0;e<7;e++)a[e]=tt(a[e]),h[e]=tt(h[e]),l[e]=tt(l[e]);this._weekdaysRegex=new RegExp("^("+l.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+s.join("|")+")","i")}function Vt(){return this.hours()%12||12}function Bt(){return this.hours()||24}function Ut(t,e){H(t,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),e)})}function Ht(t,e){return e._meridiemParse}function Xt(t){return"p"===(t+"").toLowerCase().charAt(0)}function Zt(t,e,i){return t>11?i?"pm":"PM":i?"am":"AM"}function qt(t){return t?t.toLowerCase().replace("_","-"):t}function Qt(t){for(var e,i,n,r,o=0;o<t.length;){for(r=qt(t[o]).split("-"),e=r.length,i=qt(t[o+1]),i=i?i.split("-"):null;e>0;){if(n=$t(r.slice(0,e).join("-")))return n;if(i&&i.length>=e&&x(r,i,!0)>=e-1)break;e--}o++}return null}function $t(e){var i=null;if(!Tr[e]&&"undefined"!=typeof t&&t&&t.exports)try{i=wr._abbr,!function(){var t=new Error('Cannot find module "./locale"');throw t.code="MODULE_NOT_FOUND",t}(),Jt(i)}catch(t){}return Tr[e]}function Jt(t,e){var i;return t&&(i=m(e)?ee(t):Kt(t,e),i&&(wr=i)),wr._abbr}function Kt(t,e){if(null!==e){var i=Sr;return e.abbr=t,null!=Tr[t]?(T("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),i=Tr[t]._config):null!=e.parentLocale&&(null!=Tr[e.parentLocale]?i=Tr[e.parentLocale]._config:T("parentLocaleUndefined","specified parentLocale is not defined yet. See http://momentjs.com/guides/#/warnings/parent-locale/")),Tr[t]=new C(M(i,e)),Jt(t),Tr[t]}return delete Tr[t],null}function te(t,e){if(null!=e){var i,n=Sr;null!=Tr[t]&&(n=Tr[t]._config),e=M(n,e),i=new C(e),i.parentLocale=Tr[t],Tr[t]=i,Jt(t)}else null!=Tr[t]&&(null!=Tr[t].parentLocale?Tr[t]=Tr[t].parentLocale:null!=Tr[t]&&delete Tr[t]);return Tr[t]}function ee(t){var e;if(t&&t._locale&&t._locale._abbr&&(t=t._locale._abbr),!t)return wr;if(!n(t)){if(e=$t(t))return e;t=[t]}return Qt(t)}function ie(){return _n(Tr)}function ne(t){var e,i=t._a;return i&&c(t).overflow===-2&&(e=i[Kn]<0||i[Kn]>11?Kn:i[tr]<1||i[tr]>rt(i[Jn],i[Kn])?tr:i[er]<0||i[er]>24||24===i[er]&&(0!==i[ir]||0!==i[nr]||0!==i[rr])?er:i[ir]<0||i[ir]>59?ir:i[nr]<0||i[nr]>59?nr:i[rr]<0||i[rr]>999?rr:-1,c(t)._overflowDayOfYear&&(e<Jn||e>tr)&&(e=tr),c(t)._overflowWeeks&&e===-1&&(e=or),
c(t)._overflowWeekday&&e===-1&&(e=sr),c(t).overflow=e),t}function re(t){var e,i,n,r,o,s,a=t._i,h=Dr.exec(a)||kr.exec(a);if(h){for(c(t).iso=!0,e=0,i=Cr.length;e<i;e++)if(Cr[e][1].exec(h[1])){r=Cr[e][0],n=Cr[e][2]!==!1;break}if(null==r)return void(t._isValid=!1);if(h[3]){for(e=0,i=Er.length;e<i;e++)if(Er[e][1].exec(h[3])){o=(h[2]||" ")+Er[e][0];break}if(null==o)return void(t._isValid=!1)}if(!n&&null!=o)return void(t._isValid=!1);if(h[4]){if(!Mr.exec(h[4]))return void(t._isValid=!1);s="Z"}t._f=r+(o||"")+(s||""),ue(t)}else t._isValid=!1}function oe(t){var i=Or.exec(t._i);return null!==i?void(t._d=new Date(+i[1])):(re(t),void(t._isValid===!1&&(delete t._isValid,e.createFromInputFallback(t))))}function se(t,e,i){return null!=t?t:null!=e?e:i}function ae(t){var i=new Date(e.now());return t._useUTC?[i.getUTCFullYear(),i.getUTCMonth(),i.getUTCDate()]:[i.getFullYear(),i.getMonth(),i.getDate()]}function he(t){var e,i,n,r,o=[];if(!t._d){for(n=ae(t),t._w&&null==t._a[tr]&&null==t._a[Kn]&&le(t),t._dayOfYear&&(r=se(t._a[Jn],n[Jn]),t._dayOfYear>mt(r)&&(c(t)._overflowDayOfYear=!0),i=_t(r,0,t._dayOfYear),t._a[Kn]=i.getUTCMonth(),t._a[tr]=i.getUTCDate()),e=0;e<3&&null==t._a[e];++e)t._a[e]=o[e]=n[e];for(;e<7;e++)t._a[e]=o[e]=null==t._a[e]?2===e?1:0:t._a[e];24===t._a[er]&&0===t._a[ir]&&0===t._a[nr]&&0===t._a[rr]&&(t._nextDay=!0,t._a[er]=0),t._d=(t._useUTC?_t:gt).apply(null,o),null!=t._tzm&&t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),t._nextDay&&(t._a[er]=24)}}function le(t){var e,i,n,r,o,s,a,h;e=t._w,null!=e.GG||null!=e.W||null!=e.E?(o=1,s=4,i=se(e.GG,t._a[Jn],bt(ge(),1,4).year),n=se(e.W,1),r=se(e.E,1),(r<1||r>7)&&(h=!0)):(o=t._locale._week.dow,s=t._locale._week.doy,i=se(e.gg,t._a[Jn],bt(ge(),o,s).year),n=se(e.w,1),null!=e.d?(r=e.d,(r<0||r>6)&&(h=!0)):null!=e.e?(r=e.e+o,(e.e<0||e.e>6)&&(h=!0)):r=o),n<1||n>St(i,o,s)?c(t)._overflowWeeks=!0:null!=h?c(t)._overflowWeekday=!0:(a=xt(i,n,r,o,s),t._a[Jn]=a.year,t._dayOfYear=a.dayOfYear)}function ue(t){if(t._f===e.ISO_8601)return void re(t);t._a=[],c(t).empty=!0;var i,n,r,o,s,a=""+t._i,h=a.length,l=0;for(r=Q(t._f,t._locale).match(En)||[],i=0;i<r.length;i++)o=r[i],n=(a.match(J(o,t))||[])[0],n&&(s=a.substr(0,a.indexOf(n)),s.length>0&&c(t).unusedInput.push(s),a=a.slice(a.indexOf(n)+n.length),l+=n.length),Ln[o]?(n?c(t).empty=!1:c(t).unusedTokens.push(o),nt(o,n,t)):t._strict&&!n&&c(t).unusedTokens.push(o);c(t).charsLeftOver=h-l,a.length>0&&c(t).unusedInput.push(a),t._a[er]<=12&&c(t).bigHour===!0&&t._a[er]>0&&(c(t).bigHour=void 0),c(t).parsedDateParts=t._a.slice(0),c(t).meridiem=t._meridiem,t._a[er]=de(t._locale,t._a[er],t._meridiem),he(t),ne(t)}function de(t,e,i){var n;return null==i?e:null!=t.meridiemHour?t.meridiemHour(e,i):null!=t.isPM?(n=t.isPM(i),n&&e<12&&(e+=12),n||12!==e||(e=0),e):e}function ce(t){var e,i,n,r,o;if(0===t._f.length)return c(t).invalidFormat=!0,void(t._d=new Date(NaN));for(r=0;r<t._f.length;r++)o=0,e=v({},t),null!=t._useUTC&&(e._useUTC=t._useUTC),e._f=t._f[r],ue(e),f(e)&&(o+=c(e).charsLeftOver,o+=10*c(e).unusedTokens.length,c(e).score=o,(null==n||o<n)&&(n=o,i=e));l(t,i||e)}function fe(t){if(!t._d){var e=W(t._i);t._a=a([e.year,e.month,e.day||e.date,e.hour,e.minute,e.second,e.millisecond],function(t){return t&&parseInt(t,10)}),he(t)}}function pe(t){var e=new y(ne(me(t)));return e._nextDay&&(e.add(1,"d"),e._nextDay=void 0),e}function me(t){var e=t._i,i=t._f;return t._locale=t._locale||ee(t._l),null===e||void 0===i&&""===e?p({nullInput:!0}):("string"==typeof e&&(t._i=e=t._locale.preparse(e)),g(e)?new y(ne(e)):(n(i)?ce(t):s(e)?t._d=e:i?ue(t):ve(t),f(t)||(t._d=null),t))}function ve(t){var i=t._i;void 0===i?t._d=new Date(e.now()):s(i)?t._d=new Date(i.valueOf()):"string"==typeof i?oe(t):n(i)?(t._a=a(i.slice(0),function(t){return parseInt(t,10)}),he(t)):"object"==typeof i?fe(t):"number"==typeof i?t._d=new Date(i):e.createFromInputFallback(t)}function ye(t,e,i,s,a){var h={};return"boolean"==typeof i&&(s=i,i=void 0),(r(t)&&o(t)||n(t)&&0===t.length)&&(t=void 0),h._isAMomentObject=!0,h._useUTC=h._isUTC=a,h._l=i,h._i=t,h._f=e,h._strict=s,pe(h)}function ge(t,e,i,n){return ye(t,e,i,n,!1)}function _e(t,e){var i,r;if(1===e.length&&n(e[0])&&(e=e[0]),!e.length)return ge();for(i=e[0],r=1;r<e.length;++r)e[r].isValid()&&!e[r][t](i)||(i=e[r]);return i}function we(){var t=[].slice.call(arguments,0);return _e("isBefore",t)}function xe(){var t=[].slice.call(arguments,0);return _e("isAfter",t)}function be(t){var e=W(t),i=e.year||0,n=e.quarter||0,r=e.month||0,o=e.week||0,s=e.day||0,a=e.hour||0,h=e.minute||0,l=e.second||0,u=e.millisecond||0;this._milliseconds=+u+1e3*l+6e4*h+1e3*a*60*60,this._days=+s+7*o,this._months=+r+3*n+12*i,this._data={},this._locale=ee(),this._bubble()}function Se(t){return t instanceof be}function Te(t){return t<0?Math.round(-1*t)*-1:Math.round(t)}function De(t,e){H(t,0,0,function(){var t=this.utcOffset(),i="+";return t<0&&(t=-t,i="-"),i+U(~~(t/60),2)+e+U(~~t%60,2)})}function ke(t,e){var i=(e||"").match(t)||[],n=i[i.length-1]||[],r=(n+"").match(Yr)||["-",0,0],o=+(60*r[1])+w(r[2]);return"+"===r[0]?o:-o}function Me(t,i){var n,r;return i._isUTC?(n=i.clone(),r=(g(t)||s(t)?t.valueOf():ge(t).valueOf())-n.valueOf(),n._d.setTime(n._d.valueOf()+r),e.updateOffset(n,!1),n):ge(t).local()}function Ce(t){return 15*-Math.round(t._d.getTimezoneOffset()/15)}function Ee(t,i){var n,r=this._offset||0;return this.isValid()?null!=t?("string"==typeof t?t=ke(Xn,t):Math.abs(t)<16&&(t*=60),!this._isUTC&&i&&(n=Ce(this)),this._offset=t,this._isUTC=!0,null!=n&&this.add(n,"m"),r!==t&&(!i||this._changeInProgress?Ue(this,Fe(t-r,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,e.updateOffset(this,!0),this._changeInProgress=null)),this):this._isUTC?r:Ce(this):null!=t?this:NaN}function Oe(t,e){return null!=t?("string"!=typeof t&&(t=-t),this.utcOffset(t,e),this):-this.utcOffset()}function Pe(t){return this.utcOffset(0,t)}function Le(t){return this._isUTC&&(this.utcOffset(0,t),this._isUTC=!1,t&&this.subtract(Ce(this),"m")),this}function Re(){if(this._tzm)this.utcOffset(this._tzm);else if("string"==typeof this._i){var t=ke(Hn,this._i);0===t?this.utcOffset(0,!0):this.utcOffset(ke(Hn,this._i))}return this}function Ye(t){return!!this.isValid()&&(t=t?ge(t).utcOffset():0,(this.utcOffset()-t)%60===0)}function Ae(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Ie(){if(!m(this._isDSTShifted))return this._isDSTShifted;var t={};if(v(t,this),t=me(t),t._a){var e=t._isUTC?u(t._a):ge(t._a);this._isDSTShifted=this.isValid()&&x(t._a,e.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function We(){return!!this.isValid()&&!this._isUTC}function ze(){return!!this.isValid()&&this._isUTC}function Ne(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}function Fe(t,e){var i,n,r,o=t,s=null;return Se(t)?o={ms:t._milliseconds,d:t._days,M:t._months}:"number"==typeof t?(o={},e?o[e]=t:o.milliseconds=t):(s=Ar.exec(t))?(i="-"===s[1]?-1:1,o={y:0,d:w(s[tr])*i,h:w(s[er])*i,m:w(s[ir])*i,s:w(s[nr])*i,ms:w(Te(1e3*s[rr]))*i}):(s=Ir.exec(t))?(i="-"===s[1]?-1:1,o={y:Ge(s[2],i),M:Ge(s[3],i),w:Ge(s[4],i),d:Ge(s[5],i),h:Ge(s[6],i),m:Ge(s[7],i),s:Ge(s[8],i)}):null==o?o={}:"object"==typeof o&&("from"in o||"to"in o)&&(r=Ve(ge(o.from),ge(o.to)),o={},o.ms=r.milliseconds,o.M=r.months),n=new be(o),Se(t)&&h(t,"_locale")&&(n._locale=t._locale),n}function Ge(t,e){var i=t&&parseFloat(t.replace(",","."));return(isNaN(i)?0:i)*e}function je(t,e){var i={milliseconds:0,months:0};return i.months=e.month()-t.month()+12*(e.year()-t.year()),t.clone().add(i.months,"M").isAfter(e)&&--i.months,i.milliseconds=+e-+t.clone().add(i.months,"M"),i}function Ve(t,e){var i;return t.isValid()&&e.isValid()?(e=Me(e,t),t.isBefore(e)?i=je(t,e):(i=je(e,t),i.milliseconds=-i.milliseconds,i.months=-i.months),i):{milliseconds:0,months:0}}function Be(t,e){return function(i,n){var r,o;return null===n||isNaN(+n)||(T(e,"moment()."+e+"(period, number) is deprecated. Please use moment()."+e+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),o=i,i=n,n=o),i="string"==typeof i?+i:i,r=Fe(i,n),Ue(this,r,t),this}}function Ue(t,i,n,r){var o=i._milliseconds,s=Te(i._days),a=Te(i._months);t.isValid()&&(r=null==r||r,o&&t._d.setTime(t._d.valueOf()+o*n),s&&j(t,"Date",G(t,"Date")+s*n),a&&lt(t,G(t,"Month")+a*n),r&&e.updateOffset(t,s||a))}function He(t,e){var i=t.diff(e,"days",!0);return i<-6?"sameElse":i<-1?"lastWeek":i<0?"lastDay":i<1?"sameDay":i<2?"nextDay":i<7?"nextWeek":"sameElse"}function Xe(t,i){var n=t||ge(),r=Me(n,this).startOf("day"),o=e.calendarFormat(this,r)||"sameElse",s=i&&(D(i[o])?i[o].call(this,n):i[o]);return this.format(s||this.localeData().calendar(o,this,ge(n)))}function Ze(){return new y(this)}function qe(t,e){var i=g(t)?t:ge(t);return!(!this.isValid()||!i.isValid())&&(e=I(m(e)?"millisecond":e),"millisecond"===e?this.valueOf()>i.valueOf():i.valueOf()<this.clone().startOf(e).valueOf())}function Qe(t,e){var i=g(t)?t:ge(t);return!(!this.isValid()||!i.isValid())&&(e=I(m(e)?"millisecond":e),"millisecond"===e?this.valueOf()<i.valueOf():this.clone().endOf(e).valueOf()<i.valueOf())}function $e(t,e,i,n){return n=n||"()",("("===n[0]?this.isAfter(t,i):!this.isBefore(t,i))&&(")"===n[1]?this.isBefore(e,i):!this.isAfter(e,i))}function Je(t,e){var i,n=g(t)?t:ge(t);return!(!this.isValid()||!n.isValid())&&(e=I(e||"millisecond"),"millisecond"===e?this.valueOf()===n.valueOf():(i=n.valueOf(),this.clone().startOf(e).valueOf()<=i&&i<=this.clone().endOf(e).valueOf()))}function Ke(t,e){return this.isSame(t,e)||this.isAfter(t,e)}function ti(t,e){return this.isSame(t,e)||this.isBefore(t,e)}function ei(t,e,i){var n,r,o,s;return this.isValid()?(n=Me(t,this),n.isValid()?(r=6e4*(n.utcOffset()-this.utcOffset()),e=I(e),"year"===e||"month"===e||"quarter"===e?(s=ii(this,n),"quarter"===e?s/=3:"year"===e&&(s/=12)):(o=this-n,s="second"===e?o/1e3:"minute"===e?o/6e4:"hour"===e?o/36e5:"day"===e?(o-r)/864e5:"week"===e?(o-r)/6048e5:o),i?s:_(s)):NaN):NaN}function ii(t,e){var i,n,r=12*(e.year()-t.year())+(e.month()-t.month()),o=t.clone().add(r,"months");return e-o<0?(i=t.clone().add(r-1,"months"),n=(e-o)/(o-i)):(i=t.clone().add(r+1,"months"),n=(e-o)/(i-o)),-(r+n)||0}function ni(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function ri(){var t=this.clone().utc();return 0<t.year()&&t.year()<=9999?D(Date.prototype.toISOString)?this.toDate().toISOString():q(t,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):q(t,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function oi(t){t||(t=this.isUtc()?e.defaultFormatUtc:e.defaultFormat);var i=q(this,t);return this.localeData().postformat(i)}function si(t,e){return this.isValid()&&(g(t)&&t.isValid()||ge(t).isValid())?Fe({to:this,from:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function ai(t){return this.from(ge(),t)}function hi(t,e){return this.isValid()&&(g(t)&&t.isValid()||ge(t).isValid())?Fe({from:this,to:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function li(t){return this.to(ge(),t)}function ui(t){var e;return void 0===t?this._locale._abbr:(e=ee(t),null!=e&&(this._locale=e),this)}function di(){return this._locale}function ci(t){switch(t=I(t)){case"year":this.month(0);case"quarter":case"month":this.date(1);case"week":case"isoWeek":case"day":case"date":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}return"week"===t&&this.weekday(0),"isoWeek"===t&&this.isoWeekday(1),"quarter"===t&&this.month(3*Math.floor(this.month()/3)),this}function fi(t){return t=I(t),void 0===t||"millisecond"===t?this:("date"===t&&(t="day"),this.startOf(t).add(1,"isoWeek"===t?"week":t).subtract(1,"ms"))}function pi(){return this._d.valueOf()-6e4*(this._offset||0)}function mi(){return Math.floor(this.valueOf()/1e3)}function vi(){return new Date(this.valueOf())}function yi(){var t=this;return[t.year(),t.month(),t.date(),t.hour(),t.minute(),t.second(),t.millisecond()]}function gi(){var t=this;return{years:t.year(),months:t.month(),date:t.date(),hours:t.hours(),minutes:t.minutes(),seconds:t.seconds(),milliseconds:t.milliseconds()}}function _i(){return this.isValid()?this.toISOString():null}function wi(){return f(this)}function xi(){return l({},c(this))}function bi(){return c(this).overflow}function Si(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function Ti(t,e){H(0,[t,t.length],0,e)}function Di(t){return Ei.call(this,t,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function ki(t){return Ei.call(this,t,this.isoWeek(),this.isoWeekday(),1,4)}function Mi(){return St(this.year(),1,4)}function Ci(){var t=this.localeData()._week;return St(this.year(),t.dow,t.doy)}function Ei(t,e,i,n,r){var o;return null==t?bt(this,n,r).year:(o=St(t,n,r),e>o&&(e=o),Oi.call(this,t,e,i,n,r))}function Oi(t,e,i,n,r){var o=xt(t,e,i,n,r),s=_t(o.year,0,o.dayOfYear);return this.year(s.getUTCFullYear()),this.month(s.getUTCMonth()),this.date(s.getUTCDate()),this}function Pi(t){return null==t?Math.ceil((this.month()+1)/3):this.month(3*(t-1)+this.month()%3)}function Li(t){var e=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==t?e:this.add(t-e,"d")}function Ri(t,e){e[rr]=w(1e3*("0."+t))}function Yi(){return this._isUTC?"UTC":""}function Ai(){return this._isUTC?"Coordinated Universal Time":""}function Ii(t){return ge(1e3*t)}function Wi(){return ge.apply(null,arguments).parseZone()}function zi(t){return t}function Ni(t,e,i,n){var r=ee(),o=u().set(n,e);return r[i](o,t)}function Fi(t,e,i){if("number"==typeof t&&(e=t,t=void 0),t=t||"",null!=e)return Ni(t,e,i,"month");var n,r=[];for(n=0;n<12;n++)r[n]=Ni(t,n,i,"month");return r}function Gi(t,e,i,n){"boolean"==typeof t?("number"==typeof e&&(i=e,e=void 0),e=e||""):(e=t,i=e,t=!1,"number"==typeof e&&(i=e,e=void 0),e=e||"");var r=ee(),o=t?r._week.dow:0;if(null!=i)return Ni(e,(i+o)%7,n,"day");var s,a=[];for(s=0;s<7;s++)a[s]=Ni(e,(s+o)%7,n,"day");return a}function ji(t,e){return Fi(t,e,"months")}function Vi(t,e){return Fi(t,e,"monthsShort")}function Bi(t,e,i){return Gi(t,e,i,"weekdays")}function Ui(t,e,i){return Gi(t,e,i,"weekdaysShort")}function Hi(t,e,i){return Gi(t,e,i,"weekdaysMin")}function Xi(){var t=this._data;return this._milliseconds=Zr(this._milliseconds),this._days=Zr(this._days),this._months=Zr(this._months),t.milliseconds=Zr(t.milliseconds),t.seconds=Zr(t.seconds),t.minutes=Zr(t.minutes),t.hours=Zr(t.hours),t.months=Zr(t.months),t.years=Zr(t.years),this}function Zi(t,e,i,n){var r=Fe(e,i);return t._milliseconds+=n*r._milliseconds,t._days+=n*r._days,t._months+=n*r._months,t._bubble()}function qi(t,e){return Zi(this,t,e,1)}function Qi(t,e){return Zi(this,t,e,-1)}function $i(t){return t<0?Math.floor(t):Math.ceil(t)}function Ji(){var t,e,i,n,r,o=this._milliseconds,s=this._days,a=this._months,h=this._data;return o>=0&&s>=0&&a>=0||o<=0&&s<=0&&a<=0||(o+=864e5*$i(tn(a)+s),s=0,a=0),h.milliseconds=o%1e3,t=_(o/1e3),h.seconds=t%60,e=_(t/60),h.minutes=e%60,i=_(e/60),h.hours=i%24,s+=_(i/24),r=_(Ki(s)),a+=r,s-=$i(tn(r)),n=_(a/12),a%=12,h.days=s,h.months=a,h.years=n,this}function Ki(t){return 4800*t/146097}function tn(t){return 146097*t/4800}function en(t){var e,i,n=this._milliseconds;if(t=I(t),"month"===t||"year"===t)return e=this._days+n/864e5,i=this._months+Ki(e),"month"===t?i:i/12;switch(e=this._days+Math.round(tn(this._months)),t){case"week":return e/7+n/6048e5;case"day":return e+n/864e5;case"hour":return 24*e+n/36e5;case"minute":return 1440*e+n/6e4;case"second":return 86400*e+n/1e3;case"millisecond":return Math.floor(864e5*e)+n;default:throw new Error("Unknown unit "+t)}}function nn(){return this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*w(this._months/12)}function rn(t){return function(){return this.as(t)}}function on(t){return t=I(t),this[t+"s"]()}function sn(t){return function(){return this._data[t]}}function an(){return _(this.days()/7)}function hn(t,e,i,n,r){return r.relativeTime(e||1,!!i,t,n)}function ln(t,e,i){var n=Fe(t).abs(),r=uo(n.as("s")),o=uo(n.as("m")),s=uo(n.as("h")),a=uo(n.as("d")),h=uo(n.as("M")),l=uo(n.as("y")),u=r<co.s&&["s",r]||o<=1&&["m"]||o<co.m&&["mm",o]||s<=1&&["h"]||s<co.h&&["hh",s]||a<=1&&["d"]||a<co.d&&["dd",a]||h<=1&&["M"]||h<co.M&&["MM",h]||l<=1&&["y"]||["yy",l];return u[2]=e,u[3]=+t>0,u[4]=i,hn.apply(null,u)}function un(t){return void 0===t?uo:"function"==typeof t&&(uo=t,!0)}function dn(t,e){return void 0!==co[t]&&(void 0===e?co[t]:(co[t]=e,!0))}function cn(t){var e=this.localeData(),i=ln(this,!t,e);return t&&(i=e.pastFuture(+this,i)),e.postformat(i)}function fn(){var t,e,i,n=fo(this._milliseconds)/1e3,r=fo(this._days),o=fo(this._months);t=_(n/60),e=_(t/60),n%=60,t%=60,i=_(o/12),o%=12;var s=i,a=o,h=r,l=e,u=t,d=n,c=this.asSeconds();return c?(c<0?"-":"")+"P"+(s?s+"Y":"")+(a?a+"M":"")+(h?h+"D":"")+(l||u||d?"T":"")+(l?l+"H":"")+(u?u+"M":"")+(d?d+"S":""):"P0D"}var pn,mn;mn=Array.prototype.some?Array.prototype.some:function(t){for(var e=Object(this),i=e.length>>>0,n=0;n<i;n++)if(n in e&&t.call(this,e[n],n,e))return!0;return!1};var vn=e.momentProperties=[],yn=!1,gn={};e.suppressDeprecationWarnings=!1,e.deprecationHandler=null;var _n;_n=Object.keys?Object.keys:function(t){var e,i=[];for(e in t)h(t,e)&&i.push(e);return i};var wn,xn={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},bn={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},Sn="Invalid date",Tn="%d",Dn=/\d{1,2}/,kn={future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},Mn={},Cn={},En=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,On=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,Pn={},Ln={},Rn=/\d/,Yn=/\d\d/,An=/\d{3}/,In=/\d{4}/,Wn=/[+-]?\d{6}/,zn=/\d\d?/,Nn=/\d\d\d\d?/,Fn=/\d\d\d\d\d\d?/,Gn=/\d{1,3}/,jn=/\d{1,4}/,Vn=/[+-]?\d{1,6}/,Bn=/\d+/,Un=/[+-]?\d+/,Hn=/Z|[+-]\d\d:?\d\d/gi,Xn=/Z|[+-]\d\d(?::?\d\d)?/gi,Zn=/[+-]?\d+(\.\d{1,3})?/,qn=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,Qn={},$n={},Jn=0,Kn=1,tr=2,er=3,ir=4,nr=5,rr=6,or=7,sr=8;wn=Array.prototype.indexOf?Array.prototype.indexOf:function(t){var e;for(e=0;e<this.length;++e)if(this[e]===t)return e;return-1},H("M",["MM",2],"Mo",function(){return this.month()+1}),H("MMM",0,0,function(t){return this.localeData().monthsShort(this,t)}),H("MMMM",0,0,function(t){return this.localeData().months(this,t)}),A("month","M"),z("month",8),$("M",zn),$("MM",zn,Yn),$("MMM",function(t,e){return e.monthsShortRegex(t)}),$("MMMM",function(t,e){return e.monthsRegex(t)}),et(["M","MM"],function(t,e){e[Kn]=w(t)-1}),et(["MMM","MMMM"],function(t,e,i,n){var r=i._locale.monthsParse(t,n,i._strict);null!=r?e[Kn]=r:c(i).invalidMonth=t});var ar=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,hr="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),lr="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),ur=qn,dr=qn;H("Y",0,0,function(){var t=this.year();return t<=9999?""+t:"+"+t}),H(0,["YY",2],0,function(){return this.year()%100}),H(0,["YYYY",4],0,"year"),H(0,["YYYYY",5],0,"year"),H(0,["YYYYYY",6,!0],0,"year"),A("year","y"),z("year",1),$("Y",Un),$("YY",zn,Yn),$("YYYY",jn,In),$("YYYYY",Vn,Wn),$("YYYYYY",Vn,Wn),et(["YYYYY","YYYYYY"],Jn),et("YYYY",function(t,i){i[Jn]=2===t.length?e.parseTwoDigitYear(t):w(t)}),et("YY",function(t,i){i[Jn]=e.parseTwoDigitYear(t)}),et("Y",function(t,e){e[Jn]=parseInt(t,10)}),e.parseTwoDigitYear=function(t){return w(t)+(w(t)>68?1900:2e3)};var cr=F("FullYear",!0);H("w",["ww",2],"wo","week"),H("W",["WW",2],"Wo","isoWeek"),A("week","w"),A("isoWeek","W"),z("week",5),z("isoWeek",5),$("w",zn),$("ww",zn,Yn),$("W",zn),$("WW",zn,Yn),it(["w","ww","W","WW"],function(t,e,i,n){e[n.substr(0,1)]=w(t)});var fr={dow:0,doy:6};H("d",0,"do","day"),H("dd",0,0,function(t){return this.localeData().weekdaysMin(this,t)}),H("ddd",0,0,function(t){return this.localeData().weekdaysShort(this,t)}),H("dddd",0,0,function(t){return this.localeData().weekdays(this,t)}),H("e",0,0,"weekday"),H("E",0,0,"isoWeekday"),A("day","d"),A("weekday","e"),A("isoWeekday","E"),z("day",11),z("weekday",11),z("isoWeekday",11),$("d",zn),$("e",zn),$("E",zn),$("dd",function(t,e){return e.weekdaysMinRegex(t)}),$("ddd",function(t,e){return e.weekdaysShortRegex(t)}),$("dddd",function(t,e){return e.weekdaysRegex(t)}),it(["dd","ddd","dddd"],function(t,e,i,n){var r=i._locale.weekdaysParse(t,n,i._strict);null!=r?e.d=r:c(i).invalidWeekday=t}),it(["d","e","E"],function(t,e,i,n){e[n]=w(t)});var pr="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),mr="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),vr="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),yr=qn,gr=qn,_r=qn;H("H",["HH",2],0,"hour"),H("h",["hh",2],0,Vt),H("k",["kk",2],0,Bt),H("hmm",0,0,function(){return""+Vt.apply(this)+U(this.minutes(),2)}),H("hmmss",0,0,function(){return""+Vt.apply(this)+U(this.minutes(),2)+U(this.seconds(),2)}),H("Hmm",0,0,function(){return""+this.hours()+U(this.minutes(),2)}),H("Hmmss",0,0,function(){return""+this.hours()+U(this.minutes(),2)+U(this.seconds(),2)}),Ut("a",!0),Ut("A",!1),A("hour","h"),z("hour",13),$("a",Ht),$("A",Ht),$("H",zn),$("h",zn),$("HH",zn,Yn),$("hh",zn,Yn),$("hmm",Nn),$("hmmss",Fn),$("Hmm",Nn),$("Hmmss",Fn),et(["H","HH"],er),et(["a","A"],function(t,e,i){i._isPm=i._locale.isPM(t),i._meridiem=t}),et(["h","hh"],function(t,e,i){e[er]=w(t),c(i).bigHour=!0}),et("hmm",function(t,e,i){var n=t.length-2;e[er]=w(t.substr(0,n)),e[ir]=w(t.substr(n)),c(i).bigHour=!0}),et("hmmss",function(t,e,i){var n=t.length-4,r=t.length-2;e[er]=w(t.substr(0,n)),e[ir]=w(t.substr(n,2)),e[nr]=w(t.substr(r)),c(i).bigHour=!0}),et("Hmm",function(t,e,i){var n=t.length-2;e[er]=w(t.substr(0,n)),e[ir]=w(t.substr(n))}),et("Hmmss",function(t,e,i){var n=t.length-4,r=t.length-2;e[er]=w(t.substr(0,n)),e[ir]=w(t.substr(n,2)),e[nr]=w(t.substr(r))});var wr,xr=/[ap]\.?m?\.?/i,br=F("Hours",!0),Sr={calendar:xn,longDateFormat:bn,invalidDate:Sn,ordinal:Tn,ordinalParse:Dn,relativeTime:kn,months:hr,monthsShort:lr,week:fr,weekdays:pr,weekdaysMin:vr,weekdaysShort:mr,meridiemParse:xr},Tr={},Dr=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,kr=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,Mr=/Z|[+-]\d\d(?::?\d\d)?/,Cr=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],Er=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Or=/^\/?Date\((\-?\d+)/i;e.createFromInputFallback=S("value provided is not in a recognized ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(t){t._d=new Date(t._i+(t._useUTC?" UTC":""))}),e.ISO_8601=function(){};var Pr=S("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=ge.apply(null,arguments);return this.isValid()&&t.isValid()?t<this?this:t:p()}),Lr=S("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=ge.apply(null,arguments);return this.isValid()&&t.isValid()?t>this?this:t:p()}),Rr=function(){return Date.now?Date.now():+new Date};De("Z",":"),De("ZZ",""),$("Z",Xn),$("ZZ",Xn),et(["Z","ZZ"],function(t,e,i){i._useUTC=!0,i._tzm=ke(Xn,t)});var Yr=/([\+\-]|\d\d)/gi;e.updateOffset=function(){};var Ar=/^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,Ir=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;Fe.fn=be.prototype;var Wr=Be(1,"add"),zr=Be(-1,"subtract");e.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",e.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var Nr=S("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(t){return void 0===t?this.localeData():this.locale(t)});H(0,["gg",2],0,function(){return this.weekYear()%100}),H(0,["GG",2],0,function(){return this.isoWeekYear()%100}),Ti("gggg","weekYear"),Ti("ggggg","weekYear"),Ti("GGGG","isoWeekYear"),Ti("GGGGG","isoWeekYear"),A("weekYear","gg"),A("isoWeekYear","GG"),z("weekYear",1),z("isoWeekYear",1),$("G",Un),$("g",Un),$("GG",zn,Yn),$("gg",zn,Yn),$("GGGG",jn,In),$("gggg",jn,In),$("GGGGG",Vn,Wn),$("ggggg",Vn,Wn),it(["gggg","ggggg","GGGG","GGGGG"],function(t,e,i,n){e[n.substr(0,2)]=w(t)}),it(["gg","GG"],function(t,i,n,r){i[r]=e.parseTwoDigitYear(t)}),H("Q",0,"Qo","quarter"),A("quarter","Q"),z("quarter",7),$("Q",Rn),et("Q",function(t,e){e[Kn]=3*(w(t)-1)}),H("D",["DD",2],"Do","date"),A("date","D"),z("date",9),$("D",zn),$("DD",zn,Yn),$("Do",function(t,e){return t?e._ordinalParse:e._ordinalParseLenient}),et(["D","DD"],tr),et("Do",function(t,e){e[tr]=w(t.match(zn)[0],10)});var Fr=F("Date",!0);H("DDD",["DDDD",3],"DDDo","dayOfYear"),A("dayOfYear","DDD"),z("dayOfYear",4),$("DDD",Gn),$("DDDD",An),et(["DDD","DDDD"],function(t,e,i){i._dayOfYear=w(t)}),H("m",["mm",2],0,"minute"),A("minute","m"),z("minute",14),$("m",zn),$("mm",zn,Yn),et(["m","mm"],ir);var Gr=F("Minutes",!1);H("s",["ss",2],0,"second"),A("second","s"),z("second",15),$("s",zn),$("ss",zn,Yn),et(["s","ss"],nr);var jr=F("Seconds",!1);H("S",0,0,function(){return~~(this.millisecond()/100)}),H(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),H(0,["SSS",3],0,"millisecond"),H(0,["SSSS",4],0,function(){return 10*this.millisecond()}),H(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),H(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),H(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),H(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),H(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),A("millisecond","ms"),z("millisecond",16),$("S",Gn,Rn),$("SS",Gn,Yn),$("SSS",Gn,An);var Vr;for(Vr="SSSS";Vr.length<=9;Vr+="S")$(Vr,Bn);for(Vr="S";Vr.length<=9;Vr+="S")et(Vr,Ri);var Br=F("Milliseconds",!1);H("z",0,0,"zoneAbbr"),H("zz",0,0,"zoneName");var Ur=y.prototype;Ur.add=Wr,Ur.calendar=Xe,Ur.clone=Ze,Ur.diff=ei,Ur.endOf=fi,Ur.format=oi,Ur.from=si,Ur.fromNow=ai,Ur.to=hi,Ur.toNow=li,Ur.get=V,Ur.invalidAt=bi,Ur.isAfter=qe,Ur.isBefore=Qe,Ur.isBetween=$e,Ur.isSame=Je,Ur.isSameOrAfter=Ke,Ur.isSameOrBefore=ti,Ur.isValid=wi,Ur.lang=Nr,Ur.locale=ui,Ur.localeData=di,Ur.max=Lr,Ur.min=Pr,Ur.parsingFlags=xi,Ur.set=B,Ur.startOf=ci,Ur.subtract=zr,Ur.toArray=yi,Ur.toObject=gi,Ur.toDate=vi,Ur.toISOString=ri,Ur.toJSON=_i,Ur.toString=ni,Ur.unix=mi,Ur.valueOf=pi,Ur.creationData=Si,Ur.year=cr,Ur.isLeapYear=yt,Ur.weekYear=Di,Ur.isoWeekYear=ki,Ur.quarter=Ur.quarters=Pi,Ur.month=ut,Ur.daysInMonth=dt,Ur.week=Ur.weeks=Mt,Ur.isoWeek=Ur.isoWeeks=Ct,Ur.weeksInYear=Ci,Ur.isoWeeksInYear=Mi,Ur.date=Fr,Ur.day=Ur.days=It,Ur.weekday=Wt,Ur.isoWeekday=zt,Ur.dayOfYear=Li,Ur.hour=Ur.hours=br,Ur.minute=Ur.minutes=Gr,Ur.second=Ur.seconds=jr,Ur.millisecond=Ur.milliseconds=Br,Ur.utcOffset=Ee,Ur.utc=Pe,Ur.local=Le,Ur.parseZone=Re,Ur.hasAlignedHourOffset=Ye,Ur.isDST=Ae,Ur.isLocal=We,Ur.isUtcOffset=ze,Ur.isUtc=Ne,Ur.isUTC=Ne,Ur.zoneAbbr=Yi,Ur.zoneName=Ai,Ur.dates=S("dates accessor is deprecated. Use date instead.",Fr),Ur.months=S("months accessor is deprecated. Use month instead",ut),Ur.years=S("years accessor is deprecated. Use year instead",cr),Ur.zone=S("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",Oe),Ur.isDSTShifted=S("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",Ie);var Hr=Ur,Xr=C.prototype;Xr.calendar=E,Xr.longDateFormat=O,Xr.invalidDate=P,Xr.ordinal=L,Xr.preparse=zi,Xr.postformat=zi,Xr.relativeTime=R,Xr.pastFuture=Y,Xr.set=k,Xr.months=ot,Xr.monthsShort=st,Xr.monthsParse=ht,Xr.monthsRegex=ft,Xr.monthsShortRegex=ct,Xr.week=Tt,Xr.firstDayOfYear=kt,Xr.firstDayOfWeek=Dt,Xr.weekdays=Pt,Xr.weekdaysMin=Rt,Xr.weekdaysShort=Lt,Xr.weekdaysParse=At,Xr.weekdaysRegex=Nt,Xr.weekdaysShortRegex=Ft,Xr.weekdaysMinRegex=Gt,Xr.isPM=Xt,Xr.meridiem=Zt,Jt("en",{ordinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(t){var e=t%10,i=1===w(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th";return t+i}}),e.lang=S("moment.lang is deprecated. Use moment.locale instead.",Jt),e.langData=S("moment.langData is deprecated. Use moment.localeData instead.",ee);var Zr=Math.abs,qr=rn("ms"),Qr=rn("s"),$r=rn("m"),Jr=rn("h"),Kr=rn("d"),to=rn("w"),eo=rn("M"),io=rn("y"),no=sn("milliseconds"),ro=sn("seconds"),oo=sn("minutes"),so=sn("hours"),ao=sn("days"),ho=sn("months"),lo=sn("years"),uo=Math.round,co={s:45,m:45,h:22,d:26,M:11},fo=Math.abs,po=be.prototype;po.abs=Xi,po.add=qi,po.subtract=Qi,po.as=en,po.asMilliseconds=qr,po.asSeconds=Qr,po.asMinutes=$r,po.asHours=Jr,po.asDays=Kr,po.asWeeks=to,po.asMonths=eo,po.asYears=io,po.valueOf=nn,po._bubble=Ji,po.get=on,po.milliseconds=no,po.seconds=ro,po.minutes=oo,po.hours=so,po.days=ao,po.weeks=an,po.months=ho,po.years=lo,po.humanize=cn,po.toISOString=fn,po.toString=fn,po.toJSON=fn,po.locale=ui,po.localeData=di,po.toIsoString=S("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",fn),po.lang=Nr,H("X",0,0,"unix"),H("x",0,0,"valueOf"),$("x",Un),$("X",Zn),et("X",function(t,e,i){i._d=new Date(1e3*parseFloat(t,10))}),et("x",function(t,e,i){i._d=new Date(w(t))}),e.version="2.15.2",i(ge),e.fn=Hr,e.min=we,e.max=xe,e.now=Rr,e.utc=u,e.unix=Ii,e.months=ji,e.isDate=s,e.locale=Jt,e.invalid=p,e.duration=Fe,e.isMoment=g,e.weekdays=Bi,e.parseZone=Wi,e.localeData=ee,e.isDuration=Se,e.monthsShort=Vi,e.weekdaysMin=Hi,e.defineLocale=Kt,e.updateLocale=te,e.locales=ie,e.weekdaysShort=Ui,e.normalizeUnits=I,e.relativeTimeRounding=un,e.relativeTimeThreshold=dn,e.calendarFormat=He,e.prototype=Hr;var mo=e;return mo})}).call(e,i(4)(t))},function(t,e){t.exports=function(t){return t.webpackPolyfill||(t.deprecate=function(){},t.paths=[],t.children=[],t.webpackPolyfill=1),t}},function(t,e){function i(t){throw new Error("Cannot find module '"+t+"'.")}i.keys=function(){return[]},i.resolve=i,t.exports=i,i.id=5},function(t,e){(function(e){function i(t,e,i){var n=e&&i||0,r=0;for(e=e||[],t.toLowerCase().replace(/[0-9a-f]{2}/g,function(t){r<16&&(e[n+r++]=d[t])});r<16;)e[n+r++]=0;return e}function n(t,e){var i=e||0,n=u;return n[t[i++]]+n[t[i++]]+n[t[i++]]+n[t[i++]]+"-"+n[t[i++]]+n[t[i++]]+"-"+n[t[i++]]+n[t[i++]]+"-"+n[t[i++]]+n[t[i++]]+"-"+n[t[i++]]+n[t[i++]]+n[t[i++]]+n[t[i++]]+n[t[i++]]+n[t[i++]]}function r(t,e,i){var r=e&&i||0,o=e||[];t=t||{};var s=void 0!==t.clockseq?t.clockseq:m,a=void 0!==t.msecs?t.msecs:(new Date).getTime(),h=void 0!==t.nsecs?t.nsecs:y+1,l=a-v+(h-y)/1e4;if(l<0&&void 0===t.clockseq&&(s=s+1&16383),(l<0||a>v)&&void 0===t.nsecs&&(h=0),h>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");v=a,y=h,m=s,a+=122192928e5;var u=(1e4*(268435455&a)+h)%4294967296;o[r++]=u>>>24&255,o[r++]=u>>>16&255,o[r++]=u>>>8&255,o[r++]=255&u;var d=a/4294967296*1e4&268435455;o[r++]=d>>>8&255,o[r++]=255&d,o[r++]=d>>>24&15|16,
o[r++]=d>>>16&255,o[r++]=s>>>8|128,o[r++]=255&s;for(var c=t.node||p,f=0;f<6;f++)o[r+f]=c[f];return e?e:n(o)}function o(t,e,i){var r=e&&i||0;"string"==typeof t&&(e="binary"==t?new Array(16):null,t=null),t=t||{};var o=t.random||(t.rng||s)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,e)for(var a=0;a<16;a++)e[r+a]=o[a];return e||n(o)}var s,a="undefined"!=typeof window?window:"undefined"!=typeof e?e:null;if(a&&a.crypto&&crypto.getRandomValues){var h=new Uint8Array(16);s=function(){return crypto.getRandomValues(h),h}}if(!s){var l=new Array(16);s=function(){for(var t,e=0;e<16;e++)0===(3&e)&&(t=4294967296*Math.random()),l[e]=t>>>((3&e)<<3)&255;return l}}for(var u=[],d={},c=0;c<256;c++)u[c]=(c+256).toString(16).substr(1),d[u[c]]=c;var f=s(),p=[1|f[0],f[1],f[2],f[3],f[4],f[5]],m=16383&(f[6]<<8|f[7]),v=0,y=0,g=o;g.v1=r,g.v4=o,g.parse=i,g.unparse=n,t.exports=g}).call(e,function(){return this}())},function(t,e){e.prepareElements=function(t){for(var e in t)t.hasOwnProperty(e)&&(t[e].redundant=t[e].used,t[e].used=[])},e.cleanupElements=function(t){for(var e in t)if(t.hasOwnProperty(e)&&t[e].redundant){for(var i=0;i<t[e].redundant.length;i++)t[e].redundant[i].parentNode.removeChild(t[e].redundant[i]);t[e].redundant=[]}},e.resetElements=function(t){e.prepareElements(t),e.cleanupElements(t),e.prepareElements(t)},e.getSVGElement=function(t,e,i){var n;return e.hasOwnProperty(t)?e[t].redundant.length>0?(n=e[t].redundant[0],e[t].redundant.shift()):(n=document.createElementNS("http://www.w3.org/2000/svg",t),i.appendChild(n)):(n=document.createElementNS("http://www.w3.org/2000/svg",t),e[t]={used:[],redundant:[]},i.appendChild(n)),e[t].used.push(n),n},e.getDOMElement=function(t,e,i,n){var r;return e.hasOwnProperty(t)?e[t].redundant.length>0?(r=e[t].redundant[0],e[t].redundant.shift()):(r=document.createElement(t),void 0!==n?i.insertBefore(r,n):i.appendChild(r)):(r=document.createElement(t),e[t]={used:[],redundant:[]},void 0!==n?i.insertBefore(r,n):i.appendChild(r)),e[t].used.push(r),r},e.drawPoint=function(t,i,n,r,o,s){var a;if("circle"==n.style?(a=e.getSVGElement("circle",r,o),a.setAttributeNS(null,"cx",t),a.setAttributeNS(null,"cy",i),a.setAttributeNS(null,"r",.5*n.size)):(a=e.getSVGElement("rect",r,o),a.setAttributeNS(null,"x",t-.5*n.size),a.setAttributeNS(null,"y",i-.5*n.size),a.setAttributeNS(null,"width",n.size),a.setAttributeNS(null,"height",n.size)),void 0!==n.styles&&a.setAttributeNS(null,"style",n.styles),a.setAttributeNS(null,"class",n.className+" vis-point"),s){var h=e.getSVGElement("text",r,o);s.xOffset&&(t+=s.xOffset),s.yOffset&&(i+=s.yOffset),s.content&&(h.textContent=s.content),s.className&&h.setAttributeNS(null,"class",s.className+" vis-label"),h.setAttributeNS(null,"x",t),h.setAttributeNS(null,"y",i)}return a},e.drawBar=function(t,i,n,r,o,s,a,h){if(0!=r){r<0&&(r*=-1,i-=r);var l=e.getSVGElement("rect",s,a);l.setAttributeNS(null,"x",t-.5*n),l.setAttributeNS(null,"y",i),l.setAttributeNS(null,"width",n),l.setAttributeNS(null,"height",r),l.setAttributeNS(null,"class",o),h&&l.setAttributeNS(null,"style",h)}}},function(t,e,i){function n(t,e){if(t&&!Array.isArray(t)&&(e=t,t=null),this._options=e||{},this._data={},this.length=0,this._fieldId=this._options.fieldId||"id",this._type={},this._options.type)for(var i=Object.keys(this._options.type),n=0,r=i.length;n<r;n++){var o=i[n],s=this._options.type[o];"Date"==s||"ISODate"==s||"ASPDate"==s?this._type[o]="Date":this._type[o]=s}if(this._options.convert)throw new Error('Option "convert" is deprecated. Use "type" instead.');this._subscribers={},t&&this.add(t),this.setOptions(e)}var r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},o=i(1),s=i(9);n.prototype.setOptions=function(t){t&&void 0!==t.queue&&(t.queue===!1?this._queue&&(this._queue.destroy(),delete this._queue):(this._queue||(this._queue=s.extend(this,{replace:["add","update","remove"]})),"object"===r(t.queue)&&this._queue.setOptions(t.queue)))},n.prototype.on=function(t,e){var i=this._subscribers[t];i||(i=[],this._subscribers[t]=i),i.push({callback:e})},n.prototype.subscribe=function(){throw new Error("DataSet.subscribe is deprecated. Use DataSet.on instead.")},n.prototype.off=function(t,e){var i=this._subscribers[t];i&&(this._subscribers[t]=i.filter(function(t){return t.callback!=e}))},n.prototype.unsubscribe=function(){throw new Error("DataSet.unsubscribe is deprecated. Use DataSet.off instead.")},n.prototype._trigger=function(t,e,i){if("*"==t)throw new Error("Cannot trigger event *");var n=[];t in this._subscribers&&(n=n.concat(this._subscribers[t])),"*"in this._subscribers&&(n=n.concat(this._subscribers["*"]));for(var r=0,o=n.length;r<o;r++){var s=n[r];s.callback&&s.callback(t,e,i||null)}},n.prototype.add=function(t,e){var i,n=[],r=this;if(Array.isArray(t))for(var o=0,s=t.length;o<s;o++)i=r._addItem(t[o]),n.push(i);else{if(!(t instanceof Object))throw new Error("Unknown dataType");i=r._addItem(t),n.push(i)}return n.length&&this._trigger("add",{items:n},e),n},n.prototype.update=function(t,e){var i=[],n=[],r=[],s=[],a=this,h=a._fieldId,l=function(t){var e=t[h];if(a._data[e]){var l=o.extend({},a._data[e]);e=a._updateItem(t),n.push(e),s.push(t),r.push(l)}else e=a._addItem(t),i.push(e)};if(Array.isArray(t))for(var u=0,d=t.length;u<d;u++)t[u]instanceof Object?l(t[u]):console.warn("Ignoring input item, which is not an object at index "+u);else{if(!(t instanceof Object))throw new Error("Unknown dataType");l(t)}if(i.length&&this._trigger("add",{items:i},e),n.length){var c={items:n,oldData:r,data:s};this._trigger("update",c,e)}return i.concat(n)},n.prototype.get=function(t){var e,i,n,r=this,s=o.getType(arguments[0]);"String"==s||"Number"==s?(e=arguments[0],n=arguments[1]):"Array"==s?(i=arguments[0],n=arguments[1]):n=arguments[0];var a;if(n&&n.returnType){var h=["Array","Object"];a=h.indexOf(n.returnType)==-1?"Array":n.returnType}else a="Array";var l,u,d,c,f,p=n&&n.type||this._options.type,m=n&&n.filter,v=[];if(void 0!=e)l=r._getItem(e,p),l&&m&&!m(l)&&(l=null);else if(void 0!=i)for(c=0,f=i.length;c<f;c++)l=r._getItem(i[c],p),m&&!m(l)||v.push(l);else for(u=Object.keys(this._data),c=0,f=u.length;c<f;c++)d=u[c],l=r._getItem(d,p),m&&!m(l)||v.push(l);if(n&&n.order&&void 0==e&&this._sort(v,n.order),n&&n.fields){var y=n.fields;if(void 0!=e)l=this._filterFields(l,y);else for(c=0,f=v.length;c<f;c++)v[c]=this._filterFields(v[c],y)}if("Object"==a){var g,_={};for(c=0,f=v.length;c<f;c++)g=v[c],_[g.id]=g;return _}return void 0!=e?l:v},n.prototype.getIds=function(t){var e,i,n,r,o,s=this._data,a=t&&t.filter,h=t&&t.order,l=t&&t.type||this._options.type,u=Object.keys(s),d=[];if(a)if(h){for(o=[],e=0,i=u.length;e<i;e++)n=u[e],r=this._getItem(n,l),a(r)&&o.push(r);for(this._sort(o,h),e=0,i=o.length;e<i;e++)d.push(o[e][this._fieldId])}else for(e=0,i=u.length;e<i;e++)n=u[e],r=this._getItem(n,l),a(r)&&d.push(r[this._fieldId]);else if(h){for(o=[],e=0,i=u.length;e<i;e++)n=u[e],o.push(s[n]);for(this._sort(o,h),e=0,i=o.length;e<i;e++)d.push(o[e][this._fieldId])}else for(e=0,i=u.length;e<i;e++)n=u[e],r=s[n],d.push(r[this._fieldId]);return d},n.prototype.getDataSet=function(){return this},n.prototype.forEach=function(t,e){var i,n,r,o,s=e&&e.filter,a=e&&e.type||this._options.type,h=this._data,l=Object.keys(h);if(e&&e.order){var u=this.get(e);for(i=0,n=u.length;i<n;i++)r=u[i],o=r[this._fieldId],t(r,o)}else for(i=0,n=l.length;i<n;i++)o=l[i],r=this._getItem(o,a),s&&!s(r)||t(r,o)},n.prototype.map=function(t,e){var i,n,r,o,s=e&&e.filter,a=e&&e.type||this._options.type,h=[],l=this._data,u=Object.keys(l);for(i=0,n=u.length;i<n;i++)r=u[i],o=this._getItem(r,a),s&&!s(o)||h.push(t(o,r));return e&&e.order&&this._sort(h,e.order),h},n.prototype._filterFields=function(t,e){if(!t)return t;var i,n,r={},o=Object.keys(t),s=o.length;if(Array.isArray(e))for(i=0;i<s;i++)n=o[i],e.indexOf(n)!=-1&&(r[n]=t[n]);else for(i=0;i<s;i++)n=o[i],e.hasOwnProperty(n)&&(r[e[n]]=t[n]);return r},n.prototype._sort=function(t,e){if(o.isString(e)){var i=e;t.sort(function(t,e){var n=t[i],r=e[i];return n>r?1:n<r?-1:0})}else{if("function"!=typeof e)throw new TypeError("Order must be a function or a string");t.sort(e)}},n.prototype.remove=function(t,e){var i,n,r,o,s=[],a=[],h=[];for(h=Array.isArray(t)?t:[t],i=0,n=h.length;i<n;i++)o=this._remove(h[i]),o&&(r=o[this._fieldId],r&&(s.push(r),a.push(o)));return s.length&&this._trigger("remove",{items:s,oldData:a},e),s},n.prototype._remove=function(t){var e,i;return o.isNumber(t)||o.isString(t)?i=t:t instanceof Object&&(i=t[this._fieldId]),void 0!==i&&this._data[i]?(e=this._data[i],delete this._data[i],this.length--,e):null},n.prototype.clear=function(t){var e,i,n=Object.keys(this._data),r=[];for(e=0,i=n.length;e<i;e++)r.push(this._data[n[e]]);return this._data={},this.length=0,this._trigger("remove",{items:n,oldData:r},t),n},n.prototype.max=function(t){var e,i,n=this._data,r=Object.keys(n),o=null,s=null;for(e=0,i=r.length;e<i;e++){var a=r[e],h=n[a],l=h[t];null!=l&&(!o||l>s)&&(o=h,s=l)}return o},n.prototype.min=function(t){var e,i,n=this._data,r=Object.keys(n),o=null,s=null;for(e=0,i=r.length;e<i;e++){var a=r[e],h=n[a],l=h[t];null!=l&&(!o||l<s)&&(o=h,s=l)}return o},n.prototype.distinct=function(t){var e,i,n,r=this._data,s=Object.keys(r),a=[],h=this._options.type&&this._options.type[t]||null,l=0;for(e=0,n=s.length;e<n;e++){var u=s[e],d=r[u],c=d[t],f=!1;for(i=0;i<l;i++)if(a[i]==c){f=!0;break}f||void 0===c||(a[l]=c,l++)}if(h)for(e=0,n=a.length;e<n;e++)a[e]=o.convert(a[e],h);return a},n.prototype._addItem=function(t){var e=t[this._fieldId];if(void 0!=e){if(this._data[e])throw new Error("Cannot add item: item with id "+e+" already exists")}else e=o.randomUUID(),t[this._fieldId]=e;var i,n,r={},s=Object.keys(t);for(i=0,n=s.length;i<n;i++){var a=s[i],h=this._type[a];r[a]=o.convert(t[a],h)}return this._data[e]=r,this.length++,e},n.prototype._getItem=function(t,e){var i,n,r,s,a=this._data[t];if(!a)return null;var h={},l=Object.keys(a);if(e)for(r=0,s=l.length;r<s;r++)i=l[r],n=a[i],h[i]=o.convert(n,e[i]);else for(r=0,s=l.length;r<s;r++)i=l[r],n=a[i],h[i]=n;return h},n.prototype._updateItem=function(t){var e=t[this._fieldId];if(void 0==e)throw new Error("Cannot update item: item has no id (item: "+JSON.stringify(t)+")");var i=this._data[e];if(!i)throw new Error("Cannot update item: no item with id "+e+" found");for(var n=Object.keys(t),r=0,s=n.length;r<s;r++){var a=n[r],h=this._type[a];i[a]=o.convert(t[a],h)}return e},t.exports=n},function(t,e){function i(t){this.delay=null,this.max=1/0,this._queue=[],this._timeout=null,this._extended=null,this.setOptions(t)}i.prototype.setOptions=function(t){t&&"undefined"!=typeof t.delay&&(this.delay=t.delay),t&&"undefined"!=typeof t.max&&(this.max=t.max),this._flushIfNeeded()},i.extend=function(t,e){var n=new i(e);if(void 0!==t.flush)throw new Error("Target object already has a property flush");t.flush=function(){n.flush()};var r=[{name:"flush",original:void 0}];if(e&&e.replace)for(var o=0;o<e.replace.length;o++){var s=e.replace[o];r.push({name:s,original:t[s]}),n.replace(t,s)}return n._extended={object:t,methods:r},n},i.prototype.destroy=function(){if(this.flush(),this._extended){for(var t=this._extended.object,e=this._extended.methods,i=0;i<e.length;i++){var n=e[i];n.original?t[n.name]=n.original:delete t[n.name]}this._extended=null}},i.prototype.replace=function(t,e){var i=this,n=t[e];if(!n)throw new Error("Method "+e+" undefined");t[e]=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];i.queue({args:t,fn:n,context:this})}},i.prototype.queue=function(t){"function"==typeof t?this._queue.push({fn:t}):this._queue.push(t),this._flushIfNeeded()},i.prototype._flushIfNeeded=function(){if(this._queue.length>this.max&&this.flush(),clearTimeout(this._timeout),this.queue.length>0&&"number"==typeof this.delay){var t=this;this._timeout=setTimeout(function(){t.flush()},this.delay)}},i.prototype.flush=function(){for(;this._queue.length>0;){var t=this._queue.shift();t.fn.apply(t.context||t.fn,t.args||[])}},t.exports=i},function(t,e,i){function n(t,e){this._data=null,this._ids={},this.length=0,this._options=e||{},this._fieldId="id",this._subscribers={};var i=this;this.listener=function(){i._onEvent.apply(i,arguments)},this.setData(t)}var r=i(1),o=i(8);n.prototype.setData=function(t){var e,i,n,r,o;if(this._data){for(this._data.off&&this._data.off("*",this.listener),e=this._data.getIds({filter:this._options&&this._options.filter}),o=[],n=0,r=e.length;n<r;n++)o.push(this._data._data[e[n]]);this._ids={},this.length=0,this._trigger("remove",{items:e,oldData:o})}if(this._data=t,this._data){for(this._fieldId=this._options.fieldId||this._data&&this._data.options&&this._data.options.fieldId||"id",e=this._data.getIds({filter:this._options&&this._options.filter}),n=0,r=e.length;n<r;n++)i=e[n],this._ids[i]=!0;this.length=e.length,this._trigger("add",{items:e}),this._data.on&&this._data.on("*",this.listener)}},n.prototype.refresh=function(){var t,e,i,n=this._data.getIds({filter:this._options&&this._options.filter}),r=Object.keys(this._ids),o={},s=[],a=[],h=[];for(e=0,i=n.length;e<i;e++)t=n[e],o[t]=!0,this._ids[t]||(s.push(t),this._ids[t]=!0);for(e=0,i=r.length;e<i;e++)t=r[e],o[t]||(a.push(t),h.push(this._data[t]),delete this._ids[t]);this.length+=s.length-a.length,s.length&&this._trigger("add",{items:s}),a.length&&this._trigger("remove",{items:a,oldData:h})},n.prototype.get=function(t){var e,i,n,o=this,s=r.getType(arguments[0]);"String"==s||"Number"==s||"Array"==s?(e=arguments[0],i=arguments[1],n=arguments[2]):(i=arguments[0],n=arguments[1]);var a=r.extend({},this._options,i);this._options.filter&&i&&i.filter&&(a.filter=function(t){return o._options.filter(t)&&i.filter(t)});var h=[];return void 0!=e&&h.push(e),h.push(a),h.push(n),this._data&&this._data.get.apply(this._data,h)},n.prototype.getIds=function(t){var e;if(this._data){var i,n=this._options.filter;i=t&&t.filter?n?function(e){return n(e)&&t.filter(e)}:t.filter:n,e=this._data.getIds({filter:i,order:t&&t.order})}else e=[];return e},n.prototype.map=function(t,e){var i=[];if(this._data){var n,r=this._options.filter;n=e&&e.filter?r?function(t){return r(t)&&e.filter(t)}:e.filter:r,i=this._data.map(t,{filter:n,order:e&&e.order})}else i=[];return i},n.prototype.getDataSet=function(){for(var t=this;t instanceof n;)t=t._data;return t||null},n.prototype._onEvent=function(t,e,i){var n,r,o,s,a=e&&e.items,h=[],l=[],u=[],d=[],c=[],f=[];if(a&&this._data){switch(t){case"add":for(n=0,r=a.length;n<r;n++)o=a[n],s=this.get(o),s&&(this._ids[o]=!0,h.push(o));break;case"update":for(n=0,r=a.length;n<r;n++)o=a[n],s=this.get(o),s?this._ids[o]?(l.push(o),c.push(e.data[n]),d.push(e.oldData[n])):(this._ids[o]=!0,h.push(o)):this._ids[o]&&(delete this._ids[o],u.push(o),f.push(e.oldData[n]));break;case"remove":for(n=0,r=a.length;n<r;n++)o=a[n],this._ids[o]&&(delete this._ids[o],u.push(o),f.push(e.oldData[n]))}this.length+=h.length-u.length,h.length&&this._trigger("add",{items:h},i),l.length&&this._trigger("update",{items:l,oldData:d,data:c},i),u.length&&this._trigger("remove",{items:u,oldData:f},i)}},n.prototype.on=o.prototype.on,n.prototype.off=o.prototype.off,n.prototype._trigger=o.prototype._trigger,n.prototype.subscribe=n.prototype.on,n.prototype.unsubscribe=n.prototype.off,t.exports=n},function(t,e,i){function n(t,e,i){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.containerElement=t,this.dataTable=null,this.dataPoints=null,this.create(),v.setDefaults(g,this),this.colX=void 0,this.colY=void 0,this.colZ=void 0,this.colValue=void 0,this.colFilter=void 0,this.setOptions(i),e&&this.setData(e)}function r(t){return"clientX"in t?t.clientX:t.targetTouches[0]&&t.targetTouches[0].clientX||0}function o(t){return"clientY"in t?t.clientY:t.targetTouches[0]&&t.targetTouches[0].clientY||0}var s=i(12),a=i(8),h=i(10),l=i(1),u=i(13),d=i(14),c=(i(15),i(16)),f=i(17),p=i(18),m=i(19),v=i(20);n.STYLE=v.STYLE;var y=void 0,g={width:"400px",height:"400px",filterLabel:"time",legendLabel:"value",xLabel:"x",yLabel:"y",zLabel:"z",xValueLabel:function(t){return t},yValueLabel:function(t){return t},zValueLabel:function(t){return t},showGrid:!0,showPerspective:!0,showShadow:!1,keepAspectRatio:!0,verticalRatio:.5,dotSizeRatio:.02,showAnimationControls:y,animationInterval:1e3,animationPreload:!1,animationAutoStart:y,axisColor:"#4D4D4D",gridColor:"#D3D3D3",xCenter:"55%",yCenter:"50%",style:n.STYLE.DOT,tooltip:!1,showLegend:y,backgroundColor:y,dataColor:{fill:"#7DC1FF",stroke:"#3267D2",strokeWidth:1},cameraPosition:{horizontal:1,vertical:.5,distance:1.7},xBarWidth:y,yBarWidth:y,valueMin:y,valueMax:y,xMin:y,xMax:y,xStep:y,yMin:y,yMax:y,yStep:y,zMin:y,zMax:y,zStep:y};s(n.prototype),n.prototype._setScale=function(){this.scale=new u(1/this.xRange.range(),1/this.yRange.range(),1/this.zRange.range()),this.keepAspectRatio&&(this.scale.x<this.scale.y?this.scale.y=this.scale.x:this.scale.x=this.scale.y),this.scale.z*=this.verticalRatio,void 0!==this.valueRange&&(this.scale.value=1/this.valueRange.range());var t=this.xRange.center()*this.scale.x,e=this.yRange.center()*this.scale.y,i=this.zRange.center()*this.scale.z;this.camera.setArmLocation(t,e,i)},n.prototype._convert3Dto2D=function(t){var e=this._convertPointToTranslation(t);return this._convertTranslationToScreen(e)},n.prototype._convertPointToTranslation=function(t){var e=this.camera.getCameraLocation(),i=this.camera.getCameraRotation(),n=t.x*this.scale.x,r=t.y*this.scale.y,o=t.z*this.scale.z,s=e.x,a=e.y,h=e.z,l=Math.sin(i.x),d=Math.cos(i.x),c=Math.sin(i.y),f=Math.cos(i.y),p=Math.sin(i.z),m=Math.cos(i.z),v=f*(p*(r-a)+m*(n-s))-c*(o-h),y=l*(f*(o-h)+c*(p*(r-a)+m*(n-s)))+d*(m*(r-a)-p*(n-s)),g=d*(f*(o-h)+c*(p*(r-a)+m*(n-s)))-l*(m*(r-a)-p*(n-s));return new u(v,y,g)},n.prototype._convertTranslationToScreen=function(t){var e,i,n=this.eye.x,r=this.eye.y,o=this.eye.z,s=t.x,a=t.y,h=t.z;return this.showPerspective?(e=(s-n)*(o/h),i=(a-r)*(o/h)):(e=s*-(o/this.camera.getArmLength()),i=a*-(o/this.camera.getArmLength())),new d(this.currentXCenter+e*this.frame.canvas.clientWidth,this.currentYCenter-i*this.frame.canvas.clientWidth)},n.prototype._calcTranslations=function(t,e){void 0===e&&(e=!0);for(var i=0;i<t.length;i++){var n=t[i];n.trans=this._convertPointToTranslation(n.point),n.screen=this._convertTranslationToScreen(n.trans);var r=this._convertPointToTranslation(n.bottom);n.dist=this.showPerspective?r.length():-r.z}if(e){var o=function(t,e){return e.dist-t.dist};t.sort(o)}},n.prototype.getNumberOfRows=function(t){return t.length},n.prototype.getNumberOfColumns=function(t){var e=0;for(var i in t[0])t[0].hasOwnProperty(i)&&e++;return e},n.prototype.getDistinctValues=function(t,e){for(var i=[],n=0;n<t.length;n++)i.indexOf(t[n][e])==-1&&i.push(t[n][e]);return i},n.prototype.getColumnRange=function(t,e){for(var i=new m,n=0;n<t.length;n++){var r=t[n][e];i.adjust(r)}return i},n.prototype._checkValueField=function(t){var e=this.style===n.STYLE.BARCOLOR||this.style===n.STYLE.BARSIZE||this.style===n.STYLE.DOTCOLOR||this.style===n.STYLE.DOTSIZE;if(e){if(void 0===this.colValue)throw new Error("Expected data to have  field 'style'  for graph style '"+this.style+"'");if(void 0===t[0][this.colValue])throw new Error("Expected data to have  field '"+this.colValue+"'  for graph style '"+this.style+"'")}},n.prototype._setRangeDefaults=function(t,e,i){void 0!==e&&(t.min=e),void 0!==i&&(t.max=i),t.max<=t.min&&(t.max=t.min+1)},n.prototype._dataInitialize=function(t,e){var i=this;if(this.dataSet&&this.dataSet.off("*",this._onChange),void 0!==t){Array.isArray(t)&&(t=new a(t));var r;if(!(t instanceof a||t instanceof h))throw new Error("Array, DataSet, or DataView expected");if(r=t.get(),0!=r.length){this.dataSet=t,this.dataTable=r,this._onChange=function(){i.setData(i.dataSet)},this.dataSet.on("*",this._onChange),this.colX="x",this.colY="y",this.colZ="z";var o=this.style==n.STYLE.BAR||this.style==n.STYLE.BARCOLOR||this.style==n.STYLE.BARSIZE;if(o){if(void 0!==this.defaultXBarWidth)this.xBarWidth=this.defaultXBarWidth;else{var s=this.getDistinctValues(r,this.colX);this.xBarWidth=s[1]-s[0]||1}if(void 0!==this.defaultYBarWidth)this.yBarWidth=this.defaultYBarWidth;else{var l=this.getDistinctValues(r,this.colY);this.yBarWidth=l[1]-l[0]||1}}var u=5,d=this.getColumnRange(r,this.colX);o&&d.expand(this.xBarWidth/2),this._setRangeDefaults(d,this.defaultXMin,this.defaultXMax),this.xRange=d,this.xStep=void 0!==this.defaultXStep?this.defaultXStep:d.range()/u;var f=this.getColumnRange(r,this.colY);o&&f.expand(this.yBarWidth/2),this._setRangeDefaults(f,this.defaultYMin,this.defaultYMax),this.yRange=f,this.yStep=void 0!==this.defaultYStep?this.defaultYStep:f.range()/u;var p=this.getColumnRange(r,this.colZ);if(this._setRangeDefaults(p,this.defaultZMin,this.defaultZMax),this.zRange=p,this.zStep=void 0!==this.defaultZStep?this.defaultZStep:p.range()/u,r[0].hasOwnProperty("style")){this.colValue="style";var m=this.getColumnRange(r,this.colValue);this._setRangeDefaults(m,this.defaultValueMin,this.defaultValueMax),this.valueRange=m}r[0].hasOwnProperty("filter")&&(this.colFilter="filter",void 0===this.dataFilter&&(this.dataFilter=new c(t,this.colFilter,this),this.dataFilter.setOnLoadCallback(function(){i.redraw()}))),this._setScale()}}},n.prototype._getDataPoints=function(t){var e,i,r,o,s,a,h=[];if(this.style===n.STYLE.GRID||this.style===n.STYLE.SURFACE){var l=[],d=[];for(r=0;r<this.getNumberOfRows(t);r++)e=t[r][this.colX]||0,i=t[r][this.colY]||0,l.indexOf(e)===-1&&l.push(e),d.indexOf(i)===-1&&d.push(i);var c=function(t,e){return t-e};l.sort(c),d.sort(c);var f=[];for(r=0;r<t.length;r++){e=t[r][this.colX]||0,i=t[r][this.colY]||0,o=t[r][this.colZ]||0;var p=l.indexOf(e),m=d.indexOf(i);void 0===f[p]&&(f[p]=[]);var v=new u;v.x=e,v.y=i,v.z=o,v.data=t[r],s={},s.point=v,s.trans=void 0,s.screen=void 0,s.bottom=new u(e,i,this.zRange.min),f[p][m]=s,h.push(s)}for(e=0;e<f.length;e++)for(i=0;i<f[e].length;i++)f[e][i]&&(f[e][i].pointRight=e<f.length-1?f[e+1][i]:void 0,f[e][i].pointTop=i<f[e].length-1?f[e][i+1]:void 0,f[e][i].pointCross=e<f.length-1&&i<f[e].length-1?f[e+1][i+1]:void 0)}else for(this._checkValueField(t),r=0;r<t.length;r++)a=new u,a.x=t[r][this.colX]||0,a.y=t[r][this.colY]||0,a.z=t[r][this.colZ]||0,a.data=t[r],void 0!==this.colValue&&(a.value=t[r][this.colValue]||0),s={},s.point=a,s.bottom=new u(a.x,a.y,this.zRange.min),s.trans=void 0,s.screen=void 0,this.style===n.STYLE.LINE&&r>0&&(h[r-1].pointNext=s),h.push(s);return h},n.prototype.create=function(){for(;this.containerElement.hasChildNodes();)this.containerElement.removeChild(this.containerElement.firstChild);this.frame=document.createElement("div"),this.frame.style.position="relative",this.frame.style.overflow="hidden",this.frame.canvas=document.createElement("canvas"),this.frame.canvas.style.position="relative",this.frame.appendChild(this.frame.canvas);var t=document.createElement("DIV");t.style.color="red",t.style.fontWeight="bold",t.style.padding="10px",t.innerHTML="Error: your browser does not support HTML canvas",this.frame.canvas.appendChild(t),this.frame.filter=document.createElement("div"),this.frame.filter.style.position="absolute",this.frame.filter.style.bottom="0px",this.frame.filter.style.left="0px",this.frame.filter.style.width="100%",this.frame.appendChild(this.frame.filter);var e=this,i=function(t){e._onMouseDown(t)},n=function(t){e._onTouchStart(t)},r=function(t){e._onWheel(t)},o=function(t){e._onTooltip(t)};l.addEventListener(this.frame.canvas,"keydown",onkeydown),l.addEventListener(this.frame.canvas,"mousedown",i),l.addEventListener(this.frame.canvas,"touchstart",n),l.addEventListener(this.frame.canvas,"mousewheel",r),l.addEventListener(this.frame.canvas,"mousemove",o),this.containerElement.appendChild(this.frame)},n.prototype.setSize=function(t,e){this.frame.style.width=t,this.frame.style.height=e,this._resizeCanvas()},n.prototype._resizeCanvas=function(){this.frame.canvas.style.width="100%",this.frame.canvas.style.height="100%",this.frame.canvas.width=this.frame.canvas.clientWidth,this.frame.canvas.height=this.frame.canvas.clientHeight,this.frame.filter.style.width=this.frame.canvas.clientWidth-20+"px"},n.prototype.animationStart=function(){if(!this.frame.filter||!this.frame.filter.slider)throw new Error("No animation available");this.frame.filter.slider.play()},n.prototype.animationStop=function(){this.frame.filter&&this.frame.filter.slider&&this.frame.filter.slider.stop()},n.prototype._resizeCenter=function(){"%"===this.xCenter.charAt(this.xCenter.length-1)?this.currentXCenter=parseFloat(this.xCenter)/100*this.frame.canvas.clientWidth:this.currentXCenter=parseFloat(this.xCenter),"%"===this.yCenter.charAt(this.yCenter.length-1)?this.currentYCenter=parseFloat(this.yCenter)/100*(this.frame.canvas.clientHeight-this.frame.filter.clientHeight):this.currentYCenter=parseFloat(this.yCenter)},n.prototype.getCameraPosition=function(){var t=this.camera.getArmRotation();return t.distance=this.camera.getArmLength(),t},n.prototype._readData=function(t){this._dataInitialize(t,this.style),this.dataFilter?this.dataPoints=this.dataFilter._getDataPoints():this.dataPoints=this._getDataPoints(this.dataTable),this._redrawFilter()},n.prototype.setData=function(t){this._readData(t),this.redraw(),this.animationAutoStart&&this.dataFilter&&this.animationStart()},n.prototype.setOptions=function(t){this.animationStop(),v.setOptions(t,this),this.setPointDrawingMethod(),this.setSize(this.width,this.height),this.dataTable&&this.setData(this.dataTable),this.animationAutoStart&&this.dataFilter&&this.animationStart()},n.prototype.setPointDrawingMethod=function(){var t=void 0;switch(this.style){case n.STYLE.BAR:t=n.prototype._redrawBarGraphPoint;break;case n.STYLE.BARCOLOR:t=n.prototype._redrawBarColorGraphPoint;break;case n.STYLE.BARSIZE:t=n.prototype._redrawBarSizeGraphPoint;break;case n.STYLE.DOT:t=n.prototype._redrawDotGraphPoint;break;case n.STYLE.DOTLINE:t=n.prototype._redrawDotLineGraphPoint;break;case n.STYLE.DOTCOLOR:t=n.prototype._redrawDotColorGraphPoint;break;case n.STYLE.DOTSIZE:t=n.prototype._redrawDotSizeGraphPoint;break;case n.STYLE.SURFACE:t=n.prototype._redrawSurfaceGraphPoint;break;case n.STYLE.GRID:t=n.prototype._redrawGridGraphPoint;break;case n.STYLE.LINE:t=n.prototype._redrawLineGraphPoint;break;default:throw new Error("Can not determine point drawing method for graph style '"+this.style+"'")}this._pointDrawingMethod=t},n.prototype.redraw=function(){if(void 0===this.dataPoints)throw new Error("Graph data not initialized");this._resizeCanvas(),this._resizeCenter(),this._redrawSlider(),this._redrawClear(),this._redrawAxis(),this._redrawDataGraph(),this._redrawInfo(),this._redrawLegend()},n.prototype._getContext=function(){var t=this.frame.canvas,e=t.getContext("2d");return e.lineJoin="round",e.lineCap="round",e},n.prototype._redrawClear=function(){var t=this.frame.canvas,e=t.getContext("2d");e.clearRect(0,0,t.width,t.height)},n.prototype._dotSize=function(){return this.frame.clientWidth*this.dotSizeRatio},n.prototype._getLegendWidth=function(){var t;if(this.style===n.STYLE.DOTSIZE){var e=this._dotSize();t=e/2+2*e}else t=this.style===n.STYLE.BARSIZE?this.xBarWidth:20;return t},n.prototype._redrawLegend=function(){if(this.showLegend===!0&&this.style!==n.STYLE.LINE&&this.style!==n.STYLE.BARSIZE){var t=this.style===n.STYLE.BARSIZE||this.style===n.STYLE.DOTSIZE,e=this.style===n.STYLE.DOTSIZE||this.style===n.STYLE.DOTCOLOR||this.style===n.STYLE.BARCOLOR,i=Math.max(.25*this.frame.clientHeight,100),r=this.margin,o=this._getLegendWidth(),s=this.frame.clientWidth-this.margin,a=s-o,h=r+i,l=this._getContext();if(l.lineWidth=1,l.font="14px arial",t===!1){var u,c=0,f=i;for(u=c;u<f;u++){var m=(u-c)/(f-c),v=240*m,y=this._hsv2rgb(v,1,1);l.strokeStyle=y,l.beginPath(),l.moveTo(a,r+u),l.lineTo(s,r+u),l.stroke()}l.strokeStyle=this.axisColor,l.strokeRect(a,r,o,i)}else{var g;if(this.style===n.STYLE.DOTSIZE){var _=this._dotSize();g=_/2}else this.style===n.STYLE.BARSIZE;l.strokeStyle=this.axisColor,l.fillStyle=this.dataColor.fill,l.beginPath(),l.moveTo(a,r),l.lineTo(s,r),l.lineTo(s-o+g,h),l.lineTo(a,h),l.closePath(),l.fill(),l.stroke()}var w=5,x=e?this.valueRange.min:this.zRange.min,b=e?this.valueRange.max:this.zRange.max,S=new p(x,b,(b-x)/5,!0);S.start(!0);for(var u,T,D;!S.end();)u=h-(S.getCurrent()-x)/(b-x)*i,T=new d(a-w,u),D=new d(a,u),this._line(l,T,D),l.textAlign="right",l.textBaseline="middle",l.fillStyle=this.axisColor,l.fillText(S.getCurrent(),a-2*w,u),S.next();l.textAlign="right",l.textBaseline="top";var k=this.legendLabel;l.fillText(k,s,h+this.margin)}},n.prototype._redrawFilter=function(){if(this.frame.filter.innerHTML="",this.dataFilter){var t={visible:this.showAnimationControls},e=new f(this.frame.filter,t);this.frame.filter.slider=e,this.frame.filter.style.padding="10px",e.setValues(this.dataFilter.values),e.setPlayInterval(this.animationInterval);var i=this,n=function(){var t=e.getIndex();i.dataFilter.selectValue(t),i.dataPoints=i.dataFilter._getDataPoints(),i.redraw()};e.setOnChangeCallback(n)}else this.frame.filter.slider=void 0},n.prototype._redrawSlider=function(){void 0!==this.frame.filter.slider&&this.frame.filter.slider.redraw()},n.prototype._redrawInfo=function(){if(this.dataFilter){var t=this._getContext();t.font="14px arial",t.lineStyle="gray",t.fillStyle="gray",t.textAlign="left",t.textBaseline="top";var e=this.margin,i=this.margin;t.fillText(this.dataFilter.getLabel()+": "+this.dataFilter.getSelectedValue(),e,i)}},n.prototype._line=function(t,e,i,n){void 0!==n&&(t.strokeStyle=n),t.beginPath(),t.moveTo(e.x,e.y),t.lineTo(i.x,i.y),t.stroke()},n.prototype.drawAxisLabelX=function(t,e,i,n,r){void 0===r&&(r=0);var o=this._convert3Dto2D(e);Math.cos(2*n)>0?(t.textAlign="center",t.textBaseline="top",o.y+=r):Math.sin(2*n)<0?(t.textAlign="right",t.textBaseline="middle"):(t.textAlign="left",t.textBaseline="middle"),t.fillStyle=this.axisColor,t.fillText(i,o.x,o.y)},n.prototype.drawAxisLabelY=function(t,e,i,n,r){void 0===r&&(r=0);var o=this._convert3Dto2D(e);Math.cos(2*n)<0?(t.textAlign="center",t.textBaseline="top",o.y+=r):Math.sin(2*n)>0?(t.textAlign="right",t.textBaseline="middle"):(t.textAlign="left",t.textBaseline="middle"),t.fillStyle=this.axisColor,t.fillText(i,o.x,o.y)},n.prototype.drawAxisLabelZ=function(t,e,i,n){void 0===n&&(n=0);var r=this._convert3Dto2D(e);t.textAlign="right",t.textBaseline="middle",t.fillStyle=this.axisColor,t.fillText(i,r.x-n,r.y)},n.prototype._line3d=function(t,e,i,n){var r=this._convert3Dto2D(e),o=this._convert3Dto2D(i);this._line(t,r,o,n)},n.prototype._redrawAxis=function(){var t,e,i,n,r,o,s,a,h,l,c,f=this._getContext();f.font=24/this.camera.getArmLength()+"px arial";var m=.025/this.scale.x,v=.025/this.scale.y,y=5/this.camera.getArmLength(),g=this.camera.getArmRotation().horizontal,_=new d(Math.cos(g),Math.sin(g)),w=this.xRange,x=this.yRange,b=this.zRange;for(f.lineWidth=1,n=void 0===this.defaultXStep,i=new p(w.min,w.max,this.xStep,n),i.start(!0);!i.end();){var S=i.getCurrent();this.showGrid?(t=new u(S,x.min,b.min),e=new u(S,x.max,b.min),this._line3d(f,t,e,this.gridColor)):(t=new u(S,x.min,b.min),e=new u(S,x.min+m,b.min),this._line3d(f,t,e,this.axisColor),t=new u(S,x.max,b.min),e=new u(S,x.max-m,b.min),this._line3d(f,t,e,this.axisColor)),s=_.x>0?x.min:x.max;var T=new u(S,s,b.min),D="  "+this.xValueLabel(S)+"  ";this.drawAxisLabelX(f,T,D,g,y),i.next()}for(f.lineWidth=1,n=void 0===this.defaultYStep,i=new p(x.min,x.max,this.yStep,n),i.start(!0);!i.end();){var k=i.getCurrent();this.showGrid?(t=new u(w.min,k,b.min),e=new u(w.max,k,b.min),this._line3d(f,t,e,this.gridColor)):(t=new u(w.min,k,b.min),e=new u(w.min+v,k,b.min),this._line3d(f,t,e,this.axisColor),t=new u(w.max,k,b.min),e=new u(w.max-v,k,b.min),this._line3d(f,t,e,this.axisColor)),o=_.y>0?w.min:w.max,T=new u(o,k,b.min);var D="  "+this.yValueLabel(k)+"  ";this.drawAxisLabelY(f,T,D,g,y),i.next()}for(f.lineWidth=1,n=void 0===this.defaultZStep,i=new p(b.min,b.max,this.zStep,n),i.start(!0),o=_.x>0?w.min:w.max,s=_.y<0?x.min:x.max;!i.end();){
var M=i.getCurrent(),C=new u(o,s,M),E=this._convert3Dto2D(C);e=new d(E.x-y,E.y),this._line(f,E,e,this.axisColor);var D=this.zValueLabel(M)+" ";this.drawAxisLabelZ(f,C,D,5),i.next()}f.lineWidth=1,t=new u(o,s,b.min),e=new u(o,s,b.max),this._line3d(f,t,e,this.axisColor);var O,P;f.lineWidth=1,O=new u(w.min,x.min,b.min),P=new u(w.max,x.min,b.min),this._line3d(f,O,P,this.axisColor),O=new u(w.min,x.max,b.min),P=new u(w.max,x.max,b.min),this._line3d(f,O,P,this.axisColor),f.lineWidth=1,t=new u(w.min,x.min,b.min),e=new u(w.min,x.max,b.min),this._line3d(f,t,e,this.axisColor),t=new u(w.max,x.min,b.min),e=new u(w.max,x.max,b.min),this._line3d(f,t,e,this.axisColor);var L=this.xLabel;L.length>0&&(c=.1/this.scale.y,o=w.center()/2,s=_.x>0?x.min-c:x.max+c,r=new u(o,s,b.min),this.drawAxisLabelX(f,r,L,g));var R=this.yLabel;R.length>0&&(l=.1/this.scale.x,o=_.y>0?w.min-l:w.max+l,s=x.center()/2,r=new u(o,s,b.min),this.drawAxisLabelY(f,r,R,g));var Y=this.zLabel;Y.length>0&&(h=30,o=_.x>0?w.min:w.max,s=_.y<0?x.min:x.max,a=b.center()/2,r=new u(o,s,a),this.drawAxisLabelZ(f,r,Y,h))},n.prototype._hsv2rgb=function(t,e,i){var n,r,o,s,a,h;switch(s=i*e,a=Math.floor(t/60),h=s*(1-Math.abs(t/60%2-1)),a){case 0:n=s,r=h,o=0;break;case 1:n=h,r=s,o=0;break;case 2:n=0,r=s,o=h;break;case 3:n=0,r=h,o=s;break;case 4:n=h,r=0,o=s;break;case 5:n=s,r=0,o=h;break;default:n=0,r=0,o=0}return"RGB("+parseInt(255*n)+","+parseInt(255*r)+","+parseInt(255*o)+")"},n.prototype._getStrokeWidth=function(t){return void 0!==t?this.showPerspective?1/-t.trans.z*this.dataColor.strokeWidth:-(this.eye.z/this.camera.getArmLength())*this.dataColor.strokeWidth:this.dataColor.strokeWidth},n.prototype._redrawBar=function(t,e,i,n,r,o){var s,a,h=this,l=e.point,d=this.zRange.min,c=[{point:new u(l.x-i,l.y-n,l.z)},{point:new u(l.x+i,l.y-n,l.z)},{point:new u(l.x+i,l.y+n,l.z)},{point:new u(l.x-i,l.y+n,l.z)}],f=[{point:new u(l.x-i,l.y-n,d)},{point:new u(l.x+i,l.y-n,d)},{point:new u(l.x+i,l.y+n,d)},{point:new u(l.x-i,l.y+n,d)}];c.forEach(function(t){t.screen=h._convert3Dto2D(t.point)}),f.forEach(function(t){t.screen=h._convert3Dto2D(t.point)});var p=[{corners:c,center:u.avg(f[0].point,f[2].point)},{corners:[c[0],c[1],f[1],f[0]],center:u.avg(f[1].point,f[0].point)},{corners:[c[1],c[2],f[2],f[1]],center:u.avg(f[2].point,f[1].point)},{corners:[c[2],c[3],f[3],f[2]],center:u.avg(f[3].point,f[2].point)},{corners:[c[3],c[0],f[0],f[3]],center:u.avg(f[0].point,f[3].point)}];for(e.surfaces=p,s=0;s<p.length;s++){a=p[s];var m=this._convertPointToTranslation(a.center);a.dist=this.showPerspective?m.length():-m.z}for(p.sort(function(t,e){var i=e.dist-t.dist;return i?i:t.corners===c?1:e.corners===c?-1:0}),t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=o,t.fillStyle=r,s=2;s<p.length;s++)a=p[s],this._polygon(t,a.corners)},n.prototype._polygon=function(t,e,i,n){if(!(e.length<2)){void 0!==i&&(t.fillStyle=i),void 0!==n&&(t.strokeStyle=n),t.beginPath(),t.moveTo(e[0].screen.x,e[0].screen.y);for(var r=1;r<e.length;++r){var o=e[r];t.lineTo(o.screen.x,o.screen.y)}t.closePath(),t.fill(),t.stroke()}},n.prototype._drawCircle=function(t,e,i,n,r){var o=this._calcRadius(e,r);t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=n,t.fillStyle=i,t.beginPath(),t.arc(e.screen.x,e.screen.y,o,0,2*Math.PI,!0),t.fill(),t.stroke()},n.prototype._getColorsRegular=function(t){var e=240*(1-(t.point.z-this.zRange.min)*this.scale.z/this.verticalRatio),i=this._hsv2rgb(e,1,1),n=this._hsv2rgb(e,1,.8);return{fill:i,border:n}},n.prototype._getColorsColor=function(t){var e=240*(1-(t.point.value-this.valueRange.min)*this.scale.value),i=this._hsv2rgb(e,1,1),n=this._hsv2rgb(e,1,.8);return{fill:i,border:n}},n.prototype._getColorsSize=function(){return{fill:this.dataColor.fill,border:this.dataColor.stroke}},n.prototype._calcRadius=function(t,e){void 0===e&&(e=this._dotSize());var i;return i=this.showPerspective?e/-t.trans.z:e*-(this.eye.z/this.camera.getArmLength()),i<0&&(i=0),i},n.prototype._redrawBarGraphPoint=function(t,e){var i=this.xBarWidth/2,n=this.yBarWidth/2,r=this._getColorsRegular(e);this._redrawBar(t,e,i,n,r.fill,r.border)},n.prototype._redrawBarColorGraphPoint=function(t,e){var i=this.xBarWidth/2,n=this.yBarWidth/2,r=this._getColorsColor(e);this._redrawBar(t,e,i,n,r.fill,r.border)},n.prototype._redrawBarSizeGraphPoint=function(t,e){var i=(e.point.value-this.valueRange.min)/this.valueRange.range(),n=this.xBarWidth/2*(.8*i+.2),r=this.yBarWidth/2*(.8*i+.2),o=this._getColorsSize();this._redrawBar(t,e,n,r,o.fill,o.border)},n.prototype._redrawDotGraphPoint=function(t,e){var i=this._getColorsRegular(e);this._drawCircle(t,e,i.fill,i.border)},n.prototype._redrawDotLineGraphPoint=function(t,e){var i=this._convert3Dto2D(e.bottom);t.lineWidth=1,this._line(t,i,e.screen,this.gridColor),this._redrawDotGraphPoint(t,e)},n.prototype._redrawDotColorGraphPoint=function(t,e){var i=this._getColorsColor(e);this._drawCircle(t,e,i.fill,i.border)},n.prototype._redrawDotSizeGraphPoint=function(t,e){var i=this._dotSize(),n=(e.point.value-this.valueRange.min)/this.valueRange.range(),r=i/2+2*i*n,o=this._getColorsSize();this._drawCircle(t,e,o.fill,o.border,r)},n.prototype._redrawSurfaceGraphPoint=function(t,e){var i=e.pointRight,n=e.pointTop,r=e.pointCross;if(void 0!==e&&void 0!==i&&void 0!==n&&void 0!==r){var o,s,a=!0;if(this.showGrayBottom||this.showShadow){var h=u.subtract(r.trans,e.trans),l=u.subtract(n.trans,i.trans),d=u.crossProduct(h,l),c=d.length();a=d.z>0}if(a){var f,p=(e.point.z+i.point.z+n.point.z+r.point.z)/4,m=240*(1-(p-this.zRange.min)*this.scale.z/this.verticalRatio),v=1;this.showShadow?(f=Math.min(1+d.x/c/2,1),o=this._hsv2rgb(m,v,f),s=o):(f=1,o=this._hsv2rgb(m,v,f),s=this.axisColor)}else o="gray",s=this.axisColor;t.lineWidth=this._getStrokeWidth(e);var y=[e,i,r,n];this._polygon(t,y,o,s)}},n.prototype._drawGridLine=function(t,e,i){if(void 0!==e&&void 0!==i){var n=(e.point.z+i.point.z)/2,r=240*(1-(n-this.zRange.min)*this.scale.z/this.verticalRatio);t.lineWidth=2*this._getStrokeWidth(e),t.strokeStyle=this._hsv2rgb(r,1,1),this._line(t,e.screen,i.screen)}},n.prototype._redrawGridGraphPoint=function(t,e){this._drawGridLine(t,e,e.pointRight),this._drawGridLine(t,e,e.pointTop)},n.prototype._redrawLineGraphPoint=function(t,e){void 0!==e.pointNext&&(t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=this.dataColor.stroke,this._line(t,e.screen,e.pointNext.screen))},n.prototype._redrawDataGraph=function(){var t,e=this._getContext();if(!(void 0===this.dataPoints||this.dataPoints.length<=0))for(this._calcTranslations(this.dataPoints),t=0;t<this.dataPoints.length;t++){var i=this.dataPoints[t];this._pointDrawingMethod.call(this,e,i)}},n.prototype._onMouseDown=function(t){if(t=t||window.event,this.leftButtonDown&&this._onMouseUp(t),this.leftButtonDown=t.which?1===t.which:1===t.button,this.leftButtonDown||this.touchDown){this.startMouseX=r(t),this.startMouseY=o(t),this.startStart=new Date(this.start),this.startEnd=new Date(this.end),this.startArmRotation=this.camera.getArmRotation(),this.frame.style.cursor="move";var e=this;this.onmousemove=function(t){e._onMouseMove(t)},this.onmouseup=function(t){e._onMouseUp(t)},l.addEventListener(document,"mousemove",e.onmousemove),l.addEventListener(document,"mouseup",e.onmouseup),l.preventDefault(t)}},n.prototype._onMouseMove=function(t){t=t||window.event;var e=parseFloat(r(t))-this.startMouseX,i=parseFloat(o(t))-this.startMouseY,n=this.startArmRotation.horizontal+e/200,s=this.startArmRotation.vertical+i/200,a=4,h=Math.sin(a/360*2*Math.PI);Math.abs(Math.sin(n))<h&&(n=Math.round(n/Math.PI)*Math.PI-.001),Math.abs(Math.cos(n))<h&&(n=(Math.round(n/Math.PI-.5)+.5)*Math.PI-.001),Math.abs(Math.sin(s))<h&&(s=Math.round(s/Math.PI)*Math.PI),Math.abs(Math.cos(s))<h&&(s=(Math.round(s/Math.PI-.5)+.5)*Math.PI),this.camera.setArmRotation(n,s),this.redraw();var u=this.getCameraPosition();this.emit("cameraPositionChange",u),l.preventDefault(t)},n.prototype._onMouseUp=function(t){this.frame.style.cursor="auto",this.leftButtonDown=!1,l.removeEventListener(document,"mousemove",this.onmousemove),l.removeEventListener(document,"mouseup",this.onmouseup),l.preventDefault(t)},n.prototype._onTooltip=function(t){var e=300,i=this.frame.getBoundingClientRect(),n=r(t)-i.left,s=o(t)-i.top;if(this.showTooltip){if(this.tooltipTimeout&&clearTimeout(this.tooltipTimeout),this.leftButtonDown)return void this._hideTooltip();if(this.tooltip&&this.tooltip.dataPoint){var a=this._dataPointFromXY(n,s);a!==this.tooltip.dataPoint&&(a?this._showTooltip(a):this._hideTooltip())}else{var h=this;this.tooltipTimeout=setTimeout(function(){h.tooltipTimeout=null;var t=h._dataPointFromXY(n,s);t&&h._showTooltip(t)},e)}}},n.prototype._onTouchStart=function(t){this.touchDown=!0;var e=this;this.ontouchmove=function(t){e._onTouchMove(t)},this.ontouchend=function(t){e._onTouchEnd(t)},l.addEventListener(document,"touchmove",e.ontouchmove),l.addEventListener(document,"touchend",e.ontouchend),this._onMouseDown(t)},n.prototype._onTouchMove=function(t){this._onMouseMove(t)},n.prototype._onTouchEnd=function(t){this.touchDown=!1,l.removeEventListener(document,"touchmove",this.ontouchmove),l.removeEventListener(document,"touchend",this.ontouchend),this._onMouseUp(t)},n.prototype._onWheel=function(t){t||(t=window.event);var e=0;if(t.wheelDelta?e=t.wheelDelta/120:t.detail&&(e=-t.detail/3),e){var i=this.camera.getArmLength(),n=i*(1-e/10);this.camera.setArmLength(n),this.redraw(),this._hideTooltip()}var r=this.getCameraPosition();this.emit("cameraPositionChange",r),l.preventDefault(t)},n.prototype._insideTriangle=function(t,e){function i(t){return t>0?1:t<0?-1:0}var n=e[0],r=e[1],o=e[2],s=i((r.x-n.x)*(t.y-n.y)-(r.y-n.y)*(t.x-n.x)),a=i((o.x-r.x)*(t.y-r.y)-(o.y-r.y)*(t.x-r.x)),h=i((n.x-o.x)*(t.y-o.y)-(n.y-o.y)*(t.x-o.x));return!(0!=s&&0!=a&&s!=a||0!=a&&0!=h&&a!=h||0!=s&&0!=h&&s!=h)},n.prototype._dataPointFromXY=function(t,e){var i,r=100,o=null,s=null,a=null,h=new d(t,e);if(this.style===n.STYLE.BAR||this.style===n.STYLE.BARCOLOR||this.style===n.STYLE.BARSIZE)for(i=this.dataPoints.length-1;i>=0;i--){o=this.dataPoints[i];var l=o.surfaces;if(l)for(var u=l.length-1;u>=0;u--){var c=l[u],f=c.corners,p=[f[0].screen,f[1].screen,f[2].screen],m=[f[2].screen,f[3].screen,f[0].screen];if(this._insideTriangle(h,p)||this._insideTriangle(h,m))return o}}else for(i=0;i<this.dataPoints.length;i++){o=this.dataPoints[i];var v=o.screen;if(v){var y=Math.abs(t-v.x),g=Math.abs(e-v.y),_=Math.sqrt(y*y+g*g);(null===a||_<a)&&_<r&&(a=_,s=o)}}return s},n.prototype._showTooltip=function(t){var e,i,n;this.tooltip?(e=this.tooltip.dom.content,i=this.tooltip.dom.line,n=this.tooltip.dom.dot):(e=document.createElement("div"),e.style.position="absolute",e.style.padding="10px",e.style.border="1px solid #4d4d4d",e.style.color="#1a1a1a",e.style.background="rgba(255,255,255,0.7)",e.style.borderRadius="2px",e.style.boxShadow="5px 5px 10px rgba(128,128,128,0.5)",i=document.createElement("div"),i.style.position="absolute",i.style.height="40px",i.style.width="0",i.style.borderLeft="1px solid #4d4d4d",n=document.createElement("div"),n.style.position="absolute",n.style.height="0",n.style.width="0",n.style.border="5px solid #4d4d4d",n.style.borderRadius="5px",this.tooltip={dataPoint:null,dom:{content:e,line:i,dot:n}}),this._hideTooltip(),this.tooltip.dataPoint=t,"function"==typeof this.showTooltip?e.innerHTML=this.showTooltip(t.point):e.innerHTML="<table><tr><td>"+this.xLabel+":</td><td>"+t.point.x+"</td></tr><tr><td>"+this.yLabel+":</td><td>"+t.point.y+"</td></tr><tr><td>"+this.zLabel+":</td><td>"+t.point.z+"</td></tr></table>",e.style.left="0",e.style.top="0",this.frame.appendChild(e),this.frame.appendChild(i),this.frame.appendChild(n);var r=e.offsetWidth,o=e.offsetHeight,s=i.offsetHeight,a=n.offsetWidth,h=n.offsetHeight,l=t.screen.x-r/2;l=Math.min(Math.max(l,10),this.frame.clientWidth-10-r),i.style.left=t.screen.x+"px",i.style.top=t.screen.y-s+"px",e.style.left=l+"px",e.style.top=t.screen.y-s-o+"px",n.style.left=t.screen.x-a/2+"px",n.style.top=t.screen.y-h/2+"px"},n.prototype._hideTooltip=function(){if(this.tooltip){this.tooltip.dataPoint=null;for(var t in this.tooltip.dom)if(this.tooltip.dom.hasOwnProperty(t)){var e=this.tooltip.dom[t];e&&e.parentNode&&e.parentNode.removeChild(e)}}},n.prototype.setCameraPosition=function(t){v.setCameraPosition(t,this),this.redraw()},t.exports=n},function(t,e){function i(t){if(t)return n(t)}function n(t){for(var e in i.prototype)t[e]=i.prototype[e];return t}t.exports=i,i.prototype.on=i.prototype.addEventListener=function(t,e){return this._callbacks=this._callbacks||{},(this._callbacks[t]=this._callbacks[t]||[]).push(e),this},i.prototype.once=function(t,e){function i(){n.off(t,i),e.apply(this,arguments)}var n=this;return this._callbacks=this._callbacks||{},i.fn=e,this.on(t,i),this},i.prototype.off=i.prototype.removeListener=i.prototype.removeAllListeners=i.prototype.removeEventListener=function(t,e){if(this._callbacks=this._callbacks||{},0==arguments.length)return this._callbacks={},this;var i=this._callbacks[t];if(!i)return this;if(1==arguments.length)return delete this._callbacks[t],this;for(var n,r=0;r<i.length;r++)if(n=i[r],n===e||n.fn===e){i.splice(r,1);break}return this},i.prototype.emit=function(t){this._callbacks=this._callbacks||{};var e=[].slice.call(arguments,1),i=this._callbacks[t];if(i){i=i.slice(0);for(var n=0,r=i.length;n<r;++n)i[n].apply(this,e)}return this},i.prototype.listeners=function(t){return this._callbacks=this._callbacks||{},this._callbacks[t]||[]},i.prototype.hasListeners=function(t){return!!this.listeners(t).length}},function(t,e){function i(t,e,i){this.x=void 0!==t?t:0,this.y=void 0!==e?e:0,this.z=void 0!==i?i:0}i.subtract=function(t,e){var n=new i;return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n},i.add=function(t,e){var n=new i;return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n},i.avg=function(t,e){return new i((t.x+e.x)/2,(t.y+e.y)/2,(t.z+e.z)/2)},i.crossProduct=function(t,e){var n=new i;return n.x=t.y*e.z-t.z*e.y,n.y=t.z*e.x-t.x*e.z,n.z=t.x*e.y-t.y*e.x,n},i.prototype.length=function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},t.exports=i},function(t,e){function i(t,e){this.x=void 0!==t?t:0,this.y=void 0!==e?e:0}t.exports=i},function(t,e,i){function n(){this.armLocation=new r,this.armRotation={},this.armRotation.horizontal=0,this.armRotation.vertical=0,this.armLength=1.7,this.cameraLocation=new r,this.cameraRotation=new r(.5*Math.PI,0,0),this.calculateCameraOrientation()}var r=i(13);n.prototype.setArmLocation=function(t,e,i){this.armLocation.x=t,this.armLocation.y=e,this.armLocation.z=i,this.calculateCameraOrientation()},n.prototype.setArmRotation=function(t,e){void 0!==t&&(this.armRotation.horizontal=t),void 0!==e&&(this.armRotation.vertical=e,this.armRotation.vertical<0&&(this.armRotation.vertical=0),this.armRotation.vertical>.5*Math.PI&&(this.armRotation.vertical=.5*Math.PI)),void 0===t&&void 0===e||this.calculateCameraOrientation()},n.prototype.getArmRotation=function(){var t={};return t.horizontal=this.armRotation.horizontal,t.vertical=this.armRotation.vertical,t},n.prototype.setArmLength=function(t){void 0!==t&&(this.armLength=t,this.armLength<.71&&(this.armLength=.71),this.armLength>5&&(this.armLength=5),this.calculateCameraOrientation())},n.prototype.getArmLength=function(){return this.armLength},n.prototype.getCameraLocation=function(){return this.cameraLocation},n.prototype.getCameraRotation=function(){return this.cameraRotation},n.prototype.calculateCameraOrientation=function(){this.cameraLocation.x=this.armLocation.x-this.armLength*Math.sin(this.armRotation.horizontal)*Math.cos(this.armRotation.vertical),this.cameraLocation.y=this.armLocation.y-this.armLength*Math.cos(this.armRotation.horizontal)*Math.cos(this.armRotation.vertical),this.cameraLocation.z=this.armLocation.z+this.armLength*Math.sin(this.armRotation.vertical),this.cameraRotation.x=Math.PI/2-this.armRotation.vertical,this.cameraRotation.y=0,this.cameraRotation.z=-this.armRotation.horizontal},t.exports=n},function(t,e,i){function n(t,e,i){this.data=t,this.column=e,this.graph=i,this.index=void 0,this.value=void 0,this.values=i.getDistinctValues(t.get(),this.column),this.values.sort(function(t,e){return t>e?1:t<e?-1:0}),this.values.length>0&&this.selectValue(0),this.dataPoints=[],this.loaded=!1,this.onLoadCallback=void 0,i.animationPreload?(this.loaded=!1,this.loadInBackground()):this.loaded=!0}var r=i(10);n.prototype.isLoaded=function(){return this.loaded},n.prototype.getLoadedProgress=function(){for(var t=this.values.length,e=0;this.dataPoints[e];)e++;return Math.round(e/t*100)},n.prototype.getLabel=function(){return this.graph.filterLabel},n.prototype.getColumn=function(){return this.column},n.prototype.getSelectedValue=function(){if(void 0!==this.index)return this.values[this.index]},n.prototype.getValues=function(){return this.values},n.prototype.getValue=function(t){if(t>=this.values.length)throw new Error("Index out of range");return this.values[t]},n.prototype._getDataPoints=function(t){if(void 0===t&&(t=this.index),void 0===t)return[];var e;if(this.dataPoints[t])e=this.dataPoints[t];else{var i={};i.column=this.column,i.value=this.values[t];var n=new r(this.data,{filter:function(t){return t[i.column]==i.value}}).get();e=this.graph._getDataPoints(n),this.dataPoints[t]=e}return e},n.prototype.setOnLoadCallback=function(t){this.onLoadCallback=t},n.prototype.selectValue=function(t){if(t>=this.values.length)throw new Error("Index out of range");this.index=t,this.value=this.values[t]},n.prototype.loadInBackground=function(t){void 0===t&&(t=0);var e=this.graph.frame;if(t<this.values.length){this._getDataPoints(t);void 0===e.progress&&(e.progress=document.createElement("DIV"),e.progress.style.position="absolute",e.progress.style.color="gray",e.appendChild(e.progress));var i=this.getLoadedProgress();e.progress.innerHTML="Loading animation... "+i+"%",e.progress.style.bottom="60px",e.progress.style.left="10px";var n=this;setTimeout(function(){n.loadInBackground(t+1)},10),this.loaded=!1}else this.loaded=!0,void 0!==e.progress&&(e.removeChild(e.progress),e.progress=void 0),this.onLoadCallback&&this.onLoadCallback()},t.exports=n},function(t,e,i){function n(t,e){if(void 0===t)throw new Error("No container element defined");if(this.container=t,this.visible=!e||void 0==e.visible||e.visible,this.visible){this.frame=document.createElement("DIV"),this.frame.style.width="100%",this.frame.style.position="relative",this.container.appendChild(this.frame),this.frame.prev=document.createElement("INPUT"),this.frame.prev.type="BUTTON",this.frame.prev.value="Prev",this.frame.appendChild(this.frame.prev),this.frame.play=document.createElement("INPUT"),this.frame.play.type="BUTTON",this.frame.play.value="Play",this.frame.appendChild(this.frame.play),this.frame.next=document.createElement("INPUT"),this.frame.next.type="BUTTON",this.frame.next.value="Next",this.frame.appendChild(this.frame.next),this.frame.bar=document.createElement("INPUT"),this.frame.bar.type="BUTTON",this.frame.bar.style.position="absolute",this.frame.bar.style.border="1px solid red",this.frame.bar.style.width="100px",this.frame.bar.style.height="6px",this.frame.bar.style.borderRadius="2px",this.frame.bar.style.MozBorderRadius="2px",this.frame.bar.style.border="1px solid #7F7F7F",this.frame.bar.style.backgroundColor="#E5E5E5",this.frame.appendChild(this.frame.bar),this.frame.slide=document.createElement("INPUT"),this.frame.slide.type="BUTTON",this.frame.slide.style.margin="0px",this.frame.slide.value=" ",this.frame.slide.style.position="relative",this.frame.slide.style.left="-100px",this.frame.appendChild(this.frame.slide);var i=this;this.frame.slide.onmousedown=function(t){i._onMouseDown(t)},this.frame.prev.onclick=function(t){i.prev(t)},this.frame.play.onclick=function(t){i.togglePlay(t)},this.frame.next.onclick=function(t){i.next(t)}}this.onChangeCallback=void 0,this.values=[],this.index=void 0,this.playTimeout=void 0,this.playInterval=1e3,this.playLoop=!0}var r=i(1);n.prototype.prev=function(){var t=this.getIndex();t>0&&(t--,this.setIndex(t))},n.prototype.next=function(){var t=this.getIndex();t<this.values.length-1&&(t++,this.setIndex(t))},n.prototype.playNext=function(){var t=new Date,e=this.getIndex();e<this.values.length-1?(e++,this.setIndex(e)):this.playLoop&&(e=0,this.setIndex(e));var i=new Date,n=i-t,r=Math.max(this.playInterval-n,0),o=this;this.playTimeout=setTimeout(function(){o.playNext()},r)},n.prototype.togglePlay=function(){void 0===this.playTimeout?this.play():this.stop()},n.prototype.play=function(){this.playTimeout||(this.playNext(),this.frame&&(this.frame.play.value="Stop"))},n.prototype.stop=function(){clearInterval(this.playTimeout),this.playTimeout=void 0,this.frame&&(this.frame.play.value="Play")},n.prototype.setOnChangeCallback=function(t){this.onChangeCallback=t},n.prototype.setPlayInterval=function(t){this.playInterval=t},n.prototype.getPlayInterval=function(t){return this.playInterval},n.prototype.setPlayLoop=function(t){this.playLoop=t},n.prototype.onChange=function(){void 0!==this.onChangeCallback&&this.onChangeCallback()},n.prototype.redraw=function(){if(this.frame){this.frame.bar.style.top=this.frame.clientHeight/2-this.frame.bar.offsetHeight/2+"px",this.frame.bar.style.width=this.frame.clientWidth-this.frame.prev.clientWidth-this.frame.play.clientWidth-this.frame.next.clientWidth-30+"px";var t=this.indexToLeft(this.index);this.frame.slide.style.left=t+"px"}},n.prototype.setValues=function(t){this.values=t,this.values.length>0?this.setIndex(0):this.index=void 0},n.prototype.setIndex=function(t){if(!(t<this.values.length))throw new Error("Index out of range");this.index=t,this.redraw(),this.onChange()},n.prototype.getIndex=function(){return this.index},n.prototype.get=function(){return this.values[this.index]},n.prototype._onMouseDown=function(t){var e=t.which?1===t.which:1===t.button;if(e){this.startClientX=t.clientX,this.startSlideX=parseFloat(this.frame.slide.style.left),this.frame.style.cursor="move";var i=this;this.onmousemove=function(t){i._onMouseMove(t)},this.onmouseup=function(t){i._onMouseUp(t)},r.addEventListener(document,"mousemove",this.onmousemove),r.addEventListener(document,"mouseup",this.onmouseup),r.preventDefault(t)}},n.prototype.leftToIndex=function(t){var e=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10,i=t-3,n=Math.round(i/e*(this.values.length-1));return n<0&&(n=0),n>this.values.length-1&&(n=this.values.length-1),n},n.prototype.indexToLeft=function(t){var e=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10,i=t/(this.values.length-1)*e,n=i+3;return n},n.prototype._onMouseMove=function(t){var e=t.clientX-this.startClientX,i=this.startSlideX+e,n=this.leftToIndex(i);this.setIndex(n),r.preventDefault()},n.prototype._onMouseUp=function(t){this.frame.style.cursor="auto",r.removeEventListener(document,"mousemove",this.onmousemove),r.removeEventListener(document,"mouseup",this.onmouseup),r.preventDefault()},t.exports=n},function(t,e){function i(t,e,i,n){this._start=0,this._end=0,this._step=1,this.prettyStep=!0,this.precision=5,this._current=0,this.setRange(t,e,i,n)}i.prototype.isNumeric=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},i.prototype.setRange=function(t,e,i,n){if(!this.isNumeric(t))throw new Error("Parameter 'start' is not numeric; value: "+t);if(!this.isNumeric(e))throw new Error("Parameter 'end' is not numeric; value: "+t);if(!this.isNumeric(i))throw new Error("Parameter 'step' is not numeric; value: "+t);this._start=t?t:0,this._end=e?e:0,this.setStep(i,n)},i.prototype.setStep=function(t,e){void 0===t||t<=0||(void 0!==e&&(this.prettyStep=e),this.prettyStep===!0?this._step=i.calculatePrettyStep(t):this._step=t)},i.calculatePrettyStep=function(t){var e=function(t){return Math.log(t)/Math.LN10},i=Math.pow(10,Math.round(e(t))),n=2*Math.pow(10,Math.round(e(t/2))),r=5*Math.pow(10,Math.round(e(t/5))),o=i;return Math.abs(n-t)<=Math.abs(o-t)&&(o=n),Math.abs(r-t)<=Math.abs(o-t)&&(o=r),o<=0&&(o=1),o},i.prototype.getCurrent=function(){return parseFloat(this._current.toPrecision(this.precision))},i.prototype.getStep=function(){return this._step},i.prototype.start=function(t){void 0===t&&(t=!1),this._current=this._start-this._start%this._step,t&&this.getCurrent()<this._start&&this.next()},i.prototype.next=function(){this._current+=this._step},i.prototype.end=function(){return this._current>this._end},t.exports=i},function(t,e){function i(){this.min=void 0,this.max=void 0}i.prototype.adjust=function(t){void 0!==t&&((void 0===this.min||this.min>t)&&(this.min=t),(void 0===this.max||this.max<t)&&(this.max=t))},i.prototype.combine=function(t){this.add(t.min),this.add(t.max)},i.prototype.expand=function(t){if(void 0!==t){var e=this.min-t,i=this.max+t;if(e>i)throw new Error("Passed expansion value makes range invalid");this.min=e,this.max=i}},i.prototype.range=function(){return this.max-this.min},i.prototype.center=function(){return(this.min+this.max)/2},t.exports=i},function(t,e,i){function n(t){for(var e in t)if(t.hasOwnProperty(e))return!1;return!0}function r(t){return void 0===t||""===t?t:t.charAt(0).toUpperCase()+t.slice(1)}function o(t,e){return void 0===t||""===t?e:t+r(e)}function s(t,e,i,n){var r,s;for(var a in i)r=i[a],s=o(n,r),e[s]=t[r]}function a(t,e,i,n){var r,s;for(var a in i)r=i[a],void 0!==t[r]&&(s=o(n,r),e[s]=t[r])}function h(t,e){if(void 0===t||n(t))throw new Error("No DEFAULTS passed");if(void 0===e)throw new Error("No dst passed");D=t,s(t,e,S),s(t,e,T,"default"),u(t,e),e.margin=10,e.showGrayBottom=!1,e.showTooltip=!1,e.eye=new w(0,0,-1)}function l(t,e){if(void 0!==t){if(void 0===e)throw new Error("No dst passed");if(void 0===D||n(D))throw new Error("DEFAULTS not set for module Settings");a(t,e,S),a(t,e,T,"default"),u(t,e)}}function u(t,e){void 0!==t.backgroundColor&&m(t.backgroundColor,e),v(t.dataColor,e),p(t.style,e),d(t.showLegend,e),y(t.cameraPosition,e),void 0!==t.tooltip&&(e.showTooltip=t.tooltip)}function d(t,e){if(void 0===t){var i=void 0===D.showLegend;if(i){var n=e.style===x.DOTCOLOR||e.style===x.DOTSIZE;e.showLegend=n}}else e.showLegend=t}function c(t){var e=b[t];return void 0===e?-1:e}function f(t){var e=!1;for(var i in x)if(x[i]===t){e=!0;break}return e}function p(t,e){if(void 0!==t){var i;if("string"==typeof t){if(i=c(t),i===-1)throw new Error("Style '"+t+"' is invalid")}else{if(!f(t))throw new Error("Style '"+t+"' is invalid");i=t}e.style=i}}function m(t,e){var i="white",n="gray",r=1;if("string"==typeof t)i=t,n="none",r=0;else{if("object"!==("undefined"==typeof t?"undefined":g(t)))throw new Error("Unsupported type of backgroundColor");void 0!==t.fill&&(i=t.fill),void 0!==t.stroke&&(n=t.stroke),void 0!==t.strokeWidth&&(r=t.strokeWidth)}e.frame.style.backgroundColor=i,e.frame.style.borderColor=n,e.frame.style.borderWidth=r+"px",e.frame.style.borderStyle="solid"}function v(t,e){void 0!==t&&(void 0===e.dataColor&&(e.dataColor={}),"string"==typeof t?(e.dataColor.fill=t,e.dataColor.stroke=t):(t.fill&&(e.dataColor.fill=t.fill),t.stroke&&(e.dataColor.stroke=t.stroke),void 0!==t.strokeWidth&&(e.dataColor.strokeWidth=t.strokeWidth)))}function y(t,e){var i=t;void 0!==i&&(void 0===e.camera&&(e.camera=new _),e.camera.setArmRotation(i.horizontal,i.vertical),e.camera.setArmLength(i.distance))}var g="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},_=i(15),w=i(13),x={BAR:0,BARCOLOR:1,BARSIZE:2,DOT:3,DOTLINE:4,DOTCOLOR:5,DOTSIZE:6,GRID:7,LINE:8,SURFACE:9},b={dot:x.DOT,"dot-line":x.DOTLINE,"dot-color":x.DOTCOLOR,"dot-size":x.DOTSIZE,line:x.LINE,grid:x.GRID,surface:x.SURFACE,bar:x.BAR,"bar-color":x.BARCOLOR,"bar-size":x.BARSIZE},S=["width","height","filterLabel","legendLabel","xLabel","yLabel","zLabel","xValueLabel","yValueLabel","zValueLabel","showGrid","showPerspective","showShadow","keepAspectRatio","verticalRatio","dotSizeRatio","showAnimationControls","animationInterval","animationPreload","animationAutoStart","axisColor","gridColor","xCenter","yCenter"],T=["xBarWidth","yBarWidth","valueMin","valueMax","xMin","xMax","xStep","yMin","yMax","yStep","zMin","zMax","zStep"],D=void 0;t.exports.STYLE=x,t.exports.setDefaults=h,t.exports.setOptions=l,t.exports.setCameraPosition=y},function(t,e,i){if("undefined"!=typeof window){var n=i(22),r=window.Hammer||i(23);t.exports=n(r,{preventDefault:"mouse"})}else t.exports=function(){throw Error("hammer.js is only available in a browser, not in node.js.")}},function(t,e,i){var n,r,o;!function(i){r=[],n=i,o="function"==typeof n?n.apply(e,r):n,!(void 0!==o&&(t.exports=o))}(function(){var t=null;return function e(i,n){function r(t){return t.match(/[^ ]+/g)}function o(e){if("hammer.input"!==e.type){if(e.srcEvent._handled||(e.srcEvent._handled={}),e.srcEvent._handled[e.type])return;e.srcEvent._handled[e.type]=!0}var i=!1;e.stopPropagation=function(){i=!0};var n=e.srcEvent.stopPropagation.bind(e.srcEvent);"function"==typeof n&&(e.srcEvent.stopPropagation=function(){n(),e.stopPropagation()}),e.firstTarget=t;for(var r=t;r&&!i;){var o=r.hammer;if(o)for(var s,a=0;a<o.length;a++)if(s=o[a]._handlers[e.type])for(var h=0;h<s.length&&!i;h++)s[h](e);r=r.parentNode}}var s=n||{preventDefault:!1};if(i.Manager){var a=i,h=function(t,i){var n=Object.create(s);return i&&a.assign(n,i),e(new a(t,n),n)};return a.assign(h,a),h.Manager=function(t,i){var n=Object.create(s);return i&&a.assign(n,i),e(new a.Manager(t,n),n)},h}var l=Object.create(i),u=i.element;return u.hammer||(u.hammer=[]),u.hammer.push(l),i.on("hammer.input",function(e){s.preventDefault!==!0&&s.preventDefault!==e.pointerType||e.preventDefault(),e.isFirst&&(t=e.target)}),l._handlers={},l.on=function(t,e){return r(t).forEach(function(t){var n=l._handlers[t];n||(l._handlers[t]=n=[],i.on(t,o)),n.push(e)}),l},l.off=function(t,e){return r(t).forEach(function(t){var n=l._handlers[t];n&&(n=e?n.filter(function(t){return t!==e}):[],n.length>0?l._handlers[t]=n:(i.off(t,o),delete l._handlers[t]))}),l},l.emit=function(e,n){t=n.target,i.emit(e,n)},l.destroy=function(){var t=i.element.hammer,e=t.indexOf(l);e!==-1&&t.splice(e,1),t.length||delete i.element.hammer,l._handlers={},i.destroy()},l}})},function(t,e,i){var n;/*! Hammer.JS - v2.0.7 - 2016-04-22
   * http://hammerjs.github.io/
   *
   * Copyright (c) 2016 Jorik Tangelder;
   * Licensed under the MIT license */
!function(r,o,s,a){function h(t,e,i){return setTimeout(f(t,i),e)}function l(t,e,i){return!!Array.isArray(t)&&(u(t,i[e],i),!0)}function u(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==a)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function d(t,e,i){var n="DEPRECATED METHOD: "+e+"\n"+i+" AT \n";return function(){var e=new Error("get-stack-trace"),i=e&&e.stack?e.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",o=r.console&&(r.console.warn||r.console.log);return o&&o.call(r.console,n,i),t.apply(this,arguments)}}function c(t,e,i){var n,r=e.prototype;n=t.prototype=Object.create(r),n.constructor=t,n._super=r,i&&mt(n,i)}function f(t,e){return function(){return t.apply(e,arguments)}}function p(t,e){return typeof t==gt?t.apply(e?e[0]||a:a,e):t}function m(t,e){return t===a?e:t}function v(t,e,i){u(w(e),function(e){t.addEventListener(e,i,!1)})}function y(t,e,i){u(w(e),function(e){t.removeEventListener(e,i,!1)})}function g(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function _(t,e){return t.indexOf(e)>-1}function w(t){return t.trim().split(/\s+/g)}function x(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function b(t){return Array.prototype.slice.call(t,0)}function S(t,e,i){for(var n=[],r=[],o=0;o<t.length;){var s=e?t[o][e]:t[o];x(r,s)<0&&n.push(t[o]),r[o]=s,o++}return i&&(n=e?n.sort(function(t,i){return t[e]>i[e]}):n.sort()),n}function T(t,e){for(var i,n,r=e[0].toUpperCase()+e.slice(1),o=0;o<vt.length;){if(i=vt[o],n=i?i+r:e,n in t)return n;o++}return a}function D(){return Tt++}function k(t){var e=t.ownerDocument||t;return e.defaultView||e.parentWindow||r}function M(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){p(t.options.enable,[t])&&i.handler(e)},this.init()}function C(t){var e,i=t.options.inputClass;return new(e=i?i:Mt?j:Ct?U:kt?X:G)(t,E)}function E(t,e,i){var n=i.pointers.length,r=i.changedPointers.length,o=e&Yt&&n-r===0,s=e&(It|Wt)&&n-r===0;i.isFirst=!!o,i.isFinal=!!s,o&&(t.session={}),i.eventType=e,O(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function O(t,e){var i=t.session,n=e.pointers,r=n.length;i.firstInput||(i.firstInput=R(e)),r>1&&!i.firstMultiple?i.firstMultiple=R(e):1===r&&(i.firstMultiple=!1);var o=i.firstInput,s=i.firstMultiple,a=s?s.center:o.center,h=e.center=Y(n);e.timeStamp=xt(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=z(a,h),e.distance=W(a,h),P(i,e),e.offsetDirection=I(e.deltaX,e.deltaY);var l=A(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=l.x,e.overallVelocityY=l.y,e.overallVelocity=wt(l.x)>wt(l.y)?l.x:l.y,e.scale=s?F(s.pointers,n):1,e.rotation=s?N(s.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,L(i,e);var u=t.element;g(e.srcEvent.target,u)&&(u=e.srcEvent.target),e.target=u}function P(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},o=t.prevInput||{};e.eventType!==Yt&&o.eventType!==It||(r=t.prevDelta={x:o.deltaX||0,y:o.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y}),e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}function L(t,e){var i,n,r,o,s=t.lastInterval||e,h=e.timeStamp-s.timeStamp;if(e.eventType!=Wt&&(h>Rt||s.velocity===a)){var l=e.deltaX-s.deltaX,u=e.deltaY-s.deltaY,d=A(h,l,u);n=d.x,r=d.y,i=wt(d.x)>wt(d.y)?d.x:d.y,o=I(l,u),t.lastInterval=e}else i=s.velocity,n=s.velocityX,r=s.velocityY,o=s.direction;e.velocity=i,e.velocityX=n,e.velocityY=r,e.direction=o}function R(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:_t(t.pointers[i].clientX),clientY:_t(t.pointers[i].clientY)},i++;return{timeStamp:xt(),pointers:e,center:Y(e),deltaX:t.deltaX,deltaY:t.deltaY}}function Y(t){var e=t.length;if(1===e)return{x:_t(t[0].clientX),y:_t(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:_t(i/e),y:_t(n/e)}}function A(t,e,i){return{x:e/t||0,y:i/t||0}}function I(t,e){return t===e?zt:wt(t)>=wt(e)?t<0?Nt:Ft:e<0?Gt:jt}function W(t,e,i){i||(i=Ht);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function z(t,e,i){i||(i=Ht);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}function N(t,e){return z(e[1],e[0],Xt)+z(t[1],t[0],Xt)}function F(t,e){return W(e[0],e[1],Xt)/W(t[0],t[1],Xt)}function G(){this.evEl=qt,this.evWin=Qt,this.pressed=!1,M.apply(this,arguments)}function j(){this.evEl=Kt,this.evWin=te,M.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}function V(){this.evTarget=ie,this.evWin=ne,this.started=!1,M.apply(this,arguments)}function B(t,e){var i=b(t.touches),n=b(t.changedTouches);return e&(It|Wt)&&(i=S(i.concat(n),"identifier",!0)),[i,n]}function U(){this.evTarget=oe,this.targetIds={},M.apply(this,arguments)}function H(t,e){var i=b(t.touches),n=this.targetIds;if(e&(Yt|At)&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,o,s=b(t.changedTouches),a=[],h=this.target;if(o=i.filter(function(t){return g(t.target,h)}),e===Yt)for(r=0;r<o.length;)n[o[r].identifier]=!0,r++;for(r=0;r<s.length;)n[s[r].identifier]&&a.push(s[r]),e&(It|Wt)&&delete n[s[r].identifier],r++;return a.length?[S(o.concat(a),"identifier",!0),a]:void 0}function X(){M.apply(this,arguments);var t=f(this.handler,this);this.touch=new U(this.manager,t),this.mouse=new G(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function Z(t,e){t&Yt?(this.primaryTouch=e.changedPointers[0].identifier,q.call(this,e)):t&(It|Wt)&&q.call(this,e)}function q(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches,r=function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)};setTimeout(r,se)}}function Q(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],o=Math.abs(e-r.x),s=Math.abs(i-r.y);if(o<=ae&&s<=ae)return!0}return!1}function $(t,e){this.manager=t,this.set(e)}function J(t){if(_(t,fe))return fe;var e=_(t,pe),i=_(t,me);return e&&i?fe:e||i?e?pe:me:_(t,ce)?ce:de}function K(){if(!le)return!1;var t={},e=r.CSS&&r.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(i){t[i]=!e||r.CSS.supports("touch-action",i)}),t}function tt(t){this.options=mt({},this.defaults,t||{}),this.id=D(),this.manager=null,this.options.enable=m(this.options.enable,!0),this.state=ye,this.simultaneous={},this.requireFail=[]}function et(t){return t&be?"cancel":t&we?"end":t&_e?"move":t&ge?"start":""}function it(t){return t==jt?"down":t==Gt?"up":t==Nt?"left":t==Ft?"right":""}function nt(t,e){var i=e.manager;return i?i.get(t):t}function rt(){tt.apply(this,arguments)}function ot(){rt.apply(this,arguments),this.pX=null,this.pY=null}function st(){rt.apply(this,arguments)}function at(){tt.apply(this,arguments),this._timer=null,this._input=null}function ht(){rt.apply(this,arguments)}function lt(){rt.apply(this,arguments)}function ut(){tt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function dt(t,e){return e=e||{},e.recognizers=m(e.recognizers,dt.defaults.preset),new ct(t,e)}function ct(t,e){this.options=mt({},dt.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=C(this),this.touchAction=new $(this,this.options.touchAction),ft(this,!0),u(this.options.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function ft(t,e){var i=t.element;if(i.style){var n;u(t.options.cssProps,function(r,o){n=T(i.style,o),e?(t.oldCssProps[n]=i.style[n],i.style[n]=r):i.style[n]=t.oldCssProps[n]||""}),e||(t.oldCssProps={})}}function pt(t,e){var i=o.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}var mt,vt=["","webkit","Moz","MS","ms","o"],yt=o.createElement("div"),gt="function",_t=Math.round,wt=Math.abs,xt=Date.now;mt="function"!=typeof Object.assign?function(t){if(t===a||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==a&&null!==n)for(var r in n)n.hasOwnProperty(r)&&(e[r]=n[r])}return e}:Object.assign;var bt=d(function(t,e,i){for(var n=Object.keys(e),r=0;r<n.length;)(!i||i&&t[n[r]]===a)&&(t[n[r]]=e[n[r]]),r++;return t},"extend","Use `assign`."),St=d(function(t,e){return bt(t,e,!0)},"merge","Use `assign`."),Tt=1,Dt=/mobile|tablet|ip(ad|hone|od)|android/i,kt="ontouchstart"in r,Mt=T(r,"PointerEvent")!==a,Ct=kt&&Dt.test(navigator.userAgent),Et="touch",Ot="pen",Pt="mouse",Lt="kinect",Rt=25,Yt=1,At=2,It=4,Wt=8,zt=1,Nt=2,Ft=4,Gt=8,jt=16,Vt=Nt|Ft,Bt=Gt|jt,Ut=Vt|Bt,Ht=["x","y"],Xt=["clientX","clientY"];M.prototype={handler:function(){},init:function(){this.evEl&&v(this.element,this.evEl,this.domHandler),this.evTarget&&v(this.target,this.evTarget,this.domHandler),this.evWin&&v(k(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&y(this.element,this.evEl,this.domHandler),this.evTarget&&y(this.target,this.evTarget,this.domHandler),this.evWin&&y(k(this.element),this.evWin,this.domHandler)}};var Zt={mousedown:Yt,mousemove:At,mouseup:It},qt="mousedown",Qt="mousemove mouseup";c(G,M,{handler:function(t){var e=Zt[t.type];e&Yt&&0===t.button&&(this.pressed=!0),e&At&&1!==t.which&&(e=It),this.pressed&&(e&It&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:Pt,srcEvent:t}))}});var $t={pointerdown:Yt,pointermove:At,pointerup:It,pointercancel:Wt,pointerout:Wt},Jt={2:Et,3:Ot,4:Pt,5:Lt},Kt="pointerdown",te="pointermove pointerup pointercancel";r.MSPointerEvent&&!r.PointerEvent&&(Kt="MSPointerDown",te="MSPointerMove MSPointerUp MSPointerCancel"),c(j,M,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=$t[n],o=Jt[t.pointerType]||t.pointerType,s=o==Et,a=x(e,t.pointerId,"pointerId");r&Yt&&(0===t.button||s)?a<0&&(e.push(t),a=e.length-1):r&(It|Wt)&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:o,srcEvent:t}),i&&e.splice(a,1))}});var ee={touchstart:Yt,touchmove:At,touchend:It,touchcancel:Wt},ie="touchstart",ne="touchstart touchmove touchend touchcancel";c(V,M,{handler:function(t){var e=ee[t.type];if(e===Yt&&(this.started=!0),this.started){var i=B.call(this,t,e);e&(It|Wt)&&i[0].length-i[1].length===0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:Et,srcEvent:t})}}});var re={touchstart:Yt,touchmove:At,touchend:It,touchcancel:Wt},oe="touchstart touchmove touchend touchcancel";c(U,M,{handler:function(t){var e=re[t.type],i=H.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:Et,srcEvent:t})}});var se=2500,ae=25;c(X,M,{handler:function(t,e,i){var n=i.pointerType==Et,r=i.pointerType==Pt;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)Z.call(this,e,i);else if(r&&Q.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var he=T(yt.style,"touchAction"),le=he!==a,ue="compute",de="auto",ce="manipulation",fe="none",pe="pan-x",me="pan-y",ve=K();$.prototype={set:function(t){t==ue&&(t=this.compute()),le&&this.manager.element.style&&ve[t]&&(this.manager.element.style[he]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return u(this.manager.recognizers,function(e){p(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),J(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)return void e.preventDefault();var n=this.actions,r=_(n,fe)&&!ve[fe],o=_(n,me)&&!ve[me],s=_(n,pe)&&!ve[pe];if(r){var a=1===t.pointers.length,h=t.distance<2,l=t.deltaTime<250;if(a&&h&&l)return}return s&&o?void 0:r||o&&i&Vt||s&&i&Bt?this.preventSrc(e):void 0},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var ye=1,ge=2,_e=4,we=8,xe=we,be=16,Se=32;tt.prototype={defaults:{},set:function(t){return mt(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(l(t,"recognizeWith",this))return this;var e=this.simultaneous;return t=nt(t,this),e[t.id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return l(t,"dropRecognizeWith",this)?this:(t=nt(t,this),delete this.simultaneous[t.id],this)},requireFailure:function(t){if(l(t,"requireFailure",this))return this;var e=this.requireFail;return t=nt(t,this),x(e,t)===-1&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(l(t,"dropRequireFailure",this))return this;t=nt(t,this);var e=x(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){function e(e){i.manager.emit(e,t)}var i=this,n=this.state;n<we&&e(i.options.event+et(n)),e(i.options.event),t.additionalEvent&&e(t.additionalEvent),n>=we&&e(i.options.event+et(n))},tryEmit:function(t){return this.canEmit()?this.emit(t):void(this.state=Se)},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(Se|ye)))return!1;t++}return!0},recognize:function(t){var e=mt({},t);return p(this.options.enable,[this,e])?(this.state&(xe|be|Se)&&(this.state=ye),this.state=this.process(e),void(this.state&(ge|_e|we|be)&&this.tryEmit(e))):(this.reset(),void(this.state=Se))},process:function(t){},getTouchAction:function(){},reset:function(){}},c(rt,tt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=e&(ge|_e),r=this.attrTest(t);return n&&(i&Wt||!r)?e|be:n||r?i&It?e|we:e&ge?e|_e:ge:Se}}),c(ot,rt,{defaults:{event:"pan",threshold:10,pointers:1,direction:Ut},getTouchAction:function(){var t=this.options.direction,e=[];return t&Vt&&e.push(me),t&Bt&&e.push(pe),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,o=t.deltaX,s=t.deltaY;return r&e.direction||(e.direction&Vt?(r=0===o?zt:o<0?Nt:Ft,i=o!=this.pX,n=Math.abs(t.deltaX)):(r=0===s?zt:s<0?Gt:jt,i=s!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return rt.prototype.attrTest.call(this,t)&&(this.state&ge||!(this.state&ge)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=it(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),c(st,rt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[fe]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||this.state&ge)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),c(at,tt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[de]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||t.eventType&(It|Wt)&&!r)this.reset();else if(t.eventType&Yt)this.reset(),this._timer=h(function(){this.state=xe,this.tryEmit()},e.time,this);else if(t.eventType&It)return xe;return Se},reset:function(){clearTimeout(this._timer)},emit:function(t){this.state===xe&&(t&&t.eventType&It?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=xt(),this.manager.emit(this.options.event,this._input)))}}),c(ht,rt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[fe]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||this.state&ge)}}),c(lt,rt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:Vt|Bt,pointers:1},getTouchAction:function(){return ot.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return i&(Vt|Bt)?e=t.overallVelocity:i&Vt?e=t.overallVelocityX:i&Bt&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&wt(e)>this.options.velocity&&t.eventType&It},emit:function(t){var e=it(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),c(ut,tt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[ce]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),t.eventType&Yt&&0===this.count)return this.failTimeout();if(n&&r&&i){if(t.eventType!=It)return this.failTimeout();var o=!this.pTime||t.timeStamp-this.pTime<e.interval,s=!this.pCenter||W(this.pCenter,t.center)<e.posThreshold;this.pTime=t.timeStamp,this.pCenter=t.center,s&&o?this.count+=1:this.count=1,this._input=t;var a=this.count%e.taps;if(0===a)return this.hasRequireFailures()?(this._timer=h(function(){this.state=xe,this.tryEmit()},e.interval,this),ge):xe}return Se},failTimeout:function(){return this._timer=h(function(){this.state=Se},this.options.interval,this),Se},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==xe&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),dt.VERSION="2.0.7",dt.defaults={domEvents:!1,touchAction:ue,enable:!0,inputTarget:null,inputClass:null,preset:[[ht,{enable:!1}],[st,{enable:!1},["rotate"]],[lt,{direction:Vt}],[ot,{direction:Vt},["swipe"]],[ut],[ut,{event:"doubletap",taps:2},["tap"]],[at]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};var Te=1,De=2;ct.prototype={set:function(t){return mt(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?De:Te},recognize:function(t){var e=this.session;if(!e.stopped){this.touchAction.preventDefaults(t);var i,n=this.recognizers,r=e.curRecognizer;(!r||r&&r.state&xe)&&(r=e.curRecognizer=null);for(var o=0;o<n.length;)i=n[o],e.stopped===De||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&i.state&(ge|_e|we)&&(r=e.curRecognizer=i),o++}},get:function(t){if(t instanceof tt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(l(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(l(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=x(e,t);i!==-1&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==a&&e!==a){var i=this.handlers;return u(w(t),function(t){i[t]=i[t]||[],i[t].push(e)}),this}},off:function(t,e){if(t!==a){var i=this.handlers;return u(w(t),function(t){e?i[t]&&i[t].splice(x(i[t],e),1):delete i[t]}),this}},emit:function(t,e){this.options.domEvents&&pt(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var n=0;n<i.length;)i[n](e),n++}},destroy:function(){this.element&&ft(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},mt(dt,{INPUT_START:Yt,INPUT_MOVE:At,INPUT_END:It,INPUT_CANCEL:Wt,STATE_POSSIBLE:ye,STATE_BEGAN:ge,STATE_CHANGED:_e,STATE_ENDED:we,STATE_RECOGNIZED:xe,STATE_CANCELLED:be,STATE_FAILED:Se,DIRECTION_NONE:zt,DIRECTION_LEFT:Nt,DIRECTION_RIGHT:Ft,DIRECTION_UP:Gt,DIRECTION_DOWN:jt,DIRECTION_HORIZONTAL:Vt,DIRECTION_VERTICAL:Bt,DIRECTION_ALL:Ut,Manager:ct,Input:M,TouchAction:$,TouchInput:U,MouseInput:G,PointerEventInput:j,TouchMouseInput:X,SingleTouchInput:V,Recognizer:tt,AttrRecognizer:rt,Tap:ut,Pan:ot,Swipe:lt,Pinch:st,Rotate:ht,Press:at,on:v,off:y,each:u,merge:St,extend:bt,assign:mt,inherit:c,bindFn:f,prefixed:T});var ke="undefined"!=typeof r?r:"undefined"!=typeof self?self:{};ke.Hammer=dt,n=function(){return dt}.call(e,i,e,t),!(n!==a&&(t.exports=n))}(window,document,"Hammer")},function(t,e,i){var n,r,o;!function(i,s){r=[],n=s,o="function"==typeof n?n.apply(e,r):n,!(void 0!==o&&(t.exports=o))}(this,function(){function t(t){var e,i=t&&t.preventDefault||!1,n=t&&t.container||window,r={},o={keydown:{},keyup:{}},s={};for(e=97;e<=122;e++)s[String.fromCharCode(e)]={code:65+(e-97),shift:!1};for(e=65;e<=90;e++)s[String.fromCharCode(e)]={code:e,shift:!0};for(e=0;e<=9;e++)s[""+e]={code:48+e,shift:!1};for(e=1;e<=12;e++)s["F"+e]={code:111+e,shift:!1};for(e=0;e<=9;e++)s["num"+e]={code:96+e,shift:!1};s["num*"]={code:106,shift:!1},s["num+"]={code:107,shift:!1},s["num-"]={code:109,shift:!1},s["num/"]={code:111,shift:!1},s["num."]={code:110,shift:!1},s.left={code:37,shift:!1},s.up={code:38,shift:!1},s.right={code:39,shift:!1},s.down={code:40,shift:!1},s.space={code:32,shift:!1},s.enter={code:13,shift:!1},s.shift={code:16,shift:void 0},s.esc={code:27,shift:!1},s.backspace={code:8,shift:!1},s.tab={code:9,shift:!1},s.ctrl={code:17,shift:!1},s.alt={code:18,shift:!1},s.delete={code:46,shift:!1},s.pageup={code:33,shift:!1},s.pagedown={code:34,shift:!1},s["="]={code:187,shift:!1},s["-"]={code:189,shift:!1},s["]"]={code:221,shift:!1},s["["]={code:219,shift:!1};var a=function(t){l(t,"keydown")},h=function(t){l(t,"keyup")},l=function(t,e){if(void 0!==o[e][t.keyCode]){for(var n=o[e][t.keyCode],r=0;r<n.length;r++)void 0===n[r].shift?n[r].fn(t):1==n[r].shift&&1==t.shiftKey?n[r].fn(t):0==n[r].shift&&0==t.shiftKey&&n[r].fn(t);1==i&&t.preventDefault()}};return r.bind=function(t,e,i){if(void 0===i&&(i="keydown"),void 0===s[t])throw new Error("unsupported key: "+t);void 0===o[i][s[t].code]&&(o[i][s[t].code]=[]),o[i][s[t].code].push({fn:e,shift:s[t].shift})},r.bindAll=function(t,e){void 0===e&&(e="keydown");for(var i in s)s.hasOwnProperty(i)&&r.bind(i,t,e)},r.getKey=function(t){for(var e in s)if(s.hasOwnProperty(e)){if(1==t.shiftKey&&1==s[e].shift&&t.keyCode==s[e].code)return e;if(0==t.shiftKey&&0==s[e].shift&&t.keyCode==s[e].code)return e;if(t.keyCode==s[e].code&&"shift"==e)return e}return"unknown key, currently not supported"},r.unbind=function(t,e,i){if(void 0===i&&(i="keydown"),void 0===s[t])throw new Error("unsupported key: "+t);if(void 0!==e){var n=[],r=o[i][s[t].code];if(void 0!==r)for(var a=0;a<r.length;a++)r[a].fn==e&&r[a].shift==s[t].shift||n.push(o[i][s[t].code][a]);o[i][s[t].code]=n}else o[i][s[t].code]=[]},r.reset=function(){o={keydown:{},keyup:{}}},r.destroy=function(){o={keydown:{},keyup:{}},n.removeEventListener("keydown",a,!0),n.removeEventListener("keyup",h,!0)},n.addEventListener("keydown",a,!0),n.addEventListener("keyup",h,!0),r}return t})}])});