/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.exception.PdfException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.EncryptionUsed;
import org.jpedal.io.ImageInputStreamFileBuffer;
import org.jpedal.io.NameLookup;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.io.RandomAccessMemoryMapBuffer;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.raw.FDFObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class PdfReader
implements PdfObjectReader,
Serializable {
    private PdfFileReader objectReader = new PdfFileReader();
    Map pagesReferences = new HashMap();
    private PageLookup pageLookup = new PageLookup();
    private long eof = 0L;
    private String tempFileName = null;
    private NameLookup nameLookup = null;
    RandomAccessBuffer pdf_datafile = null;
    private Javascript javascript;

    public PdfReader() {
    }

    public PdfReader(String string) {
        if (string == null) {
            string = "";
        }
        this.objectReader.setPassword(string);
    }

    public PdfReader(Certificate certificate, PrivateKey privateKey) {
        this.objectReader.setCertificate(certificate, privateKey);
    }

    public String getReferenceforPage(int n) {
        return (String)this.pagesReferences.get(n);
    }

    public final void closePdfFile() {
        block4: {
            try {
                this.objectReader.closeFile();
                if (this.pdf_datafile != null) {
                    this.pdf_datafile.close();
                }
                if (this.tempFileName != null) {
                    File file = new File(this.tempFileName);
                    file.delete();
                    this.tempFileName = null;
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception " + exception + " closing file");
            }
        }
    }

    public PdfObject getPDFObject(int n) {
        if (n == 1113489015) {
            return this.objectReader.encyptionObj;
        }
        throw new RuntimeException("Access to " + n + " not supported");
    }

    public PdfFileReader getObjectReader() {
        return this.objectReader;
    }

    public String convertNameToRef(String string) {
        if (this.nameLookup == null) {
            return null;
        }
        return (String)this.nameLookup.get(string);
    }

    public final PdfObject readFDF() throws PdfException {
        FDFObject fDFObject;
        try {
            byte[] byArray = this.objectReader.readFDFData();
            fDFObject = new FDFObject("1 0 R");
            int n = 0;
            while ((long)n < this.eof && (byArray[n] != 47 || byArray[n + 1] != 70 || byArray[n + 2] != 68 || byArray[n + 3] != 70)) {
                ++n;
            }
            n += 4;
            while ((long)n < this.eof && (byArray[n] != 60 || byArray[n + 1] != 60)) {
                ++n;
            }
            ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
            objectDecoder.readDictionaryAsObject(fDFObject, n += 2, byArray);
        }
        catch (Exception exception) {
            block6: {
                try {
                    this.objectReader.closeFile();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception " + exception + " closing file");
                }
            }
            throw new PdfException("Exception " + exception + " reading trailer");
        }
        return fDFObject;
    }

    public void readNames(PdfObject pdfObject, Javascript javascript, boolean bl) {
        this.nameLookup = new NameLookup(this.objectReader);
        this.nameLookup.readNames(pdfObject, javascript, bl);
    }

    public int convertObjectToPageNumber(String string) {
        return this.pageLookup.convertObjectToPageNumber(string);
    }

    public void setLookup(String string, int n) {
        this.pageLookup.put(string, n);
        this.pagesReferences.put(n, string);
    }

    public void dispose() {
        this.nameLookup = null;
        if (this.objectReader != null) {
            this.objectReader.dispose();
        }
        this.objectReader = null;
        if (this.pageLookup != null) {
            this.pageLookup.dispose();
        }
        this.pageLookup = null;
    }

    public final void openPdfFile(InputStream inputStream) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessMemoryMapBuffer(inputStream);
            this.objectReader.init(this.pdf_datafile);
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception + " accessing file");
            }
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(ImageInputStream imageInputStream) throws PdfException {
        try {
            ImageInputStreamFileBuffer imageInputStreamFileBuffer = new ImageInputStreamFileBuffer(imageInputStream);
            this.objectReader.init(imageInputStreamFileBuffer);
            this.eof = imageInputStreamFileBuffer.length();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception + " accessing file");
            }
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public void checkParentForResources(PdfObject pdfObject) {
        String string;
        if (pdfObject.getDictionary(2004251818) == null && (string = pdfObject.getStringKey(1110793845)) != null) {
            PageObject pageObject = new PageObject(string);
            this.readObject(pageObject);
            PdfObject pdfObject2 = ((PdfObject)pageObject).getDictionary(2004251818);
            if (pdfObject2 != null) {
                pdfObject.setDictionary(2004251818, pdfObject2);
            }
        }
    }

    public final void openPdfFile(String string) throws PdfException {
        try {
            RandomAccessFileBuffer randomAccessFileBuffer = new RandomAccessFileBuffer(string, "r");
            this.objectReader.init(randomAccessFileBuffer);
            this.eof = randomAccessFileBuffer.length();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception + " accessing file");
            }
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(byte[] byArray) throws PdfException {
        try {
            RandomAccessBuffer randomAccessBuffer;
            if (PdfFileReader.alwaysCacheInMemory == -1 || byArray.length < PdfFileReader.alwaysCacheInMemory) {
                randomAccessBuffer = new RandomAccessDataBuffer(byArray);
            } else {
                try {
                    File file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
                    this.tempFileName = file.getAbsolutePath();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    randomAccessBuffer = new RandomAccessFileBuffer(this.tempFileName, "r");
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to create temporary file in " + ObjectStore.temp_dir);
                }
            }
            this.objectReader.init(randomAccessBuffer);
            this.eof = randomAccessBuffer.length();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception + " accessing file");
            }
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    public void checkResolved(PdfObject pdfObject) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(pdfObject);
    }

    public byte[] readStream(PdfObject pdfObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        return this.objectReader.readStream(pdfObject, bl, bl2, bl3, bl4, bl5, string);
    }

    public void readObject(PdfObject pdfObject) {
        this.objectReader.readObject(pdfObject);
    }

    public EncryptionUsed getEncryptionType() {
        PdfFileReader pdfFileReader = this.objectReader;
        DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
        if (decryptionFactory == null) {
            return EncryptionUsed.NO_ENCRYPTION;
        }
        if (decryptionFactory.hasPassword()) {
            return EncryptionUsed.PASSWORD;
        }
        return EncryptionUsed.CERTIFICATE;
    }
}

