/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.OS2;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;

public class OS2Writer
extends OS2
implements FontTableWriter {
    int glyphCount = 0;
    int xAvgCharWidth = 0;
    int minCharCode;
    int maxCharCode;
    float[] bounds;
    double scaling = 1.0;
    PdfFont originalFont;
    PdfJavaGlyphs glyphs;

    public OS2Writer(PdfFont pdfFont, PdfJavaGlyphs pdfJavaGlyphs, int n, int n2, int n3, float[] fArray, double d) {
        this.originalFont = pdfFont;
        this.glyphs = pdfJavaGlyphs;
        this.glyphCount = pdfJavaGlyphs.getGlyphCount();
        this.minCharCode = n2;
        this.maxCharCode = n3;
        this.bounds = fArray;
        this.xAvgCharWidth = n;
        if (d != 1000.0) {
            this.scaling = 1.0 / (d / 1000.0);
        }
    }

    public byte[] writeTable() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.originalFont.getFontType() == 1217103210) {
            TTGlyphs tTGlyphs = (TTGlyphs)this.glyphs;
            Hhea hhea = (Hhea)this.glyphs.getTable(5);
            int n = hhea.getIntValue(1);
            int n2 = hhea.getIntValue(2);
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(3));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(this.xAvgCharWidth));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(400));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(5));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16((int)((double)n * 0.3)));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16((int)((double)n * 0.3)));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16((int)((double)n * 0.3)));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16((int)((double)n * 0.3)));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16((int)((double)n * 0.3)));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16((int)((double)n * 0.3)));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(new byte[4]);
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(64));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(this.minCharCode));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(this.maxCharCode));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(n + n2));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(n));
            n2 = Math.abs(n2);
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(n2));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
        } else {
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(3));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(this.xAvgCharWidth));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(400));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(5));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(102));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(102));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(102));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(102));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(102));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(102));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(new byte[4]);
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(64));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(this.minCharCode));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(this.maxCharCode));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(1000));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16((int)((double)this.bounds[3] * this.scaling)));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(-((int)((double)this.bounds[1] * this.scaling))));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(0));
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public int getIntValue(int n) {
        return 0;
    }
}

