/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Glyf
extends Table {
    private Map charStrings = new HashMap();
    private int glyfCount = 0;
    private Map emptyCharStrings = new HashMap();
    private byte[] glyphTable;

    public Glyf(FontFile2 fontFile2, int n, int[] nArray) {
        this.glyfCount = n;
        int n2 = fontFile2.selectTable(3);
        if (n2 != 0) {
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray[i + 1]) {
                    this.charStrings.put(i, -1);
                    this.emptyCharStrings.put(i, "x");
                    continue;
                }
                this.charStrings.put(i, nArray[i]);
            }
            this.glyphTable = fontFile2.getTableBytes(4);
        }
    }

    public boolean isPresent(int n) {
        Integer n2 = n;
        Object v = this.charStrings.get(n2);
        return v != null && this.emptyCharStrings.get(n2) == null;
    }

    public int getCharString(int n) {
        Object v = this.charStrings.get(n);
        if (v == null) {
            return n;
        }
        return (Integer)v;
    }

    public byte[] getTableData() {
        return this.glyphTable;
    }

    public int getGlypfCount() {
        return this.glyfCount;
    }

    public Map buildCharStringTable(int n) {
        HashMap hashMap = new HashMap();
        for (Object k : this.charStrings.keySet()) {
            if (this.emptyCharStrings.containsKey(k)) continue;
            hashMap.put(k, k);
        }
        return hashMap;
    }
}

