/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4054062852632000027L;
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    public static ColorSpace CMYK = null;

    public void clearCache() {
        this.lastC = -1.0f;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initColorspace() {
        InputStream inputStream = null;
        String string = System.getProperty("org.jpedal.CMYKprofile");
        if (string == null) {
            inputStream = this.getClass().getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm");
        } else {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                throw new PdfException("PdfException attempting to use user profile " + string + " Message=" + exception);
            }
        }
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
        CMYK = new ICC_ColorSpace(iCC_Profile);
        Object var5_6 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            if (!LogWriter.isOutput()) return;
            LogWriter.writeLog("Exception " + iOException);
        }
        return;
        {
            catch (Exception exception) {
                if (!LogWriter.isOutput()) throw new RuntimeException("Problem setting CMYK Colorspace with message " + exception + " Possible cause file cmyk.icm corrupted");
                LogWriter.writeLog("Exception " + exception);
                throw new RuntimeException("Problem setting CMYK Colorspace with message " + exception + " Possible cause file cmyk.icm corrupted");
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) throw throwable;
                LogWriter.writeLog("Exception " + iOException);
            }
            throw throwable;
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.value = 1498837125;
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    public final void setColor(float[] fArray, int n) {
        boolean bl = true;
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (n > 3) {
            this.c = fArray[0];
            this.m = fArray[1];
            this.y = fArray[2];
            this.k = fArray[3];
        } else {
            if (n > 0) {
                this.c = fArray[0];
            }
            if (n > 1) {
                this.m = fArray[1];
            }
            if (n > 2) {
                this.y = fArray[2];
            }
            if (n > 3) {
                this.k = fArray[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.rawValues = new float[4];
            this.rawValues[0] = this.c;
            this.rawValues[1] = this.m;
            this.rawValues[2] = this.y;
            this.rawValues[3] = this.k;
            if (!bl) {
                float f;
                float f2;
                float f3 = this.c + this.k;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                if ((f2 = this.m + this.k) > 1.0f) {
                    f2 = 1.0f;
                }
                if ((f = this.y + this.k) > 1.0f) {
                    f = 1.0f;
                }
                this.currentColor = new PdfColor((int)(255.0f * (1.0f - f3)), (int)(255.0f * (1.0f - f2)), (int)(255.0f * (1.0f - f)));
            } else if (this.c == 0.0f && this.y == 0.0f && this.m == 0.0f && this.k == 0.0f) {
                this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
            } else {
                if ((double)this.c > 0.99) {
                    this.c = 1.0f;
                } else if ((double)this.c < 0.01) {
                    this.c = 0.0f;
                }
                if ((double)this.m > 0.99) {
                    this.m = 1.0f;
                } else if ((double)this.m < 0.01) {
                    this.m = 0.0f;
                }
                if ((double)this.y > 0.99) {
                    this.y = 1.0f;
                } else if ((double)this.y < 0.01) {
                    this.y = 0.0f;
                }
                if ((double)this.k > 0.99) {
                    this.k = 1.0f;
                } else if ((double)this.k < 0.01) {
                    this.k = 0.0f;
                }
                float[] fArray2 = null;
                if (fArray2 == null) {
                    float[] fArray3 = new float[]{this.c, this.m, this.y, this.k};
                    fArray2 = CMYK.toRGB(fArray3);
                    for (int i = 0; i < 3; ++i) {
                        if ((double)fArray2[i] > 0.99) {
                            fArray2[i] = 1.0f;
                            continue;
                        }
                        if (!((double)fArray2[i] < 0.01)) continue;
                        fArray2[i] = 0.0f;
                    }
                }
                this.currentColor = new PdfColor((float)fArray2[0], (float)fArray2[1], (float)fArray2[2]);
            }
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
        }
    }

    public final BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        return this.nonRGBJPEGToRGBImage(byArray, n, n2, fArray, n3, n4);
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) throws PdfException {
        BufferedImage bufferedImage;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG2000").next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            byte[] byArray2 = this.getIndexedMap();
            if (byArray2 != null) {
                if (!this.isIndexConverted()) {
                    byArray2 = this.convertIndexToRGB(byArray2);
                }
                RenderedImage renderedImage = imageReader.readAsRenderedImage(0, imageReader.getDefaultReadParam());
                Raster raster = renderedImage.getData();
                IndexColorModel indexColorModel = new IndexColorModel(8, byArray2.length / 3, byArray2, 0, false);
                bufferedImage = new BufferedImage(indexColorModel, raster.createCompatibleWritableRaster(), false, null);
                bufferedImage.setData(raster);
                bufferedImage = DeviceCMYKColorSpace.cleanupImage(bufferedImage, n3, n4, bufferedImage.getType());
            } else {
                Object object;
                bufferedImage = imageReader.read(0);
                Raster raster = bufferedImage.getRaster();
                if (fArray != null) {
                    if (fArray.length == 6 && fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 1.0f && fArray[3] == 0.0f && fArray[4] == 1.0f && fArray[5] == 0.0f || fArray.length > 2 && fArray[0] == 1.0f && fArray[1] == 0.0f) {
                        object = raster.getDataBuffer();
                        int n5 = ((DataBuffer)object).getSize();
                        for (int i = 0; i < n5; ++i) {
                            ((DataBuffer)object).setElem(i, 255 - ((DataBuffer)object).getElem(i));
                        }
                    } else if (fArray.length == 6 && fArray[0] == 0.0f && fArray[1] == 1.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 1.0f || fArray == null || fArray.length > 0) {
                        // empty if block
                    }
                }
                raster = DeviceCMYKColorSpace.cleanupRaster(raster, n3, n4, 4);
                n = raster.getWidth();
                n2 = raster.getHeight();
                if (bufferedImage.getType() == 13) {
                    object = ColorSpaceConvertor.createCompatibleWritableRaaster(bufferedImage.getColorModel(), n, n2);
                    CSToRGB = new ColorConvertOp(this.cs, bufferedImage.getColorModel().getColorSpace(), ColorSpaces.hints);
                    bufferedImage = new BufferedImage(n, n2, bufferedImage.getType());
                } else {
                    if (CSToRGB == null) {
                        DeviceCMYKColorSpace.initCMYKColorspace();
                    }
                    object = ColorSpaceConvertor.createCompatibleWritableRaaster(rgbModel, n, n2);
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    CSToRGB.filter(raster, (WritableRaster)object);
                    bufferedImage = new BufferedImage(n, n2, 1);
                }
                bufferedImage.setData((Raster)object);
            }
            imageReader.dispose();
            imageInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
            }
            exception.printStackTrace();
            throw new PdfException("Exception " + exception + " with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        catch (Error error) {
            error.printStackTrace();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000 with error " + error);
            }
            throw new PdfException("Error with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        return bufferedImage;
    }

    public final byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        return this.convert4Index(byArray);
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace colorSpace = new DeviceCMYKColorSpace().getColorSpace();
        String string = System.getProperty("org.jpedal.CMYKprofile");
        if (string != null) {
            try {
                colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string)));
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to create CMYK colorspace with  " + string + "\nPlease check Path and file valid or use built-in");
            }
        }
        return colorSpace;
    }
}

