/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.SearchListener;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_String;

public class PdfGroupingAlgorithms {
    private boolean includeHTMLtags = false;
    public static final int USER_DEFINED_LIST_ONLY = 0;
    public static final int SURROUND_BY_ANY_PUNCTUATION = 1;
    private static String SystemSeparator = System.getProperty("line.separator");
    private boolean[] isUsed;
    private float[] f_x1;
    private float[] f_x2;
    private float[] f_y1;
    private float[] f_y2;
    private boolean[] hadSpace;
    private String[] f_colorTag;
    private int[] writingMode;
    private int[] moveType;
    private int[] fontSize;
    private float[] spaceWidth;
    private StringBuilder[] content;
    private int[] textLength;
    private PdfData pdf_data;
    PdfPageData pageData;
    private boolean isXHTML = true;
    private int nextSlot;
    private Vector_Int lineBreaks = new Vector_Int();
    private Vector_Object lines;
    private Vector_Int lineY2;
    private static final String MARKER = PdfData.marker;
    public static char MARKER2 = MARKER.charAt(0);
    private int max_rows = 0;
    private int master = 0;
    private boolean colorExtracted = false;
    private int[] line_order;
    private static final int increment = 100;
    public static boolean useUnrotatedCoords;
    private float[] endPoints;
    private boolean includeTease;
    private String[] teasers;
    private List multipleTermTeasers = new ArrayList();
    private boolean usingMultipleTerms = false;
    private boolean isXMLExtraction = true;
    private int linkedSearchAreas = -101;

    public PdfGroupingAlgorithms(PdfData pdfData, PdfPageData pdfPageData, boolean bl) {
        this.pdf_data = pdfData;
        this.pageData = pdfPageData;
        this.isXMLExtraction = bl;
        this.colorExtracted = pdfData.isColorExtracted();
    }

    public static void setSeparator(String string) {
        SystemSeparator = string;
    }

    private static final String getLineDownSeparator(StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl) {
        StringBuilder stringBuilder3;
        StringBuilder stringBuilder4;
        String string = " ";
        boolean bl2 = false;
        if (bl) {
            stringBuilder4 = Strip.stripXML(stringBuilder, bl);
            stringBuilder3 = Strip.stripXML(stringBuilder2, bl);
        } else {
            stringBuilder4 = Strip.trim(stringBuilder);
            stringBuilder3 = Strip.trim(stringBuilder2);
        }
        int n = stringBuilder4.length();
        int n2 = stringBuilder3.length();
        if (n > 1 && n2 > 1) {
            char c = stringBuilder4.charAt(n - 1);
            char c2 = stringBuilder4.charAt(n - 2);
            char c3 = stringBuilder3.charAt(0);
            char c4 = stringBuilder3.charAt(1);
            String string2 = "";
            if (string2.indexOf(c) != -1) {
                string = "";
                if (c2 == ':') {
                    string = "\n";
                }
                if (c == ' ') {
                    string = " ";
                }
            } else if ((c2 == '.' | c == '.') & (Character.isUpperCase(c3) | c3 == '&' | Character.isUpperCase(c4) | c4 == '&')) {
                string = bl ? "<p></p>\n" : "\n";
            }
        }
        if (bl2) {
            string = bl ? string + "<p></p>\n" : string + '\n';
        }
        return string;
    }

    private final void cleanupShadowsAndDrownedObjects(boolean bl) {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (this.isUsed[n2]) continue;
            float f = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
            float f2 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            for (int j = i + 1; j < n; ++j) {
                String string;
                boolean bl2;
                float f3;
                int n3 = nArray[j];
                if (this.isUsed[n3] || this.isUsed[n2]) continue;
                float f4 = this.fontSize[n3] - this.fontSize[n2];
                if (f4 < 0.0f) {
                    f4 = -f4;
                }
                if ((f3 = this.f_x2[n3] - this.f_x1[n3] - (this.f_x2[n2] - this.f_x1[n2])) < 0.0f) {
                    f3 = -f3;
                }
                if (f4 == 0.0f && f > this.f_x1[n3] && f < this.f_x2[n3] && f3 < 10.0f && f2 < this.f_y1[n3] && f2 > this.f_y2[n3]) {
                    this.isUsed[n3] = true;
                    continue;
                }
                boolean bl3 = this.f_x1[n3] > this.f_x1[n2] && this.f_x2[n3] < this.f_x2[n2] && this.f_y1[n3] < this.f_y1[n2] && this.f_y2[n3] > this.f_y2[n2];
                boolean bl4 = bl2 = this.f_x1[n2] > this.f_x1[n3] && this.f_x2[n2] < this.f_x2[n3] && this.f_y1[n2] < this.f_y1[n3] && this.f_y2[n2] > this.f_y2[n3];
                if (!bl3 && !bl2) continue;
                if (this.f_y2[n2] > this.f_y2[n3]) {
                    string = PdfGroupingAlgorithms.getLineDownSeparator(this.content[n2], this.content[n3], this.isXMLExtraction);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n2, n3, string, true);
                    }
                } else {
                    string = PdfGroupingAlgorithms.getLineDownSeparator(this.content[n3], this.content[n2], this.isXMLExtraction);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n3, n2, string, true);
                    }
                }
                f = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
                f2 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            }
        }
    }

    private final String isGapASpace(int n, int n2, float f, boolean bl, int n3) {
        int n4;
        String string = "";
        float f2 = this.spaceWidth[n] * (float)this.fontSize[n];
        float f3 = this.spaceWidth[n2] * (float)this.fontSize[n2];
        float f4 = f2 > f3 ? f3 : f2;
        if ((f4 = f / (f4 / 1000.0f)) > 0.51f && f4 < 1.0f) {
            f4 = 1.0f;
        }
        if ((n4 = (int)f4) > 0) {
            string = " ";
        }
        if (n4 > 1 && bl && n3 == 0) {
            string = " <SpaceCount space=\"" + n4 + "\" />";
        }
        return string;
    }

    private final void merge(int n, int n2, String string, boolean bl) {
        if (this.f_x1[n] > this.f_x1[n2]) {
            this.f_x1[n] = this.f_x1[n2];
        }
        if (this.f_y1[n] < this.f_y1[n2]) {
            this.f_y1[n] = this.f_y1[n2];
        }
        if (this.f_x2[n] < this.f_x2[n2]) {
            this.f_x2[n] = this.f_x2[n2];
        }
        if (this.f_y2[n] > this.f_y2[n2]) {
            this.f_y2[n] = this.f_y2[n2];
        }
        if (this.isXMLExtraction) {
            String string2 = Fonts.fe;
            if (this.colorExtracted) {
                string2 = Fonts.fe + "</color>";
            }
            if (bl && this.content[n].toString().lastIndexOf(string2) != -1) {
                String string3 = this.content[n].toString();
                this.content[n] = new StringBuilder(string3.substring(0, string3.lastIndexOf(string2)));
                this.content[n].append(string);
                this.content[n].append(string3.substring(string3.lastIndexOf(string2)));
            } else {
                this.content[n].append(string);
            }
            if (this.textLength[n2] > 1 && this.content[n].toString().endsWith(" ")) {
                this.content[n].deleteCharAt(this.content[n].lastIndexOf(" "));
            }
            this.fontSize[n] = this.fontSize[n2];
            if (this.content[n2].indexOf("<color") != -1 && this.content[n].indexOf("<color") != -1 && this.content[n2].toString().startsWith(this.content[n].substring(this.content[n].lastIndexOf("<color"), this.content[n].indexOf(">", this.content[n].lastIndexOf("<color")))) && this.content[n].lastIndexOf("</color>") + 7 == this.content[n].lastIndexOf(">")) {
                this.content[n2].replace(this.content[n2].indexOf("<color"), this.content[n2].indexOf(">") + 1, "");
                this.content[n].replace(this.content[n].lastIndexOf("</color>"), this.content[n].lastIndexOf("</color>") + 8, "");
            }
            if (this.content[n2].indexOf("<font") != -1 && this.content[n].indexOf("<font") != -1 && this.content[n2].toString().startsWith(this.content[n].substring(this.content[n].lastIndexOf("<font"), this.content[n].indexOf(">", this.content[n].lastIndexOf("<font")))) && this.content[n].lastIndexOf("</font>") + 6 == this.content[n].lastIndexOf(">")) {
                this.content[n2].replace(this.content[n2].indexOf("<font"), this.content[n2].indexOf(">") + 1, "");
                this.content[n].replace(this.content[n].lastIndexOf("</font>"), this.content[n].lastIndexOf("</font>") + 7, "");
            }
            this.content[n] = this.content[n].append((CharSequence)this.content[n2]);
            this.textLength[n] = this.textLength[n] + this.textLength[n2];
            this.isUsed[n2] = true;
            this.content[n2] = null;
        } else {
            this.fontSize[n] = this.fontSize[n2];
            this.content[n] = this.content[n].append(string).append((CharSequence)this.content[n2]);
            this.textLength[n] = this.textLength[n] + this.textLength[n2];
            this.isUsed[n2] = true;
            this.content[n2] = null;
        }
    }

    private final void removeEncoding() {
        int[] nArray;
        for (int n : nArray = this.getUnusedFragments()) {
            int n2 = n;
            if (this.isUsed[n2]) continue;
            this.content[n2] = this.removeHiddenMarkers(n2);
        }
    }

    private final void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int n = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[n];
        this.fontSize = new int[n];
        this.writingMode = new int[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuilder[n];
        this.textLength = new int[n];
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.moveType = new int[n];
        for (int i = 0; i < n; ++i) {
            this.content[i] = new StringBuilder(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.moveType[i] = this.pdf_data.move_command[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
        }
    }

    private int[] getUnusedFragments() {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private StringBuilder removeHiddenMarkers(int n) {
        if (this.content[n].indexOf(MARKER) == -1) {
            return this.content[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.content[n].toString(), MARKER, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuilder = stringBuilder.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuilder = stringBuilder.append(string);
        }
        return stringBuilder;
    }

    public void setIncludeHTML(boolean bl) {
        this.includeHTMLtags = bl;
    }

    public static String removeHiddenMarkers(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains(MARKER)) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuilder = stringBuilder.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuilder = stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private void findVerticalLines(float f, float f2, float f3, float f4, int n) throws PdfException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        int n3 = this.pdf_data.getRawTextElementCount();
        for (int i = 0; i < n3; ++i) {
            float f5;
            float f6;
            float f7;
            float f8;
            float f9 = 0.0f;
            String string = this.pdf_data.contents[i];
            if (n == 0) {
                f8 = this.f_x1[i];
                f7 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 1) {
                f7 = this.f_x1[i];
                f8 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 3) {
                f8 = this.f_y1[i];
                f7 = this.f_y2[i];
                f6 = this.f_x2[i];
                f5 = this.f_x1[i];
            } else if (n == 2) {
                f8 = this.f_y2[i];
                f7 = this.f_y1[i];
                f5 = this.f_x1[i];
                f6 = this.f_x2[i];
            } else {
                throw new PdfException("Illegal value " + n + "for currentWritingMode");
            }
            if (!((double)f8 > (double)f - 0.5) || !((double)f7 < (double)f3 + 0.5) || !((double)f5 > (double)f2 - 0.5) || !((double)f6 < (double)f4 + 0.5)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(MARKER)) continue;
                string3 = stringTokenizer.nextToken();
                if (string3.length() > 0) {
                    float f10 = f9;
                    f9 = Float.parseFloat(string3);
                    try {
                        if (string2.length() == 0 || string2.indexOf(32) != -1) {
                            int n4;
                            Integer n5 = (int)f9;
                            Object v = hashMap.get(n5);
                            if (v == null) {
                                hashMap.put(n5, 1);
                            } else {
                                n4 = (Integer)v;
                                if (++n4 > n2) {
                                    n2 = n4;
                                }
                                hashMap.put(n5, n4);
                            }
                            n4 = (int)(f10 + (f9 - f10) / 2.0f);
                            if (f10 != 0.0f) {
                                n5 = n4;
                                v = hashMap.get(n5);
                                if (v == null) {
                                    hashMap.put(n5, 1);
                                } else {
                                    int n6 = (Integer)v;
                                    if (++n6 > n2) {
                                        n2 = n6;
                                    }
                                    hashMap.put(n5, n6);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " stripping x values");
                    }
                }
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string2 = string3 = stringTokenizer.nextToken();
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        int n7 = n2 / 2;
        while (iterator.hasNext()) {
            Integer n8 = (Integer)iterator.next();
            int n9 = (Integer)hashMap.get(n8);
            if (n9 <= n7) continue;
            this.lineBreaks.addElement(n8);
        }
    }

    private void copyToArrays(float f, float f2, float f3, float f4, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) throws PdfException {
        int n = this.pdf_data.getRawTextElementCount() + 100;
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.hadSpace = new boolean[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuilder[n];
        this.fontSize = new int[n];
        this.textLength = new int[n];
        this.writingMode = new int[n];
        this.isUsed = new boolean[n];
        this.moveType = new int[n];
        boolean bl5 = false;
        n -= 100;
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            float f5;
            float f6;
            float f7;
            float f8;
            float f9 = this.pdf_data.f_character_spacing[i];
            String string3 = this.pdf_data.contents[i];
            float f10 = this.pdf_data.f_x1[i];
            String string4 = this.pdf_data.colorTag[i];
            float f11 = this.pdf_data.f_x2[i];
            float f12 = this.pdf_data.f_y1[i];
            float f13 = this.pdf_data.f_y2[i];
            int n2 = this.pdf_data.text_length[i];
            int n3 = this.pdf_data.f_writingMode[i];
            int n4 = this.pdf_data.move_command[i];
            boolean bl6 = false;
            if ((n3 == 0 || n3 == 1) && f13 > f2 && f12 < f4 && f10 < f3 && f11 > f) {
                bl6 = true;
            } else if ((n3 == 3 || n3 == 2) && f10 > f && f11 < f3 && f12 > f2 && f13 < f4) {
                bl6 = true;
            }
            if (!bl6) continue;
            if (!bl5 && bl3) {
                this.findVerticalLines(f, f2, f3, f4, n3);
                bl5 = true;
            }
            if (n3 == 0 || n3 == 1) {
                f8 = f10;
                f7 = f10;
                f6 = f;
                f5 = f3;
            } else {
                f8 = f13;
                f7 = f13;
                f6 = f2;
                f5 = f4;
            }
            float f14 = -1.0f;
            char[] cArray = string3.toCharArray();
            int n5 = cArray.length;
            int n6 = 0;
            String string5 = "";
            if (!string3.contains(MARKER)) {
                stringBuilder = new StringBuilder(string3);
            }
            boolean bl7 = true;
            boolean bl8 = false;
            while (n6 < n5) {
                int n7;
                int n8;
                int n9;
                String string6;
                int n10;
                do {
                    if (cArray[n6] != MARKER2) {
                        n10 = n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string6 = string3.substring(n10, n6);
                    } else {
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        n10 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        String string7 = string3.substring(n10, n6);
                        n10 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string2 = string3.substring(n10, n6);
                        n10 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string5 = string6 = string3.substring(n10, n6);
                        if (string7.length() > 0) {
                            f7 = f8;
                            f8 = Float.parseFloat(string7);
                            if (bl8) {
                                if (n3 == 0) {
                                    f10 = f8;
                                } else if (n3 == 1) {
                                    f11 = f8;
                                } else if (n3 == 3) {
                                    f13 = f8;
                                } else if (n3 == 2) {
                                    f12 = f8;
                                }
                                bl8 = false;
                            }
                        }
                        if (this.isXMLExtraction && f7 < f6 && f8 > f6 && !string6.startsWith(Fonts.fb)) {
                            string6 = Fonts.getActiveFontTag(string3, "") + string6;
                        }
                    }
                    if (f8 > f6 & f8 < f5) {
                        if (n3 != 0) break;
                        if ((f10 < f6 || f10 > f5) && f8 >= f6) {
                            f10 = f8;
                            break;
                        }
                        if (n3 != 1) break;
                        if ((f11 > f5 || f11 < f6) && f8 <= f5) {
                            f11 = f8;
                            break;
                        }
                        if (n3 != 3) break;
                        if ((f13 < f6 || f13 > f5) && f8 >= f6) {
                            f13 = f8;
                            break;
                        }
                        if (n3 != 2 || !(f12 < f6) && !(f12 > f5) || !(f8 <= f6)) break;
                        f12 = f8;
                        break;
                    }
                    string6 = "";
                    string5 = "";
                } while (n6 < n5);
                if (bl7) {
                    bl7 = false;
                    if (this.isXMLExtraction && bl && !string6.startsWith(Fonts.fb) && !string6.startsWith("<color ")) {
                        stringBuilder.append(Fonts.getActiveFontTag(stringBuilder.toString(), string3));
                    }
                }
                n10 = 0;
                if (bl3 && f9 > 0.0f && stringBuilder.toString().endsWith(" ")) {
                    n9 = this.lineBreaks.size();
                    for (n8 = 0; n8 < n9; ++n8) {
                        n7 = this.lineBreaks.elementAt(n8);
                        if (!(f7 < (float)n7 & f8 > (float)n7)) continue;
                        n8 = n9;
                        n10 = 1;
                    }
                }
                n9 = PdfGroupingAlgorithms.checkForPunctuation(string5, string);
                if (n10 != 0) {
                    float f15 = f10;
                    float f16 = f11;
                    float f17 = f12;
                    float f18 = f13;
                    if (n3 == 0) {
                        f16 = f7 + Float.parseFloat(string2);
                    } else if (n3 == 1) {
                        f15 = f7 + Float.parseFloat(string2);
                    } else if (n3 == 3) {
                        f17 = f7 + Float.parseFloat(string2);
                    } else if (n3 == 2) {
                        f18 = f7 + Float.parseFloat(string2);
                    }
                    this.addFragment(n4, i, stringBuilder, f15, f16, f17, f18, n2, bl, string4, bl4);
                    stringBuilder = new StringBuilder(Fonts.getActiveFontTag(stringBuilder.toString(), string3));
                    stringBuilder.append(string6);
                    if (n3 == 0) {
                        f10 = f8;
                        continue;
                    }
                    if (n3 == 1) {
                        f11 = f8;
                        continue;
                    }
                    if (n3 == 3) {
                        f13 = f8;
                        continue;
                    }
                    if (n3 != 2) continue;
                    f12 = f8;
                    continue;
                }
                if (n9 | (bl2 && (string5.indexOf(32) != -1 || string6.endsWith(" "))) | string5.contains("   ")) {
                    if (string5.length() > 1 && string5.indexOf(32) != -1 && (n8 = string5.indexOf(32)) > 0) {
                        f8 += (float)n8 * (Float.parseFloat(string2) / (float)string5.length());
                    }
                    if (n9 == 0) {
                        stringBuilder.append(string6.trim());
                    }
                    if (n3 == 0) {
                        this.addFragment(n4, i, stringBuilder, f10, f8, f12, f13, n2, bl, string4, bl4);
                    } else if (n3 == 1) {
                        this.addFragment(n4, i, stringBuilder, f8, f11, f12, f13, n2, bl, string4, bl4);
                    } else if (n3 == 3) {
                        this.addFragment(n4, i, stringBuilder, f10, f11, f8, f13, n2, bl, string4, bl4);
                    } else if (n3 == 2) {
                        this.addFragment(n4, i, stringBuilder, f10, f11, f12, f8, n2, bl, string4, bl4);
                    }
                    if (string2.length() > 0) {
                        n8 = 0;
                        if (string5.indexOf(32) != -1) {
                            n8 = string5.indexOf(32);
                        }
                        if (bl4) {
                            n7 = string5.length();
                            while (n8 < n7 && string5.charAt(n8) == ' ') {
                                ++n8;
                            }
                        }
                        f8 = n8 > 0 ? (f8 += (float)n8 * Float.parseFloat(string2)) : (f8 += Float.parseFloat(string2));
                        bl8 = n8 > 0;
                    }
                    if (bl2 & this.nextSlot > 0) {
                        this.hadSpace[this.nextSlot - 1] = true;
                    }
                    stringBuilder = new StringBuilder(Fonts.getActiveFontTag(stringBuilder.toString(), string3));
                    if (n3 == 0) {
                        f10 = f8;
                        continue;
                    }
                    if (n3 == 1) {
                        f11 = f8;
                        continue;
                    }
                    if (n3 == 3) {
                        f13 = f8;
                        continue;
                    }
                    if (n3 != 2) continue;
                    f12 = f8;
                    continue;
                }
                if (f14 != -1.0f & f8 > f14) {
                    if (n3 == 0) {
                        this.addFragment(n4, i, stringBuilder, f10, f14, f12, f13, n2, bl, string4, bl4);
                    } else if (n3 == 1) {
                        this.addFragment(n4, i, stringBuilder, f14, f11, f12, f13, n2, bl, string4, bl4);
                    } else if (n3 == 3) {
                        this.addFragment(n4, i, stringBuilder, f10, f11, f14, f13, n2, bl, string4, bl4);
                    } else if (n3 == 2) {
                        this.addFragment(n4, i, stringBuilder, f10, f11, f12, f14, n2, bl, string4, bl4);
                    }
                    stringBuilder = new StringBuilder(Fonts.getActiveFontTag(stringBuilder.toString(), string3));
                    stringBuilder.append(string6);
                    if (n3 == 0) {
                        f10 = f14;
                    } else if (n3 == 1) {
                        f11 = f14;
                    } else if (n3 == 3) {
                        f13 = f14;
                    } else if (n3 == 2) {
                        f12 = f14;
                    }
                    f14 = -1.0f;
                    continue;
                }
                if (this.isXMLExtraction && string6.endsWith(' ' + Fonts.fe)) {
                    string6 = Fonts.fe;
                    string5 = "";
                    if (n3 == 0) {
                        f11 = f7;
                    } else if (n3 == 1) {
                        f10 = f7;
                    } else if (n3 == 3) {
                        f12 = f7;
                    } else if (n3 == 2) {
                        f13 = f7;
                    }
                }
                stringBuilder.append(string6);
            }
            if (bl && this.isXMLExtraction && !stringBuilder.toString().endsWith(Fonts.fe) && !stringBuilder.toString().endsWith("</color>")) {
                stringBuilder.append(Fonts.fe);
            }
            if (n3 == 0 || n3 == 1) {
                if (f10 < f11) {
                    this.addFragment(n4, i, stringBuilder, f10, f11, f12, f13, n2, bl, string4, bl4);
                }
            } else if ((n3 == 3 || n3 == 2) && f12 > f13) {
                this.addFragment(n4, i, stringBuilder, f10, f11, f12, f13, n2, bl, string4, bl4);
            }
            stringBuilder = new StringBuilder();
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private static boolean checkForPunctuation(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        int n = string.length();
        int n2 = n - 1;
        if (n > 0) {
            char c = string.charAt(n2);
            boolean bl2 = c == '>';
            while ((bl2 | c == ' ') & n2 > 0) {
                if (c == '<') {
                    bl2 = false;
                }
                if ((c = string.charAt(--n2)) != '>') continue;
                bl2 = true;
            }
            if (c == ';') {
                bl = true;
                --n2;
                while (n2 > -1) {
                    c = string.charAt(n2);
                    if (c == '&' || c == '#') {
                        bl = false;
                        n2 = 0;
                    }
                    if (n2 != 0 && c != ' ' && Character.isLetterOrDigit(c)) {
                        --n2;
                        continue;
                    }
                    break;
                }
            } else if (string2.indexOf(c) != -1) {
                bl = true;
            }
        }
        return bl;
    }

    private void addFragment(int n, int n2, StringBuilder stringBuilder, float f, float f2, float f3, float f4, int n3, boolean bl, String string, boolean bl2) {
        StringBuilder stringBuilder2 = stringBuilder;
        String string2 = stringBuilder2.toString();
        if (bl2) {
            if (string2.contains("&#")) {
                stringBuilder2 = Strip.stripAmpHash(stringBuilder2);
            }
            if (this.isXMLExtraction && (string2.contains("&lt;") || string2.contains("&gt;"))) {
                stringBuilder2 = Strip.stripXMLArrows(stringBuilder2, true);
            } else if (!(this.isXMLExtraction || string2.indexOf(60) == -1 && string2.indexOf(62) == -1)) {
                stringBuilder2 = Strip.stripArrows(stringBuilder2);
            }
        }
        if (this.getFirstChar(stringBuilder2) != -1) {
            if (!bl) {
                stringBuilder2 = Strip.stripXML(stringBuilder2, this.isXMLExtraction);
            } else if (this.isXMLExtraction) {
                if (this.pdf_data.isColorExtracted() && !stringBuilder2.toString().endsWith("</color>")) {
                    if (!stringBuilder2.toString().endsWith(Fonts.fe)) {
                        stringBuilder2 = stringBuilder2.append(Fonts.fe);
                    }
                    stringBuilder2 = stringBuilder2.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !stringBuilder2.toString().endsWith(Fonts.fe)) {
                    stringBuilder2 = stringBuilder2.append(Fonts.fe);
                }
            }
            int n4 = this.f_x1.length;
            if (this.nextSlot < n4) {
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.moveType[this.nextSlot] = n;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n2];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n2];
                this.textLength[this.nextSlot] = n3;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n2];
                this.content[this.nextSlot] = stringBuilder2;
                ++this.nextSlot;
            } else {
                float[] fArray = new float[n4 += 100];
                String[] stringArray = new String[n4];
                float[] fArray2 = new float[n4];
                float[] fArray3 = new float[n4];
                float[] fArray4 = new float[n4];
                float[] fArray5 = new float[n4];
                StringBuilder[] stringBuilderArray = new StringBuilder[n4];
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                int[] nArray3 = new int[n4];
                int[] nArray4 = new int[n4];
                boolean[] blArray = new boolean[n4];
                boolean[] blArray2 = new boolean[n4];
                for (int i = 0; i < n4 - 100; ++i) {
                    fArray[i] = this.f_x1[i];
                    stringArray[i] = this.f_colorTag[i];
                    fArray2[i] = this.f_x2[i];
                    fArray3[i] = this.f_y1[i];
                    fArray4[i] = this.f_y2[i];
                    blArray2[i] = this.hadSpace[i];
                    fArray5[i] = this.spaceWidth[i];
                    stringBuilderArray[i] = this.content[i];
                    nArray[i] = this.fontSize[i];
                    nArray3[i] = this.writingMode[i];
                    nArray2[i] = this.textLength[i];
                    blArray[i] = this.isUsed[i];
                    nArray4[i] = this.moveType[i];
                }
                this.f_x1 = fArray;
                this.f_colorTag = stringArray;
                this.hadSpace = blArray2;
                this.f_x2 = fArray2;
                this.f_y1 = fArray3;
                this.f_y2 = fArray4;
                this.isUsed = blArray;
                this.fontSize = nArray;
                this.writingMode = nArray3;
                this.textLength = nArray2;
                this.spaceWidth = fArray5;
                this.content = stringBuilderArray;
                this.moveType = nArray4;
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n2];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n2];
                nArray2[this.nextSlot] = n3;
                this.content[this.nextSlot] = stringBuilder2;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n2];
                this.moveType[this.nextSlot] = n;
                ++this.nextSlot;
            }
        }
    }

    private void mergeTableRows(int n) {
        String string = "</tr>\n<tr>";
        if (!this.isXHTML) {
            string = "\n";
        }
        this.master = ((Vector_Int)this.lines.elementAt(this.line_order[0])).elementAt(0);
        for (int i = 1; i < this.max_rows; ++i) {
            int n2 = ((Vector_Int)this.lines.elementAt(this.line_order[i])).elementAt(0);
            if (this.content[this.master] == null) {
                this.master = n2;
                continue;
            }
            if (this.content[n2] == null) continue;
            this.merge(this.master, n2, string, false);
        }
        if (this.isXHTML) {
            if (n == 0) {
                this.content[this.master].insert(0, "<TABLE>\n<tr>");
                this.content[this.master].append("</tr>\n</TABLE>\n");
            } else {
                StringBuilder stringBuilder = new StringBuilder("<TABLE border='");
                stringBuilder.append(String.valueOf(n));
                stringBuilder.append("'>\n<tr>");
                stringBuilder.append((CharSequence)this.content[this.master]);
                this.content[this.master] = stringBuilder;
                this.content[this.master].append("</tr>\n</TABLE>\n");
            }
        }
    }

    private final int[] getsortedUnusedFragments(boolean bl, boolean bl2) {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray2[i] = n3 = nArray[i];
            nArray3[i] = (int)this.f_x1[n3];
            nArray4[i] = (int)this.f_y1[n3];
            nArray5[i] = (int)this.f_y2[n3];
        }
        int[] nArray6 = !bl ? (bl2 ? Sorts.quicksort(nArray4, nArray3, nArray2) : Sorts.quicksort(nArray5, nArray3, nArray2)) : Sorts.quicksort(nArray3, nArray4, nArray2);
        return nArray6;
    }

    private void createTableRows(boolean bl, boolean bl2, int n) throws PdfException {
        float f;
        boolean bl3;
        int n2;
        int n3;
        float[] fArray;
        float[] fArray2;
        if (n == 0) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
        } else if (n == 1) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
        } else if (n == 3) {
            fArray2 = this.f_y2;
            fArray = this.f_y1;
        } else if (n == 2) {
            fArray2 = this.f_y1;
            fArray = this.f_y2;
            n3 = 0;
            for (float f2 : fArray2) {
                if (!((float)n3 < f2)) continue;
                n3 = (int)f2;
            }
            ++n3;
            for (n2 = 0; n2 < fArray.length; ++n2) {
                fArray2[n2] = (float)n3 - fArray2[n2];
                fArray[n2] = (float)n3 - fArray[n2];
            }
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.max_rows];
        Vector_Int[] vector_IntArray = new Vector_Int[this.max_rows];
        Vector_String vector_String = new Vector_String();
        Vector_Float vector_Float = new Vector_Float();
        Vector_Float vector_Float2 = new Vector_Float();
        String string = "";
        String string2 = "&nbsp;";
        if (!this.isXHTML) {
            string = "\",\"";
            string2 = "";
        }
        int[] nArray2 = new int[this.max_rows];
        for (n2 = 0; n2 < this.max_rows; ++n2) {
            nArray2[n2] = ((Vector_Int)this.lines.elementAt(n2)).size() - 1;
            n4 += nArray2[n2];
            nArray[n2] = 0;
            vector_IntArray[n2] = new Vector_Int(20);
        }
        do {
            float f3;
            float f4;
            float f5 = 9999.0f;
            float f6 = 9999.0f;
            float f7 = 9999.0f;
            float f8 = 0.0f;
            bl3 = true;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            String string3 = "center";
            if (n5 >= n4) continue;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                if (nArray2[n2] <= nArray[n2]) continue;
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f = fArray2[n3];
                float f12 = fArray[n3];
                if (f < f5) {
                    f5 = f;
                }
                if (!(f12 < f6)) continue;
                f6 = f12;
            }
            vector_Float2.addElement(f5);
            float f13 = f6;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f4 = fArray2[n3];
                if (f4 >= f5 & f4 < f6 & (f3 = fArray[n3]) > f13) {
                    f13 = f3;
                }
                if (nArray[n2] >= nArray2[n2] || !((f = fArray2[n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2] + 1)]) > f6 & f < f7)) continue;
                f7 = f;
            }
            if (f5 != f13) {
                if (f7 == 9999.0f) {
                    f7 = f13;
                }
                for (n2 = 0; n2 < this.max_rows; ++n2) {
                    n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                    f4 = fArray2[n3];
                    if (!(f4 >= f5 & f4 < f6 & (f3 = fArray[n3]) <= f7)) continue;
                    f9 += f4;
                    f10 += f3;
                    f8 += 1.0f;
                }
                if (n2 == 0) {
                    f11 = f5;
                }
                float f14 = f7 == -1.0f ? 0.0f : (float)((int)((f7 - f13) / 2.0f));
                int n6 = (int)(f13 - f5 + f14 + f11);
                f11 = f14;
                vector_Float.addElement(n6);
                float f15 = f9 / f8 - f5;
                float f16 = f13 - f10 / f8;
                if (f15 < 1.0f) {
                    string3 = "left";
                } else if (f16 < 1.0f) {
                    string3 = "right";
                }
                vector_String.addElement(string3);
                for (n2 = 0; n2 < this.max_rows; ++n2) {
                    this.master = ((Vector_Int)this.lines.elementAt(n2)).elementAt(0);
                    if (nArray2[n2] > nArray[n2]) {
                        n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                        f4 = fArray2[n3];
                        f3 = fArray[n3];
                        bl3 = false;
                    } else {
                        n3 = -1;
                        f4 = -1.0f;
                        f3 = -1.0f;
                    }
                    if (n3 == -1 & n5 <= n4) {
                        vector_IntArray[n2].addElement(-1);
                        continue;
                    }
                    if (f4 >= f5 & f4 < f13) {
                        vector_IntArray[n2].addElement(n3);
                        int n7 = n2;
                        nArray[n7] = nArray[n7] + 1;
                        ++n5;
                        continue;
                    }
                    if (!(f4 > f13)) continue;
                    vector_IntArray[n2].addElement(-1);
                }
            }
            break;
        } while (!bl3);
        for (int i = 0; i < this.max_rows; ++i) {
            StringBuilder stringBuilder = new StringBuilder(100);
            int n8 = vector_IntArray[i].size() - 1;
            this.master = ((Vector_Int)this.lines.elementAt(i)).elementAt(0);
            for (n2 = 0; n2 < n8; ++n2) {
                n3 = vector_IntArray[i].elementAt(n2);
                if (this.isXHTML) {
                    f = vector_Float.elementAt(n2);
                    String string4 = vector_String.elementAt(n2);
                    int n9 = 1;
                    int n10 = n2 + 1;
                    if (n3 != -1) {
                        int n11;
                        while (!((n11 = vector_IntArray[i].elementAt(n2 + 1)) != -1 | n8 == n2 + 1) && !(nArray2[i] > 1 & vector_Float2.elementAt(n2 + 1) > fArray[n3])) {
                            --n8;
                            vector_IntArray[i].removeElementAt(n2 + 1);
                            ++n9;
                            f += vector_Float.elementAt(n10);
                            ++n10;
                        }
                    }
                    stringBuilder.append("<td");
                    if (bl) {
                        stringBuilder.append(" align='");
                        stringBuilder.append(string4);
                        stringBuilder.append('\'');
                        if (n9 > 1) {
                            stringBuilder.append(" colspan='").append(n9).append('\'');
                        }
                    }
                    if (bl2) {
                        stringBuilder.append(" width='").append((int)f).append('\'');
                    }
                    stringBuilder.append(" nowrap>");
                    if (n3 == -1) {
                        stringBuilder.append(string2);
                    } else {
                        stringBuilder.append((CharSequence)this.content[n3]);
                    }
                    stringBuilder.append("</td>");
                } else if (n3 == -1) {
                    stringBuilder.append("\"\",");
                } else {
                    stringBuilder.append('\"');
                    stringBuilder.append((CharSequence)this.content[n3]);
                    stringBuilder.append("\",");
                }
                if (n3 == -1 || this.master == n3) continue;
                this.merge(this.master, n3, string, false);
            }
            this.content[this.master] = stringBuilder;
        }
    }

    private void createLinesInTable(int n, int[] nArray, boolean bl, int n2) throws PdfException {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        if (n2 == 1) {
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        }
        switch (n2) {
            case 0: {
                fArray4 = this.f_x1;
                fArray3 = this.f_x2;
                fArray2 = this.f_y1;
                fArray = this.f_y2;
                break;
            }
            case 1: {
                fArray3 = this.f_x1;
                fArray4 = this.f_x2;
                fArray2 = this.f_y1;
                fArray = this.f_y2;
                break;
            }
            case 3: {
                fArray4 = this.f_y1;
                fArray3 = this.f_y2;
                fArray2 = this.f_x2;
                fArray = this.f_x1;
                break;
            }
            case 2: {
                fArray4 = this.f_y2;
                fArray3 = this.f_y1;
                fArray = this.f_x1;
                fArray2 = this.f_x2;
                nArray = this.getsortedUnusedFragments(false, true);
                nArray = PdfGroupingAlgorithms.reverse(nArray);
                break;
            }
            default: {
                throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
            }
        }
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            int n4 = -1;
            int n5 = n3;
            float f = -1.0f;
            if (this.isUsed[n3] || this.writingMode[n3] != n2) continue;
            Vector_Int vector_Int = new Vector_Int(20);
            vector_Int.addElement(n3);
            this.lineY2.addElement((int)fArray[n3]);
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f2;
                    int n6 = nArray[j];
                    if (this.isUsed[n6] || n6 == n3 || this.writingMode[n3] != n2 || !(fArray4[n6] > fArray4[n3] && n2 != 2) && (!(fArray4[n6] < fArray4[n3]) || n2 != 2)) continue;
                    float f3 = fArray4[n6] - fArray3[n3];
                    if (n2 == 1 || n2 == 2) {
                        f3 = -f3;
                    }
                    if (f3 < 0.0f && f3 > -2.0f) {
                        f3 = 0.0f;
                    }
                    if (!((f2 = (fArray2[n6] + fArray[n6]) / 2.0f) < fArray2[n3]) || !(f2 > fArray[n3]) || !(f < 0.0f) && !(f3 < f)) continue;
                    f = f3;
                    n4 = n6;
                }
                if (n4 == -1) break;
                float f4 = fArray4[n4] - fArray3[n5];
                float f5 = fArray4[n4] - fArray3[n3];
                float f6 = 1.5f * ((fArray3[n4] - fArray4[n4]) / (float)this.textLength[n4]);
                float f7 = 1.5f * ((fArray3[n5] - fArray4[n5]) / (float)this.textLength[n5]);
                if (n2 == 1 || n2 == 2) {
                    f5 = -f5;
                    f4 = -f4;
                    f6 = -f6;
                    f7 = -f7;
                }
                if (f4 < f6 && f4 < f7) {
                    this.merge(n5, n4, this.isGapASpace(n4, n5, f5, bl, n2), true);
                } else {
                    vector_Int.addElement(n4);
                    n5 = n4;
                }
                this.isUsed[n4] = true;
                n4 = -1;
                f = 1000000.0f;
            }
            this.lines.addElement(vector_Int);
            ++this.max_rows;
        }
    }

    public final Map extractTextAsTable(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n6) throws PdfException {
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LogWriter.writeLog("extracting Text As Table");
        this.isXHTML = !bl;
        this.lines = new Vector_Object(20);
        this.lineY2 = new Vector_Int(20);
        this.max_rows = 0;
        this.copyToArrays(n, n4, n3, n2, bl2, false, true, null, false);
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n7 = nArray2.length;
        if (n7 == 0) {
            return hashMap;
        }
        int n8 = this.getWritingMode(nArray2, n7);
        String string = "Table Merging algorithm being applied " + n7 + " items";
        LogWriter.writeLog(string);
        if (n7 > 1) {
            this.createLinesInTable(n7, nArray2, this.isXHTML, n8);
            int n9 = 1;
            if (n8 == 0 || n8 == 2) {
                n9 = -1;
            }
            this.line_order = new int[this.max_rows];
            int[] nArray3 = new int[this.max_rows];
            for (int i = 0; i < this.max_rows; ++i) {
                nArray3[i] = n9 * this.lineY2.elementAt(i);
                this.line_order[i] = i;
            }
            this.line_order = Sorts.quicksort(nArray3, this.line_order);
            this.createTableRows(bl4, bl3, n8);
            this.mergeTableRows(n6);
        }
        this.content[this.master] = this.cleanup(this.content[this.master]);
        String string2 = this.content[this.master].toString();
        if (string2 != null) {
            if (!bl) {
                string2 = Fonts.cleanupTokens(string2);
            }
            hashMap.put("content", string2);
            hashMap.put("x1", String.valueOf(n));
            hashMap.put("x2", String.valueOf(n3));
            hashMap.put("y1", String.valueOf(n2));
            hashMap.put("y2", String.valueOf(n4));
        }
        return hashMap;
    }

    private static int[] validateCoordinates(int n, int n2, int n3, int n4) throws PdfException {
        if (n > n3 | n2 < n4) {
            int n5;
            if (n > n3) {
                n5 = n;
                n = n3;
                n3 = n5;
                LogWriter.writeLog("x1 > x2, coordinates were swapped to validate");
            }
            if (n2 < n4) {
                n5 = n2;
                n2 = n4;
                n4 = n5;
                LogWriter.writeLog("y1 < y2, coordinates were swapped to validate");
            }
        }
        return new int[]{n, n2, n3, n4};
    }

    public final List extractTextAsWordlist(int n, int n2, int n3, int n4, int n5, boolean bl, String string) throws PdfException {
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        if (bl) {
            this.copyToArrays(n, n4, n3, n2, true, true, false, string, true);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(true);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n6 = nArray2.length;
        if (n6 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n7 = this.getWritingMode(nArray2, n6);
        this.createLines(n6, nArray2, n7, true, false, false);
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (useUnrotatedCoords || n7 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 3) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n7 == 2) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            if (this.colorExtracted && this.isXMLExtraction) {
                if (!this.content[i].toString().toLowerCase().startsWith("<color ")) {
                    this.content[i].insert(0, this.f_colorTag[this.master]);
                }
                if (!this.content[i].toString().toLowerCase().endsWith("</color>")) {
                    this.content[i].append("</color>");
                }
            }
            if (this.isXMLExtraction) {
                arrayList.add(this.content[i].toString());
            } else {
                arrayList.add(Strip.convertToText(this.content[i].toString(), this.isXMLExtraction));
            }
            if (!useUnrotatedCoords && n7 == 2) {
                arrayList.add(String.valueOf(fArray[i]));
                arrayList.add(String.valueOf(fArray3[i]));
                arrayList.add(String.valueOf(fArray2[i]));
                arrayList.add(String.valueOf(fArray4[i]));
                continue;
            }
            if (!useUnrotatedCoords && n7 == 3) {
                arrayList.add(String.valueOf(fArray[i]));
                arrayList.add(String.valueOf(fArray4[i]));
                arrayList.add(String.valueOf(fArray2[i]));
                arrayList.add(String.valueOf(fArray3[i]));
                continue;
            }
            arrayList.add(String.valueOf(fArray[i]));
            arrayList.add(String.valueOf(fArray3[i]));
            arrayList.add(String.valueOf(fArray2[i]));
            arrayList.add(String.valueOf(fArray4[i]));
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return arrayList;
    }

    private void reset() {
        this.isXHTML = true;
        this.nextSlot = 0;
        this.lineBreaks = new Vector_Int();
        this.max_rows = 0;
        this.master = 0;
        this.colorExtracted = false;
    }

    public final String extractTextInRectangle(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) throws PdfException {
        this.reset();
        if (bl2 && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        if (bl2) {
            this.copyToArrays(n, n4, n3, n2, this.isXMLExtraction, false, false, null, false);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n6 = nArray2.length;
        if (n6 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n7 = this.getWritingMode(nArray2, n6);
        this.createLines(n6, nArray2, n7, false, this.isXMLExtraction, false);
        int n8 = this.mergeLinesTogether(n7, bl, n, n3, n2, n4);
        if (this.isXMLExtraction) {
            this.content[n8] = new StringBuilder(Fonts.cleanupTokens(this.content[n8].toString()));
            this.content[n8].insert(0, "<p>");
            this.content[n8].append("</p>");
        }
        LogWriter.writeLog("Text extraction completed");
        return this.cleanup(this.content[n8]).toString();
    }

    private StringBuilder cleanup(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return stringBuilder;
        }
        if (this.isXMLExtraction) {
            String string = stringBuilder.toString();
            string = string.replaceAll("&#", "XX#");
            string = string.replaceAll("&lt", "XXlt");
            string = string.replaceAll("&gt", "XXgt");
            string = string.replaceAll("&", "&amp;");
            string = string.replaceAll("XX#", "&#");
            string = string.replaceAll("XXlt", "&lt");
            string = string.replaceAll("XXgt", "&gt");
            boolean bl = true;
            if (bl) {
                int n;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (n = 1; n <= 8; ++n) {
                    hashMap.put("&#" + n + ';', "");
                }
                for (n = 11; n <= 12; ++n) {
                    hashMap.put("&#" + n + ';', "");
                }
                for (n = 14; n <= 31; ++n) {
                    hashMap.put("&#" + n + ';', "");
                }
                for (Object k : hashMap.keySet()) {
                    String string2 = (String)k;
                    String string3 = (String)hashMap.get(string2);
                    string = string.replace(string2, string3);
                }
            }
            stringBuilder = new StringBuilder(string);
        }
        return stringBuilder;
    }

    private int getWritingMode(int[] nArray, int n) {
        int n2 = this.writingMode[nArray[0]];
        if (n2 == 0 || n2 == 1) {
            return n2;
        }
        for (int i = 1; i < n; ++i) {
            int n3 = nArray[i];
            if (this.isUsed[n3] || this.writingMode[n3] != 0 && this.writingMode[n3] != 1) continue;
            n2 = this.writingMode[n3];
            i = n;
            LogWriter.writeLog("Text of multiple orientations found. Only horizontal text used.");
        }
        return n2;
    }

    private int mergeLinesTogether(int n, boolean bl, int n2, int n3, int n4, int n5) throws PdfException {
        int n6;
        int[] nArray;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        if (n == 0) {
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 1) {
            fArray3 = this.f_x1;
            fArray4 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 3) {
            fArray4 = this.f_y1;
            fArray3 = this.f_y2;
            fArray2 = this.f_x2;
            fArray = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            nArray = PdfGroupingAlgorithms.reverse(nArray);
            n6 = (n4 + n5) / 2;
        } else if (n == 2) {
            fArray4 = this.f_y2;
            fArray3 = this.f_y1;
            fArray = this.f_x2;
            fArray2 = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            n6 = (n4 + n5) / 2;
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n7 = n6 / 2;
        int n8 = nArray.length;
        int n9 = nArray[n8 - 1];
        for (int i = n8 - 2; i > -1; --i) {
            int n10 = nArray[i];
            String string = "";
            int n11 = this.getLastChar(this.content[n10]);
            if (n11 == -1) continue;
            this.addAlignmentFormatting(bl, n6, fArray4, fArray3, n7, n10);
            String string2 = "</p>" + SystemSeparator + "<p>";
            if (this.isXMLExtraction) {
                string2 = SystemSeparator;
            }
            float f = fArray[n9] - fArray2[n10];
            float f2 = fArray2[n10] - fArray[n10];
            if (n == 3) {
                f = -f;
                f2 = -f2;
            }
            if (f > f2 & f2 > 0.0f) {
                while (f > f2) {
                    string = string + string2;
                    f -= f2;
                }
                string = this.isXMLExtraction ? string + "</p>" + SystemSeparator + "<p>" : SystemSeparator;
            } else if (bl) {
                int n12 = this.getFirstChar(this.content[n10]);
                int n13 = this.getLastChar(this.content[n9]);
                if ((n13 == 46 || n13 == 34) && n12 >= 65 && n12 <= 90) {
                    string = this.isXMLExtraction ? "</p>" + SystemSeparator + "<p>" : SystemSeparator;
                }
            } else if (this.isXMLExtraction) {
                this.content[n10].insert(0, "</p>" + SystemSeparator + "<p>");
            } else {
                this.content[n9].append(SystemSeparator);
            }
            this.merge(n9, n10, string, false);
        }
        return n9;
    }

    private int getFirstChar(StringBuilder stringBuilder) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuilder.length();
        int n3 = 32;
        for (int i = 0; i < n2; ++i) {
            char c = stringBuilder.charAt(i);
            if (!bl && (c == '<' || this.isXMLExtraction && c == '&')) {
                bl = true;
                n3 = c;
                if (n3 == 38) {
                    if (i + 1 == n2) {
                        n = 38;
                        i = n2;
                    } else {
                        char c2 = stringBuilder.charAt(i + 1);
                        if (c2 != '#' && c2 != 'g' && c2 != 'l') {
                            n = 38;
                            i = n2;
                        }
                    }
                }
            }
            if (!bl && c != ' ') {
                n = c;
                i = n2;
            }
            if (bl && n3 == 38 && c == ' ') {
                n = n3;
                i = n2;
                continue;
            }
            if (!bl || c != '>' && (!this.isXMLExtraction || n3 != 38 || c != ';')) continue;
            if (c == ';' && n3 == 38 && i > 2 & stringBuilder.charAt(i - 1) == 't') {
                if (stringBuilder.charAt(i - 2) == 'l') {
                    n = 60;
                    i = n2;
                } else if (stringBuilder.charAt(i - 2) == 'g') {
                    n = 62;
                    i = n2;
                }
            }
            bl = false;
        }
        return n;
    }

    private int getLastChar(StringBuilder stringBuilder) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuilder.length();
        int n3 = n2--;
        int n4 = 32;
        while (n2 > -1) {
            char c = stringBuilder.charAt(n2);
            if (bl && n4 == 59 && c == ';') {
                n = 59;
                n2 = -1;
            }
            if (!bl && (c == '>' || this.isXMLExtraction && c == ';')) {
                bl = true;
                int n5 = stringBuilder.lastIndexOf("</");
                if (n5 == -1) {
                    bl = false;
                } else {
                    for (int i = n5; i < n2; ++i) {
                        char c2 = stringBuilder.charAt(i);
                        if (c2 != ' ' && c2 != '>') continue;
                        bl = false;
                        i = n2;
                    }
                }
                if (bl) {
                    n4 = c;
                } else {
                    n = c;
                    n2 = -1;
                }
            }
            if (!bl && c != ' ') {
                n = c;
                n2 = -1;
            }
            if (c == '<' || this.isXMLExtraction && n4 == 59 && c == '&') {
                bl = false;
                if (c == '&' && n2 + 3 < n3 & stringBuilder.charAt(n2 + 2) == 't' && stringBuilder.charAt(n2 + 3) == ';') {
                    if (stringBuilder.charAt(n2 + 1) == 'l') {
                        n = 60;
                        n2 = -1;
                    } else if (stringBuilder.charAt(n2 + 1) == 'g') {
                        n = 62;
                        n2 = -1;
                    }
                }
            }
            if (bl && n4 == 59 && c == ' ') {
                n2 = -1;
                n = 59;
            }
            --n2;
        }
        return n;
    }

    private static int[] reverse(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[n - i - 1];
        }
        return nArray2;
    }

    private void addAlignmentFormatting(boolean bl, int n, float[] fArray, float[] fArray2, int n2, int n3) {
        float f = (float)n - fArray[n3];
        float f2 = fArray2[n3] - (float)n;
        if (!bl && this.isXMLExtraction && f > 0.0f && f2 > 0.0f && fArray[n3] > (float)n2 && fArray[n3] < (float)(n + n2)) {
            float f3 = f / f2;
            if (f3 > 1.0f) {
                f3 = 1.0f / f3;
            }
            if ((double)f3 > 0.95) {
                this.content[n3] = new StringBuilder(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<center>");
                this.content[n3].append("</center>\n");
            } else if (f2 < 10.0f & f > 30.0f) {
                this.content[n3] = new StringBuilder(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<right>");
                this.content[n3].append("</right>\n");
            }
        }
    }

    private void createLines(int n, int[] nArray, int n2, boolean bl, boolean bl2, boolean bl3) throws PdfException {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        if (n2 == 1 || n2 == 2) {
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        }
        if (n2 == 0) {
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
        } else if (n2 == 1) {
            fArray3 = this.f_x1;
            fArray4 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
        } else if (n2 == 3) {
            fArray4 = this.f_y1;
            fArray3 = this.f_y2;
            fArray2 = this.f_x2;
            fArray = this.f_x1;
        } else if (n2 == 2) {
            fArray4 = this.f_y2;
            fArray3 = this.f_y1;
            fArray = this.f_x1;
            fArray2 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
        }
        block0: for (int i = 0; i < n; ++i) {
            int n3 = -1;
            int n4 = nArray[i];
            float f = -1.0f;
            if (this.isUsed[n4] || this.writingMode[n4] != n2) continue;
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f2;
                    int n5;
                    int n6;
                    int n7;
                    int n8 = nArray[j];
                    if (this.isUsed[n8]) continue;
                    int n9 = (int)(fArray[n8] - fArray[n4]);
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if ((n7 = (int)(fArray2[n8] - fArray2[n4])) < 0) {
                        n7 = -n7;
                    }
                    if ((n6 = (int)(fArray4[n8] - fArray3[n4])) > (int)(fArray4[n4] - fArray3[n8])) {
                        n6 = (int)(fArray4[n4] - fArray3[n8]);
                    }
                    if ((n5 = this.fontSize[n4] - this.fontSize[n8]) < 0) {
                        n5 = -n5;
                    }
                    if (bl3 && n6 > this.fontSize[n4] && n6 > 0 || bl3 && n9 > 1 && n6 > 2 * this.fontSize[n4] && this.fontSize[n4] == this.fontSize[n8] || bl3 && n9 > 3 || bl3 && n5 > 2 || n8 == n4 || !(fArray4[n8] > fArray4[n4] && n2 != 2) && (!(fArray4[n8] < fArray4[n4]) || n2 != 2 || this.writingMode[n4] != n2 || n5 > 2 && (n5 <= 2 || n7 >= 3))) continue;
                    float f3 = fArray4[n8] - fArray3[n4];
                    if (n2 == 1 || n2 == 2) {
                        f3 = -f3;
                    }
                    if (f3 < 0.0f && f3 > -2.0f) {
                        f3 = 0.0f;
                    }
                    if (!((f2 = (fArray2[n8] + fArray[n8]) / 2.0f) < fArray2[n4]) || !(f2 > fArray[n4]) || !(f < 0.0f) && !(f3 < f)) continue;
                    f = f3;
                    n3 = n8;
                }
                if (n3 == -1) continue block0;
                float f4 = fArray4[n3] - fArray3[n4];
                if (n2 == 1 || n2 == 2) {
                    f4 = -f4;
                } else if (n2 == 3) {
                    f4 = fArray3[n3] - fArray4[n4];
                }
                String string = this.isGapASpace(n4, n3, f4, bl2, n2);
                if (bl && this.hadSpace != null && (this.hadSpace[n4] || string.startsWith(" "))) continue block0;
                this.merge(n4, n3, string, true);
                n3 = -1;
                f = 1000000.0f;
            }
        }
    }

    public SortedMap findMultipleTermsInRectangleWithMatchingTeasers(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, int n7, SearchListener searchListener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        boolean bl = this.includeTease;
        this.includeTease = true;
        List list = this.findMultipleTermsInRectangle(n, n2, n3, n4, n6, stringArray, n7, searchListener);
        TreeMap treeMap = new TreeMap(new ResultsComparator(n5));
        for (int i = 0; i < list.size(); ++i) {
            treeMap.put(list.get(i), this.multipleTermTeasers.get(i));
        }
        this.usingMultipleTerms = false;
        this.includeTease = bl;
        return treeMap;
    }

    public List findMultipleTermsInRectangle(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, boolean bl, int n7, SearchListener searchListener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        List list = this.findMultipleTermsInRectangle(n, n2, n3, n4, n6, stringArray, n7, searchListener);
        if (bl) {
            Collections.sort(list, new ResultsComparator(n5));
        }
        this.usingMultipleTerms = false;
        return list;
    }

    private List findMultipleTermsInRectangle(int n, int n2, int n3, int n4, int n5, String[] stringArray, int n6, SearchListener searchListener) throws PdfException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : stringArray) {
            if (searchListener != null && searchListener.isCanceled()) break;
            float[] fArray = this.findText(new Rectangle(n, n2, n3, n4), n5, new String[]{string}, n6);
            if (fArray == null) continue;
            int n7 = fArray.length;
            for (int i = 0; i < n7; i += 5) {
                int n8 = (int)fArray[i];
                int n9 = (int)fArray[i + 1];
                int n10 = (int)fArray[i + 2];
                int n11 = (int)fArray[i + 3];
                Rectangle rectangle = new Rectangle(n8, n11, n10 - n8, n9 - n11);
                int n12 = (int)fArray[i + 4];
                if (n12 == this.linkedSearchAreas) {
                    Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                    vector_Rectangle.addElement(rectangle);
                    while (n12 == this.linkedSearchAreas) {
                        n8 = (int)fArray[i += 5];
                        n9 = (int)fArray[i + 1];
                        n10 = (int)fArray[i + 2];
                        n11 = (int)fArray[i + 3];
                        n12 = (int)fArray[i + 4];
                        rectangle = new Rectangle(n8, n11, n10 - n8, n9 - n11);
                        vector_Rectangle.addElement(rectangle);
                    }
                    vector_Rectangle.trim();
                    arrayList.add(vector_Rectangle.get());
                    continue;
                }
                arrayList.add(rectangle);
            }
        }
        return arrayList;
    }

    public final float[] findText(Rectangle rectangle, int n, String[] stringArray, int n2) throws PdfException {
        int n3;
        int n4;
        int n5;
        if (stringArray == null) {
            return new float[0];
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Vector_Float vector_Float = new Vector_Float(0);
        Vector_String vector_String = new Vector_String(0);
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        block6: for (int i = 0; i != nArray.length; ++i) {
            switch (this.writingMode[nArray[i]]) {
                case 0: {
                    ++n6;
                    continue block6;
                }
                case 1: {
                    ++n7;
                    continue block6;
                }
                case 2: {
                    ++n8;
                    continue block6;
                }
                case 3: {
                    ++n9;
                }
            }
        }
        int[] nArray2 = new int[]{n6, n7, n8, n9};
        int[] nArray3 = new int[]{n6, n7, n8, n9};
        int[] nArray4 = new int[]{-1, -1, -1, -1};
        Arrays.sort(nArray3);
        for (n5 = 0; n5 != nArray2.length; ++n5) {
            for (n4 = 0; n4 < nArray3.length; ++n4) {
                if (nArray2[n5] != nArray3[n4]) continue;
                n3 = n4 - 3;
                if (n3 < 0) {
                    n3 = -n3;
                }
                if (nArray4[n3] != -1) continue;
                nArray4[n3] = n5;
                n4 = nArray3.length;
            }
        }
        for (n5 = 0; n5 != nArray4.length; ++n5) {
            int n10;
            n4 = nArray4[n5];
            if (nArray2[n4] == 0) continue;
            this.createLines(nArray.length, nArray, n4, true, false, true);
            n3 = 0;
            if ((n2 & 2) != 2) {
                n3 |= 2;
            }
            if ((n2 & 4) == 4) {
                bl = true;
            }
            if ((n2 & 1) == 1) {
                bl2 = true;
            }
            if ((n2 & 8) == 8) {
                n3 = n3 | 8 | 0x20;
            }
            if ((n2 & 0x20) == 32) {
                bl4 = true;
            }
            float[] fArray = this.f_y1;
            float[] fArray2 = this.f_y2;
            boolean bl5 = false;
            if (n4 == 0) {
                fArray = this.f_y1;
                fArray2 = this.f_y2;
            } else if (n4 == 1) {
                fArray = this.f_y1;
                fArray2 = this.f_y2;
            } else if (n4 == 3) {
                fArray = this.f_x2;
                fArray2 = this.f_x1;
                bl5 = true;
            } else if (n4 == 2) {
                fArray2 = this.f_x1;
                fArray = this.f_x2;
                bl5 = true;
            }
            String string = "";
            String string2 = "";
            for (int i = 0; i != this.content.length; ++i) {
                if (this.content[i] == null || n4 != this.writingMode[i]) continue;
                string2 = string2 + this.content[i] + "\n";
                string = string + this.content[i] + "\n";
            }
            string2 = PdfGroupingAlgorithms.removeDuplicateSpaces(string2);
            string = PdfGroupingAlgorithms.removeDuplicateSpaces(string);
            string2 = Strip.stripXML(string2, this.isXMLExtraction).toString();
            string = PdfGroupingAlgorithms.removeHiddenMarkers(string);
            string = Strip.stripXML(string, this.isXMLExtraction).toString();
            String[] stringArray2 = new String[]{string};
            String[] stringArray3 = new String[]{string2};
            block11: for (n10 = 0; n10 != stringArray.length; ++n10) {
                String string3 = stringArray[n10];
                String string4 = " ";
                if ((n2 & 8) == 8) {
                    string4 = "[ \\\\n]";
                }
                if (!bl4) {
                    string3 = "\\Q" + string3 + "\\E";
                    string4 = "\\\\E" + string4 + "\\\\Q";
                }
                if (!string4.equals(" ")) {
                    string3 = string3.replaceAll(" ", string4);
                }
                if (bl2) {
                    string3 = "\\b" + string3 + "\\b";
                }
                Pattern pattern = Pattern.compile(string3, n3);
                Pattern pattern2 = Pattern.compile("(?:\\S+\\s)?\\S*(?:\\S+\\s)?\\S*" + string3 + "\\S*(?:\\s\\S+)?\\S*(?:\\s\\S+)?", n3);
                for (int i = 0; i != stringArray2.length; ++i) {
                    String string5 = stringArray2[i];
                    String string6 = stringArray3[i];
                    if (string5 == null) continue;
                    Matcher matcher = pattern.matcher(string5);
                    Matcher matcher2 = pattern2.matcher(string5);
                    boolean bl6 = true;
                    while (matcher.find()) {
                        int n11;
                        int n12;
                        Point point = null;
                        String string7 = matcher.group();
                        int n13 = matcher.start();
                        int n14 = matcher.end() - 1;
                        if (this.includeTease) {
                            String string8 = string7;
                            if (this.includeHTMLtags) {
                                string8 = "<b>" + string8 + "</b>";
                            }
                            boolean bl7 = false;
                            if (bl6) {
                                bl7 = matcher2.find();
                            }
                            if (bl7) {
                                if (matcher2.start() < n13 && matcher2.end() > n14) {
                                    string8 = matcher2.group();
                                    if (this.includeHTMLtags) {
                                        n12 = n13 - matcher2.start();
                                        n11 = n14 - matcher2.start() + 1;
                                        string8 = string8.substring(0, n12) + "<b>" + string8.substring(n12, n11) + "</b>" + string8.substring(n11, string8.length());
                                    }
                                    bl6 = true;
                                } else {
                                    bl6 = false;
                                }
                            }
                            vector_String.addElement(string8);
                        }
                        n12 = -1;
                        n11 = 0;
                        while (this.content[n11] == null || n4 != this.writingMode[n11]) {
                            ++n11;
                        }
                        boolean bl8 = false;
                        boolean bl9 = false;
                        for (int j = 1; j < string6.length(); ++j) {
                            int n15 = j;
                            while (j < string6.length() && string6.charAt(j) != MARKER2) {
                                ++j;
                            }
                            float f = Float.parseFloat(string6.substring(n15, j));
                            n15 = ++j;
                            while (j < string6.length() && string6.charAt(j) != MARKER2) {
                                ++j;
                            }
                            float f2 = Float.parseFloat(string6.substring(n15, j));
                            n15 = ++j;
                            while (j < string6.length() && string6.charAt(j) != MARKER2) {
                                ++j;
                            }
                            String string9 = string6.substring(n15, j);
                            if (!bl8 && (n12 += string9.length()) >= n13) {
                                point = new Point((int)f, (int)fArray[n11]);
                                bl8 = true;
                            }
                            if (!bl9 && n12 >= n14) {
                                if (bl5) {
                                    if (n4 == 3) {
                                        vector_Float.addElement((int)fArray2[n11]);
                                        vector_Float.addElement((float)((int)f) + f2);
                                        vector_Float.addElement(point.y);
                                        vector_Float.addElement(point.x);
                                        vector_Float.addElement(0.0f);
                                    } else {
                                        vector_Float.addElement((int)fArray2[n11]);
                                        vector_Float.addElement(point.x);
                                        vector_Float.addElement(point.y);
                                        vector_Float.addElement((float)((int)f) + f2);
                                        vector_Float.addElement(0.0f);
                                    }
                                } else {
                                    vector_Float.addElement(point.x);
                                    vector_Float.addElement(point.y);
                                    vector_Float.addElement(f + f2);
                                    vector_Float.addElement(fArray2[n11]);
                                    vector_Float.addElement(0.0f);
                                }
                                bl9 = true;
                            }
                            if (bl8 && !bl9 && string9.contains("\n")) {
                                if (bl5) {
                                    if (n4 == 3) {
                                        vector_Float.addElement((int)fArray2[n11]);
                                        vector_Float.addElement((float)((int)f) + f2);
                                        vector_Float.addElement(point.y);
                                        vector_Float.addElement(point.x);
                                        vector_Float.addElement(this.linkedSearchAreas);
                                    } else {
                                        vector_Float.addElement((int)fArray2[n11]);
                                        vector_Float.addElement(point.x);
                                        vector_Float.addElement(point.y);
                                        vector_Float.addElement((float)((int)f) + f2);
                                        vector_Float.addElement(this.linkedSearchAreas);
                                    }
                                } else {
                                    vector_Float.addElement(point.x);
                                    vector_Float.addElement(point.y);
                                    vector_Float.addElement(f + f2);
                                    vector_Float.addElement(fArray2[n11]);
                                    vector_Float.addElement(this.linkedSearchAreas);
                                }
                                bl8 = false;
                                n13 = n12;
                            }
                            if (!string9.contains("\n")) continue;
                            ++n11;
                            while (n11 < this.content.length && (this.content[n11] == null || n4 != this.writingMode[n11])) {
                                ++n11;
                            }
                        }
                        if (!bl) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl && bl3) continue block11;
                }
            }
            vector_Float.trim();
            if (!this.includeTease) continue;
            vector_String.trim();
            if (this.usingMultipleTerms) {
                for (n10 = 0; n10 != vector_String.size(); ++n10) {
                    this.multipleTermTeasers.add(vector_String.elementAt(n10));
                }
                continue;
            }
            this.teasers = vector_String.get();
        }
        return vector_Float.get();
    }

    private static String removeDuplicateSpaces(String string) {
        if (string.contains("  ")) {
            string = string.replace("  ", " ");
        }
        return string;
    }

    public float[] getEndPoints() {
        return this.endPoints;
    }

    public String[] getTeasers() {
        return this.teasers;
    }

    public void generateTeasers() {
        this.includeTease = true;
    }

    static class ResultsComparator
    implements Comparator {
        private int rotation;

        public ResultsComparator(int n) {
            this.rotation = n;
        }

        public int compare(Object object, Object object2) {
            Rectangle[] rectangleArray = object instanceof Rectangle[] ? (Rectangle[])object : new Rectangle[]{(Rectangle)object};
            Rectangle[] rectangleArray2 = object2 instanceof Rectangle[] ? (Rectangle[])object2 : new Rectangle[]{(Rectangle)object2};
            for (int i = 0; i != rectangleArray.length; ++i) {
                for (int j = 0; j != rectangleArray2.length; ++j) {
                    Rectangle rectangle = rectangleArray[i];
                    Rectangle rectangle2 = rectangleArray2[j];
                    switch (this.rotation) {
                        case 0: {
                            if (rectangle.y == rectangle2.y) {
                                if (rectangle.x > rectangle2.x) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (rectangle.y > rectangle2.y) {
                                return -1;
                            }
                            return 1;
                        }
                        case 90: {
                            if (rectangle.x == rectangle2.x) {
                                if (rectangle.y > rectangle2.y) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (rectangle.x > rectangle2.x) {
                                return 1;
                            }
                            return -1;
                        }
                        case 180: {
                            if (rectangle.y == rectangle2.y) {
                                if (rectangle.x > rectangle2.x) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (rectangle.y > rectangle2.y) {
                                return -1;
                            }
                            return 1;
                        }
                        case 270: {
                            if (rectangle.x == rectangle2.x) {
                                if (rectangle.y > rectangle2.y) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (rectangle.x < rectangle2.x) {
                                return 1;
                            }
                            return -1;
                        }
                    }
                }
            }
            return -1;
        }
    }
}

