/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.linear;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.raw.LinearizedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class LinearParser {
    public boolean isLinearizationTested = false;
    private PageObject linObject = null;
    private Map linObjects = new HashMap();
    private int linearPageCount = -1;
    private PdfObject linearObj = null;
    private LinearizedHintTable linHintTable = null;
    private int E = -1;
    public LinearThread linearizedBackgroundReaderer = null;

    public void closePdfFile() {
        this.E = -1;
        this.linearObj = null;
        this.isLinearizationTested = false;
        this.linObjects.clear();
        if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            this.linearizedBackgroundReaderer.interrupt();
        }
        while (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && !this.linearizedBackgroundReaderer.isInterrupted()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.linHintTable = null;
    }

    public boolean isPageAvailable(int n, PdfObjectReader pdfObjectReader) {
        boolean bl = true;
        try {
            if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && n > 1 && this.linHintTable != null) {
                Integer n2 = n;
                if (this.linObjects.containsKey(n2)) {
                    this.linObject = (PageObject)this.linObjects.get(n2);
                    return true;
                }
                int n3 = this.linHintTable.getPageObjectRef(n);
                byte[] byArray = this.linHintTable.getObjData(n3);
                if (byArray != null) {
                    this.linObject = new PageObject(n3 + " 0 R");
                    this.linObject.setStatus(2);
                    this.linObject.setUnresolvedData(byArray, 540096309);
                    this.linObject.isDataExternal(true);
                    ObjectDecoder objectDecoder = new ObjectDecoder(pdfObjectReader.getObjectReader());
                    if (!objectDecoder.resolveFully(this.linObject)) {
                        bl = false;
                    } else {
                        if (this.linObject != null) {
                            byte[] byArray2 = pdfObjectReader.getObjectReader().readPageIntoStream(this.linObject);
                            if (byArray2 == null) {
                                bl = false;
                            } else {
                                PdfObject pdfObject = this.linObject.getDictionary(2004251818);
                                if (pdfObject == null) {
                                    this.linObject = null;
                                    bl = false;
                                } else if (!objectDecoder.resolveFully(pdfObject)) {
                                    this.linObject = null;
                                    bl = false;
                                } else {
                                    pdfObject.isDataExternal(true);
                                    new PdfStreamDecoder(pdfObjectReader).readResources(pdfObject, true);
                                    if (!pdfObject.isFullyResolved()) {
                                        this.linObject = null;
                                        bl = false;
                                    }
                                }
                            }
                        }
                        if (bl && this.linObject != null) {
                            this.linObjects.put(n2, this.linObject);
                        }
                    }
                } else {
                    bl = false;
                }
            } else {
                this.linObject = null;
            }
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLinearData(PdfObjectReader pdfObjectReader, File file, InputStream inputStream, PdfDecoder pdfDecoder) throws IOException {
        FileChannel fileChannel;
        int n;
        FileChannel fileChannel2 = new RandomAccessFile(file, "rws").getChannel();
        fileChannel2.force(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            if (n > 0) {
                fileChannel = fileChannel2;
                synchronized (fileChannel) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                    fileChannel2.write(byteBuffer);
                }
            }
            n2 += n;
        }
        inputStream.close();
        fileChannel = fileChannel2;
        synchronized (fileChannel) {
            fileChannel2.close();
        }
        return null;
    }

    public PdfObject readHintTable(PdfObject pdfObject, PdfObjectReader pdfObjectReader) throws PdfException {
        long l = -1L;
        this.linearPageCount = -1;
        int n = this.linearObj.getInt(31);
        if (n != -1) {
            this.linearObj.setIntNumber(31, -1);
            pdfObjectReader.getObjectReader().readReferenceTable(this.linearObj);
            pdfObject = new PageObject(n, 0);
            pdfObjectReader.readObject(pdfObject);
            this.linearPageCount = this.linearObj.getInt(30);
            l = pdfObjectReader.getObjectReader().getOffset(n);
        } else {
            pdfObject = pdfObjectReader.getObjectReader().readReferenceTable(null);
        }
        int[] nArray = this.linearObj.getIntArray(24);
        byte[] byArray = pdfObjectReader.getObjectReader().getBytes(nArray[0], nArray[1]);
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = n4;
        while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
            if (byArray[n4] < 48 || byArray[n4] > 57) {
                bl = true;
            }
            ++n4;
        }
        if (!bl) {
            int n6 = NumberUtils.parseInt(n5, n4, byArray);
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                ++n4;
            }
            n5 = n4;
            while (n4 < 10 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                ++n4;
            }
            int n7 = NumberUtils.parseInt(n5, n4, byArray);
            while (n4 < n2 - 1) {
                if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                    n3 = n4;
                    n4 = n2;
                }
                ++n4;
            }
            byte[] byArray2 = new byte[n2 - n3];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            LinearizedObject linearizedObject = new LinearizedObject(n6, n7);
            linearizedObject.setStatus(2);
            linearizedObject.setUnresolvedData(byArray2, 2004845231);
            pdfObjectReader.checkResolved(linearizedObject);
            this.linHintTable.readTable(linearizedObject, this.linearObj, n, l);
        }
        return pdfObject;
    }

    public int getPageCount() {
        return this.linearPageCount;
    }

    public boolean hasLinearData() {
        return this.linearObj != null && this.E != -1;
    }

    public PdfObject getLinearPageObject() {
        return this.linObject;
    }

    public PdfObject getLinearObject(boolean bl, PdfObjectReader pdfObjectReader) {
        if (!this.isLinearizationTested) {
            // empty if block
        }
        return this.linearObj;
    }
}

