/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ImageHelper;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;

public class DefaultImageHelper
implements ImageHelper {
    public DefaultImageHelper() {
        ImageIO.setUseCache(false);
    }

    public void write(BufferedImage object, String string, String string2) throws Exception {
        if (!string.equals("jpg") && JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
            JAI.create((String)"filestore", (RenderedImage)object, (Object)string2, (Object)string);
        } else {
            Object object2;
            if (GenericColorSpace.fasterPNG) {
                object2 = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), 13);
                Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
                graphics2D.drawImage((Image)object, 0, 0, null);
                object = object2;
            }
            object2 = new BufferedOutputStream(new FileOutputStream(new File(string2)));
            ImageIO.write((RenderedImage)object, string, (OutputStream)object2);
            ((BufferedOutputStream)object2).flush();
            ((FilterOutputStream)object2).close();
        }
    }

    public BufferedImage read(String string) {
        boolean bl = false;
        BufferedImage bufferedImage = null;
        if (JAIHelper.isJAIused()) {
            try {
                bufferedImage = JAI.create((String)"fileload", (Object)string).getAsBufferedImage();
                bl = true;
            }
            catch (Exception exception) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
                bl = false;
            }
            catch (Error error) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error: " + error.getMessage());
                }
                throw new RuntimeException("Error " + error + " loading " + string + " with JAI");
            }
        }
        if (!bl) {
            try {
                bufferedImage = ImageIO.read(new File(string));
            }
            catch (IOException iOException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
            }
            catch (Error error) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error: " + error.getMessage());
                }
                throw new RuntimeException("Error " + error + " loading " + string + " with ImageIO");
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Raster readRasterFromJPeg(byte[] byArray) throws IOException {
        ImageInputStream imageInputStream;
        ImageReader imageReader;
        Raster raster;
        block12: {
            raster = null;
            imageReader = null;
            imageInputStream = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                try {
                    ImageReader imageReader2;
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(imageReader = (imageReader2 = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    imageReader.setInput(imageInputStream, true);
                    raster = imageReader.readRaster(0, null);
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Unable to find JAI jars on classpath");
                    }
                    Object var9_10 = null;
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    if (imageInputStream != null) {
                        imageInputStream.flush();
                        imageInputStream.close();
                    }
                    if (imageReader == null) return raster;
                    imageReader.dispose();
                    return raster;
                }
                Object var9_9 = null;
                if (byteArrayInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                if (imageInputStream != null) {
                    imageInputStream.flush();
                    imageInputStream.close();
                }
                if (imageReader == null) throw throwable;
                imageReader.dispose();
                throw throwable;
            }
            byteArrayInputStream.close();
        }
        if (imageInputStream != null) {
            imageInputStream.flush();
            imageInputStream.close();
        }
        if (imageReader == null) return raster;
        imageReader.dispose();
        return raster;
    }

    public BufferedImage read(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ImageIO.setUseCache(false);
        return ImageIO.read(byteArrayInputStream);
    }
}

