/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class JAITiffHelper {
    private ImageDecoder dec;
    private int pageCount;

    public JAITiffHelper(String string) {
        block2: {
            this.pageCount = 0;
            try {
                File file = new File(string);
                FileSeekableStream fileSeekableStream = new FileSeekableStream(file);
                this.dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)fileSeekableStream, null);
                this.pageCount = this.dec.getNumPages();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public int getTiffPageCount() {
        return this.pageCount;
    }

    public BufferedImage getImage(int n) {
        BufferedImage bufferedImage;
        block2: {
            bufferedImage = null;
            try {
                NullOpImage nullOpImage = new NullOpImage(this.dec.decodeAsRenderedImage(n), null, null, 2);
                bufferedImage = JAI.create((String)"affine", (RenderedImage)nullOpImage, null, (Object)new InterpolationBicubic(1)).getAsBufferedImage();
                bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 10);
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        return bufferedImage;
    }
}

