/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfPageData;

public class ConvertPagesToGoogleMaps {
    public static void main(String[] stringArray) {
        try {
            String string;
            if (stringArray.length != 2) {
                throw new Exception("Arguments incorrect. Arguments are \"/PDF_Location/pdf.pdf\" \"/Output_Directory/\"");
            }
            if (!stringArray[0].endsWith(".pdf")) {
                throw new Exception(stringArray[0] + " not a PDF.");
            }
            File file = new File(stringArray[0]);
            if (!file.exists()) {
                throw new Exception(file.getAbsolutePath() + " does not exist.");
            }
            File file2 = new File(stringArray[1]);
            if (!file2.exists()) {
                throw new Exception(file2.getAbsolutePath() + " does not exist.");
            }
            PdfDecoder pdfDecoder = new PdfDecoder(true);
            pdfDecoder.openPdfFile(stringArray[0]);
            String string2 = file.getName().substring(0, file.getName().length() - 4);
            file2 = new File(file2, string2);
            file2.mkdir();
            int n = pdfDecoder.getPageCount();
            for (int i = 1; i <= n; ++i) {
                string = ConvertPagesToGoogleMaps.getPageAsString(i, n);
                new File(file2.getAbsolutePath() + File.separator + string + File.separator).mkdir();
                PdfPageData pdfPageData = pdfDecoder.getPdfPageData();
                int n2 = pdfPageData.getCropBoxWidth(i);
                int n3 = pdfPageData.getCropBoxHeight(i);
                for (int j = 1; j <= 4; ++j) {
                    int n4 = (int)Math.sqrt((int)Math.pow(4.0, j));
                    int n5 = 256 * n4;
                    float f = n2 > n3 ? (float)n5 / (float)n2 : (float)n5 / (float)n3;
                    pdfDecoder.setPageParameters(f, i);
                    BufferedImage bufferedImage = pdfDecoder.getPageAsImage(i);
                    BufferedImage bufferedImage2 = new BufferedImage(n5, n5, 2);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    int n6 = (n5 - bufferedImage.getWidth()) / 2;
                    int n7 = (n5 - bufferedImage.getHeight()) / 2;
                    graphics2D.drawImage(bufferedImage, n6, n7, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                    for (int k = 0; k < n4; ++k) {
                        int n8 = k * 256;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            int n9 = i2 * 256;
                            BufferedImage bufferedImage3 = bufferedImage2.getSubimage(n9, n8, 256, 256);
                            ImageIO.write((RenderedImage)bufferedImage3, "png", new FileOutputStream(file2.getAbsolutePath() + File.separator + string + File.separator + "tile_" + j + "_" + i2 + "-" + k + ".png"));
                        }
                    }
                }
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2.getAbsolutePath() + File.separator + string + ".html"));
                    String string3 = i > 1 ? ConvertPagesToGoogleMaps.getPageAsString(i - 1, n) : null;
                    String string4 = i < n ? ConvertPagesToGoogleMaps.getPageAsString(i + 1, n) : null;
                    bufferedOutputStream.write(ConvertPagesToGoogleMaps.getHTML(string2, string, string3, string4, "" + n, 1, 4).getBytes());
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.out.println("Page " + i + " completed!");
            }
            pdfDecoder.closePdfFile();
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2.getAbsolutePath() + File.separator + "index.html"));
                string = "<!DOCTYPE html><html><head><meta http-equiv=\"Refresh\" content=\"0; url=" + ConvertPagesToGoogleMaps.getPageAsString(1, n) + ".html\"></head><body></body></html>";
                bufferedOutputStream.write(string.getBytes());
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static String getPageAsString(int n, int n2) {
        int n3 = ("" + n2).length() - ("" + n).length();
        String string = "";
        for (int i = 0; i < n3; ++i) {
            string = string + "0";
        }
        string = string + "" + n;
        return string;
    }

    private static String getHTML(String string, String string2, String string3, String string4, String string5, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html>\n");
        stringBuilder.append("<html lang=\"en\">\n");
        stringBuilder.append("<head>\n");
        stringBuilder.append("\t<meta charset=\"utf-8\" />\n");
        stringBuilder.append("\t<title>" + string + " Page " + string2 + "</title>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("\n");
        stringBuilder.append("<body>\n");
        stringBuilder.append("\t<div id=\"page" + string2 + "\" style=\"width:1050px;height:590px;margin:10px auto;border:2px solid #000;\"></div>\n");
        stringBuilder.append("\t<center>" + (string3 != null ? "<a href=\"" + string3 + ".html\" >&lt;&lt;</a>" : "&lt;&lt;") + " Page " + string2 + " of " + string5 + " " + (string4 != null ? "<a href=\"" + string4 + ".html\" > &gt;&gt;</a>" : "&gt;&gt;") + "</center>\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t<script type=\"text/javascript\" src=\"http://maps.google.com/maps/api/js?libraries=geometry&sensor=false\"></script>\n");
        stringBuilder.append("\t<script type=\"text/javascript\">\n");
        stringBuilder.append("\t/* <![CDATA[ */\n");
        stringBuilder.append("\t\t// Google Maps Demo\n");
        stringBuilder.append("\t\tvar Demo = Demo || {};\n");
        stringBuilder.append("\t\tDemo.ImagesBaseUrl = '';\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t//Page" + string2 + "\n");
        stringBuilder.append("\t\tDemo.Page" + string2 + " = function (container) {\n");
        stringBuilder.append("\t\t\t// Create map\n");
        stringBuilder.append("\t\t\tthis._map = new google.maps.Map(container, {\n");
        stringBuilder.append("\t\t\t\tzoom: " + n + ",\n");
        stringBuilder.append("\t\t\t\tcenter: new google.maps.LatLng(0, -20),\n");
        stringBuilder.append("\t\t\t\tmapTypeControl: false,\n");
        stringBuilder.append("\t\t\t\tstreetViewControl: false\n");
        stringBuilder.append("\t\t\t});\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t\t// Set custom tiles\n");
        stringBuilder.append("\t\t\tthis._map.mapTypes.set('" + string2 + "', new Demo.ImgMapType('" + string2 + "', '#E5E3DF'));\n");
        stringBuilder.append("\t\t\tthis._map.setMapTypeId('" + string2 + "');\n");
        stringBuilder.append("\t\t};\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t// ImgMapType class\n");
        stringBuilder.append("\t\tDemo.ImgMapType = function (theme, backgroundColor) {\n");
        stringBuilder.append("\t\t\tthis.name = this._theme = theme;\n");
        stringBuilder.append("\t\t\tthis._backgroundColor = backgroundColor;\n");
        stringBuilder.append("\t\t};\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\tDemo.ImgMapType.prototype.tileSize = new google.maps.Size(256, 256);\n");
        stringBuilder.append("\t\tDemo.ImgMapType.prototype.minZoom = " + n + ";\n");
        stringBuilder.append("\t\tDemo.ImgMapType.prototype.maxZoom = " + n2 + ";\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\tDemo.ImgMapType.prototype.getTile = function (coord, zoom, ownerDocument) {\n");
        stringBuilder.append("\t\t\tvar tilesCount = Math.pow(2, zoom);\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t\tif (coord.x >= tilesCount || coord.x < 0 || coord.y >= tilesCount || coord.y < 0) {\n");
        stringBuilder.append("\t\t\t\tvar div = ownerDocument.createElement('div');\n");
        stringBuilder.append("\t\t\t\tdiv.style.width = this.tileSize.width + 'px';\n");
        stringBuilder.append("\t\t\t\tdiv.style.height = this.tileSize.height + 'px';\n");
        stringBuilder.append("\t\t\t\tdiv.style.backgroundColor = this._backgroundColor;\n");
        stringBuilder.append("\t\t\t\treturn div;\n");
        stringBuilder.append("\t\t\t}\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t\tvar img = ownerDocument.createElement('IMG');\n");
        stringBuilder.append("\t\t\timg.width = this.tileSize.width;\n");
        stringBuilder.append("\t\t\timg.height = this.tileSize.height;\n");
        stringBuilder.append("\t\t\timg.src = Demo.Utils.GetImageUrl(this._theme + '/tile_' + zoom + '_' + coord.x + '-' + coord.y + '.png');\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t\treturn img;\n");
        stringBuilder.append("\t\t};\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t// Other\n");
        stringBuilder.append("\t\tDemo.Utils = Demo.Utils || {};\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\tDemo.Utils.GetImageUrl = function (image) {\n");
        stringBuilder.append("\t\t\treturn Demo.ImagesBaseUrl + image;\n");
        stringBuilder.append("\t\t};\n");
        stringBuilder.append("\n");
        stringBuilder.append("\t\t// Map creation\n");
        stringBuilder.append("\t\tgoogle.maps.event.addDomListener(window, 'load', function () {\n");
        stringBuilder.append("\t\t\tvar page" + string2 + " = new Demo.Page" + string2 + "(document.getElementById('page" + string2 + "'));\n");
        stringBuilder.append("\t\t});\n");
        stringBuilder.append("\t/* ]]> */\n");
        stringBuilder.append("\t</script>\n");
        stringBuilder.append("</body>\n");
        stringBuilder.append("</html>\n");
        return stringBuilder.toString();
    }
}

