/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.SetOfIntegerSyntax;
import org.jpedal.Overlays;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PdfStreamDecoderForPrinting;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Messages;

public class SwingPrinter {
    private Overlays overlays;
    private int duplexGapOdd = 0;
    private int duplexGapEven = 0;
    ObjectStore objectPrintStoreRef = null;
    ExternalHandlers externalHandlers;
    private boolean centerOnScaling = false;
    public boolean operationSuccessful = true;
    public int pageScalingMode = 2;
    public String pageErrorMessages = "";
    public boolean printOnlyVisible = false;
    public int logicalPageOffset = 0;
    public DynamicVectorRenderer printRender = null;
    public int lastPrintedPage = -1;
    public int currentPrintPage = 0;
    public boolean isCustomPrinting = false;
    PdfObjectReader currentPdfFile;
    public Map pageFormats = new HashMap(100);
    public int[] listOfPages;
    public boolean allowDifferentPrintPageSizes = false;
    public int start = 0;
    public int end = -1;
    public boolean oddPagesOnly = false;
    public boolean evenPagesOnly = false;
    public SetOfIntegerSyntax range;
    public boolean pagesPrintedInReverse = false;
    public boolean stopPrinting = false;
    public boolean isPrintAutoRotateAndCenter = false;
    public boolean usePDFPaperSize = false;
    public PdfStreamDecoderForPrinting currentPrintDecoder = null;
    public boolean legacyPrintMode = true;
    private float scaling;
    private int insetW;
    private int insetH;

    public int getNumberOfPages(int n) {
        if (this.range != null) {
            int n2 = 0;
            for (int i = 1; i < n + 1; ++i) {
                if (!this.range.contains(i) || this.oddPagesOnly && (i & 1) != 1 || this.evenPagesOnly && (i & 1) != 0) continue;
                ++n2;
            }
            return n2;
        }
        int n3 = 1;
        if (this.end != -1 && (n3 = this.end - this.start + 1) < 0) {
            n3 = 2 - n3;
        }
        if (this.oddPagesOnly || this.evenPagesOnly) {
            return (n3 + 1) / 2;
        }
        return n3;
    }

    public PageFormat getPageFormat(int n, PdfPageData pdfPageData, int n2) throws IndexOutOfBoundsException {
        int n3;
        Object v;
        if (this.listOfPages != null && n < this.listOfPages.length) {
            n = this.listOfPages[n];
        }
        if ((v = this.pageFormats.get(n3 = this.end == -1 ? n + 1 : (this.end > this.start ? this.start + n : this.start - n))) == null) {
            v = this.pageFormats.get("standard");
        }
        PageFormat pageFormat = new PageFormat();
        this.pageFormats.put("Align-" + n3, "normal");
        if (this.usePDFPaperSize) {
            int n4 = pdfPageData.getCropBoxWidth(n3);
            int n5 = pdfPageData.getCropBoxHeight(n3);
            int n6 = pdfPageData.getRotation(n3);
            if (this.allowDifferentPrintPageSizes) {
                int n7;
                if (n6 == 90 || n6 == 270) {
                    n7 = n4;
                    n4 = n5;
                    n5 = n7;
                }
                if (n4 > n5) {
                    n7 = n4;
                    n4 = n5;
                    n5 = n7;
                    if (n6 == 90) {
                        this.pageFormats.put("Align-" + n3, "inverted");
                    }
                }
            }
            this.createCustomPaper(pageFormat, n4, n5, n2, pdfPageData);
        } else if (v != null) {
            pageFormat = (PageFormat)v;
        }
        if (!this.isPrintAutoRotateAndCenter) {
            pageFormat.setOrientation(1);
        }
        return pageFormat;
    }

    private void createCustomPaper(PageFormat pageFormat, int n, int n2, int n3, PdfPageData pdfPageData) {
        Paper paper = new Paper();
        if (n3 == 1 || this.allowDifferentPrintPageSizes) {
            paper.setSize(n, n2);
            paper.setImageableArea(0.0, 0.0, n, n2);
        } else {
            int n4 = 0;
            int n5 = 0;
            for (int i = this.start; i <= this.end; ++i) {
                if (n > pdfPageData.getMediaBoxWidth(i) + 1 || n2 > pdfPageData.getMediaBoxHeight(i) + 1) continue;
                n4 = pdfPageData.getMediaBoxWidth(i) + 1;
                n5 = pdfPageData.getMediaBoxHeight(i) + 1;
            }
            paper.setSize(n4, n5);
            paper.setImageableArea(0.0, 0.0, n, n2);
        }
        pageFormat.setPaper(paper);
    }

    public void setPagePrintRange(SetOfIntegerSyntax setOfIntegerSyntax, int n) throws PdfException {
        int n2;
        int n3;
        this.range = setOfIntegerSyntax;
        this.start = setOfIntegerSyntax.next(0);
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (!setOfIntegerSyntax.contains(n3)) continue;
            ++n4;
        }
        this.listOfPages = new int[n4 + 1];
        n3 = this.start;
        this.end = this.start;
        if (setOfIntegerSyntax.contains(Integer.MAX_VALUE)) {
            this.end = n;
        } else {
            while (setOfIntegerSyntax.next(n3) != -1) {
                ++n3;
            }
            this.end = n3;
        }
        if (this.start > this.end) {
            n2 = this.start;
            this.start = this.end;
            this.end = n2;
        }
        n2 = 0;
        for (int i = this.start; i < this.end + 1; ++i) {
            if (!setOfIntegerSyntax.contains(i) || this.oddPagesOnly && (i & 1) != 1 || this.evenPagesOnly && (i & 1) != 0) continue;
            this.listOfPages[n2] = i - this.start;
            ++n2;
        }
        if (this.start < 1 || this.end < 1 || this.start > n || this.end > n) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + this.start + ' ' + this.end);
        }
    }

    public void setPrintPageMode(int n) {
        this.oddPagesOnly = (n & 0x10) == 16;
        this.evenPagesOnly = (n & 0x20) == 32;
        this.pagesPrintedInReverse = (n & 0x40) == 64;
    }

    public void putPageFormat(Object object, PageFormat pageFormat) {
        this.pageFormats.put(object, pageFormat);
    }

    public int getCurrentPrintPage() {
        return this.currentPrintPage;
    }

    public final void stopPrinting() {
        this.stopPrinting = true;
    }

    public void setPagePrintRange(int n, int n2, int n3) throws PdfException {
        this.start = n;
        this.end = n2;
        if (n2 == Integer.MAX_VALUE) {
            n2 = n3;
        }
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        if (n < 1 || n2 < 1 || n > n3 || n2 > n3) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + n + ' ' + n2);
        }
    }

    public void useLogicalPrintOffset(int n) {
        this.logicalPageOffset = n;
    }

    public boolean isPageSuccessful() {
        return this.operationSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public void setPrintPageScalingMode(int n) {
        this.pageScalingMode = n;
    }

    private static Map toMap(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        int n = nArray.length;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(n);
        for (int n2 : nArray) {
            hashMap.put(n2, "x");
        }
        return hashMap;
    }

    private Rectangle workoutClipping(int n, Rectangle rectangle, int n2, int n3) {
        double d = rectangle.getX();
        double d2 = rectangle.getY();
        double d3 = rectangle.getWidth();
        double d4 = rectangle.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n) {
            case 0: {
                n4 = (int)((float)(rectangle.x - this.insetW) / this.scaling);
                n5 = (int)((float)n3 - (float)(rectangle.y + rectangle.height - this.insetH) / this.scaling);
                n6 = (int)((float)rectangle.width / this.scaling - 1.0f);
                n7 = (int)((float)rectangle.height / this.scaling);
                break;
            }
            case 90: {
                n4 = (int)((d2 - (double)this.insetH) / (double)this.scaling);
                n5 = (int)((d - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d4 / (double)this.scaling);
                n7 = (int)(d3 / (double)this.scaling);
                break;
            }
            case 180: {
                n5 = (int)(d2 / (double)this.scaling - (double)((float)this.insetH / this.scaling));
                n4 = (int)((double)n2 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d3 / (double)this.scaling);
                n7 = (int)(d4 / (double)this.scaling);
                break;
            }
            case 270: {
                n4 = (int)((double)n2 - (d2 + d4 - (double)this.insetH) / (double)this.scaling);
                n5 = (int)((double)n3 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d4 / (double)this.scaling);
                n7 = (int)(d3 / (double)this.scaling);
            }
        }
        Rectangle rectangle2 = new Rectangle(n4, n5, n6, n7);
        return rectangle2;
    }

    public void printAdditionalObjectsOverPage(int n, int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (this.overlays == null) {
            this.overlays = new Overlays();
        }
        this.overlays.printAdditionalObjectsOverPage(n, nArray, colorArray, objectArray);
    }

    public void printAdditionalObjectsOverAllPages(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (this.overlays == null) {
            this.overlays = new Overlays();
        }
        this.overlays.printAdditionalObjectsOverAllPages(nArray, colorArray, objectArray);
    }

    public void clear() {
        if (this.overlays != null) {
            this.overlays.clear();
        }
        if (this.objectPrintStoreRef != null) {
            this.objectPrintStoreRef.flush();
        }
    }

    public void setPrintIndent(int n, int n2) {
        this.duplexGapOdd = n;
        this.duplexGapEven = n2;
    }

    public void setCenterOnScaling(boolean bl) {
        this.centerOnScaling = bl;
    }
}

