/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.ImageObject;

public class ExampleAnnotationHandler
implements AnnotationHandler {
    public void handleAnnotations(PdfDecoder pdfDecoder, Map map, int n) {
        PdfArrayIterator pdfArrayIterator = pdfDecoder.getFormRenderer().getAnnotsOnPage(n);
        if (pdfArrayIterator != null && pdfArrayIterator.getTokenCount() > 0) {
            int n2 = 0;
            int n3 = pdfArrayIterator.getTokenCount();
            int[] nArray = new int[n3];
            Color[] colorArray = new Color[n3];
            Object[] objectArray = new Object[n3];
            while (pdfArrayIterator.hasMoreTokens()) {
                Object[] objectArray2;
                int n4 = pdfDecoder.getPdfPageData().getMediaBoxX(n);
                int n5 = pdfDecoder.getPdfPageData().getMediaBoxY(n);
                String string = pdfArrayIterator.getNextValueAsString(true);
                for (Object object : objectArray2 = pdfDecoder.getFormRenderer().getCompData().getRawForm(string)) {
                    FormObject formObject;
                    int n6;
                    if (object == null || (n6 = (formObject = (FormObject)object).getParameterConstant(1147962727)) != 473513531) continue;
                    map.put(formObject, "x");
                    Color color = Color.BLUE;
                    Rectangle rectangle = formObject.getBoundingRectangle();
                    nArray[n2] = 3;
                    ImageObject imageObject = new ImageObject();
                    imageObject.x = rectangle.x + n4;
                    imageObject.y = rectangle.y + n5;
                    imageObject.image = ExampleAnnotationHandler.createUniqueImage(16, String.valueOf(n2 + 1), color);
                    objectArray[n2] = imageObject;
                    ++n2;
                }
            }
        }
    }

    public void checkLinks(Map map, boolean bl, PdfObjectReader pdfObjectReader, int n, int n2, SwingGUI swingGUI, Values values) {
        Iterator iterator = map.keySet().iterator();
        FormObject formObject = null;
        while (iterator.hasNext() && !(formObject = (FormObject)iterator.next()).getBoundingRectangle().contains(n, n2)) {
            formObject = null;
        }
        if (formObject != null) {
            System.out.println("clicked on=" + bl + " obj=" + formObject + ' ' + formObject.getObjectRefAsString() + ' ' + formObject.getBoundingRectangle());
            if (!bl) {
                return;
            }
            PdfObject pdfObject = null;
            PdfObject pdfObject2 = formObject.getDictionary(5667);
            if (pdfObject2 != null) {
                pdfObject = pdfObject2.getDictionary(5398);
            }
            JFileChooser jFileChooser = new JFileChooser(values.getInputDir());
            jFileChooser.setFileSelectionMode(0);
            int n3 = jFileChooser.showSaveDialog(swingGUI.getFrame());
            if (n3 == 0) {
                File file = jFileChooser.getSelectedFile();
                if (pdfObject != null) {
                    pdfObjectReader.checkResolved(pdfObject);
                }
                PdfObject pdfObject3 = pdfObject.getDictionary(22);
                String string = pdfObject3.getCachedStreamFile(pdfObjectReader.getObjectReader());
                System.out.println("file=" + string);
                if (string != null) {
                    ObjectStore.copy(string, file.toString());
                } else {
                    byte[] byArray = pdfObject3.getDecodedStream();
                    if (byArray != null) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            fileOutputStream.write(byArray);
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private static BufferedImage createUniqueImage(int n, String string, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(new Rectangle(0, 0, n, n));
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(new Rectangle(0, 0, n - 1, n - 1));
        graphics2D.setColor(Color.white);
        graphics2D.drawString(string, 2, 12);
        return bufferedImage;
    }
}

