/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.io;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.render.output.io.CustomIO;
import org.jpedal.utils.LogWriter;

public class DefaultIO
implements CustomIO {
    private BufferedWriter output = null;
    Map imagesWritten = new HashMap();

    public void writeFont(String string, byte[] byArray) {
        block2: {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public void writeJS(String string, InputStream inputStream) throws IOException {
        String string2 = string + "/js";
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string + "/js/aform.js"));
        ObjectStore.copy(bufferedInputStream, bufferedOutputStream);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public void writeCSS(String string, String string2, StringBuilder stringBuilder) {
        block3: {
            String string3 = string + string2 + '/';
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3 + "styles.css"));
                bufferedOutputStream.write(stringBuilder.toString().getBytes());
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public boolean isOutputOpen() {
        return this.output != null;
    }

    public void setupOutput(String string, boolean bl, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this.output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, bl), string2));
    }

    public void flush() {
        block2: {
            try {
                this.output.flush();
                this.output.close();
                this.imagesWritten.clear();
                this.output = null;
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public void writeString(String string) {
        block2: {
            try {
                this.output.write(string);
                this.output.write(10);
                this.output.flush();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public String writeImage(String string, String string2, BufferedImage bufferedImage) {
        String string3;
        block4: {
            string3 = string2 + this.getImageTypeUsed();
            String string4 = string + string3;
            try {
                if (!JAIHelper.isJAIused()) {
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string4));
                } else {
                    JAIHelper.confirmJAIOnClasspath();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string4)));
                    ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"PNG", (OutputStream)bufferedOutputStream, null);
                    imageEncoder.encode((RenderedImage)bufferedImage);
                    bufferedOutputStream.close();
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        return string3;
    }

    public String getImageTypeUsed() {
        return ".png";
    }
}

