/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.Rectangle;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputDisplay;

public class TextBlock {
    private float rotatedXCoord;
    private float rawXCoord;
    private float rotatedYCoord;
    private float rawYCoord;
    private float yAdjust;
    private float lastXCoord;
    private float stringWidth;
    private Rectangle cropBox;
    private int fontSize;
    private String font = "";
    private String realFont = "";
    private String weight = "normal";
    private String style = "normal";
    private float spaceWidth;
    private int fontAdjust = 0;
    private String text;
    private int textColRGB;
    private float[][] matrix;
    private float[][] Trm;
    private float lastYUsed;
    private float lastX = 0.0f;
    private int maxSpacesAllowed = 3;
    boolean convertSpacesTonbsp;
    int altFontSize;
    int fontCondition = -1;
    int pageRotation;

    public TextBlock() {
        this.text = "";
        this.textColRGB = -1;
        this.stringWidth = 0.0f;
    }

    public int getAltFontSize() {
        return this.altFontSize;
    }

    public TextBlock(String string, int n, FontMapper fontMapper, float[][] fArray, float f, float f2, float f3, int n2, float f4, Rectangle rectangle, float[][] fArray2, int n3, int n4, float f5, float f6, int n5) {
        this.text = string;
        this.matrix = fArray;
        this.lastXCoord = f5 + f3;
        this.rawXCoord = f;
        this.rotatedXCoord = f5;
        this.rawYCoord = f2;
        this.rotatedYCoord = f6;
        this.stringWidth = f3;
        this.fontSize = n;
        this.font = fontMapper.getFont(false);
        this.realFont = fontMapper.getFont(true);
        this.weight = fontMapper.getWeight();
        this.style = fontMapper.getStyle();
        this.fontAdjust = fontMapper.getFontSizeAdjustment();
        this.textColRGB = n2;
        this.spaceWidth = f4;
        this.cropBox = rectangle;
        this.Trm = fArray2;
        this.altFontSize = n3;
        this.fontCondition = n4;
        this.pageRotation = n5;
        this.lastX = fArray2[2][0];
        if (!rectangle.contains(f + f3, f2)) {
            this.text = "";
        }
    }

    public boolean isEmpty() {
        return this.text.length() == 0;
    }

    public float getX() {
        return this.rawXCoord;
    }

    public float getY() {
        return this.rawYCoord + this.yAdjust;
    }

    public void adjustY(float f) {
        this.yAdjust = f;
    }

    public float getWidth() {
        return this.stringWidth;
    }

    public int getFontSize() {
        if (this.matrix != null && this.matrix[0][0] * this.matrix[0][1] != 0.0f) {
            float f;
            float f2;
            float f3;
            float f4 = this.matrix[0][0];
            if (f4 < 0.0f) {
                f4 = -f4;
            }
            if ((f3 = this.matrix[0][1]) < 0.0f) {
                f3 = -f3;
            }
            float f5 = (f2 = f4 + (float)this.fontSize * f3) > (f = (float)this.fontSize * f4 + f3) ? f2 : f;
            return (int)Math.ceil(Math.abs(f5) / (float)this.fontSize);
        }
        return this.fontSize;
    }

    public String getFont() {
        return this.realFont;
    }

    public String getWeight() {
        return this.weight;
    }

    public int getColor() {
        return this.textColRGB;
    }

    private boolean compareTrm(float[][] fArray) {
        if (this.matrix == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (fArray[j][i] == this.matrix[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public float getRotationAngle() {
        float f = Math.abs(this.matrix[0][0]) + Math.abs(this.matrix[0][1]);
        float f2 = (float)Math.acos(this.matrix[0][0] / f);
        if (f2 != 0.0f && this.matrix[1][0] < 0.0f && this.matrix[0][1] > 0.0f) {
            f2 = -f2;
        }
        return f2;
    }

    public int getRotationAngleInDegrees() {
        int n;
        for (n = (int)((double)(this.getRotationAngle() * 180.0f) / Math.PI); n < 0; n += 360) {
        }
        return n;
    }

    private void concat(String string) {
        this.text = this.text + string;
    }

    public String getOutputString(boolean bl) {
        String string = this.text;
        if (bl && OutputDisplay.Helper != null) {
            string = OutputDisplay.Helper.tidyText(string);
            if (this.convertSpacesTonbsp) {
                string = string.replaceAll(" ", "&nbsp;");
            }
        }
        return string;
    }

    public boolean isSameFont(int n, FontMapper fontMapper, float[][] fArray, int n2) {
        float f = this.fontSize < 18 || n < 18 ? 0.0f : (this.fontSize < n ? (float)this.fontSize / (float)n : (float)n / (float)this.fontSize);
        return (this.compareTrm(fArray) && this.fontSize == n || f > 0.8f) && this.compareFontMapper(fontMapper) && this.textColRGB == n2;
    }

    private boolean compareFontMapper(FontMapper fontMapper) {
        return fontMapper.getFont(false).equals(this.font) && fontMapper.getWeight().equals(this.weight);
    }

    public boolean appendText(String string, float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) {
        if (!this.cropBox.contains(f4, f5)) {
            return false;
        }
        float f6 = this.rotatedYCoord - f3;
        if (Math.abs(f6) < 0.01f) {
            f6 = 0.0f;
            this.rotatedYCoord = f3;
        }
        float f7 = f2 - this.lastXCoord;
        if (this.getRotationAngleInDegrees() == 180) {
            f7 -= f;
        }
        if (!bl && string.equals(" ") && f6 == 0.0f && f7 < -f) {
            return true;
        }
        if (!bl && string.equals(" ")) {
            return false;
        }
        if (f7 < 0.0f && f7 > -f) {
            f7 = 0.0f;
        }
        if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][0] < 0.0f) {
            float f8 = (this.lastYUsed - f3) / (float)this.fontSize;
            if ((double)f8 > 1.5) {
                return false;
            }
            if (!(this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.lastX == f2 || f6 == 0.0f && !(f7 < -1.5f))) {
                return false;
            }
        } else if (f6 != 0.0f || f7 < -1.5f) {
            return false;
        }
        String string2 = "";
        int n = (int)(f7 / this.spaceWidth);
        float f9 = f7 % this.spaceWidth;
        if ((f9 /= this.spaceWidth) > PdfStreamDecoder.currentThreshold) {
            ++n;
        }
        if ((bl2 || n > this.maxSpacesAllowed) && (n > 2 || n > 0 && this.matrix[0][0] == 0.0f && this.matrix[1][1] == 0.0f)) {
            return false;
        }
        while (n-- > 0) {
            string2 = string2 + " ";
        }
        string2 = string2 + string;
        this.concat(string2);
        if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][0] < 0.0f && this.pageRotation == 0) {
            this.stringWidth = this.rotatedYCoord - f3 + f;
        } else {
            this.stringWidth = f2 - this.rotatedXCoord + f;
            this.lastXCoord = f2 + f;
        }
        this.lastYUsed = f3;
        return true;
    }

    public boolean hasSameFont(TextBlock textBlock) {
        return this.font.equals(textBlock.font) && this.weight.equals(textBlock.weight) && this.getFontSize() == textBlock.getFontSize();
    }

    public String getStyle() {
        return this.style;
    }

    public String toString() {
        String string = "text[" + this.text + "]\tfontSize[" + this.fontSize + "]\tspaceWidth[" + this.spaceWidth + "]\tcoord[" + this.rawXCoord + ", " + this.rawYCoord + ']';
        return string;
    }

    public int getFontAdjustment() {
        return this.fontAdjust;
    }

    public static boolean ignoreGlyf(String string) {
        return string.codePointAt(0) == 65533;
    }

    public void convertSpacesTonbsp(boolean bl) {
        this.convertSpacesTonbsp = bl;
    }

    public int getFontCondition() {
        return this.fontCondition;
    }
}

