/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;

public class RenderUtils {
    public static boolean isInverted(float[][] fArray) {
        return fArray[0][0] < 0.0f || fArray[1][1] < 0.0f;
    }

    public static boolean isRotated(float[][] fArray) {
        return fArray[0][0] == 0.0f && fArray[1][1] == 0.0f || fArray[0][1] > 0.0f && fArray[1][0] < 0.0f || fArray[0][1] < 0.0f && fArray[1][0] > 0.0f;
    }

    static BufferedImage invertImage(float[][] fArray, BufferedImage bufferedImage) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(0.0, -bufferedImage.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        boolean bl = false;
        if (JAIHelper.isJAIused()) {
            block14: {
                bl = true;
                try {
                    bufferedImage = JAI.create((String)"affine", (RenderedImage)bufferedImage, (Object)affineTransform, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception exception) {
                    bl = false;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                }
                catch (Error error) {
                    bl = false;
                    if (!LogWriter.isOutput()) break block14;
                    LogWriter.writeLog("Error: " + error.getMessage());
                }
            }
            if (!bl && LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        }
        if (!bl) {
            if (bufferedImage.getType() == 12) {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                affineTransformOp.filter(bufferedImage2, bufferedImage);
            } else {
                boolean bl2 = false;
                try {
                    bufferedImage = affineTransformOp.filter(bufferedImage, null);
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                if (bl2) {
                    try {
                        affineTransformOp = new AffineTransformOp(affineTransform, null);
                        bufferedImage = affineTransformOp.filter(bufferedImage, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bufferedImage;
    }

    static BufferedImage invertImageBeforeSave(BufferedImage bufferedImage, boolean bl) {
        AffineTransform affineTransform = new AffineTransform();
        if (bl) {
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-bufferedImage.getWidth(), 0.0);
        } else {
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -bufferedImage.getHeight());
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        boolean bl2 = false;
        if (JAIHelper.isJAIused()) {
            block11: {
                bl2 = true;
                try {
                    bufferedImage = JAI.create((String)"affine", (RenderedImage)bufferedImage, (Object)affineTransform, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception exception) {
                    bl2 = false;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                }
                catch (Error error) {
                    bl2 = false;
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Error: " + error.getMessage());
                }
            }
            if (!bl2 && LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        }
        if (!bl2) {
            if (bufferedImage.getType() == 12) {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                affineTransformOp.filter(bufferedImage2, bufferedImage);
            } else {
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
        }
        return bufferedImage;
    }

    static float[] checkSize(float[] fArray, int n) {
        int n2 = fArray.length;
        if (n2 <= n) {
            int n3 = n2 * 2;
            float[] fArray2 = new float[n3];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray = fArray2;
        }
        return fArray;
    }

    public static void renderClip(Area area, Rectangle rectangle, Shape shape, Graphics2D graphics2D) {
        if (area != null) {
            graphics2D.setClip(area);
            if (rectangle != null) {
                graphics2D.clip(rectangle);
            }
        } else {
            graphics2D.setClip(shape);
        }
    }

    static Rectangle getAreaForGlyph(float[][] fArray) {
        int n = (int)Math.sqrt(fArray[0][0] * fArray[0][0] + fArray[1][0] * fArray[1][0]);
        int n2 = (int)Math.sqrt(fArray[1][1] * fArray[1][1] + fArray[0][1] * fArray[0][1]);
        float f = 0.0f;
        float f2 = 0.0f;
        if (fArray[0][0] < 0.0f) {
            f = fArray[0][0];
        } else if (fArray[1][0] < 0.0f) {
            f = fArray[1][0];
        }
        if (fArray[1][1] < 0.0f) {
            f2 = fArray[1][1];
        } else if (fArray[0][1] < 0.0f) {
            f2 = fArray[0][1];
        }
        return new Rectangle((int)(fArray[2][0] + f), (int)(fArray[2][1] + f2), n, n2);
    }

    public static boolean rectangleContains(Rectangle rectangle, int n, int n2, int n3) {
        int n4;
        int n5 = rectangle.x;
        int n6 = rectangle.x + rectangle.width;
        int n7 = rectangle.y;
        int n8 = rectangle.y + rectangle.height;
        boolean bl = false;
        if (n5 > n6) {
            n4 = n5;
            n5 = n6;
            n6 = n4;
        }
        if (n7 > n8) {
            n4 = n7;
            n7 = n8;
            n8 = n4;
        }
        if (n7 < n2 && n2 < n8 && n5 < n && n < n6) {
            bl = true;
        }
        return bl;
    }

    public static Object restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static void writeToStream(ByteArrayOutputStream byteArrayOutputStream, Object object, String string) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
    }
}

