/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class BaseDisplay
implements DynamicVectorRenderer {
    protected int type;
    private int formNum = 0;
    boolean isType3Font = false;
    protected boolean addBackground = true;
    protected Vector_Rectangle areas;
    protected ObjectStore objectStoreRef;
    protected int currentItem = -1;
    protected int endItem = -1;
    protected int pageRotation = 0;
    Area lastClip = null;
    boolean hasClips = false;
    boolean colorsLocked;
    Graphics2D g2;
    boolean optimisedTurnCode = true;
    boolean useHiResImageForDisplay = false;
    boolean extraRot = false;
    String rawKey = null;
    PdfPaint fillCol = null;
    PdfPaint strokeCol = null;
    public int pageNumber = 0;
    int xx = 0;
    int yy = 0;
    public static boolean invertHighlight = false;
    boolean isPrinting;
    ImageHandler customImageHandler = null;
    ColorHandler customColorHandler = null;
    double cropX;
    double cropH;
    float scaling;
    float lastScaling;
    int w = 0;
    int h = 0;
    protected Color backgroundColor = Color.WHITE;
    protected Color textColor = null;
    protected int colorThresholdToReplace = 255;
    protected boolean changeLineArtAndText = false;
    public static RenderingHints userHints = null;

    public void setInset(int n, int n2) {
        this.xx = n;
        this.yy = n2;
    }

    public void setG2(Graphics2D graphics2D) {
        this.g2 = graphics2D;
        if (userHints != null) {
            this.g2.setRenderingHints(userHints);
        }
    }

    public void init(int n, int n2, int n3, Color color) {
        this.w = n;
        this.h = n2;
        this.pageRotation = n3;
        this.backgroundColor = color;
    }

    public void paintBackground(Shape shape) {
        if (this.addBackground && this.g2 != null) {
            this.g2.setColor(this.backgroundColor);
            if (shape == null) {
                this.g2.fill(new Rectangle(this.xx, this.yy, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                this.g2.fill(shape);
            }
        }
    }

    protected boolean checkColorThreshold(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return n2 <= this.colorThresholdToReplace && n3 <= this.colorThresholdToReplace && n4 <= this.colorThresholdToReplace;
    }

    void renderEmbeddedText(int n, Object object, int n2, AffineTransform affineTransform, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f, float f2, int n3) {
        float f3 = 0.0f;
        if (n == 1 && (double)n3 >= 1.0) {
            f3 = this.scaling;
        }
        PdfGlyph pdfGlyph = (PdfGlyph)object;
        AffineTransform affineTransform2 = this.g2.getTransform();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        if (pdfGlyph != null) {
            Color color;
            Stroke stroke = this.g2.getStroke();
            if (n3 != 0) {
                float f4 = (float)n3 * (float)this.g2.getTransform().getScaleX();
                if (f4 < 0.0f) {
                    f4 = -f4;
                }
                this.g2.setStroke(new BasicStroke(f4));
            }
            this.g2.transform(affineTransform);
            Composite composite = this.g2.getComposite();
            if ((n & 2) == 2) {
                if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(pdfPaint2.getRGB())) {
                    pdfPaint2 = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                } else if (PdfDecoder.Helper != null) {
                    PdfDecoder.Helper.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(pdfPaint2);
                }
                if (f2 != 1.0f) {
                    this.g2.setComposite(AlphaComposite.getInstance(3, f2));
                }
                if (rectangle != null) {
                    if (invertHighlight) {
                        color = this.g2.getColor();
                        this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                    } else if (DecoderOptions.backgroundColor != null) {
                        this.g2.setColor(DecoderOptions.backgroundColor);
                    }
                }
                if (n2 == 6 && !pdfGlyph.ignoreColors()) {
                    pdfGlyph.setT3Colors(pdfPaint, pdfPaint2, false);
                }
                pdfGlyph.render(2, this.g2, this.scaling, false);
                this.g2.setComposite(composite);
            }
            if (n == 1) {
                pdfGlyph.setStrokedOnly(true);
            }
            if (!(PdfDecoder.isRunningOnMac && this.isPrinting && n == 3 || (n & 1) != 1)) {
                block32: {
                    if (pdfPaint != null) {
                        if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(pdfPaint.getRGB())) {
                            pdfPaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                        }
                        pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    if (this.customColorHandler != null) {
                        this.customColorHandler.setPaint(this.g2, pdfPaint, this.pageNumber, this.isPrinting);
                    } else if (PdfDecoder.Helper != null) {
                        PdfDecoder.Helper.setPaint(this.g2, pdfPaint, this.pageNumber, this.isPrinting);
                    } else {
                        this.g2.setPaint(pdfPaint);
                    }
                    if (f != 1.0f) {
                        this.g2.setComposite(AlphaComposite.getInstance(3, f));
                    }
                    if (rectangle != null) {
                        if (invertHighlight) {
                            color = this.g2.getColor();
                            this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                        } else if (DecoderOptions.backgroundColor != null) {
                            this.g2.setColor(DecoderOptions.backgroundColor);
                        }
                    }
                    try {
                        pdfGlyph.render(1, this.g2, f3, false);
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block32;
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                }
                this.g2.setComposite(composite);
            }
            this.g2.setTransform(affineTransform2);
            if (n3 != 0) {
                this.g2.setStroke(stroke);
            }
        }
    }

    public void renderXForm(DynamicVectorRenderer dynamicVectorRenderer, float f) {
        Shape shape = null;
        if (this.g2 != null) {
            shape = this.g2.getClip();
        }
        Rectangle rectangle = dynamicVectorRenderer.getOccupiedArea();
        int n = rectangle.x;
        int n2 = rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.height;
        if (n < 0) {
            n = 0;
        }
        if (n3 > 0) {
            n4 += n3;
        }
        if (n2 <= 0 || n4 <= 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.g2 == null) {
            graphics2D.scale(1.0, -1.0);
            graphics2D.translate(0, -n4);
        }
        graphics2D.translate(-n, 0);
        dynamicVectorRenderer.setG2(graphics2D);
        dynamicVectorRenderer.paint(null, null, null);
        if (this.g2 != null) {
            this.g2.setClip(null);
        }
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.CTM[0][0] = n2;
        graphicsState.CTM[1][0] = 0.0f;
        graphicsState.CTM[2][0] = 0.0f;
        graphicsState.CTM[0][1] = 0.0f;
        graphicsState.CTM[1][1] = n4;
        graphicsState.CTM[2][1] = 0.0f;
        graphicsState.CTM[0][2] = 0.0f;
        graphicsState.CTM[1][2] = 0.0f;
        graphicsState.CTM[2][2] = 1.0f;
        if (this.g2 != null) {
            this.g2.translate(n, 0);
            this.renderImage(new AffineTransform(), bufferedImage, f, graphicsState, rectangle.x, rectangle.y, 1);
            this.g2.translate(-n, 0);
            this.g2.setClip(shape);
        } else {
            graphicsState.CTM[2][0] = rectangle.x;
            graphicsState.CTM[2][1] = rectangle.y - n4 + rectangle.height;
            this.drawImage(this.pageNumber, bufferedImage, graphicsState, false, "xf" + this.formNum, 0, -1);
            ++this.formNum;
        }
    }

    final void renderShape(Shape shape, int n, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, Shape shape2, float f, float f2) {
        boolean bl = false;
        Shape shape3 = this.g2.getClip();
        Composite composite = this.g2.getComposite();
        if (n == 2 || n == 3) {
            block22: {
                if (pdfPaint2.getRGB() != -1 && this.changeLineArtAndText && this.textColor != null && !pdfPaint2.isPattern() && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(pdfPaint2.getRGB())) {
                    pdfPaint2 = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                } else if (PdfDecoder.Helper != null) {
                    PdfDecoder.Helper.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(pdfPaint2);
                }
                if (f2 != 1.0f) {
                    this.g2.setComposite(AlphaComposite.getInstance(3, f2));
                }
                try {
                    double d = shape2.getBounds2D().getWidth();
                    double d2 = shape2.getBounds2D().getHeight();
                    if ((d2 == 0.0 || d == 0.0) && ((BasicStroke)this.g2.getStroke()).getLineWidth() <= 1.0f) {
                        this.g2.fillRect(shape2.getBounds().x, shape2.getBounds().y, shape2.getBounds().width, shape2.getBounds().height);
                    } else {
                        this.g2.fill(shape2);
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + exception + " filling shape");
                }
            }
            this.g2.setComposite(composite);
        }
        if (n == 1 || n == 3) {
            Stroke stroke2 = this.g2.getStroke();
            if (shape2.getBounds2D().getWidth() < 1.0 && ((BasicStroke)stroke).getLineWidth() > 10.0f) {
                this.g2.setStroke(new BasicStroke(1.0f));
            } else {
                this.g2.setStroke(stroke);
            }
            if (this.changeLineArtAndText && this.textColor != null && !pdfPaint.isPattern() && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(pdfPaint.getRGB())) {
                pdfPaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
            }
            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, pdfPaint, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(this.g2, pdfPaint, this.pageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(pdfPaint);
            }
            if (f != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, f));
            }
            if (!this.isPrinting && shape3 != null && (shape3.getBounds2D().getHeight() < 1.0 || shape3.getBounds2D().getWidth() < 1.0)) {
                this.g2.setClip(shape);
                bl = true;
            }
            this.g2.draw(shape2);
            this.g2.setStroke(stroke2);
            this.g2.setComposite(composite);
        }
        if (bl) {
            this.g2.setClip(shape3);
        }
    }

    final void renderImage(AffineTransform affineTransform, BufferedImage bufferedImage, float f, GraphicsState graphicsState, float f2, float f3, int n) {
        boolean bl;
        Object object;
        Object object2;
        AffineTransform affineTransform2;
        block58: {
            Object object3;
            Object object4;
            boolean bl2;
            boolean bl3 = bl2 = graphicsState != null;
            if (bufferedImage == null) {
                return;
            }
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            AffineTransform affineTransform3 = new AffineTransform();
            boolean bl4 = false;
            float[][] fArray = new float[3][3];
            if (graphicsState != null) {
                fArray = graphicsState.CTM;
            }
            if (fArray[0][0] < 0.0f && fArray[1][1] < 0.0f && fArray[1][0] > -2.0f && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[0][1] < 10.0f) {
                fArray[0][1] = 0.0f;
                fArray[1][0] = 0.0f;
            }
            affineTransform2 = this.g2.getTransform();
            boolean bl5 = false;
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (bl2 || this.useHiResImageForDisplay) {
                if (bl2) {
                    affineTransform3 = null;
                    if ((n & 1) != 1) {
                        if (!this.optimisedTurnCode) {
                            bufferedImage = RenderUtils.invertImage(fArray, bufferedImage);
                        } else if (fArray[0][1] < 0.0f && fArray[1][0] > 0.0f && fArray[0][0] * fArray[1][1] == 0.0f) {
                            affineTransform3 = new AffineTransform(fArray[0][0] / (float)n2, fArray[0][1] / (float)n2, -fArray[1][0] / (float)n3, fArray[1][1] / (float)n3, fArray[2][0] + fArray[1][0], fArray[2][1]);
                        } else if (fArray[0][1] < 0.0f || fArray[1][0] < 0.0f) {
                            object2 = new float[][]{{1.0f / (float)n2, 0.0f, 0.0f}, {0.0f, -1.0f / (float)n3, 0.0f}, {0.0f, 1.0f / (float)n3, 1.0f}};
                            object = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                            object2 = Matrix.multiply((float[][])object2, (float[][])object);
                            affineTransform3 = new AffineTransform((float)object2[0][0], (float)object2[0][1], (float)object2[1][0], (float)object2[1][1], (float)object2[2][0], (float)object2[2][1]);
                            f4 = fArray[2][0] - (float)bufferedImage.getHeight() * object2[1][0];
                            f5 = fArray[2][1];
                            f5 += fArray[1][1];
                        } else if (fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && fArray[0][1] > 0.0f && fArray[1][0] > 0.0f) {
                            object2 = new float[][]{{-1.0f / (float)n2, 0.0f, 0.0f}, {0.0f, 1.0f / (float)n3, 0.0f}, {1.0f / (float)n2, 0.0f, 1.0f}};
                            object = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                            object2 = Matrix.multiply((float[][])object2, (float[][])object);
                            affineTransform3 = new AffineTransform((float)object2[0][0], (float)object2[1][0], (float)object2[0][1], (float)object2[1][1], (float)object2[2][0], (float)object2[2][1]);
                            f4 = fArray[2][0] - (float)bufferedImage.getHeight() * object2[0][1];
                            f5 = fArray[2][1];
                        } else if (fArray[1][1] != 0.0f) {
                            bl5 = true;
                        }
                    }
                    if (affineTransform3 == null) {
                        affineTransform3 = new AffineTransform(fArray[0][0] / (float)n2, fArray[0][1] / (float)n2, fArray[1][0] / (float)n3, fArray[1][1] / (float)n3, fArray[2][0], fArray[2][1]);
                    }
                } else {
                    affineTransform3 = affineTransform;
                    bl5 = (n & 4) == 4;
                }
                bl4 = true;
            }
            object2 = this.g2.getComposite();
            object = this.g2.getClip();
            bl = false;
            if (f != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, f));
            }
            if (this.isType3Font && this.fillCol != null) {
                object4 = new int[4];
                int n4 = this.fillCol.getRGB();
                object4[0] = n4 >> 16 & 0xFF;
                object4[1] = n4 >> 8 & 0xFF;
                object4[2] = n4 & 0xFF;
                object4[3] = 255;
                if (object4[0] != 0 || object4[1] != 0 || object4[2] != 0) {
                    if (bufferedImage.getType() == 10 && object4[0] > 250 && object4[1] > 250 && object4[2] > 250) {
                        return;
                    }
                    object3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
                    WritableRaster writableRaster = bufferedImage.getRaster();
                    WritableRaster writableRaster2 = ((BufferedImage)object3).getRaster();
                    int[] nArray = new int[4];
                    for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                        for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                            writableRaster.getPixel(j, i, nArray);
                            if (nArray[3] <= 2) continue;
                            writableRaster2.setPixel(j, i, (int[])object4);
                        }
                    }
                    bufferedImage = object3;
                }
            }
            if (bl2 || this.useHiResImageForDisplay) {
                try {
                    BufferedImage bufferedImage2;
                    boolean bl6;
                    if (this.optimisedTurnCode && bl5 && (n & 1) != 1) {
                        object4 = new double[6];
                        affineTransform3.getMatrix((double[])object4);
                        f4 = object4[4] + object4[1] * (double)bufferedImage.getWidth();
                        f5 = object4[5] + (double)bufferedImage.getHeight() * object4[3];
                        if (object4[0] > 0.0 && object4[1] > 0.0 && object4[2] > 0.0 && object4[3] < 0.0) {
                            object4[2] = -object4[2];
                        }
                        object4[3] = -object4[3];
                        object4[4] = (int)0.0;
                        object4[5] = (int)0.0;
                        affineTransform3 = new AffineTransform((double[])object4);
                    }
                    boolean bl7 = bl6 = this.customImageHandler != null;
                    if (bl6) {
                        bl6 = this.customImageHandler.drawImageOnscreen(bufferedImage, n, affineTransform3, null, this.g2, bl2, this.objectStoreRef, this.isPrinting);
                    }
                    if (bl6) {
                        this.g2.setComposite((Composite)object2);
                        return;
                    }
                    this.g2.translate(f4, f5);
                    if (this.customColorHandler != null) {
                        BufferedImage bufferedImage3 = this.customColorHandler.processImage(bufferedImage, this.pageNumber, this.isPrinting);
                        if (bufferedImage3 != null) {
                            bufferedImage = bufferedImage3;
                        }
                    } else if (PdfDecoder.Helper != null && (bufferedImage2 = PdfDecoder.Helper.processImage(bufferedImage, this.pageNumber, this.isPrinting)) != null) {
                        bufferedImage = bufferedImage2;
                    }
                    Shape shape = this.g2.getClip();
                    boolean bl8 = false;
                    if (shape != null) {
                        double d = this.g2.getClip().getBounds2D().getY();
                        double d2 = this.g2.getClip().getBounds2D().getHeight();
                        double d3 = (double)bufferedImage.getHeight() - d2;
                        if (d3 < 0.0) {
                            d3 = -d3;
                        }
                        if (d3 > 0.0 && d3 < 1.0 && d < 0.0 && bufferedImage.getHeight() > 1 && bufferedImage.getHeight() < 10) {
                            int n5;
                            PathIterator pathIterator = this.g2.getClip().getPathIterator(null);
                            for (n5 = 0; !pathIterator.isDone() && n5 < 6; ++n5) {
                                pathIterator.next();
                            }
                            if (n5 < 6) {
                                double d4 = this.g2.getClip().getBounds2D().getX();
                                double d5 = this.g2.getClip().getBounds2D().getWidth();
                                this.g2.setClip(new Rectangle((int)d4, (int)d, (int)d5, (int)d2));
                                bl8 = false;
                            }
                        }
                    }
                    this.g2.drawImage(bufferedImage, affineTransform3, null);
                    if (bl8) {
                        this.g2.setClip(shape);
                    }
                    break block58;
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    break block58;
                }
            }
            try {
                if (bl4) {
                    object4 = new AffineTransformOp(affineTransform3, ColorSpaces.hints);
                    bufferedImage = ((AffineTransformOp)object4).filter(bufferedImage, null);
                }
                this.g2.translate(f2, f3);
                if (this.optimisedTurnCode && (n & 4) == 4) {
                    float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, bufferedImage.getHeight()};
                    if (this.pageRotation == 0) {
                        object4 = new AffineTransform(fArray2);
                    } else if (this.pageRotation == 90) {
                        object4 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object4).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object4).rotate(1.5707963267948966, 0.0, 0.0);
                        }
                        ((AffineTransform)object4).translate(-bufferedImage.getWidth(), -bufferedImage.getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, bufferedImage.getWidth(), 0.0f};
                        object3 = new AffineTransform(fArray2);
                        ((AffineTransform)object4).concatenate((AffineTransform)object3);
                    } else if (this.pageRotation == 180) {
                        object4 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object4).rotate(Math.PI, 0.0, 0.0);
                        }
                        ((AffineTransform)object4).translate(-bufferedImage.getWidth(), -bufferedImage.getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, bufferedImage.getWidth(), 0.0f};
                        object3 = new AffineTransform(fArray2);
                        ((AffineTransform)object4).concatenate((AffineTransform)object3);
                    } else {
                        object4 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object4).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object4).rotate(4.71238898038469, 0.0, 0.0);
                        }
                        ((AffineTransform)object4).translate(-bufferedImage.getWidth(), -bufferedImage.getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, bufferedImage.getWidth(), 0.0f};
                        object3 = new AffineTransform(fArray2);
                        ((AffineTransform)object4).concatenate((AffineTransform)object3);
                    }
                    this.g2.drawImage(bufferedImage, (AffineTransform)object4, null);
                } else {
                    this.g2.drawImage((Image)bufferedImage, 0, 0, null);
                }
                this.g2.translate(-f2, -f3);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block58;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.g2.setTransform(affineTransform2);
        if (bl && PdfDecoder.isRunningOnMac && object != null) {
            this.g2.setClip((Shape)object);
        }
        this.g2.setComposite((Composite)object2);
    }

    final void renderText(float f, float f2, int n, Area area, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f3, float f4) {
        Color color;
        Paint paint = this.g2.getPaint();
        Composite composite = this.g2.getComposite();
        if ((n & 2) == 2) {
            if (pdfPaint2 != null) {
                if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(pdfPaint2.getRGB())) {
                    pdfPaint2 = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, f, f2);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(pdfPaint2);
            }
            if (f4 != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, f4));
            }
            if (rectangle != null) {
                if (invertHighlight) {
                    color = this.g2.getColor();
                    this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            this.g2.fill(area);
            this.g2.setComposite(composite);
        }
        if ((n & 1) == 1) {
            float f5;
            if (pdfPaint != null) {
                if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(pdfPaint.getRGB())) {
                    pdfPaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                pdfPaint.setScaling(this.cropX + (double)f, this.cropH + (double)f2, this.scaling, f, f2);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, pdfPaint, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(this.g2, pdfPaint, this.pageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(pdfPaint);
            }
            if (f3 != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, f3));
            }
            if (rectangle != null) {
                if (invertHighlight) {
                    color = this.g2.getColor();
                    this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            if ((f5 = (float)(1.0 / this.g2.getTransform().getScaleX())) < 0.0f) {
                f5 = -f5;
            }
            this.g2.setStroke(new BasicStroke(f5));
            if (f5 < 0.1f) {
                this.g2.draw(area);
            } else {
                this.g2.fill(area);
            }
            this.g2.setComposite(composite);
        }
        this.g2.setPaint(paint);
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setHiResImageForDisplayMode(boolean bl) {
        this.useHiResImageForDisplay = bl;
    }

    public void setScalingValues(double d, double d2, float f) {
        this.cropX = d;
        this.cropH = d2;
        this.scaling = f;
    }

    public void setCustomImageHandler(ImageHandler imageHandler) {
        this.customImageHandler = imageHandler;
    }

    public void setCustomColorHandler(ColorHandler colorHandler) {
        this.customColorHandler = colorHandler;
    }

    public void resetOnColorspaceChange() {
    }

    public void drawFontBounds(Rectangle rectangle) {
    }

    public void drawAffine(double[] dArray) {
    }

    public void drawFontSize(int n) {
    }

    public void setLineWidth(int n) {
    }

    public void stopClearOnNextRepaint(boolean bl) {
    }

    public boolean hasObjectsBehind(float[][] fArray) {
        int n;
        boolean bl = false;
        int n2 = (int)fArray[2][0];
        int n3 = (int)fArray[2][1];
        int n4 = (int)fArray[0][0];
        if (n4 == 0) {
            n4 = (int)fArray[0][1];
        }
        if ((n = (int)fArray[1][1]) == 0) {
            n = (int)fArray[1][0];
        }
        if (n < 0) {
            n3 += n;
            n = n3 - n;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = n2 - n4;
        }
        Rectangle[] rectangleArray = this.areas.get();
        int n5 = rectangleArray.length;
        for (int i = 0; i < n5; ++i) {
            boolean bl2;
            if (rectangleArray[i] == null) continue;
            int n6 = rectangleArray[i].x;
            int n7 = rectangleArray[i].y;
            int n8 = rectangleArray[i].width;
            int n9 = rectangleArray[i].height;
            boolean bl3 = BaseDisplay.valueInRange(n2, n6, n6 + n8) || BaseDisplay.valueInRange(n6, n2, n2 + n4);
            boolean bl4 = bl2 = bl3 && BaseDisplay.valueInRange(n3, n7, n7 + n9) || BaseDisplay.valueInRange(n7, n3, n3 + n9);
            if (!bl3 || !bl2) continue;
            i = n5;
            bl = true;
        }
        return bl;
    }

    private static boolean valueInRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public void flagDecodingFinished() {
    }

    public void flagImageDeleted(int n) {
    }

    public void setOCR(boolean bl) {
    }

    public byte[] serializeToByteArray(Set set) throws IOException {
        return new byte[0];
    }

    public void checkFontSaved(Object object, String string, PdfFont pdfFont) {
    }

    public Rectangle getArea(int n) {
        return null;
    }

    public int isInsideImage(int n, int n2) {
        return 0;
    }

    public void saveImage(int n, String string, String string2) {
    }

    public int getType() {
        return this.type;
    }

    public int getObjectUnderneath(int n, int n2) {
        return 0;
    }

    public void setneedsVerticalInvert(boolean bl) {
    }

    public void setneedsHorizontalInvert(boolean bl) {
    }

    public void stopG2HintSetting(boolean bl) {
    }

    public void setPrintPage(int n) {
    }

    public void drawColor(PdfPaint pdfPaint, int n) {
    }

    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
    }

    public void drawCustom(Object object) {
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont, float f) {
    }

    public Rectangle paint(Rectangle[] rectangleArray, AffineTransform affineTransform, Rectangle rectangle) {
        return null;
    }

    public void setMessageFrame(Container container) {
    }

    public void dispose() {
    }

    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        return -1;
    }

    public void drawXForm(DynamicVectorRenderer dynamicVectorRenderer, GraphicsState graphicsState) {
    }

    public void drawFillColor(PdfPaint pdfPaint) {
    }

    public void drawAdditionalObjectsOverPage(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
    }

    public void flushAdditionalObjOnPage() {
    }

    public void setOptimsePainting(boolean bl) {
    }

    public void flush() {
    }

    public void drawText(float[][] fArray, String string, GraphicsState graphicsState, float f, float f2, Font font) {
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        return null;
    }

    public Rectangle getOccupiedArea() {
        return null;
    }

    public void setGraphicsState(int n, float f) {
    }

    public void drawStrokeColor(Paint paint) {
    }

    public void drawTR(int n) {
    }

    public void drawStroke(Stroke stroke) {
    }

    public void drawClip(GraphicsState graphicsState, Shape shape, boolean bl) {
    }

    public void setOutputDir(String string, String string2, String string3) {
    }

    public void writeCustom(int n, Object object) {
    }

    public void flagCommand(int n, int n2) {
    }

    public void setTag(int n, String string) {
    }

    public void setValue(int n, int n2) {
        switch (n) {
            case 1: {
                this.backgroundColor = new Color(n2);
                break;
            }
            case 2: {
                this.textColor = new Color(n2);
                break;
            }
            case 3: {
                if (n2 > 0) {
                    this.changeLineArtAndText = true;
                    break;
                }
                this.changeLineArtAndText = false;
                break;
            }
            case 4: {
                this.colorThresholdToReplace = n2;
            }
        }
    }

    public void setValue(int n, String[] stringArray) {
    }

    public int getValue(int n) {
        return -1;
    }

    public BufferedImage getSingleImagePattern() {
        return null;
    }

    public void setBooleanValue(int n, boolean bl) {
    }

    public boolean isScalingControlledByUser() {
        return false;
    }

    public boolean avoidDownSamplingImage() {
        return false;
    }

    public boolean getBooleanValue(int n) {
        return false;
    }

    public float getScaling() {
        return this.scaling;
    }

    public void saveAdvanceWidth(String string, String string2, int n) {
    }

    public static int isRectangle(Shape shape) {
        int n;
        PathIterator pathIterator = shape.getPathIterator(null);
        for (n = 0; !pathIterator.isDone() && n < 8; ++n) {
            pathIterator.next();
        }
        return n;
    }
}

